/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import build.BuildConstants;
import com.aem.CentralDebugging;
import com.aem.ServerManagement;
import com.aem.VersionUtil;
import com.aem.nodelink.http.DefaultHttpClientFactory;
import com.aem.nodelink.http.extend.HttpRequestProcessor;
import com.aem.nodelink.utils.Cache;
import com.aem.nodelink.utils.DataUtils;
import com.aem.nodelink.utils.SafeClock;
import com.aem.nodelink.utils.SslToTcp;
import com.aem.nodelink.utils.WorkingNioSslSocket;
import com.aem.profiles.model.AppProfile;
import com.aem.profiles.model.AppProfiles;
import com.aem.profiles.model.ProfileType;
import com.aem.sdesktop.VersionFiles;
import com.aem.sdesktop.util.Version;
import com.aem.sgateway.SGClassPath;
import com.aem.shelp.common.SGParameters;
import com.aem.shelp.common.SHParameters;
import com.aem.shelp.common.video.VideoUtils;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.AccessManager;
import com.aem.shelp.proxy.BigPipeClient;
import com.aem.shelp.proxy.DMGBrandingRepository;
import com.aem.shelp.proxy.HtmlProvider;
import com.aem.shelp.proxy.HttpResponse;
import com.aem.shelp.proxy.HttpResponsePrinter;
import com.aem.shelp.proxy.LicenseConfig;
import com.aem.shelp.proxy.MimeTypes;
import com.aem.shelp.proxy.ProxyServer;
import com.aem.shelp.proxy.ServerBranding;
import com.aem.shelp.proxy.ServerStats;
import com.aem.shelp.proxy.SessionHistoryRepository;
import com.aem.shelp.proxy.Templates;
import com.aem.shelp.proxy.TranslationWrapper;
import com.aem.shelp.proxy.WdsStopException;
import com.aem.shelp.proxy.common.ToolBoxConstants;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.TechHelpUIArguments;
import com.aem.shelp.util.PatternWrapper;
import com.aem.shelp.util.TrialLogger;
import com.aem.utils.Debugger;
import com.aem.utils.StreamUtils;
import com.aem.utils.crc.CRCOutputStream;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.channels.ClosedChannelException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.net.ssl.SSLSocket;
import jwrapper.JWParameteriser;
import jwrapper.compression.splitcompressor.SubstitutionStreamer;
import jwrapper.updater.JWLaunchProperties;
import utils.files.FileUtil;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.progtools.Counter;
import utils.progtools.URIUtil;
import utils.progtools.arrays.ArrayUtils;
import utils.progtools.net.URLParser;
import utils.progtools.resume.TccStopException;
import utils.progtools.resume.ThreadCreateCallback;
import utils.stream.SelectPool;
import utils.stream.SelectPoolHandler;
import utils.stream.SocketLeaks;
import utils.stream.StreamParameteriser;
import utils.string.Base64;
import utils.string.CharStack;
import utils.string.HexData;
import utils.string.StringReplace;
import utils.switches.Switches;

public class WebDownloadServer
extends Thread
implements ThreadCreateCallback {
    private static final String[] FILE_SEARCH_PATHS = new String[]{"configuration", "configuration/html", "DEPLOY", "lib", "lib/html", "DEPLOY/html", "DEPLOY/legacy", "installer/signedfiles", "installer/builds", "installer/lib", "installer/DEPLOY/legacy"};
    private static final String[] MIME_TYPES_OPTION_FORWARD_SSL = new String[]{"text/html", "text/css", "text/javascript", "text/xml", "text/json"};
    private static byte[] OSX_BG_IMAGE = null;
    private static final Object OSX_BG_LOCK = new Object();
    private static final DMGBrandingRepository DMG_BRANDINGS = new DMGBrandingRepository();
    private static byte[] cachedDMGImageBytes = null;
    private static final ThreadGroup wdsGroup = new ThreadGroup("WDS Threads");
    private final JWParameteriser genericParameteriser;
    private static final String SPECIAL_PARAMETER_AUTHORIZATION = "WDS-SpecialParameterAuthorization";
    public static String FAKE_VERSION = null;
    public static long FAKE_VERSION_UNTIL = 0L;
    private boolean isSsl;
    private Socket sock;
    private OutputStream out;
    private InputStream in;
    private byte[] initial;
    private HttpRequestProcessor hproc;
    private String incomingIp;
    private String remoteSourceIpAddres;
    private InetAddress remoteAddress;
    private final SimpleDateFormat sdf;
    private AccessManager access;
    private static int counter;
    private static final Object counter_LOCK;
    private int myid;
    private boolean LOCAL_VERBOSE;
    private boolean sendNoCache;
    private String setCookie;
    private long sendIfLmod;
    private String contentDisposition;
    private static final String[] EXTRACT_FILES;
    private static final String[] FETCH_FILES;
    private static final String[] OTHER_SERVED_FILES;
    private static final String[] ALL_SERVED_FILES;
    private static VersionFiles.FileInfo[] CACHED_MD5S;
    private static long timeLastVersionFilesWasUpdated;
    private static String cachedVersionFiles3;
    private static TranslationWrapper[] translationWrappers;
    private static final Object translationsLock;
    private String sockAddr;
    private static final Object hangLOCK;
    private static HangTracker hangtrack;
    private static int threadN;
    private static final ArrayList<WeakReference<WebDownloadServer>> serverList;
    private static final SubstitutionStreamer DEPLOY_UNPACKER;
    private static final Object queries_LOCK;
    private static final HashMap<WebDownloadServer, WebDownloadServer> queries;
    private boolean blockingIsOk;
    boolean amSgMachine;
    private int myKeepalive;
    private long addedToMap;
    private long queryStarted;
    private String queryDesc;
    private int queryCount;
    private String myMachineName;
    private boolean loop;
    private boolean OK;
    private long queryTime;
    private static final Object userAgent_LOCK;
    private static final HashMap<String, String> userAgents;
    static SelectPool raSelectors;
    static SelectPool webSelectors;
    private final long RECONNECT_IN_DEF_NEW = 750L;
    private final long RECONNECT_IN_DEF_OLD = 2500L;
    private String callback_machineName;
    private boolean callback_OldServicePing;
    private boolean callback_isHead;
    static Object raVersion_LOCK;
    static String cachedRaVersion;
    static long raVersionLastRead;
    private static final Cache fileLaunchProps;
    private static final Object updates_LOCK;
    private static final Counter updatesCounter;
    private File[] allowedPaths;
    private File configutationFolder;
    private final Object allowedPathsLock;

    @Override
    public ThreadGroup getTccThreadGroup() {
        return wdsGroup;
    }

    private boolean serveUpHandledFiles(String s, boolean crcRequired) throws IOException, RedirectException {
        for (String file : ALL_SERVED_FILES) {
            if (!s.contains(file.toLowerCase())) continue;
            this.respondFile(file, MimeTypes.getMimeTypeFor(file), s.startsWith("head"), crcRequired);
            return true;
        }
        return false;
    }

    public static void clearCachedDMGImages() {
        cachedDMGImageBytes = null;
    }

    private void updateName(String query) {
        this.setName("WebServer " + this.sock.getRemoteSocketAddress() + " " + threadN + " (q=" + query + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebDownloadServer(byte[] initialData, Socket sock, HttpRequestProcessor hproc, AccessManager access) {
        block19: {
            this.genericParameteriser = new JWParameteriser();
            this.isSsl = false;
            this.remoteSourceIpAddres = null;
            this.sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            this.blockingIsOk = false;
            this.amSgMachine = false;
            this.addedToMap = 0L;
            this.queryStarted = 0L;
            this.queryCount = 0;
            this.RECONNECT_IN_DEF_NEW = 750L;
            this.RECONNECT_IN_DEF_OLD = 2500L;
            this.allowedPaths = null;
            this.configutationFolder = null;
            this.allowedPathsLock = new Object();
            try {
                Object object;
                if (CentralDebugging.DEBUG_WEBDOWNLOADSERVER_COUNT) {
                    object = serverList;
                    synchronized (object) {
                        serverList.add(new WeakReference<WebDownloadServer>(this));
                        ArrayList<WeakReference<WebDownloadServer>> tempList = new ArrayList<WeakReference<WebDownloadServer>>();
                        tempList.addAll(serverList);
                        int trimmed = 0;
                        for (WeakReference weakReference : tempList) {
                            if (weakReference.get() != null) continue;
                            serverList.remove(weakReference);
                            ++trimmed;
                        }
                        System.out.println("[WebDownloadServer] WebDownloadServer list size is " + serverList.size() + " (trimmed " + trimmed + ")");
                    }
                }
                object = hangLOCK;
                synchronized (object) {
                    ++threadN;
                    if (hangtrack == null) {
                        hangtrack = new HangTracker();
                        hangtrack.start();
                    }
                }
                this.sock = sock;
                this.hproc = hproc;
                this.access = access;
                this.updateName("prerun");
                this.sockAddr = sock.getRemoteSocketAddress() + "";
                WebDownloadServer.addMe(this);
                if (CentralDebugging.PX_WS_THREADING) {
                    System.out.println("[WS Threading] WDS Created for " + sock.getRemoteSocketAddress());
                }
                this.isSsl = sock instanceof SSLSocket || sock instanceof WorkingNioSslSocket;
                object = counter_LOCK;
                synchronized (object) {
                    this.myid = counter++;
                }
                if (Switches.SH_1829_increaseWdsReadTimeout) {
                    sock.setSoTimeout(180000);
                } else {
                    sock.setSoTimeout(30000);
                }
                this.incomingIp = sock.getInetAddress().getHostAddress();
                if (CentralDebugging.WS_VERBOSE_REQUESTS || CentralDebugging.WS_VERBOSE_CONNECTION_AND_REQUEST) {
                    Debugger.info("CONNECTION (" + this.myid + "): new connection from " + this.incomingIp);
                }
                this.remoteAddress = ((InetSocketAddress)sock.getRemoteSocketAddress()).getAddress();
                if (this.remoteAddress != null) {
                    this.remoteSourceIpAddres = this.remoteAddress.getHostAddress();
                }
                this.initial = initialData;
                this.in = new BufferedInputStream(sock.getInputStream(), 2048);
                this.out = new BufferedOutputStream(sock.getOutputStream(), 4096);
                this.sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                this.createCachedMD5s();
                WebDownloadServer.initTranslationWrappers();
                this.loadOSXBackgroundImage();
                this.start();
            }
            catch (Exception e) {
                Debugger.warning("web connection terminated at setup");
                e.printStackTrace();
                if (!CentralDebugging.WS_VERBOSE_REQUESTS && !CentralDebugging.WS_VERBOSE_CONNECTION_AND_REQUEST) break block19;
                Debugger.info("CONNECTION (" + this.myid + "): connection terminated at startup");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOSXBackgroundImage() throws IOException {
        Object object = OSX_BG_LOCK;
        synchronized (object) {
            if (OSX_BG_IMAGE == null) {
                File imageFile = new File("images/osx_bg.png");
                if (!imageFile.exists()) {
                    imageFile = new File("installer/SimpleHelp/images/osx_bg.png");
                }
                if (!imageFile.exists()) {
                    return;
                }
                BufferedInputStream bin = new BufferedInputStream(ProxyServer.fileCleanup.get(imageFile));
                try {
                    OSX_BG_IMAGE = StreamUtils.readAllAvailable(bin);
                }
                finally {
                    FileUtil.robustClose(bin);
                }
            } else {
                return;
            }
        }
        File parentFolder = new File("DEPLOY");
        if (!parentFolder.exists()) {
            parentFolder = new File("installer/SimpleHelp/DEPLOY");
        }
        DMG_BRANDINGS.loadAllChildDMGs(DEPLOY_UNPACKER, parentFolder, OSX_BG_IMAGE);
    }

    private synchronized void createCachedMD5s() {
        if (CACHED_MD5S != null) {
            return;
        }
        CACHED_MD5S = new VersionFiles.FileInfo[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void initTranslationWrappers() {
        Object object = translationsLock;
        synchronized (object) {
            if (translationWrappers != null) {
                return;
            }
            System.out.println("[WebDownloadServer] Initiating translation wrappers... ");
            File translationsDirecotory = new File("DEPLOY/translations");
            if (!translationsDirecotory.exists()) {
                translationsDirecotory = new File("lib/translations");
            }
            File newTranslationsDirectory = new File("configuration/translations");
            File[] translationFiles = translationsDirecotory.listFiles();
            ArrayList<TranslationWrapper> translationWrapperList = new ArrayList<TranslationWrapper>();
            if (translationFiles != null) {
                for (File translationFile : translationFiles) {
                    int dotIndex = translationFile.getName().indexOf(46);
                    if (dotIndex == -1) continue;
                    String code = translationFile.getName().substring(0, dotIndex);
                    File alternativeFile = new File(newTranslationsDirectory, translationFile.getName());
                    translationWrapperList.add(new TranslationWrapper(code, translationFile, alternativeFile));
                }
                File translationFile = new File(translationsDirecotory, "en.txt");
                File alternativeFile = new File(newTranslationsDirectory, "gb.txt");
                translationWrapperList.add(new TranslationWrapper("gb", translationFile, alternativeFile));
            }
            translationWrappers = new TranslationWrapper[translationWrapperList.size()];
            translationWrapperList.toArray(translationWrappers);
        }
    }

    private static synchronized String getCachedVersionFiles3() throws FileNotFoundException {
        if (System.currentTimeMillis() - timeLastVersionFilesWasUpdated > 60000L) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < SGClassPath.JARS.length; ++i) {
                VersionFiles.appendToBuffer("LOAD", WebDownloadServer.findLocalFile(SGClassPath.JARS[i]), sb);
            }
            for (String EXTRACT_FILE : EXTRACT_FILES) {
                VersionFiles.appendToBuffer("EXTRACT", WebDownloadServer.findLocalFile(EXTRACT_FILE), sb);
            }
            for (String FETCH_FILE : FETCH_FILES) {
                String alias = WebDownloadServer.getAliasForFile(FETCH_FILE);
                VersionFiles.appendToBuffer("FETCH", FETCH_FILE, WebDownloadServer.findLocalFile(alias), sb);
            }
            cachedVersionFiles3 = sb.toString();
            timeLastVersionFilesWasUpdated = System.currentTimeMillis();
        }
        return new String(cachedVersionFiles3);
    }

    private static String getAliasForFile(String filename) {
        if (filename.equals("default_translation.txt")) {
            return "translations/" + ServerConfig.get().getServerLanguage() + ".txt";
        }
        return filename;
    }

    private boolean isStatusPageAllowed() {
        PatternWrapper[] statusIps = ServerConfig.get().statusPageRestrictions;
        if (statusIps == null) {
            return true;
        }
        for (PatternWrapper statusIp : statusIps) {
            if (!statusIp.getPattern().matcher(this.incomingIp).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean isTechAllowed() {
        if (this.incomingIp.equals("localhost") || this.incomingIp.equals("127.0.0.1") || this.incomingIp.equals("local")) {
            return true;
        }
        boolean allowed = ServerConfig.get().isTechAllowed(this.incomingIp);
        if (!allowed) {
            System.out.println("[WebDownloadServer] Technician restrictions blocked request from " + this.incomingIp);
        }
        return allowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addMe(WebDownloadServer thread) {
        Object object = queries_LOCK;
        synchronized (object) {
            thread.addedToMap = SafeClock.currentTimeMillis();
            queries.put(thread, thread);
            if (CentralDebugging.PX_WS_THREADING) {
                System.out.println("[WS Threading] Added " + thread.getName() + ", x" + queries.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeMe(WebDownloadServer thread) {
        Object object = queries_LOCK;
        synchronized (object) {
            queries.remove(thread);
        }
    }

    @Override
    public void run() {
        if (Switches.SH_internalProxyServerStateTracking) {
            ProxyServer.STATEMONITOR.buildCollectionsList(this, "WebDownloadServer");
        }
        this.processAll();
    }

    private void processAll() {
        this.loop = true;
        this.OK = false;
        this.queryTime = 0L;
        this.processOneLoop();
    }

    private void processOneLoop() {
        try {
            while (this.loop) {
                this.processOne();
            }
        }
        catch (WdsStopException x) {
            return;
        }
        catch (TccStopException x) {
            if (CentralDebugging.TCC_INS_OUTS) {
                System.out.println("[TCC] Thread going down to wait for notification (" + wdsGroup.activeCount() + ")...");
            }
            return;
        }
    }

    void processOne() throws WdsStopException {
        try {
            this.blockingIsOk = false;
            if (Switches.SH_1595_useNioSelectorsInWds && this.sock.getChannel() != null && this.amSgMachine) {
                try {
                    raSelectors.dumpIntoPool(this.sock, this);
                    throw new TccStopException();
                }
                catch (ClosedChannelException x) {
                    throw new WdsStopException();
                }
                catch (IOException x) {
                    x.printStackTrace();
                    throw new WdsStopException();
                }
            }
            if (Switches.SH_1778_wdsUseSelectorsForNonRa && this.sock.getChannel() != null) {
                try {
                    webSelectors.dumpIntoPool(this.sock, this);
                    throw new TccStopException();
                }
                catch (ClosedChannelException x) {
                    throw new WdsStopException();
                }
                catch (IOException x) {
                    x.printStackTrace();
                    throw new WdsStopException();
                }
            }
            this.processNow();
        }
        catch (TccStopException x) {
            throw x;
        }
        catch (WdsStopException x) {
            try {
                this.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            WebDownloadServer.removeMe(this);
            throw x;
        }
        catch (Throwable t) {
            t.printStackTrace();
            try {
                this.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            WebDownloadServer.removeMe(this);
            throw new WdsStopException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processNow() {
        try {
            String resource;
            block269: {
                this.blockingIsOk = false;
                this.updateName("readline");
                this.queryStarted = -1L;
                this.OK = true;
                String s = this.nextLine();
                resource = null;
                this.OK = false;
                this.queryDesc = "[" + s + "]";
                this.updateName(this.queryDesc);
                while (s.trim().length() == 0) {
                    s = this.nextLine();
                }
                this.queryStarted = SafeClock.currentTimeMillis();
                ++this.queryCount;
                String sorig = s.trim();
                s = sorig.toLowerCase();
                if (CentralDebugging.PX_DEBUG_SOCKETS) {
                    SocketLeaks.associate(this.sock, "Req", sorig);
                    SocketLeaks.associate(this.sock, "Queries", "" + this.queryCount);
                }
                if (CentralDebugging.WS_TIMED_REQUESTS) {
                    this.queryTime = System.currentTimeMillis();
                }
                this.LOCAL_VERBOSE = true;
                this.sendNoCache = false;
                this.sendIfLmod = -1L;
                this.setCookie = null;
                this.contentDisposition = null;
                if (CentralDebugging.WS_VERBOSE_REQUESTS && s.contains("/machine")) {
                    this.LOCAL_VERBOSE = CentralDebugging.WS_VERBOSE_REQUESTS_INCLUDING_SG_MACHINES;
                }
                if (CentralDebugging.WS_VERBOSE_CONNECTION_AND_REQUEST || CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                    Debugger.info("NEW REQUEST (" + this.myid + "): " + s);
                }
                boolean queryWasBadHttp10 = false;
                if (s.startsWith("get") || s.startsWith("head") || ProxyServer.INSTANCE.isInSetupMode()) {
                    String head;
                    if (s.endsWith("1.0")) {
                        this.loop = false;
                        queryWasBadHttp10 = true;
                    }
                    int chop = s.lastIndexOf("http");
                    s = s.substring(4, chop).trim();
                    resource = sorig = sorig.substring(4, chop).trim();
                    if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                        Debugger.info("RESOURCE (" + this.myid + "): " + s);
                    }
                    String authorization = null;
                    String cookie = null;
                    String virtualHostname = null;
                    boolean isMobileDevice = false;
                    while ((head = this.nextLine().trim()).length() > 0) {
                        String lchead = head.toLowerCase();
                        if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                            Debugger.info("HEADER (" + this.myid + "): " + head);
                        }
                        if (lchead.startsWith("proxy-authorization")) continue;
                        if (lchead.startsWith("host:")) {
                            virtualHostname = lchead.substring("host:".length()).trim();
                            continue;
                        }
                        if (lchead.startsWith("user-agent")) {
                            if (TrialLogger.isTrial()) {
                                Object object = userAgent_LOCK;
                                synchronized (object) {
                                    if (!userAgents.containsKey(lchead)) {
                                        userAgents.put(lchead, lchead);
                                        TrialLogger.logTrialAction("New incoming client device [" + lchead + "], requesting page " + s);
                                    }
                                }
                            }
                            if (!lchead.contains("iphone") && !lchead.contains("ipad") && !lchead.contains("ipod") && !lchead.contains("blackberry") && !lchead.contains("mini") && !lchead.contains("nintendo") && !lchead.contains("xbox") && !lchead.contains("playstation") && !lchead.contains("droid") && !lchead.contains("mobile")) continue;
                            isMobileDevice = true;
                            continue;
                        }
                        if (lchead.startsWith("connection")) {
                            if (lchead.contains("close")) {
                                this.loop = false;
                            }
                            if (!lchead.contains("keep-alive")) continue;
                            this.loop = true;
                            queryWasBadHttp10 = false;
                            continue;
                        }
                        if (lchead.startsWith("cache-control")) {
                            if (!lchead.contains("no-cache")) continue;
                            this.sendNoCache = true;
                            continue;
                        }
                        if (lchead.startsWith("authorization")) {
                            try {
                                authorization = head.substring(head.indexOf(58) + 1);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if (lchead.startsWith("cookie")) {
                            try {
                                cookie = head.substring(head.indexOf(58) + 1);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if (!lchead.startsWith("shspecial-send-if-lmod-neq")) continue;
                        try {
                            String tmp = head.substring(head.indexOf(58) + 1);
                            this.sendIfLmod = Long.parseLong(tmp.trim());
                            if (!CentralDebugging.WS_VERBOSE_REQUESTS || !this.LOCAL_VERBOSE) continue;
                            Debugger.info("LASTMOD CHECK (" + this.myid + "): (will send only if last modified time doesn't match " + this.sendIfLmod + ")");
                        }
                        catch (Exception tmp) {}
                    }
                    HashMap<String, String> paramsMap = null;
                    int paramsIndex = sorig.indexOf(63);
                    int paramsIndex2 = sorig.indexOf(38);
                    if (paramsIndex2 != -1 && paramsIndex2 < paramsIndex) {
                        paramsIndex = paramsIndex2;
                    }
                    if (paramsIndex > 0) {
                        String[] params;
                        paramsMap = new HashMap<String, String>();
                        paramsMap.put("language", ServerConfig.get().getServerLanguage());
                        String ps = sorig.substring(paramsIndex + 1);
                        ps = ps.replace('?', '&');
                        s = s.substring(0, paramsIndex);
                        sorig = sorig.substring(0, paramsIndex);
                        for (String param : params = ps.split("&")) {
                            int eq = param.indexOf(61);
                            if (eq != -1) {
                                String key = param.substring(0, eq);
                                String val = param.substring(eq + 1);
                                key = key.replace('\"', ' ');
                                key = key.replace('\'', ' ');
                                val = val.replace('\"', ' ');
                                val = val.replace('\'', ' ');
                                key = key.trim();
                                val = val.trim();
                                try {
                                    key = URLDecoder.decode(key, "UTF8");
                                }
                                catch (Throwable t) {
                                    try {
                                        key = URLDecoder.decode(key);
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                                try {
                                    val = URLDecoder.decode(val, "UTF8");
                                }
                                catch (Throwable t) {
                                    try {
                                        val = URLDecoder.decode(val);
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                                key = key.toLowerCase();
                                paramsMap.put(key, val);
                                continue;
                            }
                            paramsMap.put(param, "");
                        }
                    }
                    boolean crcRequired = false;
                    boolean javascript = false;
                    if (s.endsWith("?crc64")) {
                        s = s.substring(0, s.length() - 6);
                        crcRequired = true;
                    } else if (paramsMap != null && paramsMap.containsKey("crc64")) {
                        crcRequired = true;
                    }
                    if (s.contains("?embed")) {
                        s = s.substring(0, s.length() - 6);
                        javascript = true;
                    } else if (paramsMap != null && paramsMap.containsKey("embed")) {
                        javascript = true;
                    }
                    int lindex = s.indexOf("?language=");
                    if (lindex != -1) {
                        if (paramsMap == null) {
                            paramsMap = new HashMap();
                        }
                        String val = ServerConfig.get().getServerLanguage();
                        int index = s.indexOf(38);
                        val = index == -1 ? s.substring(lindex) : s.substring(lindex += 10, index);
                        paramsMap.put("language", val);
                    }
                    if (authorization != null) {
                        if (paramsMap == null) {
                            paramsMap = new HashMap();
                        }
                        paramsMap.put(SPECIAL_PARAMETER_AUTHORIZATION, authorization);
                    }
                    HashMap<String, String> dummyParamsMap = new HashMap<String, String>();
                    dummyParamsMap.put("language", ServerConfig.get().getServerLanguage());
                    try {
                        String file;
                        AbstractStringBuilder sb;
                        if (this.isBlocked(s)) {
                            this.respondNotFound(s.startsWith("head"));
                            break block269;
                        }
                        if (s.contains("lightweightfiles")) {
                            if (s.endsWith(".js") || s.endsWith(".html") || s.endsWith(".css")) {
                                this.respondFile(s, MimeTypes.getMimeTypeFor(s), s.startsWith("head"), crcRequired);
                            } else {
                                this.respondFile(s, "image/png", s.startsWith("head"), crcRequired);
                            }
                            break block269;
                        }
                        if (s.contains("branding")) {
                            if (s.contains("brandingfiles")) {
                                File target;
                                File configurationDir = new File("configuration", "branding");
                                File shBrandingDir = new File("lib", "branding");
                                String[] allBrandingFiles = new String[]{"applet_splash.png"};
                                String[] hrBrandingFiles = new String[]{"branding.properties", "logo_full.png", "logo_blue_32.png", "logo_blue_48.png", "logo_blue_256.png", "logo_green_32.png", "logo_green_48.png", "logo_green_256.png", "systemtray_blue_16.png", "systemtray_red_16.png", "systemtray_blue_36.png", "systemtray_red_36.png"};
                                StringBuffer sb2 = new StringBuffer();
                                for (String allBrandingFile : allBrandingFiles) {
                                    target = new File(configurationDir, allBrandingFile);
                                    if (!target.exists()) {
                                        target = new File(shBrandingDir, allBrandingFile);
                                    }
                                    VersionFiles.appendToBuffer("EXTRACT", target, sb2);
                                }
                                if (LicenseConfig.get().allowsRebranding()) {
                                    for (String hrBrandingFile : hrBrandingFiles) {
                                        target = new File(configurationDir, hrBrandingFile);
                                        if (!target.exists()) {
                                            target = new File(shBrandingDir, hrBrandingFile);
                                        }
                                        VersionFiles.appendToBuffer("EXTRACT", target, sb2);
                                    }
                                }
                                this.respondString(sb2.toString(), "text/plain", s.startsWith("head"));
                            } else {
                                boolean respond = true;
                                if (!LicenseConfig.get().allowsRebranding()) {
                                    if (s.contains("logo_")) {
                                        respond = false;
                                    }
                                    if (s.contains("systemtray_")) {
                                        respond = false;
                                    }
                                }
                                if (respond) {
                                    this.respondFile(s, MimeTypes.getMimeTypeFor(s), s.startsWith("head"), crcRequired);
                                } else {
                                    this.respondBad(s.startsWith("head"));
                                }
                            }
                            break block269;
                        }
                        if (s.contains("favicon")) {
                            if (new File("lib/favicon.ico").exists()) {
                                this.respondFile("favicon.ico", "image/vnd.microsoft.icon", s.startsWith("head"), crcRequired);
                            } else {
                                this.respondFile("branding/favicon.ico", "image/vnd.microsoft.icon", s.startsWith("head"), crcRequired);
                            }
                            break block269;
                        }
                        if (s.endsWith("/date")) {
                            StringBuilder sb3 = new StringBuilder();
                            DateFormat df = DateFormat.getDateTimeInstance(1, 1);
                            sb3.append(df.format(new Date()));
                            sb3.append("\n");
                            sb3.append(System.currentTimeMillis());
                            this.respondString(sb3.toString(), "text/plain", s.startsWith("head"));
                            break block269;
                        }
                        if (s.endsWith("/allversions")) {
                            StringBuilder sb4 = new StringBuilder();
                            sb4.append("SH Version:         ").append(VersionUtil.getVersion()).append("\n");
                            sb4.append("Visual Version:     ").append(Version.getExtended()).append("\n");
                            try {
                                sb4.append("JW Version:         ").append(this.splitOutJWVersion(FileUtil.readFileAsString(WebDownloadServer.findLocalFile("access/JWrapper-JWrapper-version.txt").getPath()))).append("\n");
                            }
                            catch (Exception df) {
                                // empty catch block
                            }
                            try {
                                sb4.append("Access Version:     ").append(this.splitOutJWVersion(FileUtil.readFileAsString(WebDownloadServer.findLocalFile("access/JWrapper-Remote Access-version.txt").getPath()))).append("\n");
                            }
                            catch (Exception df) {
                                // empty catch block
                            }
                            try {
                                sb4.append("Customer Version:   ").append(this.splitOutJWVersion(FileUtil.readFileAsString(WebDownloadServer.findLocalFile("customer/JWrapper-Remote Support-version.txt").getPath()))).append("\n");
                            }
                            catch (Exception df) {
                                // empty catch block
                            }
                            try {
                                sb4.append("Technician Version: ").append(this.splitOutJWVersion(FileUtil.readFileAsString(WebDownloadServer.findLocalFile("technician/JWrapper-" + OemBranding.OEM_TECHNICIAN_APP_NAME + "-version.txt").getPath()))).append("\n");
                            }
                            catch (Exception df) {
                                // empty catch block
                            }
                            this.respondString(sb4.toString(), "text/plain", s.startsWith("head"));
                            break block269;
                        }
                        if (s.endsWith("/version")) {
                            String version = VersionUtil.getVersion();
                            if (FAKE_VERSION != null) {
                                if (System.currentTimeMillis() < FAKE_VERSION_UNTIL) {
                                    version = FAKE_VERSION;
                                } else {
                                    FAKE_VERSION = null;
                                    FAKE_VERSION_UNTIL = 0L;
                                }
                            }
                            this.respondString(version, "text/plain", s.startsWith("head"));
                            break block269;
                        }
                        if (ProxyServer.INSTANCE.isInSetupMode()) {
                            if (s.length() <= 1 || s.startsWith("/tech") || s.startsWith("/welcome")) {
                                this.respondFile("firstlaunch.html", "text/html", s.startsWith("head"), crcRequired, javascript, paramsMap == null ? dummyParamsMap : paramsMap);
                            } else if (s.startsWith("/cust") || s.startsWith("/access") || s.startsWith("/demo") || s.startsWith("/mobile")) {
                                this.respondFile("maintenance.html", "text/html", s.startsWith("head"), crcRequired, javascript, paramsMap == null ? dummyParamsMap : paramsMap);
                            } else if (s.contains("setupmode_new_config")) {
                                ProxyServer.INSTANCE.acceptSetupAsNewServer();
                                this.respondRedirect("/");
                            } else {
                                this.respondNotFound(s.startsWith("head"));
                            }
                            break block269;
                        }
                        if (s.contains("setupmode_new_config")) {
                            this.respondRedirect("/");
                            break block269;
                        }
                        if (s.contains("glassbutton")) {
                            this.respondFile(s, "image/png", s.startsWith("head"), crcRequired);
                            break block269;
                        }
                        if (s.contains("iosicon") && s.endsWith(".png")) {
                            this.respondFile("lightweightfiles/" + s, "image/png", s.startsWith("head"), crcRequired);
                            break block269;
                        }
                        if (s.contains("lightweightfiles/css")) {
                            this.respondFile(s, "text/css", s.startsWith("head"), crcRequired);
                            break block269;
                        }
                        if (s.contains("lightweightfiles/js")) {
                            this.respondFile(s, "text/javascript", s.startsWith("head"), crcRequired);
                            break block269;
                        }
                        if (s.contains("toolbox-resource")) {
                            this.respondToolboxResource(s, "application/octet-stream", s.startsWith("head"), crcRequired);
                            break block269;
                        }
                        if ((sorig.contains("presentation") || sorig.contains("demo")) && ServerConfig.get().enabledPresentation) {
                            this.sendNoCache = true;
                            this.handleDemoQuery(paramsMap, s, sorig, resource, cookie);
                            break block269;
                        }
                        if (s.contains("techsloggedin")) {
                            if (ServerConfig.get().statusPage && this.isStatusPageAllowed()) {
                                String techname = null;
                                String[] groups = null;
                                if (paramsMap != null) {
                                    techname = paramsMap.get("technician");
                                    String tmpGroup = paramsMap.get("groups");
                                    if (tmpGroup != null) {
                                        groups = tmpGroup.split(",");
                                    }
                                }
                                String result = ServerStats.INSTANCE.getTechsLoggedInResponse(javascript, techname, groups);
                                if (!javascript) {
                                    this.respondString(result, "text/plain", s.startsWith("head"));
                                } else {
                                    this.respondString(result, "text/javascript", s.startsWith("head"));
                                }
                            } else {
                                this.respondForbidden(s.startsWith("head"));
                            }
                            break block269;
                        }
                        if ((isMobileDevice && s.contains("tech") || s.contains("mobile")) && ServerConfig.get().enabledMobileAccess) {
                            if (this.isTechAllowed()) {
                                this.sendNoCache = true;
                                this.handleMobileQuery(paramsMap, s, sorig, resource, cookie);
                            } else {
                                this.respondForbidden(s.startsWith("head"));
                            }
                            break block269;
                        }
                        if (s.contains("publicfiles")) {
                            if (s.contains("..")) {
                                this.respondBad(s.startsWith("head"));
                            } else {
                                this.respondFile(s, MimeTypes.getMimeTypeFor(s), s.startsWith("head"), crcRequired);
                            }
                            break block269;
                        }
                        if (s.contains("/issimplehelptriallicense")) {
                            if (LicenseConfig.get().isLicensedTrial()) {
                                this.respondString("1", "text/plain", s.startsWith("head"));
                            } else if (LicenseConfig.get().isUnlicensedTrial()) {
                                this.respondString("2", "text/plain", s.startsWith("head"));
                            } else {
                                this.respondString("0", "text/plain", s.startsWith("head"));
                            }
                            break block269;
                        }
                        if (s.contains("/customer/")) {
                            this.respondCustomer(sorig, s, crcRequired, paramsMap);
                            break block269;
                        }
                        if (s.contains("/access/")) {
                            if (s.endsWith(".txt")) {
                                this.respondFile(sorig, "text/plain", s.startsWith("head"), crcRequired, false, paramsMap);
                            } else if (s.endsWith(".css")) {
                                this.respondFile(sorig, "text/css", s.startsWith("head"), crcRequired, false, paramsMap);
                            } else if (s.endsWith(".js")) {
                                this.respondFile(sorig, "application/javascript", s.startsWith("head"), crcRequired, true, paramsMap);
                            } else {
                                this.respondFile(sorig, "application/octet-stream", s.startsWith("head"), crcRequired, false, paramsMap);
                            }
                            break block269;
                        }
                        if (s.contains("/technician/") || s.contains("/present/") || s.contains("/groupaccess/")) {
                            if (this.isTechAllowed()) {
                                this.respondTechnician(sorig, s, crcRequired, paramsMap);
                            } else {
                                this.respondForbidden(s.startsWith("head"));
                            }
                            break block269;
                        }
                        if (s.contains("customer") || s.contains("cust")) {
                            this.respondFile("customer.html", "text/html", s.startsWith("head"), crcRequired, javascript, paramsMap == null ? dummyParamsMap : paramsMap);
                            break block269;
                        }
                        if (s.contains("technician") || s.contains("tech")) {
                            if (this.isTechAllowed()) {
                                this.respondFile("technician.html", "text/html", s.startsWith("head"), crcRequired, javascript, paramsMap == null ? dummyParamsMap : paramsMap);
                            } else {
                                this.respondForbidden(s.startsWith("head"));
                            }
                            break block269;
                        }
                        if (s.contains("access")) {
                            this.respondFile("access.html", "text/html", s.startsWith("head"), crcRequired, javascript, paramsMap == null ? dummyParamsMap : paramsMap);
                            break block269;
                        }
                        if (s.contains("welcome")) {
                            this.respondFile("welcome.html", "text/html", s.startsWith("head"), crcRequired, javascript, paramsMap == null ? dummyParamsMap : paramsMap);
                            break block269;
                        }
                        if (s.contains("versionfiles3")) {
                            String version3CacheCopy = WebDownloadServer.getCachedVersionFiles3();
                            this.respondString(version3CacheCopy, "text/plain", s.startsWith("head"));
                            break block269;
                        }
                        if (s.contains("versionfiles2")) {
                            StringBuilder sb5 = new StringBuilder();
                            for (int i = 0; i < SGClassPath.JARS.length; ++i) {
                                sb5.append("LOAD:").append(SGClassPath.JARS[i]).append("\n");
                            }
                            sb5.append("EXTRACT:elevatesh.exe\n");
                            sb5.append("EXTRACT:elevatesh_mac\n");
                            sb5.append("EXTRACT:elev_win.exe\n");
                            sb5.append("EXTRACT:elev_mac\n");
                            sb5.append("EXTRACT:shcad.exe\n");
                            sb5.append("EXTRACT:SessionLauncher.exe\n");
                            sb5.append("EXTRACT:utils_wnative.dll\n");
                            sb5.append("EXTRACT:utils_wnative64.dll\n");
                            sb5.append("EXTRACT:libutils_lnative.so\n");
                            sb5.append("EXTRACT:libutils_lnative64.so\n");
                            sb5.append("EXTRACT:libutils_mnative.jnilib\n");
                            sb5.append("EXTRACT:libutils_mnative64.jnilib\n");
                            sb5.append("EXTRACT:libutils_m_lion_native.jnilib\n");
                            sb5.append("EXTRACT:libutils_m_lion_native64.jnilib\n");
                            sb5.append("FETCH:default_translation.txt\n");
                            sb5.append("FETCH:SimpleService.exe\n");
                            this.respondString(sb5.toString(), "text/plain", s.startsWith("head"));
                            break block269;
                        }
                        if (s.contains("versionfiles")) {
                            StringBuilder sb6 = new StringBuilder();
                            for (int i = 0; i < SGClassPath.JARS.length; ++i) {
                                sb6.append("LOAD:").append(SGClassPath.JARS[i]).append("\n");
                            }
                            sb6.append("FETCH:elevatesh.exe\n");
                            sb6.append("FETCH:elevatesh_mac\n");
                            sb6.append("FETCH:elev_win.exe\n");
                            sb6.append("FETCH:elev_mac\n");
                            sb6.append("FETCH:shcad.exe\n");
                            sb6.append("FETCH:SessionLauncher.exe\n");
                            sb6.append("FETCH:utils_wnative.dll\n");
                            sb6.append("FETCH:utils_wnative64.dll\n");
                            sb6.append("FETCH:libutils_lnative.so\n");
                            sb6.append("FETCH:libutils_lnative64.so\n");
                            sb6.append("FETCH:libutils_mnative.jnilib\n");
                            sb6.append("FETCH:libutils_mnative64.jnilib\n");
                            sb6.append("FETCH:libutils_m_lion_native.jnilib\n");
                            sb6.append("FETCH:libutils_m_lion_native64.jnilib\n");
                            sb6.append("FETCH:default_translation.txt\n");
                            sb6.append("FETCH:SimpleService.exe\n");
                            this.respondString(sb6.toString(), "text/plain", s.startsWith("head"));
                            break block269;
                        }
                        if (s.contains("pseudorandomdata")) {
                            Random r = new Random();
                            sb = new StringBuffer();
                            int length = r.nextInt(1000000);
                            ((StringBuffer)sb).append("Length: " + length + "\n");
                            for (int i = 0; i < length; ++i) {
                                ((StringBuffer)sb).append((char)(65 + r.nextInt(26)));
                            }
                            ((StringBuffer)sb).append("\nFinished OK");
                            this.respondString(((StringBuffer)sb).toString(), "text/plain", s.startsWith("head"));
                            break block269;
                        }
                        if (s.contains("availableports")) {
                            int[] ports = ServerConfig.get().portList;
                            sb = new StringBuilder();
                            for (int port : ports) {
                                ((StringBuilder)sb).append(port);
                                ((StringBuilder)sb).append(",");
                            }
                            ((StringBuilder)sb).setLength(((StringBuilder)sb).length() - 1);
                            this.respondString(((StringBuilder)sb).toString(), "text/plain", s.startsWith("head"));
                            break block269;
                        }
                        if (s.contains("/app/")) {
                            int start;
                            String appProfileID;
                            AppProfile profile;
                            if (CentralDebugging.PX_APP_PROFILES) {
                                System.out.println("App profile query: " + s);
                            }
                            if ((profile = ProxyServer.INSTANCE.getAppProfile(appProfileID = s.substring(start = s.indexOf("/app/") + "/app/".length()))) != null) {
                                String baseHtml = profile.getType().getBaseHtmlFile();
                                if (CentralDebugging.PX_APP_PROFILES) {
                                    System.out.println("Request for app profile " + profile.getName() + " / @" + profile.getAlias() + " / ::" + profile.getType().getName());
                                }
                                this.respondFile(baseHtml, "text/html", s.startsWith("head"), crcRequired, javascript, paramsMap == null ? dummyParamsMap : paramsMap, profile);
                            } else {
                                System.out.println("[WebDownloadServer] Unable to find app profile for ID '" + appProfileID + "'");
                                this.respondNotFound(s.startsWith("head"));
                            }
                            break block269;
                        }
                        if (s.contains("disclaimer")) {
                            String language = null;
                            if (paramsMap != null) {
                                language = paramsMap.get("language");
                            }
                            if (language != null) {
                                try {
                                    WebDownloadServer.findLocalFile("simplehelpdisclaimer." + language);
                                    this.respondFile("simplehelpdisclaimer." + language, "text/plain", s.startsWith("head"), crcRequired);
                                }
                                catch (FileNotFoundException ex) {
                                    this.respondFile("simplehelpdisclaimer.txt", "text/plain", s.startsWith("head"), crcRequired);
                                }
                            } else {
                                this.respondFile("simplehelpdisclaimer.txt", "text/plain", s.startsWith("head"), crcRequired);
                            }
                            break block269;
                        }
                        if (s.contains("details")) {
                            String xml = ServerConfig.get().getDetailsAsXML();
                            byte[] data = xml.getBytes("UTF8");
                            this.respondDat(data, "", false);
                            break block269;
                        }
                        if (s.contains("shelplogo16.png")) {
                            this.respondFile("shelplogo16.png", "image/png", s.startsWith("head"), crcRequired);
                            break block269;
                        }
                        if (s.contains("translations/")) {
                            CharStack cs = new CharStack(s);
                            cs.popUntil("translations/".toCharArray(), false);
                            file = cs.popXmlIdentifier(true);
                            byte[] translationData = WebDownloadServer.getTranslationData(file + ".txt");
                            if (translationData != null) {
                                this.respondDat(translationData, "text/plain", s.startsWith("head"));
                            } else {
                                this.respondFile("translations/" + file + ".txt", "text/plain", s.startsWith("head"), crcRequired);
                            }
                            break block269;
                        }
                        if (s.contains("translations_user/")) {
                            CharStack cs = new CharStack(s);
                            cs.popUntil("translations_user/".toCharArray(), false);
                            file = cs.popXmlIdentifier(true);
                            TranslationWrapper translationWrapper = WebDownloadServer.getTranslationWrapper(file + ".txt");
                            if (translationWrapper != null) {
                                byte[] translationData = translationWrapper.getCustomData();
                                if (translationData != null) {
                                    this.respondDat(translationData, "text/plain", s.startsWith("head"), translationWrapper.getLastModified());
                                } else {
                                    this.respondNotFound(s.startsWith("head"));
                                }
                            } else {
                                this.respondNotFound(s.startsWith("head"));
                            }
                            break block269;
                        }
                        if (s.contains("default_translation.txt")) {
                            byte[] translationData = WebDownloadServer.getTranslationData(ServerConfig.get().getServerLanguage() + ".txt");
                            if (translationData != null) {
                                this.respondDat(translationData, "text/plain", s.startsWith("head"));
                            } else {
                                this.respondFile("translations/en.txt", "text/plain", s.startsWith("head"), crcRequired);
                            }
                            break block269;
                        }
                        if (s.contains(".well-known/acme-challenge")) {
                            String key = sorig.substring(sorig.indexOf(".well-known/acme-challenge/") + ".well-known/acme-challenge/".length());
                            System.out.println("[WebDownloadServer][ACME-Challenge] " + key);
                            boolean valid = true;
                            for (int i = 0; i < key.length(); ++i) {
                                char c = key.charAt(i);
                                if (Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '=') continue;
                                System.out.println("[WebDownloadServer][ACME-Challenge] Key invalud. Ignoring request.");
                                valid = false;
                                break;
                            }
                            File target = new File(new File("configuration", "sslconfig"), key);
                            if (valid && target.exists()) {
                                String value = FileUtil.readFileAsString(target);
                                System.out.println("[WebDownloadServer][ACME-Challenge] Responding to ACME challenge with " + value);
                                this.respondString(value, "text/plain", s.startsWith("head"));
                                target.delete();
                            } else {
                                this.respondBad(s.startsWith("head"));
                            }
                            break block269;
                        }
                        if (s.contains("server_side_parameters")) {
                            this.respondString(this.getAppletParameters(), "text/plain", s.startsWith("head"));
                            break block269;
                        }
                        if (s.contains("statuspage")) {
                            if (ServerConfig.get().statusPage && this.isStatusPageAllowed()) {
                                boolean includeMachines = ServerConfig.get().statusPageIncludeMachines;
                                boolean includeSessions = ServerConfig.get().statusPageIncludeSessions;
                                boolean includePerformance = ServerConfig.get().statusPageIncludePerformance;
                                if (s.contains("json")) {
                                    String callback = null;
                                    if (paramsMap != null) {
                                        callback = paramsMap.get("callback");
                                    }
                                    String json = ServerStats.INSTANCE.toJSON(callback, includeMachines, includeSessions, includePerformance);
                                    this.respondString(json, "text/json", s.startsWith("head"));
                                } else {
                                    String xml = ServerStats.INSTANCE.toXML(includeMachines, includeSessions, includePerformance);
                                    this.respondString(xml, "text/xml", s.startsWith("head"));
                                }
                            } else {
                                this.respondForbidden(s.startsWith("head"));
                            }
                            break block269;
                        }
                        if (this.serveUpHandledFiles(s, crcRequired)) break block269;
                        if (s.contains("/session/")) {
                            this.handleSessionQuery(paramsMap, s, sorig, resource, cookie);
                            break block269;
                        }
                        if (s.contains("test") && !s.contains("asp") && !s.contains("cgi")) {
                            this.respondString("SimpleHelp v5.1", "text/plain", s.startsWith("head"));
                            break block269;
                        }
                        if (s.endsWith("/pubkeyhash")) {
                            this.respondString("" + ProxyServer.INSTANCE.getPublicKeyHash(), "text/plain", s.startsWith("head"));
                            break block269;
                        }
                        if (s.endsWith("/serverkeys")) {
                            String lastModified = "Unknown (error)";
                            try {
                                long modtime = new File("configuration" + File.separator + "serverkeys.dat").lastModified();
                                lastModified = new Date(modtime) + "";
                            }
                            catch (Exception modtime) {
                                // empty catch block
                            }
                            this.respondString(lastModified, "text/plain", s.startsWith("head"));
                            break block269;
                        }
                        if (s.contains("publickey")) {
                            this.respondString(ProxyServer.INSTANCE.getPublicKeyHash(), "text/plain", s.startsWith("head"));
                            break block269;
                        }
                        if (s.contains("machine")) {
                            this.amSgMachine = true;
                            String pingData = null;
                            this.myKeepalive = 300;
                            if (paramsMap == null) {
                                this.respondString("MachineIdNotDetected", "text/plain", s.startsWith("head"));
                                break block269;
                            }
                            pingData = paramsMap.get("ping");
                            if (CentralDebugging.CLUSTERING_MESSAGES) {
                                System.out.println("[Clustering] Ping coming in");
                            }
                            if (pingData != null) {
                                Message pingMessage = MessageUtils.bytesToMessage(HexData.hexStringToByteArray(pingData));
                                String machineID = pingMessage.getAsString(0);
                                if (CentralDebugging.CLUSTERING_MESSAGES) {
                                    System.out.println("[Clustering] V4+ Ping from " + machineID);
                                }
                                try {
                                    if (queryWasBadHttp10) {
                                        System.out.println("[WebServer] *****************");
                                        System.out.println("[WebServer] **** WARNING **** V4 Remote Access service " + pingMessage.getAsString(0) + " is querying this server but failing to maintain a HTTP 1.1 socket - if this is not rectified the remote service will shut down to protect your server");
                                        System.out.println("[WebServer] *****************");
                                    }
                                }
                                catch (Exception xml) {
                                    // empty catch block
                                }
                                if (ProxyServer.INSTANCE.isCondenserNode()) {
                                    BigPipeClient bpc;
                                    if (CentralDebugging.CLUSTERING_MESSAGES) {
                                        System.out.println("[Clustering] Received ping checking for valid BigPipe");
                                    }
                                    if ((bpc = ProxyServer.INSTANCE.getBigPipe()) != null) {
                                        if (CentralDebugging.CLUSTERING_MESSAGES) {
                                            System.out.println("[Clustering] Sending ping for " + machineID + " to Primary");
                                        }
                                        bpc.sendServicePing(pingMessage, this.remoteSourceIpAddres, machineID);
                                    } else if (CentralDebugging.CLUSTERING_MESSAGES) {
                                        System.out.println("[Clustering] BigPipe is down, ignoring");
                                    }
                                }
                                Message response = this.handleServicePing(pingMessage, this.remoteSourceIpAddres, s.startsWith("head"));
                                if (CentralDebugging.DEBUG_WDS_PING) {
                                    System.out.println("[WDS] Sending ping response to service.");
                                }
                                this.sendServiceResponse(response);
                                break block269;
                            }
                            String machine = null;
                            String inUse = null;
                            String version = null;
                            machine = paramsMap.get("machine");
                            if (machine != null && (machine = machine.trim()).length() == 0) {
                                machine = null;
                            }
                            if (queryWasBadHttp10) {
                                System.out.println("[WebServer] *****************");
                                System.out.println("[WebServer] **** WARNING **** V3 Remote Access service " + machine + " is querying this server but failing to maintain a HTTP 1.1 socket - if this is not rectified the remote service will shut down to protect your server");
                                System.out.println("[WebServer] *****************");
                            }
                            if ((inUse = paramsMap.get("inuse")) != null) {
                                inUse = inUse.trim();
                            }
                            if ((version = paramsMap.get("version")) != null) {
                                version = version.trim();
                            }
                            String logData = paramsMap.get("logdata");
                            String response = this.handleOldServicePing(machine, inUse, version, s.startsWith("head"));
                            this.sendOldServiceResponse(response);
                            break block269;
                        }
                        if (s.equals("/") && ServerConfig.get().redirectDefaultToWelcomePage) {
                            this.respondRedirect("/welcome");
                            break block269;
                        }
                        if (s.equals("/") || s.contains("cust") || s.contains("/invite")) {
                            if (ServerManagement.isSimpleHelp()) {
                                HashMap<String, String> map = paramsMap;
                                if (map == null) {
                                    map = dummyParamsMap;
                                }
                                if (s.contains("/invite") && map.get("invite") == null) {
                                    map.put("invite", "-");
                                }
                                this.respondFile("customer.html", "text/html", s.startsWith("head"), crcRequired, javascript, paramsMap == null ? dummyParamsMap : paramsMap);
                            } else {
                                this.respondFile("technician.html", "text/html", s.startsWith("head"), crcRequired, javascript, paramsMap == null ? dummyParamsMap : paramsMap);
                            }
                            break block269;
                        }
                        this.respondNotFound(s.startsWith("head"));
                    }
                    catch (RedirectException e) {
                        System.out.println("[WebDownloadServer] Redirect non-SSL HTTP request (" + resource + ")");
                        try {
                            String url = "http://" + virtualHostname + resource;
                            URLParser parser = new URLParser(url);
                            parser.setProtocol("https");
                            if (parser.getPort(true) == 80 && ServerConfig.get().isListeningOnPort(443)) {
                                parser.setPort(443);
                            }
                            this.respondRedirect(parser.getBestGuessURL().toString());
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            this.respondNotFound(false);
                        }
                    }
                } else if (s.startsWith("post")) {
                    String head;
                    int len = -1;
                    String contentType = null;
                    String cookie = null;
                    while ((head = this.nextLine().trim()).length() > 0) {
                        if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                            Debugger.info("HEADER (" + this.myid + "): " + head);
                        }
                        if ((head = head.toLowerCase().trim()).startsWith("content-length")) {
                            head = head.substring(head.indexOf(58) + 1).trim();
                            len = Integer.parseInt(head);
                        }
                        if (head.startsWith("content-type")) {
                            contentType = head.substring(head.indexOf(58) + 1).trim();
                        }
                        if (!head.startsWith("cookie")) continue;
                        cookie = head.substring(head.indexOf(58) + 1).trim();
                    }
                    if (s.contains("lossyproc")) {
                        this.amSgMachine = true;
                        this.myKeepalive = 300;
                        if (len == -1) {
                            System.out.println("POST without content-length not allowed");
                            this.respondBad(false);
                        } else {
                            Message message;
                            String machineID = DataUtils.readStringUTF8(this.in);
                            byte[] dat = DataUtils.readBytes(this.in);
                            if (ProxyServer.INSTANCE.isCondenserNode()) {
                                message = MessageUtils.bytesToMessage(dat);
                                BigPipeClient bpc = ProxyServer.INSTANCE.getBigPipe();
                                if (bpc != null) {
                                    bpc.sendLossyMessage(machineID, message);
                                }
                                this.myMachineName = machineID;
                            } else {
                                try {
                                    this.myMachineName = ProxyServer.INSTANCE.getMachineHumanName(machineID);
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                                message = MessageUtils.bytesToMessage(dat);
                                ProxyServer.INSTANCE.lossyclient.lossyMessageReceived(ProxyServer.INSTANCE.getLossyTransportFor(machineID), message, this.sock);
                            }
                            byte[] respdat = new byte[]{};
                            this.respondDat(respdat, DefaultHttpClientFactory.MIME_TYPE, false);
                        }
                    } else if (s.contains("wtranstok")) {
                        this.myKeepalive = 180;
                        if (len == -1) {
                            System.out.println("POST without content-length not allowed");
                            this.respondBad(false);
                        } else {
                            byte[] dat = DataUtils.readBytes(this.in);
                            byte[] respdat = ProxyServer.INSTANCE.processWebTransaction(dat);
                            this.respondDat(respdat, DefaultHttpClientFactory.MIME_TYPE, false);
                        }
                    } else if (len == -1) {
                        System.out.println("POST without content-length not allowed");
                        this.respondBad(false);
                    } else if (contentType != null && contentType.equals("application/x-www-form-urlencoded")) {
                        byte[] dat = StreamUtils.readBytes(this.in, len);
                        String postedData = new String(dat);
                        String urlParameters = "";
                        int chop = s.lastIndexOf("http");
                        s = s.substring(4, chop).trim();
                        int parameterIndex = (sorig = sorig.substring(4, chop).trim()).lastIndexOf(63);
                        if (parameterIndex != -1 && !sorig.endsWith("?")) {
                            String parametersInURL = sorig.substring(parameterIndex + 1);
                            sorig = sorig.substring(0, parameterIndex);
                            s = s.substring(0, parameterIndex);
                            if (parametersInURL.length() > 0) {
                                urlParameters = parametersInURL;
                            }
                        }
                        postedData = postedData.trim();
                        urlParameters = urlParameters.trim();
                        resource = sorig;
                        resource = resource.indexOf(63) == -1 ? resource + "?" + urlParameters : resource + "&" + urlParameters;
                        HashMap<String, String> paramsMap = new HashMap<String, String>();
                        this.extractParametersFromString(paramsMap, postedData);
                        this.extractParametersFromString(paramsMap, urlParameters);
                        if (resource.startsWith("/mobile")) {
                            this.handleMobileQuery(paramsMap, s, sorig, resource, cookie);
                        } else if (resource.startsWith("/demo")) {
                            this.handleDemoQuery(paramsMap, s, sorig, resource, cookie);
                        } else if (resource.startsWith("/session")) {
                            this.handleSessionQuery(paramsMap, s, sorig, resource, cookie);
                        } else if (resource.contains("/customer/")) {
                            this.respondCustomer(sorig, s, false, paramsMap);
                        } else if (resource.contains("/technician/")) {
                            this.respondTechnician(sorig, s, false, paramsMap);
                        } else {
                            this.respondNotFound(false);
                        }
                    } else {
                        if (CentralDebugging.PX_DEBUG_SOCKETS) {
                            SocketLeaks.associate(this.sock, "ConnType", "NL-HTTP");
                        }
                        if (CentralDebugging.PX_DEBUG_WDS_NL_FDHTTP) {
                            System.out.println("[WDS-FDHTTP] Incoming request");
                        }
                        if (this.hproc.isStreamProcessor()) {
                            if (CentralDebugging.PX_DEBUG_WDS_NL_FDHTTP) {
                                System.out.println("[WDS-FDHTTP] Responding with dat stream");
                            }
                            this.respondDatStream(this.hproc.getStreamContentLength(), DefaultHttpClientFactory.MIME_TYPE);
                            this.blockingIsOk = true;
                            try {
                                if (CentralDebugging.PX_DEBUG_WDS_NL_FDHTTP) {
                                    System.out.println("[WDS-FDHTTP] Streaming HTTP data");
                                }
                                this.hproc.processHttpRequest(this.sock, this.in, this.out, this.isSsl, this.remoteAddress);
                            }
                            catch (Exception x) {
                                if (CentralDebugging.PX_DEBUG_HTTP_FDUPLEX_FAILURES || CentralDebugging.PX_DEBUG_WDS_NL_FDHTTP) {
                                    x.printStackTrace();
                                }
                                if (Switches.SH_XXXX_wdsExitHttpLoopOnFullDuplexFailure) {
                                    this.loop = false;
                                }
                            }
                        } else {
                            byte[] dat = StreamUtils.readBytes(this.in, len);
                            byte[] resp = this.hproc.processHttpRequest(dat, this.isSsl, this.remoteAddress);
                            this.respondDat(resp, DefaultHttpClientFactory.MIME_TYPE, false);
                        }
                    }
                } else {
                    String head;
                    while ((head = this.nextLine().trim()).length() > 0) {
                        if (!CentralDebugging.WS_VERBOSE_REQUESTS || !this.LOCAL_VERBOSE) continue;
                        Debugger.info("HEADER (" + this.myid + "): " + head);
                    }
                    this.respondBad(false);
                }
            }
            if (CentralDebugging.WS_TIMED_REQUESTS) {
                this.queryTime = System.currentTimeMillis() - this.queryTime;
                if (this.queryTime > 1L) {
                    Debugger.info("[WS Timed Requests] Query for " + resource + " took " + this.queryTime + "ms");
                }
            }
        }
        catch (TccStopException x) {
            WebDownloadServer.removeMe(this);
            throw x;
        }
        catch (Throwable e) {
            this.processThrowable(e);
        }
        if (!this.loop) {
            try {
                this.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            WebDownloadServer.removeMe(this);
        }
    }

    private void processThrowable(Throwable e) {
        try {
            this.sock.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (e instanceof SocketTimeoutException) {
            if (CentralDebugging.PX_SHOW_SOCKET_TIMEOUT_STACKTRACE) {
                e.printStackTrace();
            }
            StringBuilder sb = new StringBuilder();
            if (CentralDebugging.PX_WS_THREADING) {
                sb.append("[WS Threading] Socket Timeout: ").append(this.sockAddr).append(" (Queries: ").append(this.queryCount).append(")\n");
            }
            if (this.myMachineName != null) {
                if (CentralDebugging.PX_WS_THREADING) {
                    sb.append("[WS Threading] SG Name: ").append(this.myMachineName).append("\n");
                }
            } else if (CentralDebugging.PX_WS_THREADING) {
                sb.append("[WS Threading] SG Name: (not used for SG polling)\n");
            }
            if (CentralDebugging.PX_WS_THREADING) {
                sb.append("[WS Threading] Last Query: ").append(this.queryDesc).append("\n");
            }
            System.out.print(sb.toString());
            if (CentralDebugging.WS_VERBOSE_CONNECTION_AND_REQUEST || CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                Debugger.info("CONNECTION (" + this.myid + "): closed web connection (timed out)");
            }
        } else if (this.OK && e instanceof IOException) {
            if (CentralDebugging.WS_VERBOSE_CONNECTION_AND_REQUEST || CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                Debugger.info("CONNECTION (" + this.myid + "): closed web connection (" + e.getMessage() + ")");
            }
        } else if (e instanceof IOException || e instanceof SocketException) {
            if (CentralDebugging.WS_VERBOSE_CONNECTION_AND_REQUEST || CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                Debugger.info("CONNECTION (" + this.myid + "): closed web connection (" + e.getMessage() + ")");
            }
        } else {
            if (CentralDebugging.WS_VERBOSE_CONNECTION_AND_REQUEST || CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                Debugger.info("CONNECTION (" + this.myid + "): closed web connection (" + e + ")");
            }
            e.printStackTrace();
        }
        this.loop = false;
    }

    private void handleSessionQuery(HashMap<String, String> paramsMap, String s, String sorig, String resource, String cookie) throws IOException {
        if (paramsMap == null) {
            paramsMap = new HashMap();
        }
        if (paramsMap.get("language") == null) {
            paramsMap.put("language", ServerConfig.get().getServerLanguage());
        }
        int index = s.indexOf("/session/") + "/session/".length();
        String videoID = s.substring(index);
        String password = paramsMap.get("password");
        this.respondVideoHtml(paramsMap, s, videoID, s.startsWith("head"), password);
    }

    private String splitOutJWVersion(String ver) {
        long lver = Long.parseLong(ver);
        long date = jwrapper.updater.VersionUtil.getTimeForVersion(lver);
        return ver + " (" + this.sdf.format(date) + ")";
    }

    private void respondTechnician(String sorig, String s, boolean crcRequired, HashMap<String, String> paramsMap) throws IOException, RedirectException {
        if (s.endsWith(".txt")) {
            this.respondFile(sorig, "text/plain", s.startsWith("head"), crcRequired, false, paramsMap);
        } else if (s.endsWith(".css")) {
            this.respondFile(sorig, "text/css", s.startsWith("head"), crcRequired, false, paramsMap);
        } else if (s.endsWith(".js")) {
            this.respondFile(sorig, "application/javascript", s.startsWith("head"), crcRequired, true, paramsMap);
        } else {
            this.respondFile(sorig, "application/octet-stream", s.startsWith("head"), crcRequired, false, paramsMap);
        }
    }

    private void respondCustomer(String sorig, String s, boolean crcRequired, HashMap<String, String> paramsMap) throws IOException, RedirectException {
        if (s.endsWith(".txt")) {
            this.respondFile(sorig, "text/plain", s.startsWith("head"), crcRequired, false, paramsMap);
        } else if (s.endsWith(".css")) {
            this.respondFile(sorig, "text/css", s.startsWith("head"), crcRequired, false, paramsMap);
        } else if (s.endsWith(".js")) {
            this.respondFile(sorig, "application/javascript", s.startsWith("head"), crcRequired, true, paramsMap);
        } else {
            this.respondFile(sorig, "application/octet-stream", s.startsWith("head"), crcRequired, false, paramsMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message handleServicePing(Message pingMessage, String remoteIP, boolean isHead) {
        String machineName = pingMessage.getAsString(0);
        String inUse = String.valueOf(pingMessage.get(1));
        String version = pingMessage.getAsString(2);
        boolean logsAttached = pingMessage.getAsBoolean(3);
        if (logsAttached) {
            byte[] byArray = (byte[])pingMessage.get(4);
        }
        String build = null;
        if (pingMessage.length() > 5) {
            build = pingMessage.getAsString(5);
        }
        String hashPortion = null;
        if (pingMessage.length() > 6) {
            hashPortion = pingMessage.getAsString(6);
        }
        byte state = 0;
        if (pingMessage.length() > 7) {
            state = pingMessage.getAsByte(7);
        }
        boolean isHTTP10 = state & true;
        long lastGenStoreDataPoint = 0L;
        if (pingMessage.length() > 8) {
            lastGenStoreDataPoint = pingMessage.getAsLong(8);
        }
        long firstGenStoreDataPoint = 0L;
        if (pingMessage.length() > 9) {
            firstGenStoreDataPoint = pingMessage.getAsLong(9);
        }
        ProxyServer.INSTANCE.processGenStorePing(machineName, firstGenStoreDataPoint, lastGenStoreDataPoint);
        long hangFor = ServerConfig.get().defaultMachineTimeoutMS;
        long reconnectIn = 750L;
        try {
            if (CentralDebugging.DEBUG_WDS_PING) {
                System.out.println("[WDS] Delegating to Access Manager");
            }
            this.myMachineName = this.access.justPolledWithID(machineName, hangFor, inUse, version, build, hashPortion, isHTTP10, remoteIP, this.isSsl);
            if (CentralDebugging.DEBUG_WDS_PING) {
                System.out.println("[WDS] Access Manager returned");
            }
        }
        catch (AccessManager.MachineBlockedException e) {
            reconnectIn = 31536000000L;
        }
        if (CentralDebugging.DEBUG_WDS_PING) {
            System.out.println("[WDS] Checking if connection required");
        }
        String ID = this.getConnectionRequiredID(machineName, false, isHead);
        if (CentralDebugging.DEBUG_WDS_PING) {
            System.out.println("[WDS] Connection ID = " + ID);
        }
        try {
            Message message = this.finishServicePing(ID, machineName, reconnectIn);
            return message;
        }
        finally {
            if (CentralDebugging.DEBUG_WDS_PING) {
                System.out.println("[WDS] Finished service ping");
            }
        }
    }

    private Message finishServicePing(String ID, String machineName, long reconnectIn) {
        Message response;
        if (ID == null) {
            response = new Message(55430006);
            response.append(System.currentTimeMillis());
            response.append(VersionUtil.getShortVersion());
            response.append(reconnectIn);
            response.append(ProxyServer.INSTANCE.getPublicKeyHashPortion());
        } else if (ID.equals("++%%RequestAvailabilityCheck%%++")) {
            response = new Message(55430006);
            response.append(System.currentTimeMillis());
            response.append(VersionUtil.getShortVersion());
            response.append(100L);
            response.append(ProxyServer.INSTANCE.getPublicKeyHashPortion());
        } else if (ID.equals("++%%ProcessLossyMessages%%++")) {
            response = new Message(55430009);
            response.append(System.currentTimeMillis());
            response.append(VersionUtil.getShortVersion());
            response.append(1L);
            response.append(ProxyServer.INSTANCE.getPublicKeyHashPortion());
        } else {
            System.out.println("[WebDownloadServer] Connection required for machine " + machineName + " using ID: " + ID);
            boolean forceReadVersion = false;
            if (ID.startsWith("ACTIVITY_CLEAR_VERSION")) {
                this.fakeVersionForRepair();
                forceReadVersion = true;
            }
            response = new Message(55430001);
            response.append(System.currentTimeMillis());
            response.append(ID);
            response.append(VersionUtil.getShortVersion());
            response.append(VersionUtil.getVersion());
            response.append(WebDownloadServer.getRemoteAccessJwVersion(forceReadVersion));
            if (ProxyServer.INSTANCE.isCondenserNode()) {
                response.append(ServerConfig.get().condenserForURL);
            } else {
                response.append("");
            }
            response.append(ProxyServer.INSTANCE.getPublicKeyHashPortion());
        }
        this.appendAllLossyMessages(machineName, response);
        return response;
    }

    private void appendAllLossyMessages(String machineName, Message appendTo) {
        this.access.appendAllLossyMessages(machineName, appendTo);
    }

    private String getConnectionRequiredID(String machineName, boolean oldPing, boolean isHead) {
        this.prepareForCallback(machineName, oldPing, isHead);
        if (!CentralDebugging.PX_PROCESS_SG_POLLS_BY_WAITING_THREADS) {
            String ID;
            if (CentralDebugging.TCC_INS_OUTS) {
                System.out.println("[TCC] Doing resumable wait...");
            }
            if ((ID = this.access.getConnectionIdOrDoResumableWait(this, machineName, 15000L)) == null) {
                System.out.println("[TCC] ***WARNING*** TCC RETURNED UNEXPECTEDLY");
                return null;
            }
            return ID;
        }
        String ID = this.access.getConnectionRequiredID(machineName);
        long began = System.currentTimeMillis();
        for (int i = 0; ID == null && System.currentTimeMillis() - began < 15000L && i < 14; ++i) {
            try {
                this.access.doNotifiableWait(machineName, 2500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ID = this.access.getConnectionRequiredID(machineName);
        }
        return ID;
    }

    private void prepareForCallback(String machineName, boolean oldServicePing, boolean isHead) {
        this.callback_machineName = machineName;
        this.callback_OldServicePing = oldServicePing;
        this.callback_isHead = isHead;
    }

    @Override
    public void pickUp(Object stuff, long startTime) {
        if (CentralDebugging.TCC_INS_OUTS) {
            System.out.println("[TCC] Thread picked up for notification (" + wdsGroup.activeCount() + ") (timeToProcess=" + (System.currentTimeMillis() - startTime) + "ms)");
        }
        if (CentralDebugging.DEBUG_WDS_PING) {
            System.out.println("[WDS] Responding to ping (" + wdsGroup.activeCount() + ") (timeToProcess=" + (System.currentTimeMillis() - startTime) + "ms)");
        }
        Thread.currentThread().setName("WebServer " + this.sock.getRemoteSocketAddress() + " " + threadN);
        String requestID = this.access.getConnectionRequiredID(this.callback_machineName);
        if (CentralDebugging.DEBUG_WDS_PING) {
            System.out.println("[WDS] Connection ID is " + requestID);
        }
        if (this.callback_OldServicePing) {
            String response = this.finishOldServicePing(requestID, this.callback_machineName, 2500L);
            try {
                this.sendOldServiceResponse(response);
            }
            catch (Throwable e) {
                this.processThrowable(e);
            }
        } else {
            if (CentralDebugging.DEBUG_WDS_PING) {
                System.out.println("[WDS] Finishing service ping");
            }
            Message response = this.finishServicePing(requestID, this.callback_machineName, 750L);
            try {
                if (CentralDebugging.DEBUG_WDS_PING) {
                    System.out.println("[WDS] Sending service response");
                }
                this.sendServiceResponse(response);
            }
            catch (Throwable e) {
                this.processThrowable(e);
            }
        }
        this.processOneLoop();
    }

    private void sendOldServiceResponse(String response) throws IOException {
        this.respondString(response, "text/plain", this.callback_isHead);
    }

    private void sendServiceResponse(Message response) throws IOException {
        byte[] responseBytes = MessageUtils.messageToBytes(response);
        this.respondDat(responseBytes, DefaultHttpClientFactory.MIME_APPLICATION, this.callback_isHead);
    }

    private void fakeVersionForRepair() {
        FAKE_VERSION = "SSuite-5-1-REP-" + System.currentTimeMillis();
        FAKE_VERSION_UNTIL = System.currentTimeMillis() + 90000L;
    }

    private String handleOldServicePing(String machineName, String inUse, String version, boolean isHead) {
        if (machineName != null) {
            long hangFor = ServerConfig.get().defaultMachineTimeoutMS;
            long reconnectIn = 2500L;
            try {
                this.access.justPolledWithID(machineName, hangFor, inUse, version, null, null, false, this.remoteSourceIpAddres, this.isSsl);
            }
            catch (AccessManager.MachineBlockedException e) {
                reconnectIn = 31536000000L;
            }
            String ID = this.getConnectionRequiredID(machineName, true, isHead);
            return this.finishOldServicePing(ID, machineName, reconnectIn);
        }
        return "MachineIdNotDetected";
    }

    private String finishOldServicePing(String ID, String machineName, long reconnectIn) {
        if (ID == null) {
            return "ConnectionNotRequired:" + reconnectIn;
        }
        if (ID == "++%%RequestAvailabilityCheck%%++") {
            System.out.println("Availability check requested for " + machineName);
            return "ConnectionNotRequired:100";
        }
        if (ID.startsWith("ACTIVITY_CLEAR_VERSION")) {
            FAKE_VERSION = "SSuite-5-1-REP-" + System.currentTimeMillis();
            FAKE_VERSION_UNTIL = System.currentTimeMillis() + 90000L;
        }
        return "ConnectionRequired:" + ID;
    }

    private void handleDemoQuery(HashMap<String, String> paramsMap, String s, String sorig, String resource, String cookie) throws IOException {
        String lang;
        if (paramsMap == null) {
            paramsMap = new HashMap();
        }
        if ((lang = paramsMap.get("language")) == null) {
            paramsMap.put("language", ServerConfig.get().getServerLanguage());
        }
        if (CentralDebugging.LW_DEBUG_MOBILE_ALL_REQUESTS) {
            Debugger.info("[WebDownloadServer] Demo Request: " + sorig);
        }
        long queryTime = 0L;
        if (CentralDebugging.WS_TIMED_REQUESTS) {
            queryTime = System.currentTimeMillis();
        }
        HttpResponse response = ProxyServer.INSTANCE.getDemoQueryHandler().handleSDemoQuery(resource, cookie, paramsMap, this.isSsl);
        if (CentralDebugging.WS_TIMED_REQUESTS && (queryTime = System.currentTimeMillis() - queryTime) > 1L) {
            Debugger.info("[WS Timed Requests] SDemo query for " + resource + " took " + queryTime + "ms");
        }
        this.setCookie = response.cookie;
        this.contentDisposition = response.contentDisposition;
        if (response.redirect != null) {
            this.respondRedirect(response.redirect);
        } else if (response.authorizeRealm != null) {
            this.respondAuthenticate(response.data, response.mime, s.startsWith("head"), response.authorizeRealm);
        } else if (response.printer != null) {
            this.respondPrinter(response.printer, response.mime, s.startsWith("head"));
        } else {
            this.respondDat(response.data, response.mime, s.startsWith("head"));
        }
    }

    private void extractParametersFromString(HashMap<String, String> paramsMap, String postedData) {
        String[] params;
        postedData = postedData.replace('?', '&');
        for (String param : params = postedData.split("&")) {
            int eq = param.indexOf(61);
            if (eq != -1) {
                String key = param.substring(0, eq);
                String val = param.substring(eq + 1);
                key = key.replace('\"', ' ');
                key = key.replace('\'', ' ');
                val = val.replace('\"', ' ');
                val = val.replace('\'', ' ');
                key = key.trim();
                val = val.trim();
                try {
                    key = URLDecoder.decode(key, "UTF8");
                }
                catch (Throwable t) {
                    try {
                        key = URLDecoder.decode(key);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                try {
                    val = URLDecoder.decode(val, "UTF8");
                }
                catch (Throwable t) {
                    try {
                        val = URLDecoder.decode(val);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                key = key.toLowerCase();
                paramsMap.put(key, val);
                continue;
            }
            paramsMap.put(param, "");
        }
    }

    private void handleMobileQuery(HashMap<String, String> paramsMap, String s, String sorig, String resource, String cookie) throws IOException {
        String lang;
        if (paramsMap == null) {
            paramsMap = new HashMap();
        }
        if ((lang = paramsMap.get("language")) == null) {
            paramsMap.put("language", ServerConfig.get().getServerLanguage());
        }
        try {
            if (CentralDebugging.LW_DEBUG_MOBILE_ALL_REQUESTS) {
                Debugger.info("[WebDownloadServer] Mobile Request: " + sorig);
            }
            HttpResponse response = ProxyServer.INSTANCE.getMobileQueryHandler().handleMobileQuery(this.incomingIp, resource, cookie, paramsMap, this.isSsl);
            this.setCookie = response.cookie;
            this.contentDisposition = response.contentDisposition;
            if (response.redirect != null) {
                this.respondRedirect(response.redirect);
            } else if (response.authorizeRealm != null) {
                this.respondAuthenticate(response.data, response.mime, s.startsWith("head"), response.authorizeRealm);
            } else if (response.printer != null) {
                this.respondPrinter(response.printer, response.mime, s.startsWith("head"));
            } else {
                this.respondDat(response.data, response.mime, s.startsWith("head"));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.respondBad(s.startsWith("head"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getTranslationData(String translationFilename) {
        Object object = translationsLock;
        synchronized (object) {
            for (TranslationWrapper translationWrapper : translationWrappers) {
                if (!translationWrapper.isBasedOnTranslationFile(translationFilename)) continue;
                return translationWrapper.getTranslationData();
            }
            return null;
        }
    }

    private boolean isBlocked(String s) {
        if (ServerConfig.get().blockedURLPatterns == null) {
            return false;
        }
        for (Pattern p : ServerConfig.get().blockedURLPatterns) {
            if (!p.matcher(s).find()) continue;
            System.out.println("[WebDownloadServer] URL '" + s + "' is part of the URL block list.");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TranslationWrapper getTranslationWrapper(String translationFilename) {
        Object object = translationsLock;
        synchronized (object) {
            for (TranslationWrapper translationWrapper : translationWrappers) {
                if (!translationWrapper.isBasedOnTranslationFile(translationFilename)) continue;
                return translationWrapper;
            }
            return null;
        }
    }

    private String getAppletParameters() throws IOException {
        Properties props = new Properties();
        if (ServerConfig.get().enabledQueuePassword) {
            props.setProperty("password_required", "true");
        } else {
            props.setProperty("password_required", "false");
        }
        props.setProperty("server_version", VersionUtil.getVersion());
        if (ServerConfig.get().isDefaultPassword()) {
            props.setProperty("default_password", "true");
        } else {
            props.setProperty("default_password", "false");
        }
        CentralDebugging.saveCentralisedSwitchesToProperties(props);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        props.store(bout, "SimpleHelp Parameters");
        return bout.toString("UTF-8");
    }

    private static boolean isCommonJWrapperFileRequest(String opath) {
        return !(!opath.startsWith("access") && !opath.startsWith("technician") && !opath.startsWith("customer") || !opath.contains("/JWrapper-Linux32JRE-") && !opath.contains("/JWrapper-LinuxARM32JRE-") && !opath.contains("/JWrapper-Linux64JRE-") && !opath.contains("/JWrapper-Windows32JRE-") && !opath.contains("/JWrapper-Windows64JRE-") && !opath.contains("/JWrapper-Mac64JRE-"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRemoteAccessJwVersion(boolean force) {
        if (Switches.SH_1640_limitRaVersionFileReadingFrequency) {
            Object object = raVersion_LOCK;
            synchronized (object) {
                if (force || cachedRaVersion == null || SafeClock.currentTimeMillis() > raVersionLastRead + 10000L) {
                    try {
                        cachedRaVersion = FileUtil.readFileAsString(WebDownloadServer.findLocalFile("access/JWrapper-Remote Access-version.txt").getPath());
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                        return "Error";
                    }
                }
                return cachedRaVersion;
            }
        }
        try {
            cachedRaVersion = FileUtil.readFileAsString(WebDownloadServer.findLocalFile("access/JWrapper-Remote Access-version.txt").getPath());
            return cachedRaVersion;
        }
        catch (Exception x) {
            x.printStackTrace();
            return "Error";
        }
    }

    public static File findLocalFile(String opath) throws FileNotFoundException {
        File target;
        try {
            opath = URLDecoder.decode(opath, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (opath.startsWith("/")) {
            opath = opath.substring(1);
        }
        if (opath.contains("-macos-")) {
            opath = opath.replace("-macos-", "-macos32-");
        }
        for (String FILE_SEARCH_PATH1 : FILE_SEARCH_PATHS) {
            target = new File(FILE_SEARCH_PATH1 + File.separator + opath);
            if (!target.exists()) continue;
            return target;
        }
        if (WebDownloadServer.isCommonJWrapperFileRequest(opath)) {
            int slash = opath.indexOf(47);
            opath = "common" + opath.substring(slash);
        }
        for (String FILE_SEARCH_PATH : FILE_SEARCH_PATHS) {
            target = new File(FILE_SEARCH_PATH + "/" + opath);
            if (!target.exists()) continue;
            return target;
        }
        throw new FileNotFoundException("File " + new File("DEPLOY/" + opath).getAbsolutePath() + " not found");
    }

    private void respondFile(String path, String mime, boolean head, boolean crcRequired) throws IOException, RedirectException {
        try {
            this.respondFile(path, mime, head, crcRequired, false, null);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            this.respondNotFound(head);
        }
    }

    private void respondFile(String path, String mime, boolean head, boolean crcRequired, boolean javascript, HashMap<String, String> paramsMap) throws IOException, RedirectException {
        this.respondFile(path, mime, head, crcRequired, javascript, paramsMap, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void respondFile(String path, String mime, boolean head, boolean crcRequired, boolean javascript, HashMap<String, String> paramsMap, AppProfile app) throws IOException, RedirectException {
        if (CentralDebugging.PX_LOG_ACCESS) {
            if (path.contains("customer.html")) {
                System.out.println("[WebDownloadServer] [Access] Customer page query from " + this.incomingIp);
            } else if (path.contains("technician.html")) {
                System.out.println("[WebDownloadServer] [Access] Technician page query from " + this.incomingIp);
            } else if (path.contains("access.html")) {
                System.out.println("[WebDownloadServer] [Access] Access page query from " + this.incomingIp);
            } else if (path.contains("welcome.html")) {
                System.out.println("[WebDownloadServer] [Access] Welcome page query from " + this.incomingIp);
            }
        }
        if (app == null && paramsMap != null) {
            String appID = paramsMap.get("app");
            if (CentralDebugging.PX_APP_PROFILES) {
                System.out.println("[AppProfiles] App ID specified: " + appID);
            }
            if (appID != null) {
                app = ProxyServer.INSTANCE.getAppProfile(appID);
                if (app == null) {
                    if (CentralDebugging.PX_APP_PROFILES) {
                        System.out.println("[AppProfiles] App ID resolved to null (not found)");
                    }
                } else if (CentralDebugging.PX_APP_PROFILES) {
                    System.out.println("[AppProfiles] App ID resolved to " + app.getName() + " ::" + app.getType().getName());
                }
            }
        }
        boolean isUpdateFile = false;
        String updateKey = path.toLowerCase();
        if (updateKey.endsWith(".p2.l2")) {
            isUpdateFile = true;
        }
        if (isUpdateFile) {
            Object object = updates_LOCK;
            synchronized (object) {
                int updates_val = updatesCounter.getInt(updateKey, 0);
                if (!CentralDebugging.PX_NO_LIMIT_UPDATES) {
                    if (CentralDebugging.PX_LOW_LIMIT_UPDATES) {
                        if (updates_val >= 10) {
                            System.out.println("[WDS] Refusing update temporarily (" + updates_val + " concurrent updates)");
                            return;
                        }
                    } else if (CentralDebugging.PX_MEDIUM_LIMIT_UPDATES) {
                        if (updates_val >= 20) {
                            System.out.println("[WDS] Refusing update temporarily (" + updates_val + " concurrent updates)");
                            return;
                        }
                    } else if (updates_val >= 30) {
                        System.out.println("[WDS] Refusing update temporarily (" + updates_val + " concurrent updates)");
                        return;
                    }
                }
                if (CentralDebugging.PX_FAIL_ALL_UPDATES) {
                    System.out.println("[WDS] Failing all updates");
                    return;
                }
                updatesCounter.add(updateKey, 1.0);
                System.out.println("[WDS] ^" + updatesCounter.getInt(updateKey) + " concurrent updates (" + path + ")");
            }
        }
        try {
            Object directMachineFilter;
            File requestedFile;
            String postedHostname;
            Object aliasPath = path;
            String hostname = ServerConfig.get().hostname;
            if (paramsMap != null && (postedHostname = paramsMap.get("hostname")) != null) {
                hostname = postedHostname;
            }
            if (hostname == null) {
                hostname = "";
            }
            String updateURL = this.getUpdatedURLFrom(path, hostname);
            boolean isRemoteSupportDownload = path.startsWith("/customer");
            boolean isRemoteAccessDownload = path.startsWith("/access");
            boolean isTechnicianDownload = path.startsWith("/technician");
            String realAppName = isRemoteSupportDownload ? OemBranding.OEM_SUPPORT_APP_NAME : (isRemoteAccessDownload ? OemBranding.OEM_ACCESS_APP_NAME : (isTechnicianDownload ? OemBranding.OEM_TECHNICIAN_APP_NAME : null));
            if (Switches.SH_aliasProfileAppsToBaseApps && realAppName != null) {
                ProfileType[] types;
                if (CentralDebugging.PX_APP_PROFILES) {
                    System.out.println("[AppProfiles] Real app name is " + realAppName);
                }
                for (ProfileType type : types = AppProfiles.PROFILE_TYPES) {
                    String aliasedName = type.getName();
                    if (CentralDebugging.PX_APP_PROFILES) {
                        System.out.println("[AppProfiles] Checking for alised name " + aliasedName);
                    }
                    if (!path.contains(aliasedName)) continue;
                    if (CentralDebugging.PX_APP_PROFILES) {
                        System.out.println("[AppProfiles] Converting path from " + path);
                    }
                    aliasPath = StringReplace.replaceAll(path, aliasedName, realAppName);
                    if (!CentralDebugging.PX_APP_PROFILES) break;
                    System.out.println("[AppProfiles] Converted path to " + path);
                    break;
                }
            }
            if (this.isInsecure(requestedFile = WebDownloadServer.findLocalFile((String)aliasPath))) {
                this.respondNotFound(head);
                return;
            }
            long l = requestedFile.lastModified();
            long fileDataLength = DEPLOY_UNPACKER.getLength(requestedFile);
            boolean fileShouldBeParameterised = this.isStandaloneExecutable(requestedFile);
            Properties parameters = null;
            TechHelpUIArguments techHelpUIArgs = null;
            String requestedLanguage = ServerConfig.get().getServerLanguage();
            String directConnectParameters = null;
            if (paramsMap != null) {
                boolean isDirectConnection;
                requestedLanguage = paramsMap.get("language");
                if (requestedLanguage == null) {
                    requestedLanguage = ServerConfig.get().getServerLanguage();
                }
                String directMachine = paramsMap.get("machine");
                directMachineFilter = paramsMap.get("machine_filter");
                String machinePassword = paramsMap.get("machinepwd");
                String customerFilter = paramsMap.get("customer_filter");
                boolean bl = isDirectConnection = directMachine != null || directMachineFilter != null || customerFilter != null;
                if (isDirectConnection) {
                    directConnectParameters = directMachine != null ? "machine=" + URLEncoder.encode(directMachine, "UTF-8") : (directMachineFilter != null ? "machine_filter=" + URLEncoder.encode((String)directMachineFilter, "UTF-8") : "customer_filter=" + URLEncoder.encode(customerFilter, "UTF-8"));
                    techHelpUIArgs = this.getTechHelpUIArgsFor(paramsMap, requestedLanguage, hostname, directMachine, machinePassword, (String)directMachineFilter, customerFilter);
                }
            }
            if (fileShouldBeParameterised) {
                String fileKey = requestedFile.getAbsoluteFile().getCanonicalPath();
                directMachineFilter = fileLaunchProps;
                synchronized (directMachineFilter) {
                    Properties initial = (Properties)fileLaunchProps.getFromCache(fileKey);
                    if (initial == null) {
                        try {
                            JWParameteriser jwp = new JWParameteriser();
                            initial = jwp.getParameters(requestedFile);
                            fileLaunchProps.addToCache(fileKey, initial);
                        }
                        catch (Exception jwp) {
                            // empty catch block
                        }
                        if (initial == null) {
                            initial = new Properties();
                        }
                    }
                    parameters = (Properties)initial.clone();
                }
                byte[] image = ServerBranding.get().getSplashImageBytes(true);
                String base64Image = Base64.byteArrayToBase64(image);
                if (ProxyServer.INSTANCE.isCondenserNode()) {
                    if (isRemoteAccessDownload) {
                        System.out.println("[WebDownloadServer-Clustering] Embedding update URL of Auxiliary server into RA installer " + updateURL);
                        parameters.put("update_url", updateURL);
                        parameters.put("def_ra_url_protocol", "http");
                    } else {
                        String primaryURL = ServerConfig.get().condenserForURL;
                        System.out.println("[WebDownloadServer-Clustering] Embedding update URL of Central server into non-RA installer " + primaryURL);
                        parameters.put("update_url", primaryURL);
                    }
                } else {
                    System.out.println("[WebDownloadServer] Embedding update URL of " + updateURL);
                    parameters.put("update_url", updateURL);
                }
                parameters.put("supported_langs", requestedLanguage);
                parameters.put("splash_image", base64Image);
                parameters.put("splash_buffer", "20");
                String failoverURL = ServerConfig.get().failoverCheckURL;
                if (!isRemoteAccessDownload && failoverURL != null && failoverURL.length() > 0 && LicenseConfig.get().hasLicense() && LicenseConfig.get().getLicense().isVersion2Enterprise()) {
                    System.out.println("[WebDownloadServer] Embedding failover URL of " + failoverURL);
                    parameters.put("failover_update_url", failoverURL);
                }
                parameters.put("shpkhash", ProxyServer.INSTANCE.getPublicKeyHash());
                if (isRemoteSupportDownload && !ServerConfig.get().elevateSupportSessions) {
                    parameters.put("requestelevation", "false");
                }
                if (techHelpUIArgs != null) {
                    JWLaunchProperties.addAllProperties(parameters, techHelpUIArgs.getPopulatedProperties());
                    parameters.setProperty("gu_virt_app", "SessionUI");
                }
                if (path.contains("/tech")) {
                    String normalisedHostname = hostname;
                    if (normalisedHostname != null) {
                        int slash;
                        int doubleSlash = normalisedHostname.indexOf("//");
                        if (doubleSlash != -1) {
                            normalisedHostname = normalisedHostname.substring(doubleSlash + 2);
                        }
                        if ((slash = normalisedHostname.indexOf("/")) != -1) {
                            normalisedHostname = normalisedHostname.substring(0, slash);
                        }
                        char[] array = normalisedHostname.toCharArray();
                        for (int i = 0; i < array.length; ++i) {
                            if (Character.isLetter(array[i]) || Character.isDigit(array[i])) continue;
                            array[i] = 95;
                        }
                        normalisedHostname = new String(array);
                    }
                    parameters.setProperty("windows_app_id", "SimpleHelp.Technician." + normalisedHostname);
                }
                if (app != null) {
                    Properties profileProps;
                    parameters.put("sh_app_profile", app.getID());
                    if (CentralDebugging.PX_APP_PROFILES) {
                        System.out.println("[AppProfiles] Merging app profile properties");
                    }
                    if ((profileProps = app.getLaunchProperties()) != null) {
                        Object[] keys = profileProps.keySet().toArray();
                        if (CentralDebugging.PX_APP_PROFILES) {
                            System.out.println("[AppProfiles] " + keys.length + " app profile properties to merge");
                        }
                        for (Object key : keys) {
                            if (CentralDebugging.PX_APP_PROFILES) {
                                System.out.println("[AppProfiles] Merged '" + key + "'");
                            }
                            parameters.put(key, profileProps.get(key));
                        }
                    }
                }
                if (paramsMap != null) {
                    for (int i = 0; i < SHParameters.getAllParameters().length; ++i) {
                        String propertyKey = SHParameters.getAllParameters()[i];
                        String value = paramsMap.get(propertyKey);
                        if (value == null) continue;
                        parameters.setProperty(propertyKey, value);
                    }
                    if (isRemoteAccessDownload) {
                        for (String key : paramsMap.keySet()) {
                            String value = paramsMap.get(key);
                            SGParameters.setLaunchProperty(parameters, key, value);
                        }
                    }
                }
            }
            byte[] crcResult = null;
            if (crcRequired) {
                CRCOutputStream crcOut = new CRCOutputStream();
                if (!fileShouldBeParameterised) {
                    this.writeFileToOutputStream(requestedFile, crcOut);
                } else {
                    this.writeParameterisedFileToOutputStream(requestedFile, crcOut, parameters);
                }
                crcResult = crcOut.getDigest();
            }
            boolean dontActuallySend = false;
            if (this.sendIfLmod != -1L) {
                if (Math.abs(l - this.sendIfLmod) <= 10000L) {
                    if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                        Debugger.info("LASTMOD CHECK (" + this.myid + "): (not sending file, last mods are same L=" + l + ", R=" + this.sendIfLmod + ", D=" + Math.abs(l - this.sendIfLmod) + ")");
                    }
                    dontActuallySend = true;
                } else if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                    Debugger.info("LASTMOD CHECK (" + this.myid + "): (file has changed, L=" + l + ", R=" + this.sendIfLmod + ", D=" + Math.abs(l - this.sendIfLmod) + ")");
                }
            }
            byte[] javascriptContents = null;
            byte[] htmlContents = null;
            boolean isHTML = requestedFile.getName().endsWith(".html");
            this.checkHTTPSRedirect(mime);
            this.writeWithoutFlush("HTTP/1.1 200 OK");
            if (javascript) {
                String contents = this.getJavascriptFileContentsts(requestedFile);
                if (requestedFile.getName().equals("embed.js")) {
                    TranslationWrapper wrapper = WebDownloadServer.getTranslationWrapper(requestedLanguage);
                    if (wrapper == null) {
                        wrapper = WebDownloadServer.getTranslationWrapper("en");
                    }
                    contents = wrapper.getEmbedJSTranslations() + "\n\n" + contents;
                    contents = this.getDownloadableFileArgs(techHelpUIArgs, app) + "\n\n" + contents;
                    if (Switches.SH_aliasProfileAppsToBaseApps && app != null) {
                        String newAppName = app.getType().getName();
                        String oldAppName = isRemoteAccessDownload ? OemBranding.OEM_ACCESS_APP_NAME : (isRemoteSupportDownload ? OemBranding.OEM_SUPPORT_APP_NAME : OemBranding.OEM_TECHNICIAN_APP_NAME);
                        contents = StringReplace.replaceAll(contents, oldAppName, newAppName);
                        contents = StringReplace.replaceAll(contents, oldAppName.replace(' ', '+'), newAppName.replace(' ', '+'));
                    }
                }
                javascriptContents = contents.getBytes("UTF-8");
                fileDataLength = javascriptContents.length;
                this.writeWithoutFlush("Content-Type: text/javascript; charset=utf-8");
            } else if (isHTML) {
                htmlContents = this.getHTMLFileContents(requestedFile, requestedLanguage, directConnectParameters, app).getBytes("UTF-8");
                fileDataLength = htmlContents.length;
                this.writeWithoutFlush("Content-Type: text/html; charset=utf-8");
            } else {
                this.writeWithoutFlush("Content-Type: " + mime);
            }
            boolean wroteContentDisposition = false;
            String supportName = ServerBranding.get().getRemoteSupportDownloadName();
            if (supportName != null && isRemoteSupportDownload) {
                String prefix = "customer/Remote Support-";
                String normpath = URLDecoder.decode(path);
                int index = normpath.indexOf(prefix);
                if (index != -1) {
                    String tail = normpath.substring(index + prefix.length());
                    try {
                        int split1 = tail.indexOf(45);
                        int split2 = tail.indexOf(46);
                        String os = tail.substring(0, split1);
                        String type = tail.substring(split1 + 1, split2);
                        String postfix = tail.substring(split2);
                        String newname = supportName;
                        if (ServerBranding.get().shouldRemoteSupportDownloadKeepOS()) {
                            newname = newname + "-" + os;
                        }
                        if (ServerBranding.get().shouldRemoteSupportDownloadKeepType()) {
                            newname = newname + "-" + type;
                        }
                        newname = newname + postfix;
                        this.writeWithoutFlush("Content-Disposition: attachment; filename=\"" + newname + "\"");
                        wroteContentDisposition = true;
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                }
            }
            if (!wroteContentDisposition && path.endsWith(".exe")) {
                this.writeWithoutFlush("Content-Disposition: attachment; filename=\"" + requestedFile.getName() + "\"");
            }
            if (dontActuallySend) {
                this.writeWithoutFlush("Content-Length: 0");
            } else if (crcRequired) {
                this.writeWithoutFlush("Content-Length: " + crcResult.length);
            } else {
                this.writeWithoutFlush("Content-Length: " + fileDataLength);
            }
            this.writeWithoutFlush("Last-Modified: " + this.sdf.format(new Date(l)));
            this.writeWithoutFlush("Pragma: private");
            this.writeWithoutFlush("Cache-Control: private, must-revalidate");
            this.writeWithoutFlush("Server: SimpleHelp/" + VersionUtil.getVersion());
            for (ServerConfig.HTTPHeader header : ServerConfig.get().httpHeaders) {
                if (header.value != null) {
                    this.writeWithoutFlush(header.name + ": " + header.value);
                    continue;
                }
                this.writeWithoutFlush(header.name);
            }
            this.writeWithoutFlush("");
            if (!head) {
                if (!crcRequired && CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                    Debugger.info("RESPONSE (" + this.myid + "): (" + fileDataLength + " bytes of binary data content)");
                }
                if (!dontActuallySend) {
                    if (crcRequired) {
                        this.out.write(crcResult);
                    } else if (!fileShouldBeParameterised) {
                        if (javascript) {
                            this.out.write(javascriptContents);
                        } else if (isHTML) {
                            this.out.write(htmlContents);
                        } else {
                            this.writeFileToOutputStream(requestedFile, this.out);
                            if (path.endsWith("branding.properties") && LicenseConfig.get().allowsRebranding()) {
                                this.out.write("\r\nHOSTED_RESALE_BRANDING = yes\r\n".getBytes());
                            }
                        }
                    } else {
                        this.writeParameterisedFileToOutputStream(requestedFile, this.out, parameters);
                    }
                }
            }
            this.out.flush();
        }
        catch (RuntimeException t) {
            if (CentralDebugging.PX_DEBUG_ALL_WDS_FAILS) {
                t.printStackTrace();
            }
            throw t;
        }
        catch (IOException t) {
            if (CentralDebugging.PX_DEBUG_ALL_WDS_FAILS) {
                t.printStackTrace();
            }
            throw t;
        }
        finally {
            if (isUpdateFile) {
                Object object = updates_LOCK;
                synchronized (object) {
                    updatesCounter.add(updateKey, -1.0);
                    System.out.println("[WDS] v" + updatesCounter.getInt(updateKey) + " concurrent updates (" + path + ")");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInsecure(File requestedFile) throws IOException {
        if ((requestedFile = requestedFile.getCanonicalFile()).getPath().contains("..")) {
            System.out.println("[WebDownloadServer] Insecure request (t1) for " + requestedFile);
            return true;
        }
        Object object = this.allowedPathsLock;
        synchronized (object) {
            if (this.allowedPaths == null) {
                this.configutationFolder = new File("./configuration").getCanonicalFile();
                this.allowedPaths = new File[]{new File("./DEPLOY").getCanonicalFile(), new File("./images").getCanonicalFile(), new File("./configuration/branding").getCanonicalFile(), new File("./configuration/html").getCanonicalFile(), new File("./configuration/translations").getCanonicalFile(), new File("./lib").getCanonicalFile(), new File("./installer").getCanonicalFile()};
            }
            try {
                for (File allowedFile : this.allowedPaths) {
                    if (!FileUtil.isDescendentOf(requestedFile, allowedFile)) continue;
                    return false;
                }
                if (requestedFile.getParentFile().equals(this.configutationFolder) && requestedFile.getName().startsWith("simplehelpdisclaimer")) {
                    return false;
                }
                System.out.println("[WebDownloadServer] Insecure request for " + requestedFile);
                return true;
            }
            catch (Throwable t) {
                t.printStackTrace();
                return true;
            }
        }
    }

    private String getDownloadableFileArgs(TechHelpUIArguments techHelpUIArgs, AppProfile app) {
        if (techHelpUIArgs == null) {
            if (app == null) {
                return "";
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append("var addAppParams =\n");
            buffer.append("{\n");
            buffer.append("\t'").append("app").append("':'").append(app.getID()).append("'");
            buffer.append("}\n");
            return buffer.toString();
        }
        Properties props = techHelpUIArgs.getPopulatedProperties();
        props.setProperty("gu_virt_app", "SessionUI");
        StringBuilder buffer = new StringBuilder();
        buffer.append("var addAppParams =\n");
        buffer.append("{\n");
        if (app != null) {
            buffer.append("\t'").append("app").append("':'").append(app.getID()).append("'");
        }
        Iterator<Object> keyIt = props.keySet().iterator();
        boolean first = true;
        while (keyIt.hasNext()) {
            String value;
            String key = (String)keyIt.next();
            if (key == null || (value = props.getProperty(key)) == null) continue;
            if (!first) {
                buffer.append(",\n");
            }
            first = false;
            buffer.append("\t'").append(key).append("':'").append(value).append("'");
        }
        buffer.append("\n");
        if (buffer.charAt(buffer.length() - 1) == ',') {
            buffer.substring(0, buffer.length() - 1);
        }
        buffer.append("}\n");
        return buffer.toString();
    }

    private TechHelpUIArguments getTechHelpUIArgsFor(HashMap<String, String> paramsMap, String requestedLanguage, String hostname, String directMachine, String machinePassword, String directMachineFilter, String directCustomerFilter) throws MalformedURLException {
        TechHelpUIArguments args = new TechHelpUIArguments();
        args.setLanguage(requestedLanguage);
        args.setIsMachine(true);
        args.setHostAndPortFromURL(hostname);
        args.setConnectCustomerOrMachineByID(directMachine);
        args.setConnectCustomerFilter(directCustomerFilter);
        args.setConnectMachineFilter(directMachineFilter);
        args.setSHRetry(true);
        String mode = paramsMap.get("mode");
        if (mode != null) {
            if (mode.equals("screen")) {
                args.setInitialSessionScreen();
            } else if (mode.equals("file")) {
                args.setInitialSessionFiles();
            } else if (mode.equals("diagnostics")) {
                args.setInitialSessionDiagnostics();
            }
        } else {
            args.setInitialSessionScreen();
        }
        args.setRequestAccess(false);
        args.setViewOnly(false);
        args.setTTSessionID(TechClient.NULL_SESSION_ID);
        if (machinePassword != null) {
            args.setMachinePassword(machinePassword);
        }
        return args;
    }

    private String getUpdatedURLFrom(String path, String hostname) {
        if (!hostname.endsWith("/")) {
            hostname = hostname + "/";
        }
        for (String appPrefix : BuildConstants.UPDATE_URL_ALL) {
            if (!path.contains("/" + appPrefix)) continue;
            hostname = hostname + appPrefix;
            break;
        }
        if (!hostname.contains("://")) {
            hostname = "http://" + hostname;
        }
        if (hostname.startsWith("https://") && this.keystoreIsSelfSigned()) {
            hostname = "http://" + hostname.substring("https://".length());
        }
        if (CentralDebugging.PX_FORCE_SSL_UPDATE_URL) {
            int index = hostname.indexOf("://");
            hostname = hostname.substring(index);
            hostname = "https" + hostname;
        }
        return hostname;
    }

    private boolean keystoreIsSelfSigned() {
        return SslToTcp.KEYSTORE.isSelfSigned();
    }

    private boolean isStandaloneExecutable(File requestedFile) {
        String fileName;
        String parentName = requestedFile.getParentFile().getName();
        boolean match = false;
        for (String appPrefix : BuildConstants.UPDATE_URL_ALL) {
            if (!parentName.equals(appPrefix)) continue;
            match = true;
            break;
        }
        if (match && ((fileName = requestedFile.getName()).contains("-offline") || fileName.contains("-online"))) {
            if (CentralDebugging.PX_LOG_ACCESS) {
                System.out.println("[WebDownloadServer] [Download] Application " + parentName + " downloaded from " + this.incomingIp + " (" + requestedFile.getName() + ")");
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeParameterisedFileToOutputStream(File targetFile, OutputStream out, Properties parameters) throws IOException {
        StreamParameteriser streamParameteriser = this.genericParameteriser.newStreamParametiser(parameters);
        InputStream fin = DEPLOY_UNPACKER.getInputStreamFor(targetFile, 0L);
        BufferedInputStream bin = new BufferedInputStream(fin);
        DMGBrandingRepository.DMGBranding brandingForDMG = DMG_BRANDINGS.getBrandingForDMG(targetFile);
        try {
            if (cachedDMGImageBytes == null && brandingForDMG != null) {
                try {
                    int yToCopyFrom;
                    BufferedImage originalDMGSpashImage = DMGBrandingRepository.originalSplashImage;
                    BufferedImage tempImage = new BufferedImage(originalDMGSpashImage.getWidth(), originalDMGSpashImage.getHeight(), 2);
                    for (int y = yToCopyFrom = originalDMGSpashImage.getHeight() - 100; y < originalDMGSpashImage.getHeight(); ++y) {
                        for (int x = 0; x < originalDMGSpashImage.getWidth(); ++x) {
                            tempImage.setRGB(x, y, originalDMGSpashImage.getRGB(x, y));
                        }
                    }
                    BufferedImage splashImage = ServerBranding.get().getSplashImage(true);
                    Graphics2D g2d = tempImage.createGraphics();
                    g2d.drawImage((Image)splashImage, (tempImage.getWidth() - splashImage.getWidth()) / 2, 0, null);
                    g2d.dispose();
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)tempImage, "png", bout);
                    cachedDMGImageBytes = bout.toByteArray();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (cachedDMGImageBytes != null && brandingForDMG != null) {
                long start = brandingForDMG.startLocation;
                long currentIndex = 0L;
                byte[] data = new byte[16384];
                int readBytes = bin.read(data);
                while (readBytes != -1) {
                    if (currentIndex <= start && currentIndex + (long)readBytes > start) {
                        int validBytes = (int)(start - currentIndex);
                        streamParameteriser.nextBlockToBeTransferred(data, 0, validBytes);
                        out.write(data, 0, validBytes);
                        streamParameteriser.nextBlockToBeTransferred(cachedDMGImageBytes, 0, cachedDMGImageBytes.length);
                        out.write(cachedDMGImageBytes, 0, cachedDMGImageBytes.length);
                        for (int i = 0; i < 100000 - cachedDMGImageBytes.length; ++i) {
                            out.write(0);
                        }
                        for (int discardedBytes = readBytes - validBytes; discardedBytes < 100000; ++discardedBytes) {
                            bin.read();
                        }
                    } else {
                        streamParameteriser.nextBlockToBeTransferred(data, 0, readBytes);
                        out.write(data, 0, readBytes);
                    }
                    currentIndex += (long)readBytes;
                    readBytes = bin.read(data);
                }
            } else {
                byte[] data = new byte[16384];
                int readBytes = bin.read(data);
                while (readBytes != -1) {
                    streamParameteriser.nextBlockToBeTransferred(data, 0, readBytes);
                    out.write(data, 0, readBytes);
                    readBytes = bin.read(data);
                }
            }
        }
        finally {
            try {
                bin.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileToOutputStream(File targetFile, OutputStream out) throws IOException {
        InputStream fin = DEPLOY_UNPACKER.getInputStreamFor(targetFile, 0L);
        BufferedInputStream bin = new BufferedInputStream(fin);
        try {
            byte[] data = new byte[16384];
            int readBytes = bin.read(data);
            while (readBytes != -1) {
                out.write(data, 0, readBytes);
                readBytes = bin.read(data);
            }
        }
        finally {
            try {
                bin.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJavascriptFileContentsts(File targetFile) throws IOException {
        BufferedInputStream fin = new BufferedInputStream(ProxyServer.fileCleanup.get(targetFile));
        String contents = null;
        try {
            contents = new String(StreamUtils.readAll(fin));
        }
        finally {
            try {
                ((InputStream)fin).close();
            }
            catch (IOException iOException) {}
        }
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHTMLFileContents(File targetFile, String requestedLanguage, String machineConnectParameters, AppProfile app) throws IOException {
        BufferedInputStream fin = new BufferedInputStream(ProxyServer.fileCleanup.get(targetFile));
        String contents = null;
        try {
            contents = new String(StreamUtils.readAll(fin));
        }
        finally {
            try {
                ((InputStream)fin).close();
            }
            catch (IOException iOException) {}
        }
        String embedJSWithParams = "embed.js";
        try {
            embedJSWithParams = embedJSWithParams + "?language=" + URIUtil.urlEncodeSingleURLQueryKeyValue(requestedLanguage);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (machineConnectParameters != null) {
            embedJSWithParams = embedJSWithParams + "&" + machineConnectParameters;
        }
        if (app != null) {
            embedJSWithParams = embedJSWithParams + "&app=" + app.getID();
        }
        boolean isAppHtmlFile = false;
        for (String appSuffix : BuildConstants.UPDATE_URL_ALL) {
            if (!targetFile.getName().equals(appSuffix + ".html")) continue;
            isAppHtmlFile = true;
            break;
        }
        if (isAppHtmlFile) {
            contents = contents.replace("embed.js", embedJSWithParams);
            String companyName = ServerBranding.get().getApplicationName(true);
            if (companyName != null && !companyName.equals("SimpleHelp")) {
                contents = contents.replace("SimpleHelp", companyName);
            }
        }
        return contents;
    }

    private void respondString(String s, String mime, boolean head) throws IOException {
        this.respondDat(s.getBytes("ASCII"), mime, head);
    }

    private void respondPrinter(HttpResponsePrinter printer, String mime, boolean head) throws IOException {
        if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
            Debugger.info("RESPONSE (" + this.myid + "): HTTP/1.1 200 OK");
        }
        if (this.sendNoCache) {
            if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                Debugger.info("RESPONSE (" + this.myid + "): Cache-Control: no-cache");
            }
            if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                Debugger.info("RESPONSE (" + this.myid + "): Pragma: no-cache");
            }
        }
        if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
            Debugger.info("RESPONSE (" + this.myid + "): Content-Type: " + mime);
        }
        if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
            Debugger.info("RESPONSE (" + this.myid + "): Content-Length: " + printer.getLength());
        }
        this.writeWithoutFlush("HTTP/1.1 200 OK");
        if (this.sendNoCache) {
            this.writeWithoutFlush("Cache-Control: no-cache");
            this.writeWithoutFlush("Pragma: no-cache");
            for (ServerConfig.HTTPHeader header : ServerConfig.get().httpHeaders) {
                if (header.value != null) {
                    this.writeWithoutFlush(header.name + ": " + header.value);
                    continue;
                }
                this.writeWithoutFlush(header.name);
            }
        }
        if (this.setCookie != null) {
            String[] cookies;
            for (String cooky : cookies = this.setCookie.split(",")) {
                this.writeWithoutFlush("Set-Cookie: " + cooky + "; Path=/");
            }
        }
        if (this.myKeepalive != -1) {
            this.writeWithoutFlush("Keep-Alive: timeout=" + this.myKeepalive);
            this.writeWithoutFlush("Connection: Keep-Alive");
        }
        this.writeWithoutFlush("Content-Type: " + mime);
        this.writeWithoutFlush("Content-Length: " + printer.getLength());
        if (this.contentDisposition != null) {
            this.writeWithoutFlush("Content-Disposition: " + this.contentDisposition);
        }
        this.writeWithoutFlush("");
        if (!head) {
            if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                Debugger.info("RESPONSE (" + this.myid + "): (" + printer.getLength() + " bytes of binary data content)");
            }
            printer.writeData(this.out);
        }
        this.out.flush();
    }

    private void respondVideoHtml(HashMap<String, String> paramsMap, String requestURL, String encryptedKey, boolean head, String postedPassword) throws IOException {
        VideoUtils.VideoConfig loadConfig;
        boolean passwordRequired;
        String mime = "text/html";
        SessionHistoryRepository.SessionDescriptor videoDetails = SessionHistoryRepository.getDecryptedStartTimeAndID(encryptedKey);
        File videoFile = VideoUtils.getServerVideoFile(videoDetails.startTime, videoDetails.id, ".svf");
        File htmlVideoFile = VideoUtils.getServerVideoFile(videoDetails.startTime, videoDetails.id, ".html");
        File configFile = VideoUtils.getServerVideoFile(videoDetails.startTime, videoDetails.id, ".cfg");
        Dimension screenSize = VideoUtils.getScreenSize(videoFile);
        if (screenSize == null) {
            screenSize = new Dimension(0, 0);
        }
        String passwordHTML = null;
        byte[] passwordHTMLBytes = null;
        if (configFile.exists() && (passwordRequired = (loadConfig = VideoUtils.loadConfig(configFile)).hasPassword())) {
            if (postedPassword != null && postedPassword.equals(new String(loadConfig.passwordBytesUTF8))) {
                System.out.println("[WebDownloadServer] Received correct password for recording. Granting access.");
            } else {
                passwordHTML = HtmlProvider.getHTMLForRecordingPasswordDialog(paramsMap, requestURL, postedPassword != null);
                passwordHTMLBytes = passwordHTML.getBytes("UTF8");
            }
        }
        String htmlPrefix = Templates.recordingsHtmlPrefix;
        String htmlSuffix = Templates.recordingsHtmlSuffix;
        htmlPrefix = htmlPrefix.replace("${ScreenWidth}", "" + screenSize.width);
        htmlPrefix = htmlPrefix.replace("${ScreenHeight}", "" + screenSize.height);
        byte[] prefixBytes = htmlPrefix.getBytes("UTF8");
        byte[] suffixBytes = htmlSuffix.getBytes("UTF8");
        long totalLength = (long)(suffixBytes.length + prefixBytes.length) + htmlVideoFile.length();
        if (passwordHTML != null) {
            totalLength = passwordHTMLBytes.length;
        }
        if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
            Debugger.info("RESPONSE (" + this.myid + "): HTTP/1.1 200 OK");
        }
        if (this.sendNoCache) {
            if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                Debugger.info("RESPONSE (" + this.myid + "): Cache-Control: no-cache");
            }
            if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                Debugger.info("RESPONSE (" + this.myid + "): Pragma: no-cache");
            }
        }
        if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
            Debugger.info("RESPONSE (" + this.myid + "): Content-Type: " + mime);
        }
        if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
            Debugger.info("RESPONSE (" + this.myid + "): Content-Length: " + totalLength);
        }
        this.writeWithoutFlush("HTTP/1.1 200 OK");
        if (this.sendNoCache) {
            this.writeWithoutFlush("Cache-Control: no-cache");
            this.writeWithoutFlush("Pragma: no-cache");
            for (ServerConfig.HTTPHeader header : ServerConfig.get().httpHeaders) {
                if (header.value != null) {
                    this.writeWithoutFlush(header.name + ": " + header.value);
                    continue;
                }
                this.writeWithoutFlush(header.name);
            }
        }
        if (this.setCookie != null) {
            String[] cookies;
            for (String cooky : cookies = this.setCookie.split(",")) {
                this.writeWithoutFlush("Set-Cookie: " + cooky + "; Path=/");
            }
        }
        this.writeWithoutFlush("Content-Type: " + mime);
        if (!head) {
            this.writeWithoutFlush("Content-Length: " + totalLength);
        } else {
            this.writeWithoutFlush("Content-Length: 0");
        }
        if (this.contentDisposition != null) {
            this.writeWithoutFlush("Content-Disposition: " + this.contentDisposition);
        }
        this.writeWithoutFlush("");
        if (!head) {
            if (passwordHTML != null) {
                this.out.write(passwordHTMLBytes);
            } else {
                this.out.write(prefixBytes);
                this.writeFileToOutputStream(htmlVideoFile, this.out);
                this.out.write(suffixBytes);
            }
        }
        this.out.flush();
    }

    private void respondToolboxResource(String s, String mime, boolean head, boolean crcRequired) throws IOException {
        System.out.println("[WebDownloaderServer] Request for resource " + s + " received (" + head + ")");
        int toolboxResourceIndex = s.indexOf("toolbox-resource/");
        if (toolboxResourceIndex != -1) {
            s = s.substring(toolboxResourceIndex + "toolbox-resource/".length());
            String[] result = s.split("\\/");
            String itemID = result[0];
            String resourceID = result[1];
            int secondIndex = s.indexOf(47);
            if (secondIndex != -1) {
                secondIndex = s.indexOf(47, secondIndex + 1);
            }
            String resourcePath = null;
            if (secondIndex != -1) {
                resourcePath = s.substring(secondIndex);
            }
            File resourceFile = ToolBoxConstants.getResourceFile(itemID, resourceID);
            if (resourcePath != null) {
                resourceFile = new File(resourceFile, resourcePath);
            }
            long totalLength = resourceFile.length();
            if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                Debugger.info("RESPONSE (" + this.myid + "): HTTP/1.1 200 OK");
            }
            if (this.sendNoCache) {
                if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                    Debugger.info("RESPONSE (" + this.myid + "): Cache-Control: no-cache");
                }
                if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                    Debugger.info("RESPONSE (" + this.myid + "): Pragma: no-cache");
                }
            }
            if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                Debugger.info("RESPONSE (" + this.myid + "): Content-Type: " + mime);
            }
            if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                Debugger.info("RESPONSE (" + this.myid + "): Content-Length: " + totalLength);
            }
            this.writeWithoutFlush("HTTP/1.1 200 OK");
            if (this.sendNoCache) {
                this.writeWithoutFlush("Cache-Control: no-cache");
                this.writeWithoutFlush("Pragma: no-cache");
                for (ServerConfig.HTTPHeader header : ServerConfig.get().httpHeaders) {
                    if (header.value != null) {
                        this.writeWithoutFlush(header.name + ": " + header.value);
                        continue;
                    }
                    this.writeWithoutFlush(header.name);
                }
            }
            if (this.setCookie != null) {
                String[] cookies;
                for (String cooky : cookies = this.setCookie.split(",")) {
                    this.writeWithoutFlush("Set-Cookie: " + cooky + "; Path=/");
                }
            }
            this.writeWithoutFlush("Content-Type: " + mime);
            if (!head) {
                this.writeWithoutFlush("Content-Length: " + totalLength);
            } else {
                this.writeWithoutFlush("Content-Length: 0");
            }
            if (this.contentDisposition != null) {
                this.writeWithoutFlush("Content-Disposition: " + this.contentDisposition);
            }
            this.writeWithoutFlush("");
            if (!head) {
                this.writeFileToOutputStream(resourceFile, this.out);
            }
            this.out.flush();
        }
    }

    private void respondDatStream(int len, String mime) throws IOException {
        this.writeWithoutFlush("HTTP/1.1 200 OK");
        if (this.sendNoCache) {
            this.writeWithoutFlush("Cache-Control: no-cache");
            this.writeWithoutFlush("Pragma: no-cache");
            for (ServerConfig.HTTPHeader header : ServerConfig.get().httpHeaders) {
                if (header.value != null) {
                    this.writeWithoutFlush(header.name + ": " + header.value);
                    continue;
                }
                this.writeWithoutFlush(header.name);
            }
        }
        if (this.setCookie != null) {
            String[] cookies;
            for (String cooky : cookies = this.setCookie.split(",")) {
                this.writeWithoutFlush("Set-Cookie: " + cooky + "; Path=/");
            }
        }
        this.writeWithoutFlush("Content-Type: " + mime);
        this.writeWithoutFlush("Content-Length: " + len);
        if (this.contentDisposition != null) {
            this.writeWithoutFlush("Content-Disposition: " + this.contentDisposition);
        }
        if (this.myKeepalive != -1) {
            this.writeWithoutFlush("Keep-Alive: timeout=" + this.myKeepalive);
            this.writeWithoutFlush("Connection: Keep-Alive");
        }
        this.writeWithoutFlush("");
        this.out.flush();
    }

    private void respondDat(byte[] dat, String mime, boolean head) throws IOException {
        this.respondDat(dat, mime, head, 0L);
    }

    private void respondDat(byte[] dat, String mime, boolean head, long lastModified) throws IOException {
        if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
            Debugger.info("RESPONSE (" + this.myid + "): HTTP/1.1 200 OK");
        }
        if (this.sendNoCache) {
            if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                Debugger.info("RESPONSE (" + this.myid + "): Cache-Control: no-cache");
            }
            if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                Debugger.info("RESPONSE (" + this.myid + "): Pragma: no-cache");
            }
        }
        if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
            Debugger.info("RESPONSE (" + this.myid + "): Content-Type: " + mime);
        }
        if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
            Debugger.info("RESPONSE (" + this.myid + "): Content-Length: " + dat.length);
        }
        this.writeWithoutFlush("HTTP/1.1 200 OK");
        if (this.sendNoCache) {
            this.writeWithoutFlush("Cache-Control: no-cache");
            this.writeWithoutFlush("Pragma: no-cache");
            for (ServerConfig.HTTPHeader header : ServerConfig.get().httpHeaders) {
                if (header.value != null) {
                    this.writeWithoutFlush(header.name + ": " + header.value);
                    continue;
                }
                this.writeWithoutFlush(header.name);
            }
        }
        if (this.setCookie != null) {
            String[] cookies;
            for (String cooky : cookies = this.setCookie.split(",")) {
                this.writeWithoutFlush("Set-Cookie: " + cooky + "; Path=/");
            }
        }
        this.writeWithoutFlush("Content-Type: " + mime);
        if (!head && dat != null) {
            this.writeWithoutFlush("Content-Length: " + dat.length);
        } else {
            this.writeWithoutFlush("Content-Length: 0");
        }
        if (lastModified > 0L) {
            this.writeWithoutFlush("Last-Modified: " + this.sdf.format(new Date(lastModified)));
        }
        if (this.contentDisposition != null) {
            this.writeWithoutFlush("Content-Disposition: " + this.contentDisposition);
        }
        if (this.myKeepalive != -1) {
            this.writeWithoutFlush("Keep-Alive: timeout=" + this.myKeepalive);
            this.writeWithoutFlush("Connection: Keep-Alive");
        }
        this.writeWithoutFlush("");
        if (!head && dat != null) {
            if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                Debugger.info("RESPONSE (" + this.myid + "): (" + dat.length + " bytes of binary data content)");
            }
            this.out.write(dat);
        }
        this.out.flush();
    }

    private void respondString(String first, String s, String mime, boolean head) throws IOException {
        byte[] dat = s.getBytes("ASCII");
        if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
            Debugger.info("RESPONSE (" + this.myid + "): HTTP/1.1 " + first);
        }
        if (this.sendNoCache) {
            if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                Debugger.info("RESPONSE (" + this.myid + "): Cache-Control: no-cache");
            }
            if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                Debugger.info("RESPONSE (" + this.myid + "): Pragma: no-cache");
            }
        }
        if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
            Debugger.info("RESPONSE (" + this.myid + "): Content-Type: " + mime);
        }
        if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
            Debugger.info("RESPONSE (" + this.myid + "): Content-Length: " + dat.length);
        }
        this.writeWithoutFlush("HTTP/1.1 " + first);
        if (this.sendNoCache) {
            this.writeWithoutFlush("Cache-Control: no-cache");
            this.writeWithoutFlush("Pragma: no-cache");
            for (ServerConfig.HTTPHeader header : ServerConfig.get().httpHeaders) {
                if (header.value != null) {
                    this.writeWithoutFlush(header.name + ": " + header.value);
                    continue;
                }
                this.writeWithoutFlush(header.name);
            }
        }
        if (this.setCookie != null) {
            String[] cookies;
            for (String cooky : cookies = this.setCookie.split(",")) {
                this.writeWithoutFlush("Set-Cookie: " + cooky + "; Path=/");
            }
        }
        this.writeWithoutFlush("Content-Type: " + mime);
        this.writeWithoutFlush("Content-Length: " + dat.length);
        if (this.contentDisposition != null) {
            this.writeWithoutFlush("Content-Disposition: " + this.contentDisposition);
        }
        if (this.myKeepalive != -1) {
            this.writeWithoutFlush("Keep-Alive: timeout=" + this.myKeepalive);
            this.writeWithoutFlush("Connection: Keep-Alive");
        }
        this.writeWithoutFlush("");
        if (!head) {
            if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                Debugger.info("RESPONSE (" + this.myid + "): (" + dat.length + " bytes of ASCII text based content)");
            }
            this.out.write(dat);
        }
        this.out.flush();
    }

    private void respondAuthenticate(byte[] dat, String mime, boolean head, String realm) throws IOException {
        if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
            Debugger.info("RESPONSE (" + this.myid + "): HTTP/1.1 401 Authorization Required");
        }
        this.writeWithoutFlush("HTTP/1.1 401 Authorization Required");
        this.writeWithoutFlush("WWW-Authenticate: Basic realm=\"" + realm + "\"");
        if (this.sendNoCache) {
            this.writeWithoutFlush("Cache-Control: no-cache");
            this.writeWithoutFlush("Pragma: no-cache");
            for (ServerConfig.HTTPHeader header : ServerConfig.get().httpHeaders) {
                if (header.value != null) {
                    this.writeWithoutFlush(header.name + ": " + header.value);
                    continue;
                }
                this.writeWithoutFlush(header.name);
            }
        }
        if (this.setCookie != null) {
            String[] cookies;
            for (String cooky : cookies = this.setCookie.split(",")) {
                this.writeWithoutFlush("Set-Cookie: " + cooky + "; Path=/");
            }
        }
        this.writeWithoutFlush("Content-Type: " + mime);
        this.writeWithoutFlush("Content-Length: " + dat.length);
        if (this.myKeepalive != -1) {
            this.writeWithoutFlush("Keep-Alive: timeout=" + this.myKeepalive);
            this.writeWithoutFlush("Connection: Keep-Alive");
        }
        this.writeWithoutFlush("");
        if (!head) {
            if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
                Debugger.info("RESPONSE (" + this.myid + "): (" + dat.length + " bytes of binary data content)");
            }
            this.out.write(dat);
        }
        this.out.flush();
    }

    private void respondRedirect(String location) throws IOException {
        if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
            Debugger.info("RESPONSE (" + this.myid + "): HTTP/1.1 302 Found");
        }
        this.writeWithoutFlush("HTTP/1.1 302 Found");
        this.writeWithoutFlush("Cache-Control: no-cache");
        for (ServerConfig.HTTPHeader header : ServerConfig.get().httpHeaders) {
            if (header.value != null) {
                this.writeWithoutFlush(header.name + ": " + header.value);
                continue;
            }
            this.writeWithoutFlush(header.name);
        }
        this.writeWithoutFlush("Pragma: no-cache");
        for (ServerConfig.HTTPHeader header : ServerConfig.get().httpHeaders) {
            if (header.value != null) {
                this.writeWithoutFlush(header.name + ": " + header.value);
                continue;
            }
            this.writeWithoutFlush(header.name);
        }
        if (this.setCookie != null) {
            String[] cookies;
            for (String cooky : cookies = this.setCookie.split(",")) {
                this.writeWithoutFlush("Set-Cookie: " + cooky + "; Path=/");
            }
        }
        this.writeWithoutFlush("Location: " + location);
        this.writeWithoutFlush("Content-type: text/html");
        this.writeWithoutFlush("Content-length: 0");
        if (this.myKeepalive != -1) {
            this.writeWithoutFlush("Keep-Alive: timeout=" + this.myKeepalive);
            this.writeWithoutFlush("Connection: Keep-Alive");
        }
        this.writeWithoutFlush("");
        this.out.flush();
    }

    private void respondBad(boolean head) throws IOException {
        this.respondString("204 No Content", "", "text/html", head);
    }

    private void respondNotFound(boolean head) throws IOException {
        this.respondString("404 Not Found", "404 - Page Not Found", "text/html", head);
    }

    private void respondForbidden(boolean head) throws IOException {
        this.respondString("403 Forbidden", "403 - Forbidden", "text/html", head);
    }

    private String nextLine() throws IOException {
        String s = StreamUtils.readLine(this.in);
        if (this.initial != null) {
            s = new String(this.initial, "ASCII") + s;
            this.initial = null;
        }
        return s;
    }

    private void writeWithoutFlush(String str) throws IOException {
        str = str + "\r\n";
        this.out.write(str.getBytes("ASCII"));
        if (CentralDebugging.WS_VERBOSE_REQUESTS && this.LOCAL_VERBOSE) {
            Debugger.info("RESPONSE (" + this.myid + "): " + str);
        }
    }

    private void checkHTTPSRedirect(String mime) throws RedirectException {
        if (!this.isSsl && ServerConfig.get().forwardToHTTPS) {
            for (String forwardedMimeType : MIME_TYPES_OPTION_FORWARD_SSL) {
                if (!mime.equals(forwardedMimeType)) continue;
                throw new RedirectException();
            }
        }
    }

    static {
        counter_LOCK = new Object();
        EXTRACT_FILES = new String[]{"elev_win.exe", "elev_mac", "elevatesh.exe", "elevatesh_mac", "shcad.exe", "SessionLauncher.exe", "utils_wnative.dll", "utils_wnative64.dll", "libutils_lnative.so", "libutils_lnative64.so", "libutils_mnative.jnilib", "libutils_mnative64.jnilib", "libutils_m_lion_native.jnilib", "libutils_m_lion_native64.jnilib"};
        FETCH_FILES = new String[]{"default_translation.txt", "SimpleService.exe"};
        OTHER_SERVED_FILES = new String[]{"deployJava.js", "sgupgrade.jar.gz", "sgupgrade.jar", "jwrapper_utils.jar.gz", "jwrapper_utils.jar", "sevenzip.jar.gz", "sevenzip.jar"};
        ALL_SERVED_FILES = ArrayUtils.concat(ArrayUtils.concat(EXTRACT_FILES, FETCH_FILES), OTHER_SERVED_FILES);
        CACHED_MD5S = null;
        timeLastVersionFilesWasUpdated = 0L;
        cachedVersionFiles3 = null;
        translationWrappers = null;
        translationsLock = new Object();
        hangLOCK = new Object();
        threadN = 0;
        serverList = new ArrayList();
        DEPLOY_UNPACKER = new SubstitutionStreamer(new File("DEPLOY"));
        queries_LOCK = new Object();
        queries = new HashMap();
        userAgent_LOCK = new Object();
        userAgents = new HashMap();
        raSelectors = SelectPool.newPoolOrNull("WdsRaPool", new WDSSelectHandler(), Switches.SH_1778_wdsRaSelectPoolSize);
        webSelectors = SelectPool.newPoolOrNull("WdsNonRaPool", new WDSSelectHandler(), Switches.SH_1778_wdsNonRaSelectPoolSize);
        raVersion_LOCK = new Object();
        cachedRaVersion = null;
        raVersionLastRead = 0L;
        fileLaunchProps = new Cache("WebDownloadServer", 50);
        updates_LOCK = new Object();
        updatesCounter = new Counter();
    }

    class RedirectException
    extends Exception {
        RedirectException() {
        }
    }

    static class WDSSelectHandler
    implements SelectPoolHandler {
        WDSSelectHandler() {
        }

        @Override
        public void process(Socket socket, Object attachment) {
            WebDownloadServer wds = (WebDownloadServer)attachment;
            try {
                wds.processNow();
                wds.processOne();
            }
            catch (TccStopException x) {
                return;
            }
            catch (WdsStopException x) {
                return;
            }
        }
    }

    private static class HangTracker
    extends Thread {
        public HangTracker() {
            super("HangTracker");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long unacceptable = 300000L;
            try {
                int previousCount = 0;
                while (true) {
                    Object[] all;
                    Object object = queries_LOCK;
                    synchronized (object) {
                        all = queries.keySet().toArray();
                    }
                    long now = SafeClock.currentTimeMillis();
                    if (all.length != previousCount && CentralDebugging.PX_WS_THREADING) {
                        System.out.println("[WS Threading] " + all.length + " (previous was " + previousCount + ")");
                    }
                    previousCount = all.length;
                    int blockingForHttpTransport = 0;
                    int dead = 0;
                    int waitingForQuery = 0;
                    int fine = 0;
                    int notFine = 0;
                    boolean printed = false;
                    for (Object anAll : all) {
                        WebDownloadServer wd = (WebDownloadServer)anAll;
                        if (!wd.isAlive()) {
                            ++dead;
                            WebDownloadServer.removeMe(wd);
                            continue;
                        }
                        if (wd.queryStarted == -1L) {
                            ++waitingForQuery;
                            long basetime = now - wd.addedToMap;
                            if (basetime <= unacceptable) continue;
                            WebDownloadServer.removeMe(wd);
                            continue;
                        }
                        long time = now - wd.queryStarted;
                        if (time > unacceptable) {
                            if (wd.blockingIsOk) {
                                ++blockingForHttpTransport;
                                continue;
                            }
                            ++notFine;
                            WebDownloadServer.removeMe(wd);
                            StringBuilder sb = new StringBuilder();
                            StackTraceElement[] stack = wd.getStackTrace();
                            if (CentralDebugging.PX_WS_THREADING) {
                                sb.append("[WS Threading] (").append(wd.getName()).append(") ").append(wd.queryDesc).append("\n");
                            }
                            for (StackTraceElement aStack : stack) {
                                sb.append("\tat ").append(aStack).append("\n");
                            }
                            System.out.println("[WS Threading] ***Warning (" + all.length + ") - WS thread (" + wd.getName() + ") " + wd.queryDesc + " is taking a long time to process and may be blocked?");
                            System.out.println(sb.toString());
                            printed = true;
                            continue;
                        }
                        ++fine;
                    }
                    if (CentralDebugging.PX_WS_THREADING || printed) {
                        System.out.println("[WS Threading] " + blockingForHttpTransport + " blocking for HTTP transport");
                        System.out.println("[WS Threading] " + dead + " dead and cleared");
                        System.out.println("[WS Threading] " + waitingForQuery + " waiting for a query");
                        System.out.println("[WS Threading] " + notFine + " processing old queries");
                        System.out.println("[WS Threading] " + fine + " processing ongoing queries");
                    }
                    Thread.sleep(10000L);
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }
}

