/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.util.security.SecurityUtil;
import java.io.File;
import utils.email.CommonEmailer;
import utils.string.CharStack;

public class TwoTierAuthentication {
    public static String getSubstitutedText(String template, TechUser user, TechGroup group, String code) {
        StringBuffer buffer = new StringBuffer();
        CharStack stack = new CharStack(template);
        buffer.append(stack.popUntil("${", true));
        while (!stack.isEmpty()) {
            String value = null;
            String variable = stack.popUntil('}', true);
            if (variable != null && variable.length() > 0) {
                if (variable.toLowerCase().equals("code") || variable.toLowerCase().equals("authenticationcode")) {
                    value = code;
                } else if (variable.toLowerCase().equals("technicianname") || variable.toLowerCase().equals("technician") || variable.toLowerCase().equals("name")) {
                    value = user.displayName;
                } else if (variable.toLowerCase().equals("email") || variable.toLowerCase().equals("technicianemail")) {
                    value = user.emailAddress;
                } else if (variable.toLowerCase().equals("username") || variable.toLowerCase().equals("technicianusername")) {
                    value = user.login;
                }
            }
            if (value == null) {
                value = "N/A";
            }
            buffer.append(value);
            buffer.append(stack.popUntil("${", true));
        }
        return buffer.toString();
    }

    public static String getSubstitutedText(String template, String code) {
        StringBuffer buffer = new StringBuffer();
        CharStack stack = new CharStack(template);
        buffer.append(stack.popUntil("${", true));
        while (!stack.isEmpty()) {
            String value = null;
            String variable = stack.popUntil('}', true);
            if (variable != null && variable.length() > 0 && (variable.toLowerCase().equals("code") || variable.toLowerCase().equals("authenticationcode"))) {
                value = code;
            }
            if (value == null) {
                value = "N/A";
            }
            buffer.append(value);
            buffer.append(stack.popUntil("${", true));
        }
        return buffer.toString();
    }

    public static String sendAuthenticationCode(final TechUser user, final TechGroup group) throws Exception {
        int codeLength = group.getTwoTierCodeLength();
        final String subject = group.getTwoTierSubject();
        final String body = group.getTwoTierBody();
        final String code = SecurityUtil.generateNonAmbiguousCode(codeLength);
        new Thread("TwoTierAuthenticationEmailer"){

            @Override
            public void run() {
                try {
                    String subjectToSend = subject;
                    String bodyToSend = body;
                    if (subjectToSend != null) {
                        subjectToSend = TwoTierAuthentication.getSubstitutedText(subject, user, group, code);
                    }
                    if (bodyToSend != null) {
                        bodyToSend = TwoTierAuthentication.getSubstitutedText(body, user, group, code);
                    }
                    CommonEmailer emailer = ServerConfig.get().getCommonEmailerUsingSettings();
                    if (!body.toLowerCase().startsWith("<html")) {
                        emailer.send(new String[]{user.getFullEmailAddress()}, subjectToSend, bodyToSend);
                    } else {
                        emailer.send(new String[]{user.getFullEmailAddress()}, subjectToSend, bodyToSend, CommonEmailer.MIME_HTML, new File[0]);
                    }
                }
                catch (Exception ex) {
                    System.out.println("[TwoTierAuthentication] Unable to send authentication email.");
                    ex.printStackTrace();
                }
            }
        }.start();
        return code;
    }
}

