/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.CentralDebugging;
import com.aem.shelp.common.toolbox.ToolBox;
import com.aem.shelp.common.toolbox.ToolBoxGroup;
import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.proxy.GenericRegistry;
import com.aem.shelp.proxy.ToolBoxResourceRepository;
import com.aem.shelp.proxy.config.TechUser;
import java.io.File;
import java.util.Iterator;
import utils.message.Message;
import utils.string.HexData;

public class ToolBoxRegistry
extends GenericRegistry<ToolBoxWrapper> {
    public static ToolBoxRegistry INSTANCE;

    public ToolBoxRegistry() {
        super("ToolBoxRegistry", new File(new File("configuration", "toolbox"), "toolboxdb"), HexData.hexStringToString("617321C2A3244A4B4173646B41537B7D41445331322F683375683132334B4F313233312D30303938393837696F756A6B6C6E28292928552A6B686A32336C6B316C6B6A3231326A6B6C6A6C6B6173646B6A617321406A31326A6B313241534A44"));
        INSTANCE = this;
    }

    @Override
    public String getAlternativeEncryptionKey() {
        return HexData.hexStringToString("617321C382C2A3244A4B4173646B41537B7D41445331322F683375683132334B4F313233312D30303938393837696F756A6B6C6E28292928552A6B686A32336C6B316C6B6A3231326A6B6C6A6C6B6173646B6A617321406A31326A6B313241534A44");
    }

    @Override
    public boolean debugLogging() {
        return CentralDebugging.TOOLBOX_REPOSITORY;
    }

    @Override
    public ToolBoxWrapper fromMessage(Message m) {
        String userID = m.getNextString();
        ToolBox toolBox = new ToolBox();
        toolBox.fromMessage(m.getNextMessage(), true);
        return new ToolBoxWrapper(userID, toolBox);
    }

    @Override
    protected boolean supportAutoReload() {
        return true;
    }

    private String getUserID(TechUser techUser, boolean legacyAnonymous) {
        boolean isAnonymousUser;
        if (legacyAnonymous && (isAnonymousUser = techUser.isAnonymous())) {
            return "-2-" + techUser.getLogin();
        }
        return Integer.toString(techUser.getUserID());
    }

    private String getLegacyAnonymousID() {
        return Integer.toString(-2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getToolAvgMaxTotal() {
        int[] avgMaxTotal = new int[3];
        Object object = this.map_LOCK;
        synchronized (object) {
            Object[] list;
            for (Object item : list = this.all.values().toArray()) {
                ToolBoxWrapper wrapper = (ToolBoxWrapper)item;
                int count = wrapper.toolBox.getAllItems().size();
                avgMaxTotal[0] = avgMaxTotal[0] + count;
                if (count > avgMaxTotal[1]) {
                    avgMaxTotal[1] = count;
                }
                avgMaxTotal[2] = avgMaxTotal[2] + count;
            }
            avgMaxTotal[0] = avgMaxTotal[0] / list.length;
        }
        return avgMaxTotal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getToolCount() {
        int total = 0;
        Object object = this.map_LOCK;
        synchronized (object) {
            try {
                Object[] list;
                for (Object item : list = this.all.values().toArray()) {
                    ToolBoxWrapper wrapper = (ToolBoxWrapper)item;
                    total += wrapper.toolBox.getAllItems().size();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return total;
    }

    public ToolBox getToolBoxFor(TechUser techUser) {
        String id = this.getUserID(techUser, false);
        ToolBoxWrapper toolBoxWrapper = (ToolBoxWrapper)this.get(id);
        ToolBox toolBox = null;
        if (toolBoxWrapper != null) {
            toolBox = toolBoxWrapper.toolBox;
        } else {
            if (techUser.isAnonymous()) {
                id = this.getUserID(techUser, true);
                toolBoxWrapper = (ToolBoxWrapper)this.get(id);
                if (toolBoxWrapper != null && toolBoxWrapper.toolBox != null) {
                    this.setToolBoxFor(techUser, toolBoxWrapper.toolBox);
                    return toolBoxWrapper.toolBox;
                }
                String legacyID = this.getLegacyAnonymousID();
                toolBoxWrapper = (ToolBoxWrapper)this.get(legacyID);
                if (toolBoxWrapper != null) {
                    ToolBox cloneBox = new ToolBox();
                    if (toolBoxWrapper.toolBox != null) {
                        cloneBox.fromMessage(toolBoxWrapper.toolBox.toMessage(), true);
                    }
                    toolBoxWrapper = new ToolBoxWrapper(id, cloneBox);
                    this.add(toolBoxWrapper);
                    return cloneBox;
                }
            }
            toolBox = new ToolBox();
            toolBoxWrapper = new ToolBoxWrapper(id, toolBox);
            this.add(toolBoxWrapper);
        }
        return toolBox;
    }

    public void setToolBoxFor(TechUser techUser, ToolBox toolBox) {
        String id = this.getUserID(techUser, false);
        ToolBoxWrapper wrapper = new ToolBoxWrapper(id, toolBox);
        this.add(wrapper);
    }

    @Override
    protected void loaded(ToolBoxWrapper wrapper) {
        if (wrapper == null || wrapper.toolBox == null) {
            return;
        }
        this.registerToolBoxResources(wrapper.toolBox);
    }

    public void registerToolBoxResources(ToolBox toolBox) {
        if (toolBox == null) {
            return;
        }
        Iterator<ToolBoxGroup> groupIterator = toolBox.getGroupIterator();
        while (groupIterator.hasNext()) {
            ToolBoxGroup group = groupIterator.next();
            Iterator<ToolBoxItem> toolBoxItems = group.getToolBoxItems();
            while (toolBoxItems.hasNext()) {
                ToolBoxItem item = toolBoxItems.next();
                ToolBoxResourceRepository.registerNewToolBoxItem(item.getID());
            }
        }
    }

    static class ToolBoxWrapper
    implements GenericRegistry.RegistryItem {
        String userID;
        ToolBox toolBox;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("User: ").append(this.userID).append("\n");
            builder.append("Toolbox: ").append(this.toolBox).append("\n");
            return builder.toString();
        }

        public ToolBoxWrapper(String id, ToolBox toolBox) {
            this.userID = id;
            this.toolBox = toolBox;
        }

        @Override
        public String getID() {
            return this.userID;
        }

        @Override
        public Message toMessage() {
            Message m = new Message();
            m.append(this.userID);
            m.append(this.toolBox.toMessage());
            return m;
        }
    }
}

