/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.CentralDebugging;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import utils.string.HexData;

public class SessionIDRepository {
    public static final long MAX_TIMEOUT = CentralDebugging.PX_SESSION_TOKEN_REPOSITORY_DEBUG_SHORT_TIME ? 20000L : 86400000L;
    private final HashMap<String, LinkedList<SessionIDSempahore>> keyToLinkedList = new HashMap();

    public SessionIDRepository() {
        new Thread("SessionIDRepository"){

            @Override
            public void run() {
                while (true) {
                    try {
                        if (CentralDebugging.PX_SESSION_TOKEN_REPOSITORY_DEBUG_SHORT_TIME) {
                            Thread.sleep(10000L);
                        } else {
                            Thread.sleep(10800000L);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    Iterator it = SessionIDRepository.this.keyToLinkedList.keySet().iterator();
                    int totalEntries = 0;
                    int totalSessions = 0;
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        LinkedList list = (LinkedList)SessionIDRepository.this.keyToLinkedList.get(key);
                        if (list == null) continue;
                        int listSize = list.size();
                        for (int i = listSize - 1; i >= 0; --i) {
                            SessionIDSempahore sids = (SessionIDSempahore)list.get(i);
                            if (!CentralDebugging.PX_TIMEOUT_SESSION_TOKENS) continue;
                            if (System.currentTimeMillis() - sids.lastTouchTime > MAX_TIMEOUT) {
                                list.remove(i);
                                continue;
                            }
                            totalSessions += sids.count;
                        }
                        if (list.size() == 0) {
                            SessionIDRepository.this.keyToLinkedList.remove(key);
                            continue;
                        }
                        totalEntries += list.size();
                    }
                    System.out.println("[SessionIDRepository] size=" + SessionIDRepository.this.keyToLinkedList.size() + "(totalEntries=" + totalEntries + ",totalSessions=" + totalSessions + ")");
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String key, byte[] sessionID) {
        if (CentralDebugging.PX_SESSION_TOKEN_REPOSITORY) {
            System.out.println("[SessionIDRepository] Adding " + key + "-" + HexData.byteArrayToHexString(sessionID));
        }
        HashMap<String, LinkedList<SessionIDSempahore>> hashMap = this.keyToLinkedList;
        synchronized (hashMap) {
            LinkedList<SessionIDSempahore> list = this.keyToLinkedList.get(key);
            if (list == null) {
                list = new LinkedList();
                this.keyToLinkedList.put(key, list);
            }
            for (SessionIDSempahore sids : list) {
                if (sids == null || !Arrays.equals(sids.sessionToken, sessionID)) continue;
                sids.increment();
                return;
            }
            SessionIDSempahore sids = new SessionIDSempahore(sessionID);
            list.add(sids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(String key) {
        if (CentralDebugging.PX_SESSION_TOKEN_REPOSITORY) {
            System.out.println("[SessionIDRepository] Removing all " + key);
        }
        HashMap<String, LinkedList<SessionIDSempahore>> hashMap = this.keyToLinkedList;
        synchronized (hashMap) {
            this.keyToLinkedList.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key, byte[] sessionID) {
        if (CentralDebugging.PX_SESSION_TOKEN_REPOSITORY) {
            System.out.println("[SessionIDRepository] Removing " + key + "-" + HexData.byteArrayToHexString(sessionID));
        }
        HashMap<String, LinkedList<SessionIDSempahore>> hashMap = this.keyToLinkedList;
        synchronized (hashMap) {
            LinkedList<SessionIDSempahore> list = this.keyToLinkedList.get(key);
            if (list == null) {
                return;
            }
            for (int i = 0; i < list.size(); ++i) {
                SessionIDSempahore sids = list.get(i);
                if (sids == null || !Arrays.equals(sids.sessionToken, sessionID)) continue;
                int newValue = sids.decrement();
                if (newValue == 0) {
                    list.remove(sids);
                    if (list.size() == 0) {
                        this.keyToLinkedList.remove(key);
                    }
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String key, byte[] sessionID) {
        if (CentralDebugging.PX_SESSION_TOKEN_REPOSITORY) {
            System.out.println("[SessionIDRepository] Touching " + key + "-" + HexData.byteArrayToHexString(sessionID));
        }
        HashMap<String, LinkedList<SessionIDSempahore>> hashMap = this.keyToLinkedList;
        synchronized (hashMap) {
            LinkedList<SessionIDSempahore> list = this.keyToLinkedList.get(key);
            if (list == null) {
                return false;
            }
            for (SessionIDSempahore sids : list) {
                if (sids == null || !Arrays.equals(sids.sessionToken, sessionID)) continue;
                sids.lastTouchTime = System.currentTimeMillis();
                return true;
            }
        }
        return false;
    }

    class SessionIDSempahore {
        private long lastTouchTime = System.currentTimeMillis();
        private int count = 0;
        private byte[] sessionToken = null;
        private final Object LOCK = new Object();

        public SessionIDSempahore(byte[] sessionID) {
            this.sessionToken = sessionID;
            this.increment();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int increment() {
            Object object = this.LOCK;
            synchronized (object) {
                this.lastTouchTime = System.currentTimeMillis();
                ++this.count;
                return this.count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int decrement() {
            Object object = this.LOCK;
            synchronized (object) {
                --this.count;
                return this.count;
            }
        }

        public byte[] getSessionToken() {
            return this.sessionToken;
        }
    }
}

