/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import bcutil.BCUtil;
import com.aem.nodelink.NodeLink;
import com.aem.shelp.common.login.TechCredentials;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.LoginType;
import com.aem.shelp.proxy.PeerPipe;
import com.aem.shelp.proxy.ProxyTwoTierKeyManager;
import com.aem.shelp.proxy.SessionIDRepository;
import com.aem.shelp.proxy.TwoTierAuthentication;
import com.aem.shelp.proxy.authentication.TOTPAuthenticator;
import com.aem.shelp.proxy.authentication.TOTPConfig;
import com.aem.shelp.proxy.config.LazyPassword;
import com.aem.shelp.proxy.config.MergedTechGroup;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.logging.server.FailedTechLoginEvent;
import com.aem.shelp.util.BCUtilMessenger;
import com.aem.utils.StreamUtils;
import java.util.ArrayList;
import utils.loggingframework.LoggingFramework;
import utils.message.Message;
import utils.radius.ChallengeHandler;

public class ProxyServerAuthentication {
    private final SessionIDRepository credentialsToSessionIDs = new SessionIDRepository();

    public TechUser doTechnicianLogin(String technicianIPAddress, TechCredentials credentials, LoginType type, ChallengeHandler challengeHandler) {
        TechUser loggedInUser = null;
        TechUser existingUser = null;
        if (!(technicianIPAddress.equals("localhost") || technicianIPAddress.equals("127.0.0.1") || technicianIPAddress.equals("local") || ServerConfig.get().isTechAllowed(technicianIPAddress))) {
            System.out.println("[Proxy Server] Tech restrictions dictate that " + credentials + "'s IP address of " + technicianIPAddress + " is forbidden.");
        } else {
            loggedInUser = this.checkSessionTokenLogin(credentials);
            if (loggedInUser != null) {
                type.loginType = 5;
            }
            if (loggedInUser == null && credentials.hasPassword()) {
                if (credentials.hasUsername() && !credentials.isSimpleHelpAdminUser()) {
                    existingUser = ServerConfig.get().getTechUserByUsername(credentials.getUsername());
                    if (existingUser != null && existingUser.authenticate(credentials, type, challengeHandler)) {
                        loggedInUser = existingUser;
                    }
                    if (loggedInUser == null) {
                        TechGroup[] allGroups;
                        TechUser techUser = this.getAnonymousUserInstance(credentials);
                        for (TechGroup group : allGroups = ServerConfig.get().getAllTechGroups()) {
                            if (!group.allowAnonymousLogins()) continue;
                            techUser.setGroups(new TechGroup[]{group});
                            if (!group.authenticate(credentials, type, techUser, challengeHandler)) continue;
                            loggedInUser = techUser = ServerConfig.get().registerAnonymousTechnician(techUser);
                            break;
                        }
                    }
                } else if (ServerConfig.get().serverPassword.matches(credentials.getPassword())) {
                    type.loginType = 1;
                    loggedInUser = ServerConfig.get().serverAdmin;
                }
            }
        }
        if (loggedInUser != null) {
            return loggedInUser;
        }
        String existingUserGroups = null;
        if (existingUser != null) {
            existingUserGroups = existingUser.getGroupsAsString();
        }
        FailedTechLoginEvent event = FailedTechLoginEvent.createEvent(credentials.getUsername(), existingUserGroups, technicianIPAddress);
        LoggingFramework.INSTANCE.logEvent(event);
        return null;
    }

    private TechUser checkSessionTokenLogin(TechCredentials credentials) {
        if (credentials.hasSessionToken()) {
            byte[] token = credentials.getSessionToken();
            System.out.println("[ProxyServer] Session token provided (" + token.length + ") by user " + credentials.getUsername() + ".");
            TechUser matchedUser = ServerConfig.get().getTechUserByUsername(credentials.getUsername());
            if (matchedUser != null) {
                System.out.println("[ProxyServer] Local technician account found.");
                if (this.validateSessionToken(matchedUser, token)) {
                    System.out.println("[ProxyServer] Verfied user " + matchedUser.login + " with existing session token.");
                    return matchedUser;
                }
                System.out.println("[ProxyServer] Account user " + matchedUser.login + " not verified with existing session token.");
            } else {
                TechGroup[] allGroups;
                TechUser techUser = this.getAnonymousUserInstance(credentials);
                for (TechGroup group : allGroups = ServerConfig.get().getAllTechGroups()) {
                    if (!group.allowAnonymousLogins()) continue;
                    techUser.setGroups(new TechGroup[]{group});
                    if (!this.validateSessionToken(techUser, credentials.getSessionToken())) continue;
                    techUser = ServerConfig.get().registerAnonymousTechnician(techUser);
                    System.out.println("[ProxyServer] Verfied anonymous user " + techUser.login + " with existing session token in group " + group + ".");
                    return techUser;
                }
            }
        } else {
            System.out.println("[ProxyServer] No session token passed in.");
        }
        return null;
    }

    private TechUser getAnonymousUserInstance(TechCredentials credentials) {
        return new TechUser(-1, credentials.getUsername(), credentials.getUsername(), new LazyPassword(credentials.getPassword()), null, true, false, true);
    }

    public boolean isLoggedInUserBlockedByAppProfiles(TechUser loggedInUser, String appProfileID) {
        boolean blockedByAppProfiles;
        if (loggedInUser.isServerAdmin()) {
            return false;
        }
        System.out.println("[ProxyServerAuthentication] Checking app profile [" + appProfileID + "]");
        if (appProfileID.length() == 0) {
            blockedByAppProfiles = false;
            if (loggedInUser.isForAppProfilesOnly()) {
                blockedByAppProfiles = true;
                System.out.println("[ProxyServerAuthentication] Tech account is allowed dedicated app access only");
            }
        } else {
            TechGroup[] groups;
            blockedByAppProfiles = true;
            for (TechGroup check : groups = loggedInUser.getGroups()) {
                String groupProfileID = check.getAssociatedAppProfileID();
                if (groupProfileID == null || !groupProfileID.equals(appProfileID)) continue;
                blockedByAppProfiles = false;
                break;
            }
            if (blockedByAppProfiles) {
                System.out.println("[ProxyServerAuthentication] Tech is not a member of specified dedicated app profile");
            }
        }
        return blockedByAppProfiles;
    }

    public void registerSessionID(TechUser loggedInUser, byte[] sessionID) {
        if (sessionID == null) {
            return;
        }
        String key = ProxyServerAuthentication.getKeyForUser(loggedInUser);
        System.out.println("[ProxyServer] Registering session token for " + loggedInUser + " (" + key + ")");
        this.credentialsToSessionIDs.add(key, sessionID);
        Message message = new Message(4003000);
        message.append(key);
        message.append(sessionID);
        PeerPipe.sendMessageToAll(message, PeerPipe.SESSIONS_PICKER);
    }

    public void peerRegisterSessionID(String key, byte[] token) {
        System.out.println("[ProxyServer] [Peer] Adding session token for " + key);
        this.credentialsToSessionIDs.add(key, token);
    }

    public void peerRemoveSessionID(String key, byte[] token) {
        System.out.println("[ProxyServer] [Peer] Removing session token for " + key);
        this.credentialsToSessionIDs.remove(key, token);
    }

    public void deregisterSessionID(TechUser techUser, byte[] sessionID) {
        System.out.println("[ProxyServer] Removing session token for " + techUser.getLogin());
        if (sessionID != null) {
            String key = ProxyServerAuthentication.getKeyForUser(techUser);
            this.credentialsToSessionIDs.remove(key, sessionID);
            Message message = new Message(4004000);
            message.append(key);
            message.append(sessionID);
            PeerPipe.sendMessageToAll(message, PeerPipe.SESSIONS_PICKER);
        } else {
            System.out.println("[ProxyServer] Cannot remove a session ID as it is null");
        }
    }

    private static String getKeyForUser(TechUser user) {
        if (user.isAnonymous()) {
            int groupID = 0;
            if (user.getGroups() != null && user.getGroups().length > 0) {
                groupID = user.getGroups()[0].getGroupID();
            }
            return user.getLogin() + "-" + groupID;
        }
        return Integer.toString(user.getUserID());
    }

    private boolean validateSessionToken(TechUser user, byte[] sessionToken) {
        if (sessionToken == null || sessionToken.length == 0) {
            return false;
        }
        String keyForUser = ProxyServerAuthentication.getKeyForUser(user);
        return this.credentialsToSessionIDs.exists(keyForUser, sessionToken);
    }

    public void touchSessionID(TechUser techUser, byte[] sessionID) {
        this.validateSessionToken(techUser, sessionID);
    }

    /*
     * Unable to fully structure code
     */
    public MFAResult doMultiFactorAuthentication(BCUtil bcu, NodeLink sock, TechUser loggedInUser, MergedTechGroup loginGroup, String multiFactorAuthenticationHostKey) throws Exception {
        result = new MFAResult();
        requiresAppAuthentication = loginGroup.requiresAppAuthentication();
        requiresEmailAuthentication = loginGroup.requiresEmailAuthentication();
        v0 = result.mfaRequired = requiresAppAuthentication != false || requiresEmailAuthentication != false;
        if (!result.mfaRequired) {
            return result;
        }
        if (requiresAppAuthentication && loginGroup.allowedToUseMFAKeyForApp() || requiresEmailAuthentication && loginGroup.allowedToUseMFAKeyForEmail()) {
            result.mfaRequired = true;
            if (ProxyTwoTierKeyManager.getInstance().isValidKey(loggedInUser, multiFactorAuthenticationHostKey)) {
                System.out.println("[ProxySeverAuthentication] Successfully validated hostname-specific MFA key");
                result.mfaSuccessful = true;
                result.sendKey = false;
                return result;
            }
        }
        if (!requiresAppAuthentication) ** GOTO lbl46
        allowRemember = loginGroup.allowedToUseMFAKeyForApp();
        totpKey = loggedInUser.getTOTPKey();
        requiresSetup = totpKey == null || totpKey.isNull() != false;
        config = ServerConfig.get().getTOTPConfig();
        authenticator = new TOTPAuthenticator(config);
        if (!requiresSetup) ** GOTO lbl27
        if (loggedInUser.isServerAdmin()) {
            System.out.println("[ProxyServer] Skipping TOTP setup for SimpleHelpAdmin user.");
        } else {
            this.setupAppAuthentication(bcu, sock, loggedInUser, loginGroup, config, authenticator);
            result.mfaSuccessful = true;
            return result;
lbl27:
            // 1 sources

            System.out.println("[ProxyServer] App authentication code required.");
            sout = sock.getOutputStream();
            m = new Message();
            m.append(allowRemember);
            retries = 10;
            do {
                if (--retries <= 0) {
                    throw new Exception("Maximum number of authentication attempts exceeded.");
                }
                StreamUtils.writeInt(sout, 120);
                BCUtilMessenger.writeMsg(bcu, sout, m);
                sout.flush();
                readMessage = BCUtilMessenger.readMsg(bcu, sock.getInputStream());
                codeString = readMessage.getNextString();
                result.sendKey = readMessage.getNextBoolean();
                result.hostname = readMessage.getNextString();
                code = Long.parseLong(codeString);
            } while (!authenticator.checkCode(totpKey.getDecryptedPassword(), code, System.currentTimeMillis()));
            result.mfaSuccessful = true;
            return result;
lbl46:
            // 1 sources

            if (requiresEmailAuthentication) {
                groupToUseForAuthentication = loginGroup.getGroupForEmailAuthentication();
                isSimpleHelpAdmin = loggedInUser.isServerAdmin();
                validConfiguration = true;
                if (isSimpleHelpAdmin) {
                    if (loggedInUser.getEmail() == null || loggedInUser.getEmail().trim().length() == 0) {
                        validConfiguration = false;
                    }
                    emailBody = groupToUseForAuthentication.getTwoTierBody();
                    codeLength = groupToUseForAuthentication.getTwoTierCodeLength();
                    if (codeLength <= 0) {
                        validConfiguration = false;
                    }
                    if (emailBody == null || emailBody.trim().length() == 0 || !emailBody.toLowerCase().contains("{code}") && !emailBody.toLowerCase().contains("{authenticationcode}")) {
                        validConfiguration = false;
                    }
                }
                System.out.println("[ProxyServer] Email authentication code required.");
                if (!validConfiguration) {
                    result.mfaSuccessful = true;
                    System.out.println("[ProxyServer] SimpleHelpAdmin Two Tier is configured, but the configuration is incomplete. Skipping two tier request.");
                } else {
                    listOfCodes = new ArrayList<TwoFactorCode>();
                    emailAddress = loggedInUser.emailAddress;
                    allowRemember = loginGroup.allowedToUseMFAKeyForEmail();
                    System.out.println("[ProxyServer] Sending authentication code email to " + loggedInUser.getEmail());
                    newCode = TwoTierAuthentication.sendAuthenticationCode(loggedInUser, groupToUseForAuthentication);
                    listOfCodes.add(new TwoFactorCode(newCode));
                    correctCodeReceived = false;
                    while (!correctCodeReceived) {
                        StreamUtils.writeInt(sock.getOutputStream(), 100);
                        emailMessage = new Message();
                        emailMessage.append(emailAddress);
                        emailMessage.append(allowRemember);
                        BCUtilMessenger.writeMsg(bcu, sock.getOutputStream(), emailMessage);
                        sock.getOutputStream().flush();
                        readMessage = BCUtilMessenger.readMsg(bcu, sock.getInputStream());
                        if (readMessage.getType() == 110) {
                            System.out.println("[ProxyServer] " + loggedInUser + " requested another code.");
                            newCode = TwoTierAuthentication.sendAuthenticationCode(loggedInUser, groupToUseForAuthentication);
                            listOfCodes.add(new TwoFactorCode(newCode));
                            if (listOfCodes.size() <= 10) continue;
                            throw new Exception("Two tier authentication code retry limit reached. Terminating connection.");
                        }
                        System.out.println("[ProxyServer] " + loggedInUser + " responded with an authentication code.");
                        responseCode = readMessage.getNextString();
                        result.sendKey = readMessage.getNextBoolean();
                        if (result.sendKey) {
                            result.hostname = readMessage.getNextString();
                        }
                        for (i = listOfCodes.size() - 1; i >= 0; --i) {
                            code = (TwoFactorCode)listOfCodes.get(i);
                            if (code.hasExpired()) {
                                listOfCodes.remove(i);
                                continue;
                            }
                            correctCodeReceived = code.matches(responseCode);
                            if (!correctCodeReceived) continue;
                            result.mfaSuccessful = true;
                            return result;
                        }
                    }
                }
            }
        }
        return result;
    }

    private void setupAppAuthentication(BCUtil bcu, NodeLink sock, TechUser loggedInUser, MergedTechGroup loginGroup, TOTPConfig config, TOTPAuthenticator authenticator) throws Exception {
        System.out.println("[ProxyServer] App authentication setup required.");
        TOTPAuthenticator.TOTPKey key = authenticator.createCredentials();
        StreamUtils.writeInt(sock.getOutputStream(), 140);
        Message secret = new Message();
        secret.append(key.getSecret());
        secret.append(loggedInUser.getLogin());
        if (ServerConfig.get().hostname == null || ServerConfig.get().hostname.length() == 0) {
            secret.append(OemBranding.OEM_APPLICATION_NAME);
        } else {
            secret.append(ServerConfig.get().hostname);
        }
        secret.append(config.getCodeDigitLength());
        BCUtilMessenger.writeMsg(bcu, sock.getOutputStream(), secret);
        sock.getOutputStream().flush();
        Message readMessage = BCUtilMessenger.readMsg(bcu, sock.getInputStream());
        long code = readMessage.getNextLong();
        int retryCount = 20;
        System.out.println("[ProxyServer] Validating app authentication setup...");
        while (!authenticator.checkCode(key.getSecret(), code, System.currentTimeMillis())) {
            if (--retryCount <= 0) {
                throw new Exception("Too many app authentication setup attempts.");
            }
            StreamUtils.writeInt(sock.getOutputStream(), 140);
            sock.getOutputStream().flush();
            readMessage = BCUtilMessenger.readMsg(bcu, sock.getInputStream());
            code = readMessage.getNextLong();
            System.out.println("[ProxyServer] Validating app authentication setup...");
        }
        loggedInUser.setTOTPKey(new LazyPassword(key.getSecret()));
        ServerConfig.get().saveToDefaultFile();
        System.out.println("[ProxyServer] App authentication setup.");
    }

    static class TwoFactorCode {
        final String code;
        final long timeoutTime;

        public TwoFactorCode(String code) {
            this.code = code;
            this.timeoutTime = System.currentTimeMillis() + 180000L;
        }

        public boolean matches(String responseCode) {
            return this.code.equals(responseCode);
        }

        public boolean hasExpired() {
            return System.currentTimeMillis() > this.timeoutTime;
        }
    }

    public class MFAResult {
        public boolean mfaRequired;
        public boolean mfaSuccessful;
        public boolean sendKey;
        public String hostname = "";
    }
}

