/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.CentralDebugging;
import com.aem.nodelink.Node;
import com.aem.nodelink.Transport;
import com.aem.nodelink.http.FullDuplexHttpTransport;
import com.aem.nodelink.http.HttpEndpoint;
import com.aem.nodelink.http.extend.HttpRequestProcessor;
import com.aem.nodelink.http.extend.HttpServerFactory;
import com.aem.nodelink.tcp.TcpEndpoint;
import com.aem.nodelink.tcp.TcpSocketHandler;
import com.aem.nodelink.tcp.TcpTransport;
import com.aem.nodelink.udp.UdpEndpoint;
import com.aem.shelp.proxy.AccessManager;
import com.aem.shelp.proxy.WebDownloadServer;
import java.net.Socket;
import java.net.URL;
import utils.stream.SocketLeaks;
import utils.switches.Switches;
import utils.udp.bidirectional.UDPListener;

public class PortServer
extends Thread
implements TcpSocketHandler,
HttpServerFactory {
    String ip;
    int port;
    HttpRequestProcessor hproc;
    AccessManager access;
    private TcpEndpoint tcpEp;
    private TcpTransport transport;
    private UdpEndpoint udpEp;
    private HttpEndpoint httpEp;
    private Transport httptransport;

    public void clearTimedOut() {
        if (Switches.SH_1468_fullDuplexPacketWaitTimeout) {
            if (Switches.SH_1468_debugging) {
                System.out.println("[SH-1468] Clearing any old FullDuplexHttpTransport buffers now");
            }
            if (this.httptransport instanceof FullDuplexHttpTransport) {
                FullDuplexHttpTransport fdp = (FullDuplexHttpTransport)this.httptransport;
                fdp.clearOldBuffers();
            }
        }
    }

    public void testKillAllTcp() {
        try {
            this.transport.cleanupAllConnections();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void shutdown() {
        try {
            this.transport.stopAcceptingOn(this.tcpEp);
        }
        catch (Throwable x) {
            x.printStackTrace();
        }
    }

    public String getIP() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public PortServer(Node me, int port, AccessManager access, UDPListener udplist) throws Exception {
        this(me, null, port, access, udplist);
    }

    public PortServer(Node me, String ip, int port, AccessManager access, UDPListener udplist) throws Exception {
        super("PortServer");
        this.ip = ip;
        this.port = port;
        this.access = access;
        this.tcpEp = new TcpEndpoint("localhost", port);
        this.tcpEp.setAlternateSocketHandler(this);
        if (ip != null) {
            this.tcpEp.setBindIp(ip);
        }
        this.transport = (TcpTransport)me.acceptIncomingOn(this.tcpEp);
        this.httpEp = new HttpEndpoint(new URL("http://localhost/data"));
        this.httpEp.setHttpServerFactory(this);
        this.httptransport = me.acceptIncomingOn(this.httpEp);
    }

    @Override
    public void incomingNodelinkSocket(Socket sock) {
        if (CentralDebugging.PX_DEBUG_SOCKETS) {
            SocketLeaks.track(sock);
        }
    }

    @Override
    public boolean incomingSocket(byte[] initialData, Socket sock) {
        if (CentralDebugging.PX_DEBUG_SOCKETS) {
            SocketLeaks.track(sock);
        }
        try {
            String start = new String(initialData, "ASCII").toUpperCase();
            if (start.startsWith("GET") || start.startsWith("PUT") || start.startsWith("POST") || start.startsWith("HEAD") || start.startsWith("OPTI")) {
                if (CentralDebugging.PX_DEBUG_SOCKETS) {
                    SocketLeaks.associate(sock, "Initial", start);
                    SocketLeaks.associate(sock, "ConnType", "Web");
                }
                new WebDownloadServer(initialData, sock, this.hproc, this.access);
                return true;
            }
            return false;
        }
        catch (Exception x) {
            x.printStackTrace();
            return false;
        }
    }

    @Override
    public void redirectUrlRequests(URL url, HttpRequestProcessor transport) throws Exception {
        this.hproc = transport;
    }
}

