/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.shelp.proxy.common.Notification;
import com.aem.shelp.proxy.config.TechUser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import utils.encryption.aes.RijndaelDecryptionStream;
import utils.encryption.aes.RijndaelEncryptionStream;
import utils.files.AtomicFileOutputStream;
import utils.message.MessageUtils;
import utils.progtools.SaverUtil;
import utils.stream.StreamUtils;

public class NotificationRegistry
implements SaverUtil.SaveListener {
    private File registryFile = new File(new File("configuration", "notifications"), "notificationsdb");
    private String encryptionKey = "vkp{dSOKq)IJs1uTphA3Xo#jZvx:):l3Z&\\8F/OBDNLQ&R/x2f3hEBE-o;Gqkge}gqc0Icm;Ye?-I_:Q~7#eU%i4GH+|FG)P!BX";
    private final Object map_LOCK = new Object();
    private HashMap<Integer, ArrayList<Notification>> all = new HashMap();
    private SaverUtil saverUtil = new SaverUtil("NotificationRegistry", 5000, this, true);
    private NotificationImplementor implementor;
    private Object save_LOCK = new Object();

    public NotificationRegistry(NotificationImplementor implementor) {
        this.implementor = implementor;
        this.registryFile.getParentFile().mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        Object object = this.map_LOCK;
        synchronized (object) {
            this.all.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotification(TechUser user, Notification notification) {
        ArrayList<Notification> notifications;
        if (user == null || notification == null) {
            return;
        }
        ArrayList<Notification> arrayList = this.map_LOCK;
        synchronized (arrayList) {
            notifications = this.all.get(user.getUserID());
            if (notifications == null) {
                notifications = new ArrayList();
                this.all.put(user.getUserID(), notifications);
            }
        }
        arrayList = notifications;
        synchronized (arrayList) {
            notifications.add(notification);
            if (notification.keepOneOfTheseNotificationsMax()) {
                for (int i = notifications.size() - 2; i >= 0; --i) {
                    Notification otherNotification = notifications.get(i);
                    if (!otherNotification.isSameTypeAs(notification) || !otherNotification.keepOneOfTheseNotificationsMax()) continue;
                    notifications.remove(i);
                    break;
                }
            }
        }
        this.scheduleSave();
        this.implementor.sendNotificationToTech(user, notification);
    }

    public void scheduleSave() {
        this.saverUtil.queueSave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAllToDisk() {
        long C;
        long B;
        long A;
        HashMap<Integer, ArrayList<Notification>> mapCopy;
        Set<Integer> keySet;
        if (this.all == null) {
            return;
        }
        long T = System.currentTimeMillis();
        Object object = this.map_LOCK;
        synchronized (object) {
            keySet = this.all.keySet();
            mapCopy = new HashMap<Integer, ArrayList<Notification>>(this.all);
        }
        Object object2 = this.save_LOCK;
        synchronized (object2) {
            A = System.currentTimeMillis() - T;
            B = -1L;
            C = -1L;
            try {
                this.registryFile.getParentFile().mkdirs();
                RijndaelEncryptionStream fout = new RijndaelEncryptionStream((OutputStream)new BufferedOutputStream(new AtomicFileOutputStream(this.registryFile)), this.encryptionKey);
                B = System.currentTimeMillis() - T;
                try {
                    StreamUtils.writeInt(fout, keySet.size());
                    for (Integer key : keySet) {
                        StreamUtils.writeInt(fout, key);
                        ArrayList<Notification> value = mapCopy.get(key);
                        if (value != null) {
                            ArrayList<Notification> arrayList = value;
                            synchronized (arrayList) {
                                StreamUtils.writeInt(fout, value.size());
                                for (Notification notification : value) {
                                    MessageUtils.writeMessageNoFlush(fout, notification.toMessage());
                                }
                                continue;
                            }
                        }
                        StreamUtils.writeInt(fout, 0);
                    }
                }
                finally {
                    try {
                        fout.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (IOException ex) {
                System.out.println("[NotificationDB] WARNING: Unable to save notification database to file.");
                ex.printStackTrace();
                return;
            }
            C = System.currentTimeMillis() - T;
        }
        System.out.println("[NotificationDB] Saved " + A + "ms, " + B + "ms, " + C + "ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAllFromDisk() {
        Object object = this.map_LOCK;
        synchronized (object) {
            if (this.all == null) {
                this.all = new HashMap();
            } else {
                this.clearAll();
            }
            if (this.registryFile.getParentFile().exists() && this.registryFile.exists()) {
                try {
                    long start = System.currentTimeMillis();
                    AtomicFileOutputStream.prepareForReading(this.registryFile);
                    RijndaelDecryptionStream fin = new RijndaelDecryptionStream((InputStream)new BufferedInputStream(new FileInputStream(this.registryFile)), this.encryptionKey);
                    try {
                        int size = StreamUtils.readInt(fin);
                        for (int i = 0; i < size; ++i) {
                            int key = StreamUtils.readInt(fin);
                            ArrayList<Notification> values = new ArrayList<Notification>();
                            this.all.put(key, values);
                            int valueSize = StreamUtils.readInt(fin);
                            for (int v = 0; v < valueSize; ++v) {
                                values.add(Notification.fromMessage(MessageUtils.readMessage(fin)));
                            }
                            System.out.println("Loaded " + valueSize + " notifications for " + key);
                        }
                        System.out.println("[NotificationDB] Loaded " + size + " notifications. Took " + (System.currentTimeMillis() - start) + "ms");
                    }
                    finally {
                        try {
                            fin.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (IOException ex) {
                    System.out.println("[NotificationDB] WARNING: Unable to process notifications database file, even though it exists (" + this.registryFile.getAbsolutePath() + ")");
                    ex.printStackTrace();
                }
            }
        }
        System.out.println("[NotificationDB] " + this.all.size() + " notifications loaded.");
    }

    @Override
    public void performSave() {
        this.saveAllToDisk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markRead(TechUser techUser, Notification n) {
        Object object = this.map_LOCK;
        synchronized (object) {
            ArrayList<Notification> notifications = this.all.get(techUser.getUserID());
            if (notifications == null) {
                return;
            }
            for (Notification notification : notifications) {
                if (!n.equals(notification)) continue;
                notification.read = true;
                return;
            }
            this.scheduleSave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll(TechUser techUser) {
        Object object = this.map_LOCK;
        synchronized (object) {
            ArrayList<Notification> notifications = this.all.get(techUser.getUserID());
            if (notifications == null) {
                return;
            }
            notifications.clear();
            this.scheduleSave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Notification[] getAllNotificationsFor(TechUser techUser) {
        Object object = this.map_LOCK;
        synchronized (object) {
            ArrayList<Notification> notifications = this.all.get(techUser.getUserID());
            if (notifications == null) {
                return new Notification[0];
            }
            return notifications.toArray(new Notification[0]);
        }
    }

    public static interface NotificationImplementor {
        public void sendNotificationToTech(TechUser var1, Notification var2);
    }
}

