/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.shelp.proxy.MachineRegistry;
import com.aem.utils.Debugger;
import java.util.HashMap;
import java.util.LinkedList;

public class NodelinkRegistry {
    Object LOCK = new Object();
    HashMap<String, LinkedList<NodeLink>> map = new HashMap();
    MachineRegistry mregistry;

    public NodelinkRegistry(MachineRegistry mregistry) {
        this.mregistry = mregistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodelink(String machineID, NodeLink customerLink) {
        Object object = this.LOCK;
        synchronized (object) {
            Debugger.info("Associating nodelink with machine " + machineID);
            LinkedList<NodeLink> list = this.map.get(machineID);
            if (list == null) {
                list = new LinkedList();
                this.map.put(machineID, list);
                list.add(customerLink);
            } else if (!list.contains(customerLink)) {
                list.add(customerLink);
            }
            customerLink.addLinkStatusListener(new RemoveListener(machineID, customerLink));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<NodeLink> getNodelinksForMachine(String machineID) {
        Object object = this.LOCK;
        synchronized (object) {
            LinkedList<NodeLink> list = this.map.get(machineID);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodelink(String machineID, NodeLink customerLink) {
        Object object = this.LOCK;
        synchronized (object) {
            Debugger.info("Removing nodelink associated with " + machineID);
            LinkedList<NodeLink> list = this.map.get(machineID);
            if (list != null) {
                list.remove(customerLink);
                if (list.size() == 0) {
                    this.map.remove(machineID);
                }
            }
        }
    }

    class RemoveListener
    implements NodeLinkStatusListener {
        String machineID;
        NodeLink customerLink;

        public RemoveListener(String machineID, NodeLink customerLink) {
            this.machineID = machineID;
            this.customerLink = customerLink;
        }

        @Override
        public void linkDead(NodeLink link, String reason) {
            NodelinkRegistry.this.removeNodelink(this.machineID, this.customerLink);
        }

        @Override
        public void linkDown(NodeLink link, Throwable reason) {
            NodelinkRegistry.this.mregistry.requestMachineAvailabilityCheck(this.machineID);
        }

        @Override
        public void linkOK(NodeLink link) {
        }
    }
}

