/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.CentralDebugging;
import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.mdupload.SecMsgDecryptionError;
import com.aem.shelp.mdupload.SecureMessenger;
import com.aem.shelp.mdupload.SecureMessengerDB;
import java.io.IOException;
import utils.message.Message;
import utils.udp.WakeOnLan;

public class MonitoringAPI {
    long nextPrint = SafeClock.currentTimeMillis() + 5000L;
    long failedMessages = 0L;
    StringBuffer failedMachines = new StringBuffer();
    Object failure_LOCK = new Object();

    public void showMachineNotification(String machineID, String title, String content) {
        SecureMessenger machine = SecureMessengerDB.fetchSecureMessenger(machineID);
        Message message = new Message(1589706788);
        message.append(title);
        message.append(content);
        try {
            machine.secureSendNoBlock(message);
        }
        catch (Exception x) {
            System.out.println("[PopupNotify] Failed to send popup message to " + machineID + ": " + x);
            x.printStackTrace();
        }
    }

    public boolean requestStateDump(String machineID) {
        SecureMessenger machine = SecureMessengerDB.fetchSecureMessenger(machineID);
        Message message = new Message(1589706785);
        try {
            Message ret = machine.transactSecure(message);
            return ret.getNextBoolean();
        }
        catch (IOException x) {
            System.out.println("[RaConsoleCheck] Failed to complete console check for " + machineID + ": " + x);
            return false;
        }
        catch (Exception x) {
            System.out.println("[RaConsoleCheck] Failed to complete console check for " + machineID + ": " + x);
            x.printStackTrace();
            return false;
        }
    }

    public boolean requestConsoleCheck(String machineID, int consoleID) {
        SecureMessenger machine = SecureMessengerDB.fetchSecureMessenger(machineID);
        Message message = new Message(1589706784);
        message.append(consoleID);
        try {
            Message ret = machine.transactSecure(message);
            return ret.getNextBoolean();
        }
        catch (IOException x) {
            System.out.println("[RaConsoleCheck] Failed to complete console check for " + machineID + ": " + x);
            return false;
        }
        catch (Exception x) {
            System.out.println("[RaConsoleCheck] Failed to complete console check for " + machineID + ": " + x);
            x.printStackTrace();
            return false;
        }
    }

    public void requestWakeOnLan(String machineID, String[] targetIPs, String[] targetMacs) {
        SecureMessenger machine = SecureMessengerDB.fetchSecureMessenger(machineID);
        Message m = new Message(1589706769);
        try {
            for (int i = 0; i < targetIPs.length; ++i) {
                String ip = targetIPs[i];
                String mac = targetMacs[i];
                byte[] ipb = WakeOnLan.getAddrBytes(ip);
                byte[] macb = WakeOnLan.getMacBytes(mac);
                m.append(ipb);
                m.append(macb);
            }
            machine.secureSendNoBlock(m);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void forwardMessage(String machineID, Message wolMessage) {
        SecureMessenger machine = SecureMessengerDB.fetchSecureMessenger(machineID);
        try {
            machine.secureSendNoBlock(wolMessage);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void requestBasicInfo(SecureMessenger machine) {
        machine.secureSendNoBlock(new Message(1589706756));
    }

    public void uploadBigScreen(String machineID) {
        SecureMessenger machine = SecureMessengerDB.fetchSecureMessenger(machineID);
        Message m = new Message(1589727249);
        if (machine == null) {
            if (CentralDebugging.MUPLOAD_ALL) {
                System.out.println("[Monitoring] Unable to find machine with ID " + machineID + " to upload big screen");
            }
        } else {
            machine.secureSendNoBlock(m);
        }
    }

    public void changeMonitoredScreen(String machineID, boolean next, boolean big) {
        SecureMessenger machine = SecureMessengerDB.fetchSecureMessenger(machineID);
        Message m = new Message(1589727256);
        m.append(next);
        m.append(big);
        if (machine == null) {
            if (CentralDebugging.MUPLOAD_ALL) {
                System.out.println("[Monitoring] Unable to find machine with ID " + machineID + " to select monitor");
            }
        } else {
            machine.secureSendNoBlock(m);
        }
    }

    public void uploadDetails(String machineID) {
        SecureMessenger machine = SecureMessengerDB.fetchSecureMessenger(machineID);
        Message m = new Message(1589727237);
        if (machine == null) {
            if (CentralDebugging.MUPLOAD_ALL) {
                System.out.println("[Monitoring] Unable to find machine with ID " + machineID + " to upload details");
            }
        } else {
            machine.secureSendNoBlock(m);
        }
    }

    public void uploadThumbnails(String machineID) {
        SecureMessenger machine = SecureMessengerDB.fetchSecureMessenger(machineID);
        Message m = new Message(1589727238);
        if (machine == null) {
            if (CentralDebugging.MUPLOAD_ALL) {
                System.out.println("[Monitoring] Unable to find machine with ID " + machineID + " to upload thumb summary");
            }
        } else {
            machine.secureSendNoBlock(m);
        }
    }

    public void switchMonitoring(boolean on, String machineID) {
        SecureMessenger machine = SecureMessengerDB.fetchSecureMessenger(machineID);
        Message m = new Message(1589706758);
        m.append(on);
        if (machine == null) {
            if (CentralDebugging.MUPLOAD_ALL) {
                System.out.println("[Monitoring] Unable to find machine with ID " + machineID + " to switch monitoring");
            }
        } else {
            machine.secureSendNoBlock(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failedToMessage(String machineID) {
        block11: {
            try {
                Object object = this.failure_LOCK;
                synchronized (object) {
                    ++this.failedMessages;
                    if (this.failedMachines.length() == 0) {
                        this.failedMachines.append(machineID);
                    } else if (this.failedMachines.length() < 500) {
                        this.failedMachines.append(", ").append(machineID);
                    }
                }
                long T = SafeClock.currentTimeMillis();
                if (T <= this.nextPrint) break block11;
                this.nextPrint = T + 5000L;
                System.out.println("[Monitoring] Unable to proxy messages to remote machines x" + this.failedMessages + " - " + this.failedMachines.toString());
                Object object2 = this.failure_LOCK;
                synchronized (object2) {
                    this.failedMessages = 0L;
                    this.failedMachines.setLength(0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Message transactMessage(String targetMachineID, Message message) throws SecMsgDecryptionError {
        if (CentralDebugging.MONAPI_SHOW_SENDS_AND_TRANS) {
            System.out.println("[MonAPI] Trans " + message);
        }
        try {
            SecureMessenger machine = SecureMessengerDB.fetchSecureMessenger(targetMachineID);
            if (machine == null) {
                this.failedToMessage(targetMachineID);
                return new Message(-286392320);
            }
            return machine.transactSecure(message);
        }
        catch (IOException x) {
            x.printStackTrace();
            return null;
        }
    }

    public void sendMessage(String targetMachineID, Message message) throws SecMsgDecryptionError {
        SecureMessenger machine;
        if (CentralDebugging.MONAPI_SHOW_SENDS_AND_TRANS) {
            System.out.println("[MonAPI] Send " + message);
        }
        if ((machine = SecureMessengerDB.fetchSecureMessenger(targetMachineID)) == null) {
            this.failedToMessage(targetMachineID);
        } else {
            machine.secureSend(message);
        }
    }
}

