/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.proxy.MiniSessionProxy;
import com.aem.shelp.proxy.MiniSessionWait;
import java.util.HashMap;

public class MiniSessionRegistry
extends Thread {
    long ESTABLISH_TIMEOUT = 45000L;
    long TIMEOUT = 1800000L;
    HashMap map = new HashMap();
    HashMap waiting = new HashMap();
    Object LOCK = new Object();

    public MiniSessionRegistry() {
        super("MiniSessionRegistry");
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(60000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Object object = this.LOCK;
                synchronized (object) {
                    Object[] keys = this.map.keySet().toArray();
                    for (int i = 0; i < keys.length; ++i) {
                        String key = (String)keys[i];
                        Object val = this.map.get(key);
                        if (val instanceof MiniSessionProxy) {
                            MiniSessionProxy proxy = (MiniSessionProxy)val;
                            if (System.currentTimeMillis() - proxy.lastAccessed <= this.TIMEOUT) continue;
                            proxy.sock.stop("mini session registry connection timed out");
                            this.map.remove(key);
                            continue;
                        }
                        Waiter waiter = (Waiter)val;
                        if (SafeClock.currentTimeMillis() - waiter.started <= this.ESTABLISH_TIMEOUT) continue;
                        this.map.remove(key);
                    }
                    continue;
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMiniSession(String uid) {
        Object object = this.LOCK;
        synchronized (object) {
            this.map.remove(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MiniSessionWait addMiniSession(String uid, MiniSessionProxy proxy) {
        MiniSessionWait tech = null;
        Object object = this.LOCK;
        synchronized (object) {
            try {
                Waiter waiter = (Waiter)this.map.get(uid);
                if (waiter != null) {
                    tech = waiter.tech;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            this.map.put(uid, proxy);
        }
        return tech;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MiniSessionProxy getMiniSession(String uid) {
        MiniSessionProxy proxy;
        Object object = this.LOCK;
        synchronized (object) {
            proxy = (MiniSessionProxy)this.map.get(uid);
            if (proxy != null) {
                proxy.lastAccessed = System.currentTimeMillis();
            }
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerWaiting(String uid, MiniSessionWait tech) {
        Object object = this.LOCK;
        synchronized (object) {
            this.map.put(uid, new Waiter(tech));
        }
    }

    class Waiter {
        long started = SafeClock.currentTimeMillis();
        MiniSessionWait tech;

        public Waiter(MiniSessionWait tech) {
            this.tech = tech;
        }
    }
}

