/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.shelp.proxy.types.MachineInfo;
import com.aem.shelp.proxy.types.MachineName;
import com.aem.shelp.proxy.types.apptunnel.AppTunnelSpecification;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import utils.encryption.aes.RijndaelDecryptionStream;
import utils.encryption.aes.RijndaelEncryptionStream;
import utils.files.AtomicFileOutputStream;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.stream.StreamUtils;
import utils.switches.Switches;

public class MachineDB {
    private final File DB = new File("configuration", "accessdb");
    private final File MACHINESDB = new File(this.DB, "accessdb");
    private final Object map_LOCK = new Object();
    private HashMap<String, MachineDetails> map = new HashMap();
    private final Object THREAD_LOCK = new Object();
    private SaveThread saveThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSaveThread() {
        Object object = this.THREAD_LOCK;
        synchronized (object) {
            if (this.saveThread == null) {
                this.saveThread = new SaveThread();
                this.saveThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAllToDisk() {
        ArrayList<String> keys;
        long T = System.currentTimeMillis();
        int mapSize = 0;
        Object object = this.map_LOCK;
        synchronized (object) {
            if (this.map == null) {
                return;
            }
            keys = new ArrayList<String>(this.map.keySet());
            mapSize = keys.size();
        }
        long A = System.currentTimeMillis() - T;
        long B = -1L;
        long C = -1L;
        try {
            if (!this.DB.exists()) {
                this.DB.mkdirs();
            }
            RijndaelEncryptionStream fout = new RijndaelEncryptionStream((OutputStream)new BufferedOutputStream(new AtomicFileOutputStream(this.MACHINESDB)), "shdakjhk1237****88231678214gi14y980---4378295678235ibdjhsv bbnnbdiewdhiuer783294%%%767sdhai20000ffuhher[pq;q,zmznbvy");
            B = System.currentTimeMillis() - T;
            try {
                StreamUtils.writeInt(fout, mapSize);
                for (String id : keys) {
                    MachineDetails machineDetails;
                    Iterator iterator = this.map_LOCK;
                    synchronized (iterator) {
                        machineDetails = this.map.get(id);
                    }
                    if (machineDetails != null && machineDetails.machineInfo != null) {
                        StreamUtils.writeStringUTF8(fout, id);
                        machineDetails.machineInfo.save(fout);
                        StreamUtils.writeInt(fout, machineDetails.specifications.size());
                        for (AppTunnelSpecification spec : machineDetails.specifications) {
                            MessageUtils.writeMessageNoFlush(fout, spec.toMessage());
                        }
                        continue;
                    }
                    System.out.println("[MachineDB] Unable to write " + id + ", so will write blank");
                    StreamUtils.writeStringUTF8(fout, "");
                }
            }
            finally {
                try {
                    fout.close();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (IOException ex) {
            System.out.println("[MachineDB] WARNING: Unable to save machine database to file.");
            ex.printStackTrace();
            return;
        }
        C = System.currentTimeMillis() - T;
        System.out.println("[MachineDB] Saved " + A + "ms, " + B + "ms, " + C + "ms");
        File[] files = this.DB.listFiles();
        if (files != null && files.length > 0) {
            System.out.println("[MachineDB] Clearing legacy machine info files.");
            for (File f : files) {
                if (!f.getName().startsWith("SG_")) continue;
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllMachineIDs() {
        Object object = this.map_LOCK;
        synchronized (object) {
            if (this.map == null) {
                return new String[0];
            }
            Set<String> set = this.map.keySet();
            return set.toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAllFromDisk() {
        Object object = this.map_LOCK;
        synchronized (object) {
            if (this.map == null) {
                this.map = new HashMap();
            } else {
                this.map.clear();
            }
            if (this.DB.exists()) {
                if (this.MACHINESDB.exists()) {
                    try {
                        long start = System.currentTimeMillis();
                        AtomicFileOutputStream.prepareForReading(this.MACHINESDB);
                        RijndaelDecryptionStream fin = new RijndaelDecryptionStream((InputStream)new BufferedInputStream(new FileInputStream(this.MACHINESDB)), "shdakjhk1237****88231678214gi14y980---4378295678235ibdjhsv bbnnbdiewdhiuer783294%%%767sdhai20000ffuhher[pq;q,zmznbvy");
                        try {
                            int size = StreamUtils.readInt(fin);
                            for (int i = 0; i < size; ++i) {
                                String id = StreamUtils.readStringUTF8(fin);
                                if (id.length() == 0) {
                                    System.out.println("[MachineDB] Unable to read '" + id + "' at index " + i);
                                    continue;
                                }
                                MachineDetails details = new MachineDetails(MachineInfo.load(fin));
                                if (details.machineInfo != null) {
                                    int version = details.machineInfo.getSerialisationVersion();
                                    if (version >= 19) {
                                        try {
                                            int specs = StreamUtils.readInt(fin);
                                            for (int ii = 0; ii < specs; ++ii) {
                                                Message m = MessageUtils.readMessage(fin);
                                                details.specifications.add(AppTunnelSpecification.fromMessage(m));
                                            }
                                        }
                                        catch (Throwable t) {
                                            t.printStackTrace();
                                        }
                                    }
                                    this.map.put(id, details);
                                    System.out.println("[MachineDB] Loaded machine " + id + " (" + details.machineInfo.getMachineName() + ")");
                                    continue;
                                }
                                System.out.println("[MachineDB] Machine " + id + " information was not valid");
                            }
                            System.out.println("[MachineDB] Loaded " + size + " machine metadatas. Took " + (System.currentTimeMillis() - start) + "ms");
                        }
                        finally {
                            try {
                                fin.close();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    catch (Throwable ex) {
                        System.out.println("[MachineDB] WARNING: Unable to process machine database file, even though it exists (" + this.MACHINESDB.getAbsolutePath() + ")");
                        ex.printStackTrace();
                    }
                } else {
                    long start = System.currentTimeMillis();
                    File[] idFiles = this.DB.listFiles();
                    if (idFiles != null) {
                        for (File idFile : idFiles) {
                            MachineInfo info;
                            String id = idFile.getName();
                            if (!id.startsWith("SG_") || (info = MachineInfo.legacy_load(idFile)) == null) continue;
                            this.map.put(id, new MachineDetails(info));
                        }
                    }
                    System.out.println("[MachineDB] Loaded " + this.map.size() + " legacy machine metadatas. Took " + (System.currentTimeMillis() - start) + "ms");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MachineDetails getMachineDetailsFor(String machineID) {
        MachineDetails machineDetails;
        Object object = this.map_LOCK;
        synchronized (object) {
            machineDetails = this.map.get(machineID);
        }
        if (machineDetails == null) {
            machineDetails = new MachineDetails(new MachineInfo(machineID));
            object = this.map_LOCK;
            synchronized (object) {
                this.map.put(machineID, machineDetails);
            }
            this.scheduleSaveInTenSeconds();
        }
        return machineDetails;
    }

    public String getShortName(String machineID) {
        MachineInfo info = this.getInfoFor(machineID);
        if (info == null) {
            return machineID;
        }
        MachineName name = info.getMachineName();
        if (name == null) {
            return machineID;
        }
        if (name.getName() == null) {
            return machineID;
        }
        return name.getName();
    }

    public MachineInfo getInfoFor(String machineID) {
        MachineDetails details = this.getMachineDetailsFor(machineID);
        return details.machineInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MachineInfo removeInfoFor(String machineID) {
        MachineDetails removedMachineInfo = null;
        Object object = this.map_LOCK;
        synchronized (object) {
            removedMachineInfo = this.map.remove(machineID);
        }
        this.scheduleSaveInTenSeconds();
        if (removedMachineInfo == null) {
            return null;
        }
        return removedMachineInfo.machineInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppTunnelSpecification[] getAllSpecifications(String machineID) {
        MachineDetails details = this.getMachineDetailsFor(machineID);
        ArrayList arrayList = details.specifications;
        synchronized (arrayList) {
            return details.specifications.toArray(new AppTunnelSpecification[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pinSpecificationToMachine(String machineID, AppTunnelSpecification specification) {
        MachineDetails details = this.getMachineDetailsFor(machineID);
        ArrayList arrayList = details.specifications;
        synchronized (arrayList) {
            details.specifications.add(specification);
        }
        this.scheduleSaveInTenSeconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSpecificationFromMachine(String machineID, AppTunnelSpecification specification) {
        MachineDetails details = this.getMachineDetailsFor(machineID);
        ArrayList arrayList = details.specifications;
        synchronized (arrayList) {
            details.specifications.remove(specification);
        }
        this.scheduleSaveInTenSeconds();
    }

    private void scheduleSaveInTenSeconds() {
        this.initSaveThread();
        this.saveThread.requestSave();
    }

    public void notifyInfoChanged(MachineInfo machineInfo) {
        this.scheduleSaveInTenSeconds();
    }

    public void debug_addMachineInfo(String machineID, MachineInfo machineInfo) {
        this.map.put(machineID, new MachineDetails(machineInfo));
    }

    private class SaveThread
    extends Thread {
        private boolean requestSave;

        public SaveThread() {
            super("MachineDB - Save Thread");
            this.requestSave = false;
            this.setDaemon(true);
        }

        public void requestSave() {
            this.requestSave = true;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    if (Switches.SH_1839_machineDbSaveLessOften) {
                        Thread.sleep(20000L);
                    } else {
                        Thread.sleep(10000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!this.requestSave) continue;
                this.requestSave = false;
                MachineDB.this.saveAllToDisk();
            }
        }
    }

    private class MachineDetails {
        private MachineInfo machineInfo;
        private final ArrayList<AppTunnelSpecification> specifications = new ArrayList();

        public MachineDetails(MachineInfo info) {
            this.machineInfo = info;
        }
    }
}

