/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.ServerManagement;
import com.aem.shelp.licence.License;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import utils.message.Message;

public class LicenseConfig {
    private static LicenseConfig CURRENT_INSTANCE = new LicenseConfig();
    private transient License SimpleHelpLicense = null;
    private long sgExpiryDate = Long.MAX_VALUE;
    private long shExpiryDate = Long.MAX_VALUE;
    private long shPurchaseDate = Long.MAX_VALUE;
    private long sgPurchaseDate = Long.MAX_VALUE;
    private long renewalDate = Long.MAX_VALUE;
    private boolean shLicenseValid = false;
    private boolean sgLicenseValid = false;
    private int sgAllowedSessions = 1;
    private int shAllowedSessions = 1;
    private int alertLimit = 0;
    private int machineLimit = 0;
    private int sdMaxAttendees = 0;
    private boolean joinSessionCounts = false;
    private boolean rebranding = false;
    private boolean outOfDate = false;
    private boolean expiredTrial = false;
    private boolean monitoringOnly = false;
    private String licenseErrorMessage;

    public static LicenseConfig get() {
        return CURRENT_INSTANCE;
    }

    public byte[] getRecoveryHash() {
        if (this.SimpleHelpLicense != null) {
            return this.SimpleHelpLicense.getRecoveryHash();
        }
        return null;
    }

    public void loadLicense(License lic) throws IOException {
        if (!lic.supportsServerBuild()) {
            this.outOfDate = true;
            System.out.println("**************************************************************");
            System.out.println("WARNING: Your license is too old to run this build of " + ServerManagement.getServerName() + ".");
            System.out.println();
            System.out.println("         This server version does not fall within your license maintenance period.");
            System.out.println("         Please visit http://www.simple-help.com/purchase for additional details, ");
            System.out.println("         or to update your license.");
            System.out.println("**************************************************************\n");
            this.licenseErrorMessage = "VALID_LICENSE_EXPIRED";
            this.sgExpiryDate = System.currentTimeMillis() - 86400000L;
            this.shExpiryDate = System.currentTimeMillis() - 86400000L;
            throw new IOException(this.licenseErrorMessage);
        }
        this.expiredTrial = false;
        this.outOfDate = false;
        System.out.println("[License] SimpleSuite license present");
        this.sgLicenseValid = true;
        this.sgAllowedSessions = lic.getSessions();
        this.sgExpiryDate = lic.getExpiryMs();
        this.shLicenseValid = true;
        this.shAllowedSessions = lic.getSessions();
        this.shExpiryDate = lic.getExpiryMs();
        this.alertLimit = lic.getAlertLimit();
        this.machineLimit = lic.getMachineLimit();
        this.joinSessionCounts = true;
        this.SimpleHelpLicense = lic;
        this.sdMaxAttendees = lic.getDemoAttendees();
        this.rebranding = lic.allowsRebranding();
        this.monitoringOnly = lic.isMonitoringOnly();
        this.renewalDate = lic.getSupportFinishMs();
    }

    public void loadLicense(File licenseFile) throws IOException {
        try {
            System.out.println("[License] Trying " + licenseFile);
            License lic = License.read(licenseFile);
            this.loadLicense(lic);
        }
        catch (License.ExpiredException x) {
            System.out.println("[License] Expired");
            this.expiredTrial = true;
        }
    }

    public boolean hasLicense() {
        return this.getLicense() != null;
    }

    public License getLicense() {
        return this.SimpleHelpLicense;
    }

    public boolean isMonitoringOnly() {
        return this.monitoringOnly;
    }

    public String getErrorMessage() {
        return this.licenseErrorMessage;
    }

    public int getMaxSHSessions() {
        return this.shAllowedSessions;
    }

    public int getAlertedMachinesLimit() {
        return this.alertLimit;
    }

    public int getAccessibleMachinesLimit() {
        return this.machineLimit;
    }

    public int getMaxSGSessions() {
        return this.sgAllowedSessions;
    }

    public long getSgExpiryDate() {
        return this.sgExpiryDate;
    }

    public boolean isOutOfDate() {
        return this.outOfDate;
    }

    public boolean isExpiredTrial() {
        return this.expiredTrial;
    }

    public void setSgExpiryDate(long sgExpiryDate) {
        this.sgExpiryDate = sgExpiryDate;
    }

    public long getShExpiryDate() {
        return this.shExpiryDate;
    }

    public void setShExpiryDate(long shExpiryDate) {
        this.shExpiryDate = shExpiryDate;
    }

    public boolean isShLicenseValid() {
        return this.shLicenseValid;
    }

    public boolean allowsRebranding() {
        return this.rebranding;
    }

    public void setShLicenseValid(boolean shLicenseValid) {
        this.shLicenseValid = shLicenseValid;
    }

    public boolean isSgLicenseValid() {
        return this.sgLicenseValid;
    }

    public void setSgLicenseValid(boolean sgLicenseValid) {
        this.sgLicenseValid = sgLicenseValid;
    }

    public int getMaxSDemoAttendees() {
        return this.sdMaxAttendees;
    }

    public int getSgAllowedSessions() {
        return this.sgAllowedSessions;
    }

    public void setSgAllowedSessions(int sgAllowedSessions) {
        this.sgAllowedSessions = sgAllowedSessions;
    }

    public int getShAllowedSessions() {
        return this.shAllowedSessions;
    }

    public void setShAllowedSessions(int shAllowedSessions) {
        this.shAllowedSessions = shAllowedSessions;
    }

    public boolean joinSessionCounts() {
        return this.joinSessionCounts;
    }

    public void saveToMessage(Message licenseMessage) {
        int success = 0;
        License[] licenses = new License[]{this.SimpleHelpLicense};
        licenseMessage.append(new Integer(0));
        for (int i = 0; i < licenses.length; ++i) {
            if (licenses[i] == null) continue;
            try {
                licenseMessage.append(licenses[i].toBytes());
                ++success;
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        licenseMessage.set(0, new Integer(success));
    }

    public static void fromMessage(Message licenseMessage, ArrayList<License> licenseList) throws IOException {
        licenseList.clear();
        int licenseCount = (Integer)licenseMessage.get(0);
        for (int i = 0; i < licenseCount; ++i) {
            License lic = License.fromBytes((byte[])licenseMessage.get(1 + i));
            licenseList.add(lic);
        }
    }

    public void dumpLicenseDetails() {
        System.out.println();
        if (LicenseConfig.get().getLicense() != null) {
            System.out.println("Found valid SimpleSuite license:\n\n" + LicenseConfig.get().getLicense());
        } else if (LicenseConfig.get().getErrorMessage() == null) {
            System.out.println("No SimpleSuite license file ('shlicense.txt') found\n");
            System.out.println("SimpleSuite Evaluation allowed for up to one connected session for 21 days from installation date");
        }
        System.out.println("");
    }

    public static void readAllLicenses() {
        File[] possibles = new File[]{new File("license.txt"), new File("License.txt"), new File("sglicense.txt"), new File("shlicense.txt"), new File("configuration/shlicense.txt")};
        LicenseConfig.get().expiredTrial = false;
        LicenseConfig.get().outOfDate = false;
        for (int i = 0; i < possibles.length; ++i) {
            File f = possibles[i];
            try {
                LicenseConfig.get().loadLicense(f);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LicenseConfig.get().dumpLicenseDetails();
    }

    public boolean isUnlicensedTrial() {
        return !this.sgLicenseValid && !this.shLicenseValid;
    }

    public boolean isLicensedTrial() {
        if (this.shLicenseValid && this.shExpiryDate > 0L && this.shExpiryDate < Long.MAX_VALUE) {
            return true;
        }
        return this.sgLicenseValid && this.sgExpiryDate > 0L && this.sgExpiryDate < Long.MAX_VALUE;
    }

    public boolean isLicensed() {
        if (this.shLicenseValid && (this.shExpiryDate == 0L || this.shExpiryDate == Long.MAX_VALUE)) {
            return true;
        }
        return this.sgLicenseValid && (this.sgExpiryDate == 0L || this.sgExpiryDate == Long.MAX_VALUE);
    }

    public String getSecRandomFirst128BitsAsHex() {
        if (this.SimpleHelpLicense != null) {
            String secRandom = this.SimpleHelpLicense.getSecRandom();
            if (secRandom == null) {
                return null;
            }
            if (secRandom.length() > 32) {
                return secRandom.substring(0, 32);
            }
            return secRandom;
        }
        return null;
    }

    public long getRenewalDate() {
        return this.renewalDate;
    }
}

