/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.nodelink.utils.SslToTcp;
import com.aem.shelp.proxy.ProxyServer;
import com.aem.shelp.util.KeytoolUtil;
import com.aem.utils.KeyStoreUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import utils.files.FileUtil;
import utils.ssl.letsencrypt.ChallengeListener;
import utils.ssl.letsencrypt.LetsEncryptRequestor;

public class LetsEncryptUtil
implements ChallengeListener {
    public static String DEFAULT_PASSWORD = "changeit";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeytoolUtil.KeyStoreResult requestCertificate(String domain, char[] password, String email, String agreementURL) {
        KeytoolUtil.KeyStoreResult result = new KeytoolUtil.KeyStoreResult();
        result.success = 100;
        File keystore = SslToTcp.KEYSTORE.getKeystoreFile();
        if (keystore == null) {
            keystore = new File("keystore.test");
        }
        File userKeyStore = new File(keystore.getParentFile(), keystore.getName() + ".user");
        File tempKeystore = new File(keystore.getParentFile(), keystore.getName() + ".tmp");
        if (tempKeystore.exists()) {
            tempKeystore.delete();
        }
        try {
            String alias = "simplehelp";
            LetsEncryptRequestor.requestCertificate(email, domain, tempKeystore, userKeyStore, alias, password, this, agreementURL);
            KeyStore keystoreInstance = KeyStore.getInstance("PKCS12");
            FileInputStream fin = new FileInputStream(tempKeystore);
            try {
                keystoreInstance.load(fin, password);
            }
            finally {
                fin.close();
            }
            try {
                result.expiryDate = KeyStoreUtility.getExpiryDate(keystoreInstance);
            }
            catch (Throwable t) {
                t.printStackTrace();
                result.expiryDate = -1L;
            }
            keystore.delete();
            tempKeystore.renameTo(keystore);
            ProxyServer.INSTANCE.reloadKeyStore(password, password, "LetsEncrypt");
            result.success = 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result.errorMessage = ex.getMessage();
        }
        return result;
    }

    @Override
    public LetsEncryptRequestor.ChallengeRequest challengeSimpleHTTP(String domain, String token, String challengeURI, String content, boolean tls, SSLContext ctx) throws Exception {
        return null;
    }

    @Override
    public LetsEncryptRequestor.ChallengeRequest challengeDVSNI(String domain, String token, String challengeURI, String content) {
        return null;
    }

    @Override
    public LetsEncryptRequestor.ChallengeRequest challengeHTTP01(String domain, String token, String challengeURI, String content) {
        File targetFile;
        System.out.println("[LetsEncryptUtil] HTTP01 Request Received!");
        System.out.println("[LetsEncryptUtil] \t" + domain);
        System.out.println("[LetsEncryptUtil] \t" + token);
        System.out.println("[LetsEncryptUtil] \t" + challengeURI);
        System.out.println("[LetsEncryptUtil] \t" + content);
        LetsEncryptRequestor.ChallengeRequest req = new LetsEncryptRequestor.ChallengeRequest();
        req.type = "http-01";
        req.challengeURI = challengeURI;
        req.content = content;
        req.token = token;
        File configuration = new File("configuration", "sslconfig");
        if (!configuration.exists()) {
            configuration.mkdirs();
        }
        if ((targetFile = new File(configuration, token)).exists()) {
            targetFile.delete();
        }
        try {
            FileUtil.writeFileAsString(targetFile, content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return req;
    }

    @Override
    public LetsEncryptRequestor.ChallengeRequest challengeDNS(String domain, String token, String challengeURI, String content) {
        return null;
    }

    @Override
    public LetsEncryptRequestor.ChallengeRequest challengeTlsSni01(String domain, String token, String challengeURI, String content) {
        return null;
    }

    @Override
    public void challengeFailed(String domain, String reason) {
        System.out.println("[LetsEncryptUtil] Challenged failed for " + domain + ": " + reason);
    }

    @Override
    public void challengeCompleted(String domain) {
        System.out.println("[LetsEncryptUtil] Challenged complete for " + domain);
    }
}

