/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.shelp.common.Invitation;
import com.aem.shelp.proxy.NoSuchInvitationException;
import com.aem.shelp.proxy.Templates;
import com.aem.shelp.proxy.config.MergedTechGroup;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.tech.invitations.InvitationSubstitutionUtil;
import com.aem.utils.StreamUtils;
import com.jw.SHJWUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import utils.email.CommonEmailer;
import utils.xml.XML14Util;

public class InvitationHandler {
    private static final File INVITATION_DIRECTORY = new File("./configuration/invitations");
    private static final int INVITATION_CODE_LENGTH = 6;
    private static final Random r = new Random(System.currentTimeMillis());
    public static InvitationHandler INSTANCE = new InvitationHandler();

    private InvitationHandler() {
        INVITATION_DIRECTORY.mkdirs();
    }

    private static String getUniqueInvitationID() {
        StringBuffer buffer;
        File targetFile;
        String ambiguousChars = "0O1QIL";
        do {
            buffer = new StringBuffer();
            for (int i = 0; i < 6; ++i) {
                char newChar = '0';
                boolean okChar = false;
                while (!okChar) {
                    int c = r.nextInt(34);
                    newChar = c < 24 ? (char)(65 + c) : (char)(48 + (c - 24));
                    if (ambiguousChars.indexOf(newChar) != -1) continue;
                    okChar = true;
                }
                buffer.append(newChar);
            }
        } while ((targetFile = new File(INVITATION_DIRECTORY, buffer.toString())).exists());
        return buffer.toString();
    }

    public Invitation processInvitationRequest(Invitation requestedInvitation, TechUser user, MergedTechGroup loggedInGroup) throws IOException {
        requestedInvitation.setCreationTime(System.currentTimeMillis());
        if (requestedInvitation.getInvitationID().equals("")) {
            requestedInvitation.setInvitationID(InvitationHandler.getUniqueInvitationID());
        }
        if (user.isAnonymous()) {
            requestedInvitation.setCreatedByID(loggedInGroup.getFirstGroup().getGroupID());
            requestedInvitation.setCreatedByDisplayName(loggedInGroup.getFirstGroup().getName());
        } else {
            requestedInvitation.setCreatedByID(user.uniqueID);
            requestedInvitation.setCreatedByDisplayName(user.displayName);
        }
        this.saveInvitation(requestedInvitation);
        return requestedInvitation;
    }

    private void saveInvitation(Invitation requestedInvitation) throws IOException {
        File targetFile = new File(INVITATION_DIRECTORY, requestedInvitation.getInvitationID());
        BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(targetFile));
        bout.write(requestedInvitation.toXML().getBytes("UTF8"));
        bout.close();
    }

    public Invitation loadInvitation(String invitationID) throws IOException, NoSuchInvitationException {
        if (invitationID.equals("CVS") || invitationID.equals("readme.txt")) {
            return null;
        }
        File targetFile = new File(INVITATION_DIRECTORY, invitationID);
        if (!targetFile.exists()) {
            throw new NoSuchInvitationException("No invitation with ID '" + invitationID + "' found.");
        }
        try {
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(targetFile));
            String xml = StreamUtils.readAllAsStringUTF8(bin);
            bin.close();
            return InvitationHandler.fromXML(xml);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            throw new NoSuchInvitationException("No invitation with ID '" + invitationID + "' found.");
        }
    }

    public Invitation getInvitation(String invitationID, boolean decrementLimits) throws IOException, NoSuchInvitationException, ExpiredInvitationException {
        int sessionLimit;
        Invitation invitation = this.loadInvitation(invitationID);
        if (invitation == null) {
            return null;
        }
        if (invitation.isExpired()) {
            File targetFile = new File(INVITATION_DIRECTORY, invitationID);
            if (targetFile.exists()) {
                targetFile.delete();
            }
            throw new ExpiredInvitationException();
        }
        if (decrementLimits && (sessionLimit = invitation.getSessionLimit()) != -1) {
            invitation.setSessionLimit(sessionLimit - 1);
            this.saveInvitation(invitation);
        }
        return invitation;
    }

    public void deleteInvitation(Invitation toDeleteInvitation) {
        File targetFile = new File(INVITATION_DIRECTORY, toDeleteInvitation.getInvitationID());
        if (targetFile.exists()) {
            targetFile.delete();
        }
    }

    public void updateInvitation(Invitation requestedInvitation) throws IOException {
        this.saveInvitation(requestedInvitation);
    }

    public static boolean canTechnicianEditInvitation(Invitation invitation, TechUser user) {
        if (user.isServerAdmin()) {
            return true;
        }
        int invitationCreatedByID = invitation.getCreatedByID();
        if (invitationCreatedByID == -1) {
            return true;
        }
        if (ServerConfig.isTechnicianID(invitationCreatedByID)) {
            return user.uniqueID == invitationCreatedByID;
        }
        for (int i = 0; i < user.groups.length; ++i) {
            TechGroup group = user.groups[i];
            if (group.getGroupID() != invitationCreatedByID) continue;
            return true;
        }
        return false;
    }

    public ArrayList<Invitation> getAllVisibleInvitations(TechUser techUser) {
        ArrayList<Invitation> list = new ArrayList<Invitation>();
        File[] allInvitations = INVITATION_DIRECTORY.listFiles();
        if (allInvitations != null) {
            for (File allInvitation : allInvitations) {
                try {
                    Invitation loadedInvitation = this.getInvitation(allInvitation.getName(), false);
                    if (loadedInvitation == null) continue;
                    if (techUser.isServerAdmin()) {
                        list.add(loadedInvitation);
                        continue;
                    }
                    int id = loadedInvitation.getCreatedByID();
                    if (id == -1) {
                        list.add(loadedInvitation);
                        continue;
                    }
                    if (loadedInvitation.getShareOption().equals("All")) {
                        list.add(loadedInvitation);
                        continue;
                    }
                    if (loadedInvitation.getShareOption().equals("Group")) {
                        TechUser user = ServerConfig.get().getTechnicianByID(id);
                        TechGroup[] ourGroups = techUser.getGroups();
                        TechGroup[] invitationGroups = user.getGroups();
                        boolean match = false;
                        for (int ii = 0; ii < ourGroups.length && !match; ++ii) {
                            TechGroup ourGroup = ourGroups[ii];
                            for (int jj = 0; jj < invitationGroups.length && !match; ++jj) {
                                TechGroup userGroup = invitationGroups[jj];
                                if (ourGroup.getGroupID() != userGroup.getGroupID()) continue;
                                match = true;
                            }
                        }
                        if (!match) continue;
                        list.add(loadedInvitation);
                        continue;
                    }
                    if (!loadedInvitation.getShareOption().equals("None") || techUser.uniqueID != id) continue;
                    list.add(loadedInvitation);
                }
                catch (Exception ex) {
                    System.out.println("[InvitationHandler] Cannot load invitation '" + allInvitation.getName() + "': " + ex.getMessage());
                }
            }
        }
        return list;
    }

    public void sendInvitationEmail(Invitation requestedInvitation, String toAddress, String fromAddress, String url, String techDisplayName, boolean standalone, MergedTechGroup loggedInContext) throws Exception {
        String content;
        String subject;
        if (!standalone) {
            subject = Templates.invitationEmailSubject;
            content = InvitationSubstitutionUtil.substituteVariables(Templates.invitationEmailContent, requestedInvitation, url, techDisplayName);
        } else {
            String hostname = ServerConfig.get().getHostname(loggedInContext);
            String customerLink = SHJWUtil.getUpdateURLProtocol() + "://" + hostname + "/?invite=" + requestedInvitation.getInvitationID();
            subject = Templates.invitationEmailSubject;
            content = InvitationSubstitutionUtil.substituteVariables(Templates.invitationEmailContent, requestedInvitation, customerLink, techDisplayName);
        }
        if (!ServerConfig.get().emailSettingsEnabled) {
            throw new Exception("No email server configured.");
        }
        CommonEmailer emailer = ServerConfig.get().getCommonEmailerUsingSettings(fromAddress);
        emailer.send(new String[]{toAddress}, subject, content);
    }

    public static void main(String[] args) {
        Templates.loadTemplates();
        Invitation requestedInvitation = Invitation.createRandom();
        System.out.println(InvitationSubstitutionUtil.substituteVariables(Templates.invitationEmailContent, requestedInvitation, "http://google.com", "Big Dawg"));
    }

    public void sendQuickEmail(String customerName, String toAddress, String fromAddress, String url, String techDisplayName) throws Exception {
        Invitation invitation = new Invitation();
        invitation.addCustomerDetail("", customerName);
        invitation.setInvitationID("N/A");
        String subject = Templates.invitationQuickSubject;
        String content = InvitationSubstitutionUtil.substituteVariables(Templates.invitationQuickContent, invitation, url, techDisplayName);
        if (!ServerConfig.get().emailSettingsEnabled) {
            throw new Exception("No email server configured.");
        }
        CommonEmailer emailer = ServerConfig.get().getCommonEmailerUsingSettings(fromAddress);
        emailer.send(new String[]{toAddress}, subject, content);
    }

    public static Invitation fromXML(String xml) throws IOException {
        try {
            Invitation invitation = new Invitation();
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document dom = builder.parse(new InputSource(new StringReader(xml)));
            Element root = dom.getDocumentElement();
            Element child = XML14Util.getChildByName(root, "InvitationID");
            if (child != null) {
                invitation.invitationID = XML14Util.getTextContent(child);
            }
            if ((child = XML14Util.getChildByName(root, "CreatedBy")) != null) {
                TechGroup group;
                TechUser user;
                invitation.createdByID = Integer.parseInt(XML14Util.getTextContent(child));
                invitation.createdByDisplayName = ServerConfig.isTechnicianID(invitation.createdByID) ? ((user = ServerConfig.get().getTechnicianByID(invitation.createdByID)) != null ? user.displayName : "") : ((group = ServerConfig.get().getGroupByID(invitation.createdByID)) != null ? group.getName() : "");
            }
            if ((child = XML14Util.getChildByName(root, "CreationTime")) != null) {
                invitation.creationTime = Long.parseLong(XML14Util.getTextContent(child));
            }
            if ((child = XML14Util.getChildByName(root, "DurationLimit")) != null) {
                invitation.durationLimit = Long.parseLong(XML14Util.getTextContent(child));
            }
            if ((child = XML14Util.getChildByName(root, "SessionLimit")) != null) {
                invitation.sessionLimit = Integer.parseInt(XML14Util.getTextContent(child));
            }
            if ((child = XML14Util.getChildByName(root, "TechnicianFilter")) != null) {
                invitation.technicianFilter = XML14Util.getTextContent(child);
            }
            if ((child = XML14Util.getChildByName(root, "TechnicianGroupFilter")) != null) {
                invitation.technicianGroupFilter = XML14Util.getTextContent(child);
            }
            invitation.shareOption = (child = XML14Util.getChildByName(root, "ShareOption")) != null ? XML14Util.getTextContent(child) : "All";
            ArrayList<Element> detailElements = XML14Util.getChildren(root, "Detail");
            for (int i = 0; i < detailElements.size(); ++i) {
                Element detailElement = detailElements.get(i);
                String label = "";
                String value = "";
                child = XML14Util.getChildByName(detailElement, "Label");
                if (child != null) {
                    label = XML14Util.getTextContent(child);
                }
                if ((child = XML14Util.getChildByName(detailElement, "Value")) != null) {
                    value = XML14Util.getTextContent(child);
                }
                invitation.addCustomerDetail(label, value);
            }
            return invitation;
        }
        catch (Throwable t) {
            IOException ex = new IOException();
            ex.initCause(t);
            throw ex;
        }
    }

    class ExpiredInvitationException
    extends Exception {
        ExpiredInvitationException() {
        }
    }
}

