/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.shelp.common.PC;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import utils.encryption.aes.RijndaelDecryptionStream;
import utils.encryption.aes.RijndaelEncryptionStream;
import utils.files.AtomicFileOutputStream;
import utils.files.FileUtil;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.progtools.SaverUtil;
import utils.stream.StreamUtils;

public abstract class GenericRegistry<T extends RegistryItem>
implements SaverUtil.SaveListener {
    private File registryDirectory;
    private File registryFile;
    private final Object save_LOCK;
    protected final Object map_LOCK;
    protected HashMap<String, T> all;
    private SaverUtil saver;
    private String registryName;
    private String encryptionKey;
    private static RegistryReloader registryReloader = null;
    private static final Object LOCK = new Object();

    public abstract boolean debugLogging();

    public abstract T fromMessage(Message var1);

    protected abstract boolean supportAutoReload();

    protected void debug_dumpToStdout() {
        for (String key : this.all.keySet()) {
            System.out.println("Key: " + key);
            System.out.println(this.all.get(key));
            System.out.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericRegistry(String registryName, File registryFile, String encryptionKey) {
        block8: {
            this.save_LOCK = new Object();
            this.map_LOCK = new Object();
            this.all = new HashMap();
            this.encryptionKey = encryptionKey;
            this.registryName = registryName;
            this.registryFile = registryFile;
            this.registryDirectory = registryFile.getParentFile();
            if (!this.registryDirectory.exists()) {
                this.registryDirectory.mkdirs();
            }
            this.init();
            if (registryFile.exists()) {
                this.loadAllFromDisk();
            }
            this.saver = new SaverUtil(registryName, 10000, this, true);
            try {
                if (!this.supportAutoReload()) break block8;
                Object object = LOCK;
                synchronized (object) {
                    if (registryReloader == null) {
                        registryReloader = new RegistryReloader();
                        registryReloader.start();
                    }
                    registryReloader.registryRegistry(this);
                    registryReloader.updateLastModified(this);
                }
            }
            catch (Throwable t) {
                System.out.println("[GenericRegistry] Unable to start auto reload thread.");
                t.printStackTrace();
            }
        }
    }

    protected void init() {
    }

    @Override
    public void performSave() {
        this.saveAllToDisk();
    }

    public Object getMapLOCK() {
        return this.map_LOCK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAll() {
        Object object = this.map_LOCK;
        synchronized (object) {
            this.all.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(T item) {
        Object object = this.map_LOCK;
        synchronized (object) {
            if (this.debugLogging()) {
                System.out.println("[" + this.registryName + "] Removing " + item);
            }
            this.all.remove(item.getID());
            this.saver.queueSave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(T item) {
        Object object = this.map_LOCK;
        synchronized (object) {
            if (this.debugLogging()) {
                System.out.println("[" + this.registryName + "] Updating " + item);
            }
            this.all.put(item.getID(), item);
            this.saver.queueSave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T item) {
        Object object = this.map_LOCK;
        synchronized (object) {
            if (this.debugLogging()) {
                System.out.println("[" + this.registryName + "] Adding " + item);
            }
            this.all.put(item.getID(), item);
            this.saver.queueSave();
        }
    }

    protected void requestSave() {
        this.saver.queueSave();
    }

    protected void saveNow() {
        this.saver.saveNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(String id) {
        Object object = this.map_LOCK;
        synchronized (object) {
            return (T)((RegistryItem)this.all.get(id));
        }
    }

    public int size() {
        return this.all.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAllToDisk() {
        long C;
        long B;
        long A;
        HashMap<String, T> cloned;
        long T = System.currentTimeMillis();
        Object object = this.map_LOCK;
        synchronized (object) {
            if (this.all == null) {
                return;
            }
            cloned = new HashMap<String, T>(this.all);
        }
        Object object2 = this.save_LOCK;
        synchronized (object2) {
            ArrayList<String> keys = new ArrayList<String>(cloned.keySet());
            A = System.currentTimeMillis() - T;
            B = -1L;
            C = -1L;
            try {
                if (!this.registryDirectory.exists()) {
                    this.registryDirectory.mkdirs();
                }
                FilterOutputStream fout = this.encryptionKey != null ? new RijndaelEncryptionStream((OutputStream)new BufferedOutputStream(new AtomicFileOutputStream(this.registryFile)), this.encryptionKey) : new BufferedOutputStream(new AtomicFileOutputStream(this.registryFile));
                B = System.currentTimeMillis() - T;
                try {
                    Message emptyMessage = new Message(-1);
                    StreamUtils.writeInt(fout, cloned.size());
                    for (String id : keys) {
                        RegistryItem itemToSave = (RegistryItem)cloned.get(id);
                        if (itemToSave != null) {
                            Message m = itemToSave.toMessage();
                            if (this.debugLogging()) {
                                System.out.println("[" + this.registryName + "] Saving: \n" + m.toPretty(PC.REFS));
                            }
                            MessageUtils.writeMessageNoFlush(fout, m);
                            continue;
                        }
                        MessageUtils.writeMessageNoFlush(fout, emptyMessage);
                    }
                }
                finally {
                    FileUtil.robustClose(fout);
                }
            }
            catch (IOException ex) {
                System.out.println("[" + this.registryName + "] WARNING: Unable to save database to file.");
                ex.printStackTrace();
                return;
            }
            C = System.currentTimeMillis() - T;
            if (this.supportAutoReload()) {
                registryReloader.updateLastModified(this);
            }
        }
        System.out.println("[" + this.registryName + "] Saved " + A + "ms, " + B + "ms, " + C + "ms");
    }

    protected String getAlternativeEncryptionKey() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllFromDisk() {
        Object object = this.map_LOCK;
        synchronized (object) {
            if (this.all == null) {
                this.all = new HashMap();
            } else {
                this.clearAll();
            }
            if (this.registryDirectory.exists() && this.registryFile.exists()) {
                try {
                    long start = System.currentTimeMillis();
                    AtomicFileOutputStream.prepareForReading(this.registryFile);
                    FilterInputStream fin = this.encryptionKey != null ? new RijndaelDecryptionStream((InputStream)new BufferedInputStream(new FileInputStream(this.registryFile)), this.encryptionKey) : new BufferedInputStream(new FileInputStream(this.registryFile));
                    try {
                        int size = 0;
                        try {
                            size = StreamUtils.readInt(fin);
                        }
                        catch (IOException ex) {
                            if (!ex.getMessage().equals("Encrypted data integrity check failed")) {
                                throw ex;
                            }
                            String alternativeKey = this.getAlternativeEncryptionKey();
                            if (alternativeKey != null) {
                                this.encryptionKey = alternativeKey;
                                FileUtil.robustClose(fin);
                                fin = this.encryptionKey != null ? new RijndaelDecryptionStream((InputStream)new BufferedInputStream(new FileInputStream(this.registryFile)), this.encryptionKey) : new BufferedInputStream(new FileInputStream(this.registryFile));
                                size = StreamUtils.readInt(fin);
                            }
                            throw ex;
                        }
                        for (int i = 0; i < size; ++i) {
                            Message m = MessageUtils.readMessage(fin);
                            if (m == null || m.length() <= 0) continue;
                            try {
                                T rc = this.fromMessage(m);
                                if (this.debugLogging()) {
                                    System.out.println("[" + this.registryName + "] Loaded: \n" + m.toPretty(PC.REFS));
                                }
                                this.all.put(rc.getID(), rc);
                                this.loaded(rc);
                                continue;
                            }
                            catch (Exception x) {
                                x.printStackTrace();
                                System.out.println("[" + this.registryName + "] ***Warning, failed to load " + m);
                            }
                        }
                        System.out.println("[" + this.registryName + "] Loaded " + size + " items. Took " + (System.currentTimeMillis() - start) + "ms");
                    }
                    finally {
                        FileUtil.robustClose(fin);
                    }
                }
                catch (IOException ex) {
                    System.out.println("[" + this.registryName + "] WARNING: Unable to process registry file, even though it exists (" + this.registryFile.getAbsolutePath() + ")");
                    ex.printStackTrace();
                }
            }
            if (registryReloader != null && this.supportAutoReload()) {
                registryReloader.updateLastModified(this);
            }
        }
        System.out.println("[" + this.registryName + "] " + this.all.size() + " items loaded.");
    }

    protected void loaded(T item) {
    }

    public void killSaverThread() {
        this.saver.terminate();
    }

    public void saveImmediately() {
        this.saver.saveNow();
    }

    public static interface RegistryItem {
        public String getID();

        public Message toMessage();
    }

    private static class RegistryReloader
    extends Thread {
        private ArrayList<GenericRegistry> registries = new ArrayList();
        private HashMap<String, Long> registryFileNameToLastModified = new HashMap();

        public RegistryReloader() {
            super("RegistryReloader");
        }

        public void registryRegistry(GenericRegistry g) {
            this.registries.add(g);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block5: while (true) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Iterator<GenericRegistry> iterator = this.registries.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block5;
                    GenericRegistry registry = iterator.next();
                    Object object = registry.save_LOCK;
                    synchronized (object) {
                        boolean reload;
                        Long rememberedLastModified = this.registryFileNameToLastModified.get(registry.registryFile.getPath());
                        if (rememberedLastModified != null) {
                            long currentLastModified = registry.registryFile.lastModified();
                            reload = registry.registryFile.exists() && currentLastModified != rememberedLastModified;
                        } else {
                            reload = registry.registryFile.exists();
                        }
                        if (reload) {
                            System.out.println("[GenericRegistry] Registry " + registry.registryName + " has changed. Reloading...");
                            registry.loadAllFromDisk();
                        }
                    }
                }
                break;
            }
        }

        public void updateLastModified(GenericRegistry registry) {
            if (registry.registryFile.exists()) {
                this.registryFileNameToLastModified.put(registry.registryFile.getPath(), registry.registryFile.lastModified());
            }
        }
    }
}

