/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.CentralDebugging;
import com.aem.gstore.MachinesProcessor;
import com.aem.gstore.StorePacket;
import com.aem.sgateway.SimpleGatewayID;
import com.aem.shelp.proxy.ProxyServer;
import com.aem.shelp.proxy.types.MachineInfo;
import utils.message.Message;
import utils.message.MessageUtils;

public class GenStoreProcessor
implements MachinesProcessor {
    ProxyServer proxyServer;

    public GenStoreProcessor(ProxyServer px) {
        this.proxyServer = px;
    }

    @Override
    public void processStorePacket(StorePacket packet, Long longID) {
        String machineID = SimpleGatewayID.getID(longID);
        MachineInfo info = ProxyServer.INSTANCE.getMachineDB().getInfoFor(machineID);
        if (CentralDebugging.PX_GENSTORE_UPLOAD) {
            System.out.println("[GenStore] StorePacket from " + info.getMachineName().getName() + " / " + machineID + " - " + packet);
        }
        Message msg = MessageUtils.bytesToMessage(packet.getData());
        if (CentralDebugging.PX_GENSTORE_UPLOAD) {
            System.out.println("[GenStore] Message from " + info.getMachineName().getName() + " / " + machineID + " - " + msg);
        }
        System.out.println("[GenStore] " + info.getMachineName().getName() + " says " + msg);
    }
}

