/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import bcutil.BCUtil;
import com.aem.CentralDebugging;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.proxy.CustomerConnect;
import com.aem.shelp.proxy.ProxyServer;
import com.aem.shelp.proxy.ServerStats;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.logging.support.CustJoinQueue;
import com.aem.shelp.proxy.logging.support.CustJoinTechniciansQueue;
import com.aem.shelp.proxy.logging.support.CustLeaveQueue;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.util.ElapsedTimeFormatter;
import com.aem.shelp.util.PropertiesToMessage;
import com.aem.utils.Debugger;
import com.aem.utils.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Random;
import utils.loggingframework.LoggingFramework;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.switches.Switches;

public class CustomerRegistry {
    private final Object LOCK = new Object();
    private HashMap<String, CustomerThread> id_to_c = new HashMap();
    private LinkedList<CustomerThread> customers = new LinkedList();
    private static Random rand = new Random(System.currentTimeMillis());
    private static long nID = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void customerWaiting(Customer customer, NodeLink sock, BCUtil bcu) throws IOException {
        long expiry = -1L;
        if (customer.getCustomerID() == null || customer.getCustomerID().length() == 0) {
            customer.setCustomerID(Math.abs(rand.nextLong()) + "" + nID);
            ++nID;
        } else {
            expiry = System.currentTimeMillis() + 600000L;
        }
        CustomerThread c = new CustomerThread(customer, System.currentTimeMillis(), sock);
        c.setQueueExpiry(expiry);
        c.setBCUtil(bcu);
        Object object = this.LOCK;
        synchronized (object) {
            String id = customer.getCustomerID();
            this.id_to_c.put(id, c);
            this.customers.add(c);
            Debugger.info("Customer " + c + " added to waiting queue");
            if (customer.isSH()) {
                TechUser[] technicians;
                CustJoinQueue newEvent = CustJoinQueue.createEvent(customer);
                LoggingFramework.INSTANCE.logEvent(newEvent);
                ServerStats.INSTANCE.customerLogin();
                for (TechUser user : technicians = ServerConfig.get().technicians) {
                    if (!user.canTechUserSeeCustomerFromAnyGroup(customer)) continue;
                    CustJoinTechniciansQueue newTechEvent = CustJoinTechniciansQueue.createEvent(customer, user);
                    LoggingFramework.INSTANCE.logEvent(newTechEvent);
                }
            }
            ServerStats.INSTANCE.waitingIncrease(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getConnectedTime(Customer customer) {
        Object object = this.LOCK;
        synchronized (object) {
            CustomerThread c = this.id_to_c.get(customer.getCustomerID());
            return c.connected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Customer getCustomerInfo(String customerID) {
        Object object = this.LOCK;
        synchronized (object) {
            if (customerID == null) {
                return null;
            }
            CustomerThread c = this.id_to_c.get(customerID);
            if (c == null && CentralDebugging.PX_VERBOSE_CUSTOMERLIST_ON_NOT_FOUND) {
                for (String key : this.id_to_c.keySet()) {
                    System.out.println("Customer: " + key + " = " + this.id_to_c.get(key));
                }
            }
            if (c == null) {
                return null;
            }
            return c.customer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String customerID) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.id_to_c.containsKey(customerID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(Customer customer) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.id_to_c.containsKey(customer.getCustomerID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomerConnect getConnectionAndRemove(Customer customer) {
        CustomerThread c;
        String id;
        Object object = this.LOCK;
        synchronized (object) {
            id = customer.getCustomerID();
            c = this.id_to_c.remove(id);
            this.customers.remove(c);
        }
        ServerStats.INSTANCE.waitingDecrease(id);
        if (!c.stopPingingAndJoin()) {
            return null;
        }
        c.clog.joined = true;
        c.sock.removeLinkStatusListener(c.clog);
        return new CustomerConnect(c.sock, c.bcu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAndClose(String id) {
        Object object = this.LOCK;
        synchronized (object) {
            CustomerThread c = this.id_to_c.remove(id);
            this.customers.remove(c);
            try {
                c.sock.stop("customer registry removing customer " + id);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ServerStats.INSTANCE.waitingDecrease(id);
    }

    public void removeAndClose(Customer customer) {
        this.removeAndClose(customer.getCustomerID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAndClose(CustomerThread c) {
        String id;
        Object object = this.LOCK;
        synchronized (object) {
            id = c.customer.getCustomerID();
            this.id_to_c.remove(id);
            this.customers.remove(c);
            try {
                c.sock.stop("customer registry removing " + id);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ServerStats.INSTANCE.waitingDecrease(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Customer[] getCustomerListAdvanced(TechUser technician) {
        Object object = this.LOCK;
        synchronized (object) {
            ArrayList<Customer> result = new ArrayList<Customer>();
            try {
                for (int i = 0; i < this.customers.size(); ++i) {
                    CustomerThread cust = this.customers.get(i);
                    try {
                        if (!cust.sock.isAlive()) {
                            throw new IOException("socket not connected");
                        }
                        if (cust.hasExpired()) {
                            throw new IOException("expired from queue (SG)");
                        }
                        if (cust.isSgMachineWaiting() || !technician.canTechUserSeeCustomerFromAnyGroup(cust.customer)) continue;
                        result.add(cust.customer);
                        continue;
                    }
                    catch (IOException e) {
                        System.out.println("Removing from queue: " + e);
                        try {
                            this.removeAndClose(cust);
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                        --i;
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result.toArray(new Customer[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFirstCustomerMatchingFilter(String filter) {
        Object object = this.LOCK;
        synchronized (object) {
            for (CustomerThread customerThread : this.customers) {
                if (!customerThread.customer.matchesFilter(filter.toLowerCase())) continue;
                return customerThread.customer.getCustomerID();
            }
        }
        return null;
    }

    class CustomerThread
    extends Thread {
        CustomerQuitLog clog;
        private final Object ready_LOCK;
        boolean ready_now;
        boolean ready_ok;
        String ip;
        long connected;
        NodeLink sock;
        boolean stop;
        InputStream in;
        OutputStream out;
        long expiryDate;
        private Customer customer;
        BCUtil bcu;

        public void setQueueExpiry(long time) {
            this.expiryDate = time;
        }

        public void setBCUtil(BCUtil bcu) {
            this.bcu = bcu;
        }

        public boolean isSgMachineWaiting() {
            return this.expiryDate != -1L;
        }

        public boolean hasExpired() {
            if (this.expiryDate == -1L) {
                return false;
            }
            return System.currentTimeMillis() > this.expiryDate;
        }

        public CustomerThread(Customer customer, long connected, NodeLink sock) throws IOException {
            super("CustomerThread");
            this.ready_LOCK = new Object();
            this.ready_now = false;
            this.ready_ok = false;
            this.stop = false;
            this.customer = customer;
            this.ip = "" + sock.hashCode();
            this.connected = connected;
            this.sock = sock;
            this.in = sock.getInputStream();
            this.out = sock.getOutputStream();
            this.clog = new CustomerQuitLog(customer);
            sock.addLinkStatusListener(this.clog);
            this.start();
        }

        @Override
        public String toString() {
            return this.customer.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean stopPingingAndJoin() {
            Debugger.info("Preparing to join customer " + this.customer);
            this.stop = true;
            long timeout = System.currentTimeMillis() + 20000L;
            while (true) {
                Object object = this.ready_LOCK;
                synchronized (object) {
                    if (this.ready_now) {
                        if (!this.ready_ok) {
                            return false;
                        }
                        break;
                    }
                }
                if (System.currentTimeMillis() > timeout) {
                    return false;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {}
            }
            Debugger.info("Joined customer " + this.customer);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long nextTest = SafeClock.currentTimeMillis();
                long quitAt = Switches.SH_1468_liveTestsQuitAfterNlErrorTimeout ? SafeClock.currentTimeMillis() + (long)NodeLink.DEFAULT_ERROR_TIMEOUT : Long.MAX_VALUE;
                while (!this.stop) {
                    if (SafeClock.currentTimeMillis() > nextTest) {
                        StreamUtils.writeLong(this.out, 158865753896782215L);
                        this.out.flush();
                        long N = StreamUtils.readLong(this.in);
                        if (N != 158865753896782215L) {
                            Debugger.error("CUSTOMER SOCKET IS OUT OF SYNC! (expected LIVE_TEST) " + Long.toHexString(N));
                            throw new IOException("CUSTOMER SOCKET IS OUT OF SYNC! (expected LIVE_TEST) " + Long.toHexString(N));
                        }
                        nextTest = SafeClock.currentTimeMillis() + 1000L;
                    }
                    if (Switches.SH_1468_liveTestsQuitAfterNlErrorTimeout && this.customer != null && !this.customer.isSH()) {
                        if (Switches.SH_1468_debugging) {
                            System.out.println("[CustomerRegistry] RA/Demo session " + this.customer + " (" + this.sock + ") is waiting for a client to connect");
                        }
                        if (SafeClock.currentTimeMillis() > quitAt) {
                            System.out.println("[CustomerRegistry] RA/Demo session " + this.customer + " (" + this.sock + ") was never joined by client, quitting connection");
                            try {
                                this.sock.stop("closing ra/demo session " + this.customer + " never joined by client");
                            }
                            catch (Exception x) {
                                x.printStackTrace();
                            }
                            return;
                        }
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception x) {}
                }
                StreamUtils.writeLong(this.out, 825885312420231L);
                this.out.flush();
                long N = StreamUtils.readLong(this.in);
                if (N != 825885312420231L) {
                    Debugger.error("CUSTOMER SOCKET IS OUT OF SYNC! (expected LIVE_TESTS_DONE) " + Long.toHexString(N));
                    throw new IOException("CUSTOMER SOCKET IS OUT OF SYNC! (expected LIVE_TESTS_DONE) " + Long.toHexString(N));
                }
                Debugger.info("Writing centralised switches");
                Properties unencryptedDebugProps = new Properties();
                CentralDebugging.saveCentralisedSwitchesToProperties(unencryptedDebugProps);
                Message cdbgProps = PropertiesToMessage.toMessage(unencryptedDebugProps);
                MessageUtils.writeMessage(this.out, cdbgProps);
                this.out.flush();
                Debugger.info("Customer socket ready for connecting");
                Object object = this.ready_LOCK;
                synchronized (object) {
                    this.ready_ok = true;
                    this.ready_now = true;
                }
            }
            catch (IOException e) {
                Debugger.info("Removing customer " + this.customer + ": " + e);
                try {
                    CustomerRegistry.this.removeAndClose(this.customer);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Object object = this.ready_LOCK;
                synchronized (object) {
                    this.ready_ok = false;
                    this.ready_now = true;
                }
                ProxyServer.INSTANCE.notifyCustomerListChanged();
            }
            catch (Throwable t) {
                Debugger.error("Error joining customer " + this.customer + ": " + t);
                try {
                    CustomerRegistry.this.removeAndClose(this.customer);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Object object = this.ready_LOCK;
                synchronized (object) {
                    this.ready_ok = false;
                    this.ready_now = true;
                }
                ProxyServer.INSTANCE.notifyCustomerListChanged();
            }
        }
    }

    static class CustomerQuitLog
    implements NodeLinkStatusListener {
        long since;
        public boolean joined = false;
        Customer customer;

        public CustomerQuitLog(Customer customer) {
            this.customer = customer;
            this.since = System.currentTimeMillis();
        }

        @Override
        public void linkDead(NodeLink link, String reason) {
            if (!this.joined && this.customer.isSH()) {
                long timeWaiting = System.currentTimeMillis() - this.since;
                String timeWaitingFormatted = new ElapsedTimeFormatter().getCompleteFormattedTime(timeWaiting);
                CustLeaveQueue newEvent = CustLeaveQueue.createEvent(this.customer, timeWaiting, timeWaitingFormatted);
                LoggingFramework.INSTANCE.logEvent(newEvent);
                ServerStats.INSTANCE.customerLogout();
            }
        }

        @Override
        public void linkDown(NodeLink link, Throwable reason) {
        }

        @Override
        public void linkOK(NodeLink link) {
        }
    }
}

