/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import bcutil.BCUtil;
import com.aem.CentralDebugging;
import com.aem.nodelink.NodeLink;
import com.aem.shelp.common.PC;
import com.aem.shelp.proxy.ProxyServer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import utils.files.FileUtil;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.progtools.BestCaseCompressor;
import utils.udp.bidirectional.UDPResponder;

public class BigPipeHandler
extends Thread
implements PC,
UDPResponder {
    NodeLink sock;
    BCUtil bcu;
    Object out_LOCK = new Object();
    boolean die = false;

    public BigPipeHandler(NodeLink sock, BCUtil bcu) {
        this.sock = sock;
        this.bcu = bcu;
        this.start();
    }

    public boolean isOperational() {
        return this.sock.isAlive();
    }

    @Override
    public String toString() {
        try {
            return "Aux:" + this.sock.getHumanReadableTransportSpecificRemoteIdentifier();
        }
        catch (Exception x) {
            return "Aux:Unknown";
        }
    }

    public void shutdown(String reason) {
        this.die = true;
        try {
            System.out.println("[Clustering] Shutting down connection to " + this.toString() + " - " + reason);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.sock.stop("Shutting down BigPipe, " + reason);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagateConfig(String path, File file) throws IOException {
        if (file.isDirectory()) {
            File[] list;
            for (File child : list = file.listFiles()) {
                this.propagateConfig(path + File.separator + child.getName(), child);
            }
        } else {
            Message m = new Message(150005);
            byte[] dat = FileUtil.readFile(file);
            dat = BestCaseCompressor.compress(dat);
            m.append(path);
            m.append(dat);
            Object object = this.out_LOCK;
            synchronized (object) {
                OutputStream out = this.sock.getOutputStream();
                MessageUtils.writeMessage(out, m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyConfigReady() throws IOException {
        Message m = new Message(150007);
        Object object = this.out_LOCK;
        synchronized (object) {
            OutputStream out = this.sock.getOutputStream();
            MessageUtils.writeMessage(out, m);
        }
    }

    @Override
    public String getSocketInfo() {
        return "" + this.sock;
    }

    @Override
    public void run() {
        InputStream in = this.sock.getInputStream();
        System.out.println("[Clustering] Auxiliary connection ready for " + this.sock);
        try {
            while (!this.die) {
                Message m = MessageUtils.readMessage(in);
                this.handle(m);
            }
        }
        catch (IOException x) {
            System.out.println("[Clustering] Auxiliary connection finished for " + this.sock);
            x.printStackTrace();
        }
        finally {
            try {
                this.sock.stop("bigpipe aux connection finished");
            }
            catch (Exception exception) {}
        }
    }

    public void handle(Message m) {
        int type;
        if (CentralDebugging.CLUSTERING_MESSAGES) {
            System.out.println("[Clustering] Incoming BigPipe message from " + this.sock + " - " + m);
        }
        if ((type = m.getType()) == 150001) {
            String machineID = m.getNextString();
            Message msg = m.getNextMessage();
            if (CentralDebugging.CLUSTERING_MESSAGES) {
                System.out.println("[Clustering] Forwarding lossy message to ProxyServer");
            }
            ProxyServer.INSTANCE.lossyclient.lossyMessageReceived(ProxyServer.INSTANCE.getLossyTransportFor(machineID), msg, null);
        } else if (type == 150002) {
            String machineID = m.getNextString();
            Message msg = m.getNextMessage();
            String remoteSocketIPAddress = m.getNextString();
            if (CentralDebugging.CLUSTERING_MESSAGES) {
                System.out.println("[Clustering] Passing ping message to ProxyServer");
            }
            ProxyServer.INSTANCE.handleMessage(msg, (Object)machineID, (UDPResponder)this, remoteSocketIPAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendActivity(String ac, Object uid) throws IOException {
        if (CentralDebugging.CLUSTERING_MESSAGES) {
            System.out.println("[Clustering] Asked to send activity via BPC to " + uid);
        }
        Message m = new Message(150003);
        m.append((String)uid);
        m.append(ac);
        Object object = this.out_LOCK;
        synchronized (object) {
            OutputStream out = this.sock.getOutputStream();
            MessageUtils.writeMessage(out, m);
        }
        if (CentralDebugging.CLUSTERING_MESSAGES) {
            System.out.println("[Clustering] Sent message via BPC to " + uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(byte[] dat, Object uid) throws IOException {
        if (CentralDebugging.CLUSTERING_MESSAGES) {
            System.out.println("[Clustering] Asked to send lossy message via BPC to " + uid);
        }
        Message m = new Message(150004);
        m.append((String)uid);
        m.append(dat);
        Object object = this.out_LOCK;
        synchronized (object) {
            OutputStream out = this.sock.getOutputStream();
            MessageUtils.writeMessage(out, m);
        }
        if (CentralDebugging.CLUSTERING_MESSAGES) {
            System.out.println("[Clustering] Sent message via BPC to " + uid);
        }
    }

    @Override
    public void send(byte[] dat, int offset, int len, Object uid) throws IOException {
        throw new RuntimeException("BigPipeHandler invalid");
    }

    @Override
    public void sendUnwrapped(byte[] dat, int offset, int len, Object uid) throws IOException {
        throw new RuntimeException("BigPipeHandler invalid");
    }

    @Override
    public String getHostFor(Object uid) {
        throw new RuntimeException("BigPipeHandler invalid");
    }

    @Override
    public int getPortFor(Object uid) {
        throw new RuntimeException("BigPipeHandler invalid");
    }
}

