/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import bcutil.BCUtil;
import bcutil.SingleStringKeyHashProvider;
import com.aem.BuildDateUtil;
import com.aem.CentralDebugging;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.common.PC;
import com.aem.shelp.proxy.LicenseConfig;
import com.aem.shelp.proxy.ProxyServer;
import com.aem.shelp.proxy.config.LazyPassword;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.util.BCUtilMessenger;
import com.aem.shelp.util.SHelpNodelinkConnector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import utils.files.FileUtil;
import utils.files.PathUtil;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.progtools.BestCaseCompressor;
import utils.progtools.resume.TccStopException;
import utils.stream.StreamUtils;

public class BigPipeClient
implements NodeLinkStatusListener,
PC {
    private NodeLink sock;
    String host;
    String pubkeyHash;
    LazyPassword adminPass;
    int port;
    boolean haveConfig = false;
    boolean online = true;
    BigPipeReader bpr = new BigPipeReader();
    Object out_LOCK = new Object();
    OutputStream out;
    private static final Object bigpipe_LOCK = new Object();
    private static BigPipeClient bigpipe;
    private static final long BPC_RECONNECT_FREQ = 10000L;
    private static long lastBpcAttempt;

    public BigPipeClient(String host, int port) throws IOException, TechClient.WrongPasswordException, Exception {
        this.host = host;
        this.port = port;
        AsymmetricCipherKeyPair rsakeys = ProxyServer.loadRsaKeys();
        this.pubkeyHash = BCUtil.getHashOfRsaPublicKey(rsakeys);
        this.adminPass = ServerConfig.get().serverPassword;
        this.connect();
    }

    public boolean haveConfig() {
        return this.haveConfig;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void shutdown() {
        this.online = false;
    }

    private void connect() throws IOException, TechClient.WrongPasswordException, Exception {
        this.sock = SHelpNodelinkConnector.getConnection(this.host, this.port, this);
        StreamUtils.writeLong(this.sock.getOutputStream(), BuildDateUtil.getBigPipeMagicBuildDate());
        this.sock.getOutputStream().flush();
        InputStream in = this.sock.getInputStream();
        try {
            long remoteMagic = StreamUtils.readLong(in);
            if (BuildDateUtil.getBigPipeMagicBuildDate() != remoteMagic) {
                System.out.println(BuildDateUtil.getBigPipeMagicBuildDate() + " != " + remoteMagic);
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new IOException("Clustering - Central server does not appear to be a SimpleHelp server or is an incompatible version");
        }
        System.out.println("[Clustering] Central server protocol version OK, verifying server authenticity");
        BCUtil bcu = new BCUtil();
        bcu.setValidHashRequired(true);
        bcu.setClientRsaKeyPairHashNoRecovery(new SingleStringKeyHashProvider(this.pubkeyHash));
        bcu.handshake(this.sock.getInputStream(), this.sock.getOutputStream(), true, null);
        Message bplogin = new Message();
        bplogin.append(this.adminPass.getDecryptedPassword());
        BCUtilMessenger.writeMsg(bcu, this.sock.getOutputStream(), bplogin);
        this.sock.getOutputStream().flush();
        int success = StreamUtils.readInt(this.sock.getInputStream());
        if (success != 1) {
            throw new TechClient.WrongPasswordException("Clustering login failed - incorrect admin login password");
        }
        this.out = this.sock.getOutputStream();
        this.bpr.start();
        System.out.println("[Clustering] Waiting for updated config");
        while (!this.haveConfig) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        System.out.println("[Clustering] Updated config ready, loading");
    }

    @Override
    public void linkDown(NodeLink link, Throwable reason) {
        System.out.println("[Clustering] Connection to Central is DOWN: " + reason + " - " + link);
    }

    @Override
    public void linkOK(NodeLink link) {
        System.out.println("[BigPipe] Connection to Central is OK - " + link);
    }

    @Override
    public void linkDead(NodeLink link, String reason) {
        System.out.println("[Clustering] Connection to Central is DEAD: " + reason + " - " + link);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBPMessage(Message m) {
        Object object = this.out_LOCK;
        synchronized (object) {
            try {
                if (CentralDebugging.CLUSTERING_MESSAGES) {
                    System.out.println("[Clustering] BigPipe sending message to BPH");
                }
                MessageUtils.writeMessage(this.out, m);
                this.out.flush();
                if (CentralDebugging.CLUSTERING_MESSAGES) {
                    System.out.println("[Clustering] BigPipe sent message to BPH OK");
                }
            }
            catch (Exception x) {
                System.out.println("[BigPipe] Connection to Primary failed - unable to write message: " + x);
                this.online = false;
            }
        }
    }

    public void sendServicePing(Message msg, String remoteSrcIpAddress, String machineID) throws TccStopException {
        if (CentralDebugging.CLUSTERING_MESSAGES) {
            System.out.println("[Clustering] Asked to send service ping");
        }
        Message m = new Message(150002);
        m.append(machineID);
        m.append(msg);
        m.append(remoteSrcIpAddress);
        this.sendBPMessage(m);
    }

    public void sendLossyMessage(String id, Message msg) {
        if (CentralDebugging.CLUSTERING_MESSAGES) {
            System.out.println("[Clustering] Asked to send lossy message");
        }
        Message m = new Message(150001);
        m.append(id);
        m.append(msg);
        this.sendBPMessage(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigPipeClient getBigPipe(URL url) throws IOException, TechClient.WrongPasswordException, Exception {
        Object object = bigpipe_LOCK;
        synchronized (object) {
            if (bigpipe != null && !bigpipe.isOnline()) {
                System.out.println("[Clustering] Connection to Central server lost, will try to re-establish...");
                bigpipe = null;
            }
            if (bigpipe == null) {
                long T = SafeClock.currentTimeMillis();
                if (T - lastBpcAttempt < 10000L) {
                    return null;
                }
                lastBpcAttempt = T;
                System.out.println("[Clustering] Establishing new connection to Central server");
                System.out.println("[Clustering] Central server URL is [" + url + "]");
                String host = url.getHost();
                int port = url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
                System.out.println("[Clustering] Opening connection to Central server " + host + " " + port);
                if (LicenseConfig.get().getLicense() == null) {
                    LicenseConfig.readAllLicenses();
                }
                if (LicenseConfig.get().getLicense() == null) {
                    System.out.println("[BigPipeHandler] ERROR: BigPipe connection refused (license does not allow clustering)");
                    return null;
                }
                if (!LicenseConfig.get().getLicense().isVersion2Enterprise()) {
                    System.out.println("[BigPipeHandler] ERROR: BigPipe connection refused (license does not allow clustering)");
                    return null;
                }
                bigpipe = new BigPipeClient(host, port);
                System.out.println("[Clustering] Connection opened OK to Central server " + host + " " + port);
            }
        }
        return bigpipe;
    }

    static {
        lastBpcAttempt = 0L;
    }

    class BigPipeReader
    extends Thread {
        public BigPipeReader() {
            this.setName("BigPipeReader");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (BigPipeClient.this.online) {
                    byte[] dat;
                    String machineID;
                    InputStream in = BigPipeClient.this.sock.getInputStream();
                    Message m = MessageUtils.readMessage(in);
                    if (CentralDebugging.CLUSTERING_MESSAGES) {
                        System.out.println("[Clustering] Asked to deliver BigPipe lossy message");
                    }
                    if (m.getType() == 150004) {
                        if (CentralDebugging.CLUSTERING_MESSAGES) {
                            System.out.println("[Clustering] Asked to deliver BigPipe lossy message");
                        }
                        machineID = m.getNextString();
                        dat = m.getNextByteArray();
                        Message deliver = MessageUtils.bytesToMessage(dat);
                        if (CentralDebugging.CLUSTERING_MESSAGES) {
                            System.out.println("[BigPipe] Lossy response target is " + machineID + " = " + deliver);
                        }
                        ProxyServer.INSTANCE.getMachineRegistry().passMachineBigPipeMessage(machineID, deliver);
                        continue;
                    }
                    if (m.getType() == 150003) {
                        if (CentralDebugging.CLUSTERING_MESSAGES) {
                            System.out.println("[Clustering] Asked to deliver BigPipe activity request");
                        }
                        machineID = m.getNextString();
                        String activity = m.getNextString();
                        if (CentralDebugging.CLUSTERING_DETAILS) {
                            System.out.println("[Clustering] Activity target is " + machineID + " = " + activity);
                        }
                        ProxyServer.INSTANCE.getMachineRegistry().passMachineBigPipeActivity(machineID, activity);
                        continue;
                    }
                    if (m.getType() == 150005) {
                        String path = m.getNextString();
                        dat = m.getNextByteArray();
                        dat = BestCaseCompressor.decompress(dat);
                        try {
                            System.out.println("[Clustering] Central config update: writing " + dat.length + " to " + path);
                            path = PathUtil.makePathNative(path);
                            File parent = new File("configuration" + File.separator + path).getParentFile();
                            if (parent != null) {
                                parent.mkdirs();
                            }
                            if (path.equals("serverconfig.xml")) {
                                System.out.println("[Clustering] Merging serverconfig.xml with Central");
                                ServerConfig tmpconf = new ServerConfig();
                                tmpconf.loadConfig(new String(dat, "UTF8"));
                                ServerConfig myconfig = ServerConfig.get();
                                tmpconf.keystoreKeyPassword = myconfig.keystoreKeyPassword;
                                tmpconf.keystoreStorePassword = myconfig.keystoreStorePassword;
                                tmpconf.keystoreType = myconfig.keystoreType;
                                tmpconf.condenserForURL = myconfig.condenserForURL;
                                tmpconf.ipList = myconfig.ipList;
                                tmpconf.portList = myconfig.portList;
                                tmpconf.ipPortPairsList = myconfig.ipPortPairsList;
                                tmpconf.hostname = myconfig.hostname;
                                tmpconf.saveToDefaultFile();
                            } else {
                                FileUtil.writeFile("configuration" + File.separator + path, dat);
                                if (path.startsWith("profiles")) {
                                    System.out.println("[Clustering] Clearing app profile cache");
                                    if (ProxyServer.INSTANCE != null) {
                                        ProxyServer.INSTANCE.clearAppProfileCache();
                                    }
                                }
                            }
                            System.out.println("[Clustering] Wrote config OK");
                            continue;
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                            continue;
                        }
                    }
                    if (m.getType() == 150007) {
                        System.out.println("[Clustering] Central servers notified config ready");
                        BigPipeClient.this.haveConfig = true;
                        continue;
                    }
                    System.out.println("[Clustering] Unrecognised BPH request: " + m);
                }
            }
            catch (IOException x) {
                System.out.println("[Clustering] Connection to Central failed - BPC reader died - " + x);
                x.printStackTrace();
            }
            BigPipeClient.this.online = false;
        }
    }
}

