/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import utils.progtools.collections.FixedSizeMap;

public class AccessHandler {
    private final FixedSizeMap<String, AccessRequest> requestMap = new FixedSizeMap(10, 100);
    private final FixedSizeMap<String, AccessRequest> connectMap = new FixedSizeMap(10, 100);
    private final FixedSizeMap<String, Object> deniedMap = new FixedSizeMap(10, 100);
    private final FixedSizeMap<String, Object> cancelledMap = new FixedSizeMap(10, 100);
    private final FixedSizeMap<String, Object> waitingMap = new FixedSizeMap(10, 100);
    public static final AccessHandler INSTANCE = new AccessHandler();

    public static AccessRequest merge(AccessRequest technicianRequest, AccessRequest serviceRequest) {
        if (technicianRequest == null && serviceRequest == null) {
            return null;
        }
        if (technicianRequest == null) {
            return serviceRequest;
        }
        if (serviceRequest == null) {
            return technicianRequest;
        }
        technicianRequest.timeout = technicianRequest.timeout == 0L || serviceRequest.timeout == 0L ? 0L : Math.max(serviceRequest.timeout, technicianRequest.timeout);
        return technicianRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAccessDeniedForMachine(String machineID) {
        FixedSizeMap<String, Object> fixedSizeMap = this.deniedMap;
        synchronized (fixedSizeMap) {
            return this.deniedMap.remove(machineID) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRequestBeenCancelled(String customerID) {
        FixedSizeMap<String, Object> fixedSizeMap = this.cancelledMap;
        synchronized (fixedSizeMap) {
            return this.cancelledMap.remove(customerID) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRequest(String customerID) {
        FixedSizeMap<String, Object> fixedSizeMap = this.cancelledMap;
        synchronized (fixedSizeMap) {
            this.cancelledMap.put(customerID, new Object());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void denyAccessForMachine(String machineID) {
        FixedSizeMap<String, Object> fixedSizeMap = this.deniedMap;
        synchronized (fixedSizeMap) {
            this.deniedMap.put(machineID, new Object());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessRequest didATechnicianRequestAccess(String machineID) {
        FixedSizeMap<String, AccessRequest> fixedSizeMap = this.requestMap;
        synchronized (fixedSizeMap) {
            return (AccessRequest)this.requestMap.remove(machineID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessRequest didATechnicianRequestConnection(String machineID) {
        FixedSizeMap<String, AccessRequest> fixedSizeMap = this.connectMap;
        synchronized (fixedSizeMap) {
            return (AccessRequest)this.connectMap.remove(machineID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestAccessForMachine(String machineID, String technicianDisplayName, long timeout) {
        FixedSizeMap<String, AccessRequest> fixedSizeMap = this.requestMap;
        synchronized (fixedSizeMap) {
            AccessRequest wrapper = new AccessRequest();
            wrapper.id = machineID;
            wrapper.technicianDisplayName = technicianDisplayName;
            wrapper.timeout = timeout;
            this.requestMap.put(machineID, wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestConnectionsForMachine(String machineID, String technicianDisplayName, long timeout) {
        FixedSizeMap<String, AccessRequest> fixedSizeMap = this.connectMap;
        synchronized (fixedSizeMap) {
            AccessRequest wrapper = new AccessRequest();
            wrapper.id = machineID;
            wrapper.technicianDisplayName = technicianDisplayName;
            wrapper.timeout = timeout;
            this.connectMap.put(machineID, wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWaitingForRemoteUser(String id) {
        FixedSizeMap<String, Object> fixedSizeMap = this.waitingMap;
        synchronized (fixedSizeMap) {
            this.waitingMap.put(id, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWaitingForRemoteUser(String id) {
        FixedSizeMap<String, Object> fixedSizeMap = this.waitingMap;
        synchronized (fixedSizeMap) {
            return this.waitingMap.remove(id) != null;
        }
    }

    public static class AccessRequest {
        String id;
        String technicianDisplayName;
        long timeout;
    }
}

