/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.mdupload.transports;

import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.mdupload.LossyClient;
import com.aem.shelp.mdupload.LossyTransport;
import com.aem.shelp.mdupload.MessageTooLargeException;
import com.aem.shelp.mdupload.transports.UdpResponderLossyTransport;
import java.io.IOException;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.udp.bidirectional.UDPClient;
import utils.udp.bidirectional.UDPListener;
import utils.udp.bidirectional.UDPResponder;

public class UdpClientLossyTransport
implements LossyTransport,
UDPListener {
    LossyClient lossy;
    UDPClient udp;
    boolean handleIncoming = true;
    long lastGoodResponse = SafeClock.currentTimeMillis();
    Object LOCK = new Object();
    long lastPrintout = 0L;
    Object largeSendLOCK = new Object();

    public void resetNonResponseCounter() {
        this.lastGoodResponse = SafeClock.currentTimeMillis();
    }

    public void incrementNonResponseCounter() {
        if (SafeClock.currentTimeMillis() - this.lastGoodResponse > 180000L) {
            System.out.println("[UdpClient] Switching UDP sockets");
            this.lastGoodResponse = SafeClock.currentTimeMillis();
            this.switchUdpSocket();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchUdpSocket() {
        Object object = this.LOCK;
        synchronized (object) {
            this.udp.switchUdpSocket();
        }
    }

    public UdpClientLossyTransport(LossyClient client) {
        this.lossy = client;
    }

    public UdpClientLossyTransport(LossyClient client, int localport, String remotehost, int remoteport) throws IOException {
        this.lossy = client;
        this.handleIncoming = true;
        this.udp = new UDPClient(remotehost, remoteport, this, localport);
    }

    public void init(UDPClient client) {
        this.udp = client;
    }

    @Override
    public boolean providesGuaranteedDelivery() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(LossyClient lsclient, Message message) throws MessageTooLargeException {
        block11: {
            try {
                Message wrap = new Message(3001000);
                wrap.append(message);
                byte[] tosend = MessageUtils.messageToBytes(wrap);
                if (!(tosend.length <= 512 || Message.INCLUDE_CREATION_STACKS && message.getType() == LossyClient.LOSSY_GUARANTEED_MESSAGE_PART_X || message.getType() == LossyClient.LOSSY_GUARANTEED_MESSAGE_PART_X)) {
                    throw new MessageTooLargeException(tosend.length);
                }
                Object object = this.LOCK;
                synchronized (object) {
                    this.udp.send(tosend);
                }
            }
            catch (MessageTooLargeException x) {
                throw x;
            }
            catch (IOException x) {
                if (SafeClock.currentTimeMillis() > this.lastPrintout + 10000L) {
                    System.out.println("[UdpClient] (no further printouts for 10s) Unable to send to " + this.udp.getRemoteAddr() + " " + x);
                    this.lastPrintout = SafeClock.currentTimeMillis() + 10000L;
                }
            }
            catch (Exception x) {
                if (SafeClock.currentTimeMillis() <= this.lastPrintout + 10000L) break block11;
                if (this.udp != null) {
                    System.out.println("[UdpClient] (no further printouts for 10s) Unable to send to " + this.udp.getRemoteAddr() + " " + x);
                } else {
                    System.out.println("[UdpClient] (no further printouts for 10s) Unable to send to null " + x);
                }
                x.printStackTrace();
                this.lastPrintout = SafeClock.currentTimeMillis() + 10000L;
            }
        }
    }

    @Override
    public void handleMessage(byte[] dat, Object uid, UDPResponder respond, String remoteIPAddress) {
        Message m = MessageUtils.bytesToMessage(dat);
        if (m.getType() == 3002000) {
            Message rec = (Message)m.get(0);
            this.lossy.lossyMessageReceived(new UdpResponderLossyTransport(respond, uid), rec, null);
        } else if (this.handleIncoming && m.getType() == 3001000) {
            this.lossy.lossyMessageReceived(this, m.getNextMessage(), null);
        }
    }

    @Override
    public String getUnderlyingProtocolDescription() {
        return "UDP";
    }

    @Override
    public Object getLargeSendLock() {
        return this.largeSendLOCK;
    }

    public String toString() {
        if (this.udp != null) {
            return "UdpClientLossyTransport(" + this.udp.getRemoteAddr() + ")";
        }
        return "UdpClientLossyTransport(null)";
    }
}

