/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.mdupload.fs.journal;

import com.aem.CentralDebugging;
import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.mdupload.fs.FSConstants;
import com.aem.shelp.mdupload.fs.GFile;
import com.aem.shelp.mdupload.fs.LocalFS;
import com.aem.shelp.mdupload.fs.journal.FSEvent;
import com.aem.shelp.mdupload.fs.journal.FSEventComparator;
import com.aem.shelp.mdupload.fs.journal.FSJournalListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import utils.files.FileUtil;

public class FSJournal {
    LocalFS fs;
    long logicalClock = 0L;
    long listStart = 0L;
    Object allEvents_LOCK = new Object();
    ArrayList<FSEvent> allEvents = new ArrayList();
    ArrayList<FSEvent> sliceEvents = new ArrayList();
    HashMap<String, GFile> latest = new HashMap();
    FSJournalListener listener;
    File[] track;
    JournalingThread journaler;
    long lastSlept = -1L;
    boolean stop = false;

    public FSJournal(LocalFS fs, File track) {
        this(fs, new File[]{track});
    }

    public FSJournal(LocalFS fs, File[] track) {
        this.fs = fs;
        this.track = track;
        this.journaler = new JournalingThread();
        this.journaler.start();
    }

    public void registerListener(FSJournalListener listener) {
        this.listener = listener;
    }

    void initSpeed() {
        this.lastSlept = System.currentTimeMillis();
    }

    void checkSpeed() {
        long t = SafeClock.currentTimeMillis();
        long diff = t - this.lastSlept;
        if (diff > (long)FSConstants.JOURNAL_ACTIVE_MS) {
            try {
                Thread.sleep(FSConstants.JOURNAL_INACTIVE_MS);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.initSpeed();
        }
    }

    long getNextLogicalClock() {
        return this.logicalClock++;
    }

    long getNextClock(GFile file) {
        if (file.dir) {
            return System.currentTimeMillis();
        }
        return file.lastmodified;
    }

    long getCurrentClock() {
        return System.currentTimeMillis();
    }

    void journal(File f) {
        this.checkSpeed();
        try {
            if (FileUtil.isSymlink(f)) {
                if (CentralDebugging.FS_JOURNALING_VERBOSE) {
                    System.out.println("[FSJournal] ignoring symlink " + f);
                }
            } else {
                GFile gf;
                GFile lf;
                if (CentralDebugging.FS_JOURNALING_VERBOSE) {
                    System.out.println("[FSJournal] journaling " + f);
                }
                if ((lf = this.latest.get((gf = LocalFS.getFile(f)).path())) == null) {
                    this.sliceEvents.add(new FSEvent(0, gf, this.getNextClock(gf)));
                    this.latest.put(gf.path(), gf);
                }
                if (gf.dir) {
                    File[] all = new File(gf.path()).listFiles();
                    for (int i = 0; i < all.length; ++i) {
                        this.journal(all[i]);
                    }
                } else if (lf != null && gf.lastmodified != lf.lastmodified) {
                    this.sliceEvents.add(new FSEvent(1, gf, this.getNextClock(gf)));
                    this.latest.put(gf.path(), gf);
                }
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    void journalDeletes() {
        Object[] all = this.latest.values().toArray();
        for (int i = 0; i < all.length; ++i) {
            this.checkSpeed();
            GFile gf = (GFile)all[i];
            if (CentralDebugging.FS_JOURNALING_VERBOSE) {
                System.out.println("[FSJournal] journaling deletion of " + gf.path());
            }
            if (new File(gf.path()).exists()) continue;
            this.sliceEvents.add(new FSEvent(2, gf, this.getNextClock(gf)));
            this.latest.remove(gf.path());
        }
    }

    public void notifyFileCreated(GFile file) {
        try {
            GFile gf = LocalFS.getFile(new File(file.path()));
            this.latest.put(gf.path(), gf);
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    public void notifyFileDeleted(GFile gfile) {
        this.latest.remove(gfile.path());
    }

    void collapseMoves() {
        HashMap<String, FSEvent> pots = new HashMap<String, FSEvent>();
        boolean gathering = true;
        for (int i = this.sliceEvents.size() - 1; i >= 0; --i) {
            GFile del;
            FSEvent event = this.sliceEvents.get(i);
            if (gathering) {
                if (event.type == 2) {
                    GFile del2 = event.file;
                    if (event.file.dir) continue;
                    pots.put(del2.size + "---" + del2.name, event);
                    continue;
                }
                gathering = false;
                continue;
            }
            if (pots.size() == 0 || event.type == 2 || event.type == 3) break;
            if (event.type != 0) continue;
            GFile nf = event.file;
            FSEvent eDel = (FSEvent)pots.remove(nf.size + "---" + nf.name);
            if (eDel == null || (del = eDel.file).path().equals(nf.path())) continue;
            System.out.println(del + " moved to " + nf + "?");
            FSEvent move = new FSEvent(3, nf, this.getNextClock(nf), del);
            FSEvent change = new FSEvent(1, nf, this.getNextClock(nf));
            int createIndex = i;
            int deleteIndex = -1;
            for (int z = this.sliceEvents.size() - 1; z >= i; --z) {
                if (eDel != this.sliceEvents.get(z)) continue;
                deleteIndex = z;
            }
            FSEvent fe = this.sliceEvents.remove(deleteIndex);
            fe = this.sliceEvents.remove(createIndex);
            --i;
            this.sliceEvents.add(move);
            this.sliceEvents.add(change);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FSEvent> getEvents(long latestKnownEvent) {
        ArrayList<FSEvent> slice = new ArrayList<FSEvent>();
        int start = this.allEvents.size();
        Object object = this.allEvents_LOCK;
        synchronized (object) {
            int i = this.allEvents.size() - 1;
            while (i >= 0) {
                FSEvent fe = this.allEvents.get(i);
                if (latestKnownEvent >= fe.eventNum) break;
                start = i--;
            }
        }
        for (int i = start; i < this.allEvents.size(); ++i) {
            slice.add(this.allEvents.get(i));
        }
        return slice;
    }

    public void stopJournaling() {
        this.stop = true;
    }

    public static void main(String[] args) throws Exception {
        new FSJournal(new LocalFS(), new File[]{new File("/Users/aem/Desktop")});
    }

    class JournalingThread
    extends Thread {
        JournalingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FSJournal.this.initSpeed();
            while (!FSJournal.this.stop) {
                int i;
                FSJournal.this.sliceEvents.clear();
                if (CentralDebugging.FS_JOURNALING_VERBOSE) {
                    System.out.println("[FSJournal] journaling roots");
                }
                for (i = 0; i < FSJournal.this.track.length; ++i) {
                    FSJournal.this.journal(FSJournal.this.track[i]);
                }
                if (CentralDebugging.FS_JOURNALING_VERBOSE) {
                    System.out.println("[FSJournal] journaling deletes");
                }
                FSJournal.this.journalDeletes();
                if (CentralDebugging.FS_JOURNALING_CHANGES) {
                    System.out.println("[FSJournal] printing changes");
                    for (i = 0; i < FSJournal.this.sliceEvents.size(); ++i) {
                        FSEvent event = FSJournal.this.sliceEvents.get(i);
                        System.out.println(event);
                    }
                }
                Collections.sort(FSJournal.this.sliceEvents, new FSEventComparator());
                for (FSEvent fe : FSJournal.this.sliceEvents) {
                    fe.eventNum = FSJournal.this.getNextLogicalClock();
                }
                Object i2 = FSJournal.this.allEvents_LOCK;
                synchronized (i2) {
                    FSJournal.this.allEvents.addAll(FSJournal.this.sliceEvents);
                }
                if (FSJournal.this.sliceEvents.size() > 0 && FSJournal.this.listener != null) {
                    FSJournal.this.listener.newEventsReady();
                }
                try {
                    if (CentralDebugging.FS_JOURNALING_VERBOSE) {
                        System.out.println("[FSJournal] sleeping");
                    }
                    Thread.sleep(FSConstants.JOURNAL_SCAN_SLEEP);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
    }
}

