/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.mdupload.fs;

import com.aem.shelp.mdupload.fs.FSConstants;
import com.aem.shelp.mdupload.fs.FSUtils;
import com.aem.shelp.mdupload.fs.GFile;
import com.aem.shelp.mdupload.fs.GenericFS;
import com.aem.shelp.mdupload.fs.LocalFS;
import com.aem.shelp.mdupload.fs.journal.FSEvent;
import com.aem.shelp.mdupload.fs.journal.FSEventComparator;
import com.aem.shelp.mdupload.fs.journal.FSJournalListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class FSSync
extends Thread
implements FSJournalListener {
    GenericFS locFS;
    GFile locDir;
    GenericFS remFS;
    GFile remDir;
    boolean stop = false;
    Object sleep_LOCK = new Object();
    boolean sync_now = false;

    public FSSync(GenericFS locFS, GFile locFile, GenericFS remFS, GFile remFile) {
        this.locFS = locFS;
        this.locDir = locFile;
        this.remFS = remFS;
        this.remDir = remFile;
        if (locFS instanceof LocalFS) {
            ((LocalFS)locFS).registerJournalListener(this.locDir, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newEventsReady() {
        Object object = this.sleep_LOCK;
        synchronized (object) {
            this.sync_now = true;
            this.sleep_LOCK.notifyAll();
        }
    }

    void download(File local, GFile remote) throws IOException {
        File dir = local.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        BufferedOutputStream target = new BufferedOutputStream(new FileOutputStream(local));
        int z = 0;
        while ((long)z < remote.size) {
            byte[] dat = this.remFS.readFileChunk(remote, z, FSConstants.FILE_DOWNLOAD_CHUNK);
            System.out.println("[FSPane] Downloading +" + dat.length);
            ((OutputStream)target).write(dat);
            z += FSConstants.FILE_DOWNLOAD_CHUNK;
        }
        this.remFS.closeFile(remote);
        ((OutputStream)target).close();
        local.setLastModified(remote.lastmodified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long locLatestEvent = -1L;
        long remLatestEvent = -1L;
        block9: while (!this.stop) {
            Iterator<FSEvent> iterator;
            try {
                ArrayList<FSEvent> all = new ArrayList<FSEvent>();
                List<FSEvent> jloc = this.locFS.getJournalEvents(this.locDir, locLatestEvent);
                List<FSEvent> jrem = this.remFS.getJournalEvents(this.remDir, remLatestEvent);
                iterator = jloc.iterator();
                while (iterator.hasNext()) {
                    FSEvent re = (FSEvent)iterator.next();
                    locLatestEvent = Math.max(locLatestEvent, re.eventNum);
                    System.out.println("[FSSync] Local : " + re);
                }
                for (FSEvent re : jrem) {
                    re.remote = true;
                    remLatestEvent = Math.max(remLatestEvent, re.eventNum);
                    System.out.println("[FSSync] Remote : " + re);
                }
                all.addAll(jloc);
                all.addAll(jrem);
                Collections.sort(all, new FSEventComparator());
                for (FSEvent fe : all) {
                    try {
                        if (fe.remote) {
                            GFile remote = fe.file;
                            GFile local = GFile.getFileRelativeTo(this.remDir, remote, this.locDir);
                            if (fe.type == 0 || fe.type == 1) {
                                if (remote.dir) {
                                    System.out.println("[FSSync] Action : create local folder " + local.path());
                                    this.locFS.createFolder(local);
                                    this.locFS.notifyJournalFileCreated(this.locDir, local);
                                    continue;
                                }
                                System.out.println("[FSSync] Action : download to " + local.path() + " from " + remote.path());
                                this.download(new File(local.path()), remote);
                                this.locFS.notifyJournalFileCreated(this.locDir, local);
                                continue;
                            }
                            if (fe.type != 2) continue;
                            System.out.println("[FSSync] Action : locally delete " + local.path());
                            this.locFS.deleteFiles(new GFile[]{local});
                            this.locFS.notifyJournalFileDeleted(this.locDir, local);
                            continue;
                        }
                        GFile local = fe.file;
                        GFile remote = GFile.getFileRelativeTo(this.locDir, local, this.remDir);
                        if (fe.type == 0 || fe.type == 1) {
                            if (local.dir) {
                                System.out.println("[FSSync] Action : create remote folder " + remote.path());
                                this.remFS.createFolder(remote);
                                this.remFS.notifyJournalFileCreated(this.remDir, remote);
                                continue;
                            }
                            System.out.println("[FSSync] Action : upload to " + remote.path() + " from " + local.path());
                            FSUtils.upload(this.remFS, new File(local.path()), remote);
                            this.remFS.notifyJournalFileCreated(this.remDir, remote);
                            continue;
                        }
                        if (fe.type != 2) continue;
                        System.out.println("[FSSync] Action : remotely delete " + remote.path());
                        this.remFS.deleteFiles(new GFile[]{remote});
                        this.remFS.notifyJournalFileDeleted(this.remDir, remote);
                    }
                    catch (FileNotFoundException fileNotFoundException) {}
                }
            }
            catch (IOException x) {
                x.printStackTrace();
            }
            try {
                int sleepms = 500;
                int sleeps = FSConstants.SYNC_WAIT / sleepms;
                for (int i = 0; i < sleeps; ++i) {
                    if (this.sync_now) {
                        this.sync_now = false;
                        continue block9;
                    }
                    iterator = this.sleep_LOCK;
                    synchronized (iterator) {
                        this.sleep_LOCK.wait(sleepms);
                        continue;
                    }
                }
            }
            catch (Exception exception) {
            }
        }
    }

    public static void main(String[] args) throws Exception {
        LocalFS fs1 = new LocalFS();
        LocalFS fs2 = new LocalFS();
        GFile f1 = LocalFS.getFile(new File("/Users/aem/Desktop/FS Testing/FS1"));
        GFile f2 = LocalFS.getFile(new File("/Users/aem/Desktop/FS Testing/FS2"));
        fs1.startJournaling(f1);
        fs2.startJournaling(f2);
        FSSync sync = new FSSync(fs1, f1, fs2, f2);
        sync.start();
    }
}

