/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.mdupload.fs;

import aurelienribon.slidinglayout.SLAnimator;
import aurelienribon.slidinglayout.SLConfig;
import aurelienribon.slidinglayout.SLKeyframe;
import aurelienribon.slidinglayout.SLPanel;
import aurelienribon.slidinglayout.SLTransition;
import com.aem.SafeResourceBundle;
import com.aem.shelp.common.Language;
import com.aem.shelp.mdupload.fs.FSSync;
import com.aem.shelp.mdupload.fs.FsAutoUpgrade;
import com.aem.shelp.mdupload.fs.GFile;
import com.aem.shelp.mdupload.fs.GVolume;
import com.aem.shelp.mdupload.fs.GenericFS;
import com.aem.shelp.mdupload.fs.LocalFS;
import com.aem.shelp.tech.gstarted.MonitoringOnlyUtil;
import com.aem.shelp.util.EasyDateTimeFormatter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipOutputStream;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import utils.ostools.OS;
import utils.progtools.OnDemandThreadPool;
import utils.swing.SafeJFileChooser;
import utils.swing.components.SHJTable;
import utils.swing.components.SimpleMessagePanel;
import utils.swing.components.animated.arrow.ArrowOverlayIcon;
import utils.swing.components.path.PathBar;
import utils.swing.components.path.PathBarListener;
import utils.swing.components.path.elements.FilePathElement;
import utils.swing.components.path.elements.PathElement;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.dnd.FileTransferable;
import utils.swing.dnd.TableFileDropListener;
import utils.swing.dnd.TextDropListener;
import utils.swing.dnd.awt.DragAndDropHandler;
import utils.swing.dnd.swing.DndTransferHandler;
import utils.swing.formatters.DataSizeFormatter;
import utils.swing.glassdialog.GlassOptionPane;
import utils.swing.icons.SystemIconUtil;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;
import utils.swing.simplelist.wrapper.filter.FilterWrapper;
import utils.switches.Switches;

public class FSPane
extends SLPanel
implements ActionListener,
TableFileDropListener {
    private OnDemandThreadPool requestThreadPool = new OnDemandThreadPool("FSPaneThreadPool", 1, 1, 5);
    private OnDemandThreadPool fsConfigFetcher = new OnDemandThreadPool("FSPaneFetcher", 5, 5, 5);
    private final LocalFS locFS = new LocalFS();
    private GenericFS fs;
    private FsAutoUpgrade fsUpgrader;
    private final PathBar pathBar = new PathBar(false);
    private boolean monitoringOnly = false;
    private boolean readOnly = false;
    private final SimpleList<GFile> slist;
    private final FilterWrapper wrapper;
    private final JPanel buttons;
    private final JPanel queue;
    private final JButton rename;
    private final JButton delete;
    private final JButton newfolder;
    private final JToggleButton dozip;
    private final Color defBg;
    private final Color altBg;
    private final SHJTable table;
    private final GbPanel main;
    private final JScrollPane queueScrollPane;
    private RootPaneContainer rpc;
    private final SLConfig noqueue;
    private final SLConfig withqueue;
    private static final int DL_FILES = 0;
    private static final int DL_ZIP = 1;
    private static final int DL_SYNC = 2;
    private static final int Q_HEIGHT = 66;
    private boolean dragFromQueueInProgress = false;
    private boolean dragFromTableInProgress = false;
    private boolean shown = false;
    float transition = 0.7f;
    long max = 700L;
    DecimalFormat df = new DecimalFormat("###,###,###,###,###,###,###,##0.#");
    private final EasyDateTimeFormatter elapsedTimeFormatter = new EasyDateTimeFormatter();
    private GVolume[] roots;
    private GFile cdir;
    private int remoteOS;
    private static final String SELECTED_DROP = "TableSelectedDrop34784782489";
    public static final Comparator<GFile> FILE_ENTRY_WINDOWS = new Comparator<GFile>(){

        @Override
        public int compare(GFile o1, GFile o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1.dir && o2.dir || !o1.dir && !o2.dir) {
                return o1.name.toLowerCase().compareTo(o2.name.toLowerCase());
            }
            if (o1.dir) {
                return -1;
            }
            return 1;
        }
    };
    public static final Comparator<GFile> FILE_ENTRY_OTHER = new Comparator<GFile>(){

        @Override
        public int compare(GFile o1, GFile o2) {
            return o1.name.toLowerCase().compareTo(o2.name.toLowerCase());
        }
    };

    private void upgradeFS() {
        GenericFS upgraded;
        if (this.fsUpgrader != null && (upgraded = this.fsUpgrader.upgradeIfPossible(this.fs)) != null) {
            System.out.println("[FSPane] Upgraded FS to " + upgraded);
            this.fs = upgraded;
        }
    }

    public String getSelectedFileOrFolder(boolean acceptCurrentFolderIfNoSelection) {
        if (this.table.getSelectedRow() != -1) {
            GFile gfile = this.slist.get(this.table.getSelectedRow());
            return gfile.path();
        }
        if (acceptCurrentFolderIfNoSelection) {
            return this.getCurrentFolder();
        }
        return null;
    }

    private String getCurrentFolder() {
        return this.pathBar.getCurrentFolder().getRemotePath();
    }

    private void uploadToDir(GenericFS curfs, File local, GFile dir) throws IOException {
        curfs.uploadIntoDir(local, dir);
    }

    private File downloadToDir(File localDir, GFile remote) throws IOException {
        return this.fs.downloadIntoDir(localDir, remote);
    }

    public GFile getCurrentDir() {
        return this.cdir;
    }

    private void initUI(RootPaneContainer rpc, GenericFS fs) {
        this.initUI(rpc, fs, null, null);
    }

    public void initUI(RootPaneContainer rpc, GenericFS fs, GFile dir, FsAutoUpgrade fsUpgrader) {
        this.rpc = rpc;
        this.fs = fs;
        this.fsUpgrader = fsUpgrader;
        this.fsConfigFetcher.runAsync(new Load(dir));
    }

    public void setMonitoringOnly(boolean mon) {
        this.monitoringOnly = mon;
    }

    public void setReadOnly(boolean ro) {
        this.readOnly = ro;
    }

    public FSPane() {
        this(false);
    }

    public FSPane(boolean readOnly) {
        this.fsConfigFetcher.setDumpOldJobsOnBufferMaxed(true);
        this.main = new GbPanel();
        TableStructure ts = TableStructure.createTableStructure(GFile.class, new String[]{"", "getSize", "lastmodified"}, new String[]{"", Language.get("FILES_COL_SIZE"), Language.get("FILES_COL_MOD")});
        this.slist = new SimpleList();
        this.wrapper = new FilterWrapper<GFile>(this.slist);
        SimpleTableModel slm = new SimpleTableModel(this.wrapper, ts);
        this.table = new SHJTable();
        this.table.setModel(slm);
        if (!readOnly) {
            this.table.setDragEnabled(true);
        }
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FSPane.this.updateEnabled();
            }
        });
        this.table.setRowHeight(SimpleHelpLookAndFeel.scale(20));
        this.table.getTableHeader().setDefaultRenderer(new FSPaneTableHeaderRenderer(this.table));
        this.table.getColumnModel().getColumn(1).setMaxWidth(100);
        this.table.getColumnModel().getColumn(2).setMaxWidth(200);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(0).setIdentifier("NAME");
        this.table.getColumnModel().getColumn(1).setIdentifier("SIZE");
        this.table.getColumnModel().getColumn(2).setIdentifier("MOD");
        this.buttons = new JPanel();
        this.buttons.setLayout(new FlowLayout(2));
        this.queue = new SimpleMessagePanel(Language.get("FSPANE_DROP"), new Color(220, 220, 220), SHStyle.PANEL_BACKGROUND_DARKER);
        this.queue.setLayout(new FlowLayout(0));
        this.queueScrollPane = new JScrollPane(this.queue);
        this.queueScrollPane.setBorder(SHBorderFactory.createMatteBorder(1, 0, 0, 0, SHStyle.BORDER_COLOR));
        this.queueScrollPane.setPreferredSize(new Dimension(66, 66));
        this.queueScrollPane.setMinimumSize(new Dimension(66, 66));
        this.queueScrollPane.setMaximumSize(new Dimension(100000, 66));
        this.queueScrollPane.setVerticalScrollBarPolicy(21);
        this.rename = new JButton(ImageLoader.getImageIcon("images/svg/general/pencil.svg,16"));
        this.delete = new JButton(ImageLoader.getImageIcon("images/svg/general/remove.svg,16"));
        this.newfolder = new JButton(ImageLoader.getImageIcon("images/svg/files-folders/folder.svg,16"));
        this.dozip = new JToggleButton(ImageLoader.getImageIcon("images/svg/files-folders/zip.svg,16"));
        this.rename.setToolTipText(Language.get("TT_RENAME_FILE_REMOTE"));
        this.delete.setToolTipText(Language.get("CONFIRM_DELETE_REMOTE_TITLE"));
        this.newfolder.setToolTipText(Language.get("TT_NEW_FOLDER_REMOTE"));
        this.dozip.setToolTipText(Language.get("TT_ZIP_REMOTE"));
        if (!readOnly) {
            this.buttons.add(this.rename);
            this.buttons.add(this.delete);
            this.buttons.add(this.newfolder);
            if (Switches.SH_fspaneZipButton && !Switches.SH_noZipDownload) {
                this.buttons.add(this.dozip);
            }
        }
        JScrollPane tableScrollPane = new JScrollPane(this.table);
        tableScrollPane.setBackground(Color.white);
        tableScrollPane.setBorder(SHBorderFactory.createEmptyBorder());
        this.main.add(this.pathBar.getRootComponent(), 0, 0, 1, 1, 1, 0, 13, 2);
        this.main.add(this.buttons, 1, 0, 1, 1, 0, 0, 13, 2);
        this.main.add(tableScrollPane, 0, 1, 2, 1, 100, 1, 10, 1);
        this.pathBar.addPathBarListener(new PathBarListener(){

            @Override
            public void selectedPathElement(PathBar source, PathElement element) {
                if (element instanceof FilePathElement) {
                    FilePathElement fileElement = (FilePathElement)element;
                    File targetFile = fileElement.getFile();
                    System.out.println("[FSPane] Switching to " + targetFile + " (" + targetFile.getPath() + ")");
                    try {
                        FSPane.this.setDir(new GFile(targetFile.getPath(), targetFile.getName(), 0L, 0L, true, false));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    FSPane.this.showVolumes();
                }
            }

            @Override
            public void setShowHiddenFiles(PathBar source, boolean showHiddenFiles) {
            }

            @Override
            public String resolveEnvironmental(String env, PathBar source) {
                return null;
            }
        });
        this.noqueue = new SLConfig(this).gap(0, 0).col(1.0f).row(1.0f).row(0).place(0, 0, this.main).place(1, 0, this.queueScrollPane);
        this.withqueue = new SLConfig(this).gap(0, 0).col(1.0f).row(1.0f).row(66).place(0, 0, this.main).place(1, 0, this.queueScrollPane);
        this.setTweenManager(SLAnimator.createTweenManager());
        this.initialize(this.noqueue);
        this.table.setDefaultRenderer(Object.class, new FSRenderer());
        this.table.setDefaultRenderer(Boolean.class, new FSRenderer());
        this.table.setDefaultRenderer(GFile.class, new FSRenderer());
        this.table.setDefaultRenderer(Long.class, new FSRenderer());
        this.defBg = Color.white;
        this.altBg = new Color(Math.min(this.defBg.getRed(), this.defBg.getRed() - 15), Math.min(this.defBg.getGreen(), this.defBg.getGreen() - 10), this.defBg.getBlue());
        MouseDragStateListener listener = new MouseDragStateListener(){

            @Override
            protected void startedDrag(MouseEvent e) {
                FSPane.this.dragFromTableInProgress = true;
            }

            @Override
            protected void finishedDrag() {
                FSPane.this.dragFromTableInProgress = false;
            }
        };
        if (!readOnly) {
            this.table.addMouseMotionListener(listener);
        }
        if (!readOnly) {
            this.table.addMouseListener(listener);
        }
        if (!readOnly) {
            this.table.setTransferHandler(new TransferHandler(){

                @Override
                public int getSourceActions(JComponent c) {
                    return 3;
                }

                @Override
                public Transferable createTransferable(JComponent c) {
                    int row = FSPane.this.table.getSelectedRow();
                    if (row != -1) {
                        StringSelection src = new StringSelection(FSPane.this.getValueForRow(row));
                        FSPane.this.dragStarted();
                        return src;
                    }
                    return null;
                }

                @Override
                public void exportDone(JComponent c, Transferable t, int action) {
                    FSPane.this.dragEnded();
                }

                @Override
                public boolean importData(JComponent comp, Transferable tf) {
                    if (tf.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        try {
                            List list = (List)tf.getTransferData(DataFlavor.javaFileListFlavor);
                            FSPane.this.tableSelectionDropped(FSPane.this.table, list);
                            return true;
                        }
                        catch (UnsupportedFlavorException x) {
                            x.printStackTrace();
                            FSPane.this.dragCancelled();
                        }
                        catch (Exception x) {
                            FSPane.this.dragCancelled();
                            x.printStackTrace();
                        }
                    } else {
                        FSPane.this.dragCancelled();
                    }
                    return false;
                }

                @Override
                public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
                    if (FSPane.this.dragFromQueueInProgress || FSPane.this.dragFromTableInProgress) {
                        return false;
                    }
                    for (DataFlavor flavor : transferFlavors) {
                        if (!flavor.isFlavorJavaFileListType()) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
        if (!readOnly) {
            this.queue.setTransferHandler(new TransferHandler(){
                final DndTransferHandler handler;
                {
                    this.handler = new DndTransferHandler(new QueueDropListener());
                }

                @Override
                public int getSourceActions(JComponent c) {
                    return 3;
                }

                @Override
                public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
                    for (DataFlavor flavor : transferFlavors) {
                        if (!flavor.isFlavorTextType()) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public boolean importData(JComponent comp, Transferable tf) {
                    this.handler.addListFromDrop(tf);
                    return true;
                }
            });
        }
        new Thread(new Load(null)).start();
        this.table.addMouseListener(new TableMouseListener());
        if (!readOnly) {
            tableScrollPane.addMouseListener(new DragMouseListener());
        }
        this.rename.addActionListener(this);
        this.delete.addActionListener(this);
        this.newfolder.addActionListener(this);
        if (!readOnly) {
            DragAndDropHandler dh = new DragAndDropHandler(new DownloadHandler());
            dh.addDragAndDropToComponent(this.queueScrollPane);
        }
    }

    @Override
    public void dragCancelled() {
        this.dragEnded();
    }

    public void showOrHideQueue() {
        if (this.queue.getComponentCount() > 0) {
            if (!this.shown) {
                this.shown = true;
                SLTransition trans = this.createTransition().push(new SLKeyframe(this.withqueue, 0.7f));
                new DoTransition(trans).start();
            }
        } else if (this.queue.getComponentCount() == 0 && this.shown) {
            this.shown = false;
            SLTransition trans = this.createTransition().push(new SLKeyframe(this.noqueue, 0.7f));
            new DoTransition(trans).start();
        }
    }

    @Override
    public void dragStarted() {
        if (!this.shown) {
            this.shown = true;
            SLTransition trans = this.createTransition().push(new SLKeyframe(this.withqueue, 0.7f));
            new DoTransition(trans).start();
        }
    }

    private void dragEnded() {
        if (this.queue.getComponentCount() == 0 && this.shown) {
            this.shown = false;
            SLTransition trans = this.createTransition().push(new SLKeyframe(this.noqueue, 0.7f));
            new DoTransition(trans).start();
        }
    }

    private void updateEnabled() {
        this.newfolder.setEnabled(true);
        if (this.table.getSelectedRowCount() == 0) {
            this.rename.setEnabled(false);
            this.delete.setEnabled(false);
        } else {
            this.rename.setEnabled(true);
            this.delete.setEnabled(true);
        }
    }

    private String getPrimaryDrivePath(GVolume[] roots) {
        if (this.remoteOS == 0) {
            for (GVolume vol : roots) {
                if (!vol.path.startsWith("C:")) continue;
                return vol.path;
            }
        }
        return roots[0].path;
    }

    public static void main(String[] args) throws Exception {
        SafeResourceBundle.loadTestBundle();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        FSPane fsp = new FSPane();
        frame.getContentPane().add(fsp);
        fsp.initUI(frame, new LocalFS());
        frame.setVisible(true);
    }

    private void setDir(final GFile file) throws IOException {
        if (SwingUtilities.isEventDispatchThread()) {
            this.requestThreadPool.runAsync(new Runnable(){

                @Override
                public void run() {
                    try {
                        FSPane.this.setDir(file);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            return;
        }
        this.cdir = file;
        GFile[] all = this.fs.listDir(file);
        Arrays.sort(all, FSPane.getOSDependentComparator());
        this.slist.clear();
        this.slist.startBatch();
        try {
            Collections.addAll(this.slist, all);
        }
        finally {
            this.slist.endBatch();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FSPane.this.updateEnabled();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showVolumes() {
        this.slist.clear();
        this.slist.startBatch();
        try {
            for (GVolume volume : this.roots) {
                this.slist.add(new GFile(volume.path, volume.name, 0L, 0L, true, false));
            }
        }
        finally {
            this.slist.endBatch();
        }
        this.updateEnabled();
    }

    int getSelectionCount() {
        return this.table.getSelectedRowCount();
    }

    private GFile getSelectedFile() {
        if (this.table.getSelectedRow() == -1) {
            return null;
        }
        return this.slist.get(this.table.getSelectedRow());
    }

    private GFile[] getSelectedFiles() {
        GFile[] tmp = new GFile[this.table.getSelectedRowCount()];
        int[] rows = this.table.getSelectedRows();
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = this.slist.get(rows[i]);
        }
        return tmp;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block9: {
            String name;
            Object o;
            block10: {
                block8: {
                    String newname;
                    o = e.getSource();
                    if (o != this.rename) break block8;
                    GFile gf = this.getSelectedFile();
                    if (gf == null || (newname = SHGlassOptionPane.showInputDialog(this.rpc, Language.get("RENAME_LOCAL_FILE_NAME"), Language.get("RENAME_FILE"), ImageLoader.getImageIcon("O[images/svg/text/text.svg,48 | images/svg/general/pencil.svg,24"), Language.get("OK"), gf.name)) == null) break block9;
                    System.out.println("Renaming " + gf.path() + " to " + newname);
                    try {
                        for (GFile tmp : this.slist) {
                            if (!newname.equals(tmp.name)) continue;
                            SHGlassOptionPane.showErrorDialog(this.rpc, Language.get("FILE_EXISTS_SORRY"), Language.get("FILE_EXISTS"), ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,48"), Language.get("CLOSE"));
                            return;
                        }
                        GFile newfile = this.fs.renameFile(gf, newname);
                        int index = this.slist.indexOf(gf);
                        this.slist.remove(index);
                        this.slist.add(index, newfile);
                    }
                    catch (IOException iOException) {}
                    break block9;
                }
                if (o != this.delete) break block10;
                GFile[] all = this.getSelectedFiles();
                if (all.length <= 0 || !SHGlassOptionPane.showConfirmDialog(this.rpc, Language.get("CONFIRM_DELETE_REMOTE_MSG"), Language.get("DELETE"), ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,48"), Language.get("DELETE"))) break block9;
                System.out.println("Deleting files");
                try {
                    this.fs.deleteFiles(all);
                }
                catch (IOException newname) {
                    // empty catch block
                }
                for (GFile anAll : all) {
                    this.slist.remove(anAll);
                }
                break block9;
            }
            if (o != this.newfolder || (name = SHGlassOptionPane.showInputDialog(this.rpc, Language.get("NEW_LOCAL_FOLDER_NAME"), Language.get("NEW_FOLDER"), ImageLoader.getImageIcon("O[images/svg/files-folders/folder.svg,24 | images/svg/general/add.svg,12]"), Language.get("OK"), Language.get("FILES_COL_NAME"))) == null) break block9;
            try {
                this.fs.createFolder(this.cdir, name);
                this.setDir(this.cdir);
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
    }

    @Override
    public void tableSelectionDropped(JTable srcTable, List filesToCopy) {
        for (Object aFilesToCopy : filesToCopy) {
            File f = (File)aFilesToCopy;
            System.out.println("[FSPane] Upload: " + f);
        }
        new Uploader(filesToCopy).start();
    }

    @Override
    public String getValueForRow(int row) {
        return SELECTED_DROP;
    }

    public void setRemoteOS(int remoteOS) {
        this.remoteOS = remoteOS;
        this.pathBar.setOS(remoteOS);
    }

    public static final Comparator<GFile> getOSDependentComparator() {
        if (OS.isWindows()) {
            return FILE_ENTRY_WINDOWS;
        }
        return FILE_ENTRY_OTHER;
    }

    static /* synthetic */ GVolume[] access$2302(FSPane x0, GVolume[] x1) {
        x0.roots = x1;
        return x1;
    }

    public class FSPaneTableHeaderRenderer
    implements TableCellRenderer {
        final DefaultTableCellRenderer renderer;

        public FSPaneTableHeaderRenderer(JTable table) {
            this.renderer = (DefaultTableCellRenderer)table.getTableHeader().getDefaultRenderer();
            this.renderer.setBorder(SHBorderFactory.createEmptyBorder(0, 3, 0, 3));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            switch (col) {
                case 0: {
                    this.renderer.setHorizontalAlignment(2);
                    break;
                }
                default: {
                    this.renderer.setHorizontalAlignment(4);
                }
            }
            JLabel result = (JLabel)this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            result.setBorder(SHBorderFactory.createEmptyBorder(0, 3, 0, 3));
            return result;
        }
    }

    private class Uploader
    extends Thread {
        final List files;

        public Uploader(List list) {
            this.files = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (FSPane.this.monitoringOnly) {
                MonitoringOnlyUtil.disallowedPopup(FSPane.this.rpc, FSPane.this);
                return;
            }
            FSPane.this.upgradeFS();
            GenericFS cfs = FSPane.this.fs;
            GFile dir = FSPane.this.cdir;
            String filename = dir.name;
            if (this.files != null && this.files.size() > 0) {
                filename = ((File)this.files.get(0)).getName();
            }
            PackageUpload pkg = new PackageUpload(filename);
            FSPane.this.showOrHideQueue();
            try {
                for (Object file : this.files) {
                    File f = (File)file;
                    try {
                        FSPane.this.uploadToDir(cfs, f, dir);
                    }
                    catch (IOException x) {
                        x.printStackTrace();
                    }
                }
                try {
                    FSPane.this.setDir(FSPane.this.cdir);
                    FSPane.this.repaint();
                }
                catch (IOException x) {
                    x.printStackTrace();
                }
            }
            finally {
                pkg.removeFromQueue();
                FSPane.this.showOrHideQueue();
            }
        }
    }

    class Load
    implements Runnable {
        final GFile dir;

        public Load(GFile dir) {
            this.dir = dir;
        }

        @Override
        public void run() {
            try {
                if (FSPane.this.fs != null) {
                    FSPane.access$2302(FSPane.this, FSPane.this.fs.listRoots());
                    FSPane.this.pathBar.setFileSystemRoots(FSPane.this.roots);
                }
                FSPane.this.rename.setEnabled(false);
                FSPane.this.delete.setEnabled(false);
                FSPane.this.newfolder.setEnabled(false);
                if (FSPane.this.fs != null && FSPane.this.roots.length > 0) {
                    FSPane.this.pathBar.setEnabled(true);
                    if (this.dir == null) {
                        String path = FSPane.this.getPrimaryDrivePath(FSPane.this.roots);
                        File primaryFile = new File(path);
                        FSPane.this.pathBar.setCurrentFolder(primaryFile);
                        FSPane.this.setDir(new GFile(path, path, 0L, 0L, true, false));
                    } else {
                        FSPane.this.pathBar.setCurrentFolder(new File(this.dir.path()));
                        FSPane.this.setDir(this.dir);
                    }
                } else {
                    FSPane.this.pathBar.setEnabled(false);
                    FSPane.this.slist.clear();
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    private class FSRenderer
    extends DefaultTableCellRenderer {
        private FSRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value == null) {
                return label;
            }
            String cid = (String)table.getColumnModel().getColumn(column).getIdentifier();
            if (cid.equals("NAME")) {
                GFile file = (GFile)value;
                if (FSPane.this.pathBar.isVolumeListSelected()) {
                    label.setIcon(SystemIconUtil.getDefaultDriveIcon());
                } else if (file.dir) {
                    label.setIcon(SystemIconUtil.getDefaultFolderIcon());
                } else {
                    label.setIcon(SystemIconUtil.getDefaultFileIcon());
                }
                label.setText(file.name);
                label.setHorizontalAlignment(2);
                if (isSelected) {
                    label.setForeground(Color.white);
                } else {
                    label.setForeground(Color.BLACK);
                }
            } else if (cid.equals("MOD")) {
                long val = (Long)value;
                if (val == 0L) {
                    label.setText("");
                } else {
                    label.setText(FSPane.this.elapsedTimeFormatter.formatDateTime(val));
                }
                label.setHorizontalAlignment(4);
                if (isSelected) {
                    label.setForeground(Color.white);
                } else {
                    label.setForeground(Color.DARK_GRAY);
                }
            } else if (cid.equals("SIZE")) {
                long val = (Long)value;
                if (val == -1L) {
                    label.setText("");
                } else {
                    label.setText(DataSizeFormatter.INSTANCE.getFormattedSize(val));
                }
                label.setHorizontalAlignment(4);
                if (isSelected) {
                    label.setForeground(Color.white);
                } else {
                    label.setForeground(Color.DARK_GRAY);
                }
            }
            return label;
        }
    }

    private class DownloadHandler
    implements TextDropListener {
        private DownloadHandler() {
        }

        @Override
        public void textDropped(String s) {
            System.out.println("DONE");
        }
    }

    class DoTransition
    extends Thread {
        final SLTransition trans;

        public DoTransition(SLTransition trans) {
            this.trans = trans;
        }

        @Override
        public void run() {
            long until = System.currentTimeMillis() + 1000L;
            while (System.currentTimeMillis() < until && !this.trans.play()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
    }

    private class TableMouseListener
    implements MouseListener {
        private TableMouseListener() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1) {
                GFile gfile = (GFile)FSPane.this.slist.get(FSPane.this.table.getSelectedRow());
                if (gfile.dir) {
                    FSPane.this.pathBar.setCurrentFolder(new File(gfile.path()));
                    try {
                        FSPane.this.setDir(gfile);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private class DragMouseListener
    implements MouseListener {
        private DragMouseListener() {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            FSPane.this.dragCancelled();
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            FSPane.this.dragCancelled();
        }
    }

    abstract class MouseDragStateListener
    implements MouseMotionListener,
    MouseListener {
        boolean amDragging = false;

        MouseDragStateListener() {
        }

        protected abstract void startedDrag(MouseEvent var1);

        protected abstract void finishedDrag();

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.amDragging) {
                this.finishedDrag();
            }
            this.amDragging = false;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.amDragging) {
                this.finishedDrag();
            }
            this.amDragging = false;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.amDragging) {
                this.finishedDrag();
            }
            this.amDragging = false;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.amDragging) {
                this.startedDrag(e);
            }
            this.amDragging = true;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    class PackageDownload
    extends TransferHandler
    implements Runnable {
        final int dl_type;
        TransferBlock block;
        final GFile[] all;
        final ArrayList<File> readyFiles = new ArrayList();

        public PackageDownload(GFile[] all, int dl_type) {
            if (Switches.SH_noZipDownload) {
                dl_type = 0;
            }
            this.dl_type = dl_type;
            this.all = all;
            this.block = new TransferBlock(all[0].name, dl_type);
            for (int i = 0; i < all.length; ++i) {
                System.out.println("[FSPane] Downloading " + (i + 1) + "/" + all.length + " : " + all[i].path() + " using " + FSPane.this.fs);
            }
        }

        @Override
        public void run() {
            FSPane.this.queue.add(this.block);
            FSPane.this.queue.repaint();
            File sample = null;
            try {
                File file;
                File temp;
                if (this.dl_type == 0) {
                    temp = File.createTempFile("FsPaneFilesDL", "fspane");
                    temp.delete();
                    temp.mkdirs();
                    for (GFile gf : this.all) {
                        File local = FSPane.this.downloadToDir(temp, gf);
                        System.out.println("[FSPane] Locally downloaded file is " + local + " from " + FSPane.this.fs);
                        this.readyFiles.add(local);
                        if (sample != null) continue;
                        sample = local;
                    }
                } else if (this.dl_type == 1) {
                    temp = File.createTempFile("FsPaneZippedDL", "fspane");
                    temp.delete();
                    temp.mkdirs();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
                    File zip = new File(temp, "Downloaded-" + sdf.format(new Date()) + ".zip");
                    ZipOutputStream zout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zip)));
                    this.readyFiles.add(zip);
                    sample = zip;
                    for (GFile gf : this.all) {
                        File file2 = new File(temp, gf.name);
                    }
                    zout.finish();
                    zout.close();
                } else if (this.dl_type == 2 && (file = SafeJFileChooser.pickFile(FSPane.this.main)) != null) {
                    LocalFS lfs = new LocalFS();
                    GFile locfile = LocalFS.getFile(file);
                    FSSync sync = new FSSync(lfs, locfile, FSPane.this.fs, this.all[0]);
                    sync.start();
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            this.block.downloadPanel.hideProgress();
            this.block.repaint();
            this.block.setTransferHandler(this);
            MouseDragStateListener listener = new MouseDragStateListener(){

                @Override
                protected void startedDrag(MouseEvent e) {
                    FSPane.this.dragFromQueueInProgress = true;
                    PackageDownload.this.block.getTransferHandler().exportAsDrag(PackageDownload.this.block, e, 2);
                }

                @Override
                protected void finishedDrag() {
                    FSPane.this.dragFromQueueInProgress = false;
                }
            };
            this.block.addMouseMotionListener(listener);
            this.block.addMouseListener(listener);
            while (sample != null && sample.exists()) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
            FSPane.this.queue.remove(this.block);
            FSPane.this.queue.repaint();
            FSPane.this.dragEnded();
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        public Transferable createTransferable(JComponent c) {
            return new FileTransferable(this.readyFiles);
        }

        @Override
        public void exportDone(JComponent c, Transferable t, int action) {
            FSPane.this.dragEnded();
            FSPane.this.dragFromQueueInProgress = false;
        }
    }

    class PackageUpload {
        TransferBlock transferBlock;

        public PackageUpload(String filename) {
            this.transferBlock = new TransferBlock(filename, 0);
            FSPane.this.queue.add(this.transferBlock);
            FSPane.this.queue.repaint();
        }

        public void removeFromQueue() {
            FSPane.this.queue.remove(this.transferBlock);
            FSPane.this.queue.repaint();
        }
    }

    class TransferBlock
    extends GbPanel {
        JLabel name;
        DownloadPanel downloadPanel;

        public TransferBlock(String filename, int dl_type) {
            Icon fadedIcon;
            Icon icon;
            int bWid = 100;
            int bHigh = 60;
            this.setMinimumSize(new Dimension(bWid, bHigh));
            this.setPreferredSize(new Dimension(bWid, bHigh));
            this.setMaximumSize(new Dimension(bWid, bHigh));
            String shortname = filename;
            System.out.println("[FSPane] New package download : " + shortname);
            if (dl_type == 0) {
                icon = ImageLoader.getImageIcon("images/svg/files-folders/folder.svg,32");
                fadedIcon = ImageLoader.getImageIconLighter("images/svg/files-folders/folder.svg,32");
            } else if (dl_type == 1) {
                icon = ImageLoader.getImageIcon("images/svg/files-folders/zip.svg,32");
                fadedIcon = ImageLoader.getImageIconLighter("images/svg/files-folders/zip.svg,32");
            } else if (dl_type == 2) {
                icon = ImageLoader.getImageIcon("images/svg/files-folders/sync-files.svg,32");
                fadedIcon = ImageLoader.getImageIconLighter("images/svg/files-folders/sync-files.svg,32");
            } else {
                System.out.println("[FSPane] Unknown download type : " + dl_type);
                icon = null;
                fadedIcon = null;
            }
            this.name = new JLabel(shortname);
            this.name.setHorizontalAlignment(0);
            this.name.setFont(SHStyle.smallFont);
            this.downloadPanel = new DownloadPanel(icon, fadedIcon);
            this.add(this.downloadPanel, 0, 0, 1, 1, 100, 100, 10, 2, new Insets(0, 3, 0, 3));
            this.add(this.name, 0, 1, 1, 1, 100, 100, 11, 1, new Insets(1, 3, 2, 3));
        }
    }

    class DownloadPanel
    extends JPanel {
        final ArrowOverlayIcon progressBar;
        private final JLabel iconLabel;
        private final Icon icon;
        private final Icon fadedIcon;

        public DownloadPanel(Icon icon, Icon fadedIcon) {
            this.icon = icon;
            this.fadedIcon = fadedIcon;
            this.setLayout(new BorderLayout(0, 0));
            this.progressBar = new ArrowOverlayIcon(fadedIcon);
            this.progressBar.setDrawerColor(Color.white);
            this.progressBar.setArrowOffsets(0, 3);
            this.iconLabel = new JLabel(this.progressBar);
            this.add((Component)this.iconLabel, "South");
        }

        public void hideProgress() {
            this.iconLabel.setIcon(this.icon);
        }
    }

    private class QueueDropListener
    implements TextDropListener {
        private QueueDropListener() {
        }

        @Override
        public void textDropped(String s) {
            if (s.equals(FSPane.SELECTED_DROP)) {
                System.out.println("[FSPane] Adding selected files to queue");
                GFile[] all = FSPane.this.getSelectedFiles();
                boolean showSync = true;
                if (all.length > 1) {
                    showSync = false;
                }
                if (!all[0].dir) {
                    showSync = false;
                }
                int option = 0;
                if (Switches.SH_fspaneZipButton) {
                    option = FSPane.this.dozip.isSelected() ? 1 : 0;
                } else {
                    String[] options = showSync ? new String[]{Language.get("DOWNLOAD_AS_FILES"), Language.get("DOWNLOAD_AS_ZIP"), Language.get("DOWNLOAD_AS_SYNC")} : new String[]{Language.get("DOWNLOAD_AS_FILES"), Language.get("DOWNLOAD_AS_ZIP")};
                    option = GlassOptionPane.showConfirmDialog(FSPane.this.rpc, Language.get("FSPANE_PACKAGE_MESSAGE"), Language.get("FSPANE_PACKAGE_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/question.svg,48"), options);
                }
                FSPane.this.upgradeFS();
                new Thread(new PackageDownload(all, option)).start();
            }
        }
    }
}

