/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.mdupload;

import com.aem.CentralDebugging;
import com.aem.nodelink.utils.SafeClock;

public class TransmissionControlMechanism {
    private Object send_LOCK = new Object();
    private Object ack_LOCK = new Object();
    private long sent = 0L;
    private long acked = 0L;
    private long window = 20L;
    private double bpersec = 10000.0;
    private long increaseOnAck = 0L;
    private long fellOffAt = 0L;
    private boolean pushedWindow = false;
    private double nextSendAt = 0.0;
    boolean ADJUST_WINDOW_UP = true;
    boolean ADJUST_WINDOW_DOWN = false;

    public void importFrom(TransmissionControlMechanism tcm) {
        this.window = tcm.window;
        this.bpersec = tcm.bpersec;
        this.pushNextIncrease();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextToSend(double bytes, long timeout) {
        Object object = this.send_LOCK;
        synchronized (object) {
            double msAdd = bytes / this.bpersec * 1000.0;
            double T = SafeClock.currentTimeMillis();
            double mustWait = this.nextSendAt - T;
            this.nextSendAt = Math.max(T, this.nextSendAt) + msAdd;
            try {
                if (mustWait < 1.0) {
                    if (Math.random() < mustWait) {
                        Thread.sleep(1L);
                    }
                } else {
                    Thread.sleep((long)mustWait);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Object object2 = this.ack_LOCK;
            synchronized (object2) {
                while (this.sent - this.acked >= this.window) {
                    this.pushedWindow = true;
                    if ((double)SafeClock.currentTimeMillis() > T + (double)timeout) {
                        this.falloff(true);
                        return this.acked;
                    }
                    try {
                        this.ack_LOCK.wait(20L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            return this.sent++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ackReceived(long n) {
        Object object = this.ack_LOCK;
        synchronized (object) {
            if (n != this.acked) {
                this.increaseOnAck = this.sent = this.acked;
                this.falloff(false);
                this.ack_LOCK.notifyAll();
            } else {
                this.acked = Math.max(this.acked, n + 1L);
                this.ack_LOCK.notifyAll();
                if (this.acked >= this.increaseOnAck) {
                    this.increase();
                    this.pushNextIncrease();
                }
            }
        }
    }

    private void increase() {
        this.bpersec *= 1.1;
        if (this.bpersec > 5.0E7) {
            this.bpersec = 5.0E7;
        }
        if (this.ADJUST_WINDOW_UP && this.pushedWindow) {
            ++this.window;
            this.pushedWindow = false;
        }
        if (CentralDebugging.MUPLOAD_TCM_VERBOSE) {
            System.out.println("[TCM] " + this.sent + " ++" + (long)this.bpersec + " [" + this.window + "] ");
        }
    }

    private void pushNextIncrease() {
        this.increaseOnAck = this.sent + this.window;
    }

    private void pushNextFalloff() {
        this.fellOffAt = this.sent + 1L;
    }

    private void falloff(boolean force) {
        if (this.fellOffAt < this.sent || force) {
            this.bpersec *= 0.8;
            if (this.bpersec < 1000.0) {
                this.bpersec = 1000.0;
            }
            if (this.ADJUST_WINDOW_DOWN) {
                this.window = Math.max(10L, this.window - 1L);
            }
            if (CentralDebugging.MUPLOAD_TCM_VERBOSE) {
                System.out.println("[TCM] " + this.sent + " --" + (long)this.bpersec + " [" + this.window + "] <" + (force ? "timeout" : "skipped ack") + ">");
            }
            this.pushNextIncrease();
            this.pushNextFalloff();
        }
    }

    public static void main(String[] args) throws Exception {
        long mustSend;
        TransmissionControlMechanism tcm = new TransmissionControlMechanism();
        long nextSleep = System.currentTimeMillis() + 2000L;
        long T = System.currentTimeMillis();
        long bytes = 500L;
        long tot = 0L;
        int packets = 50000;
        long lossUntil = 0L;
        do {
            mustSend = tcm.nextToSend(bytes, 1000L);
            System.out.println(System.currentTimeMillis() + " Must send " + mustSend);
            if ((tot += bytes) % (bytes * 10L) == 0L) {
                double secs = (double)(System.currentTimeMillis() - T) / 1000.0;
                double k = tot / 1000L;
                System.out.println((int)(k / secs) + "k/sec");
                if (k / secs > 100.0) {
                    lossUntil = System.currentTimeMillis() + 100L;
                }
            }
            if (Math.random() < 0.99 && System.currentTimeMillis() > lossUntil) {
                tcm.ackReceived(mustSend);
            }
            if (System.currentTimeMillis() <= nextSleep) continue;
        } while (mustSend < (long)packets);
    }
}

