/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.mdupload;

import com.aem.shelp.mdupload.LossyClient;
import com.aem.shelp.mdupload.LossyTransport;
import java.io.File;
import utils.message.Message;
import utils.message.MessageUtils;

public class LossyTestThread
extends Thread {
    public static boolean DEBUG = false;
    LossyClient lossy;
    LossyTransport transport;
    String machineID;
    private boolean doneLossyTest = false;

    public LossyTestThread(LossyClient lossy, LossyTransport transport, String machineID) {
        this.lossy = lossy;
        this.transport = transport;
        this.machineID = machineID;
        if (DEBUG && !this.doneLossyTest && new File("").getAbsolutePath().startsWith("/Users/aem/Documents/workspace/SimpleHelp")) {
            this.doneLossyTest = true;
            this.start();
        }
    }

    public LossyTestThread(LossyClient lossy, LossyTransport transport) {
        this.lossy = lossy;
        this.transport = transport;
        this.start();
    }

    @Override
    public void run() {
        try {
            Message m;
            int i;
            boolean CHECK_THROUGHPUT = false;
            boolean CHECK_LAG = false;
            boolean CHECK_GUARANTEED = false;
            for (i = 3; i > 0; --i) {
                System.out.println("[LossyTestThread] Starting in " + i + "...");
                Thread.sleep(1000L);
            }
            System.out.println("[LossyTestThread] sending test echo message on " + this.transport);
            if (CHECK_THROUGHPUT) {
                long T = System.currentTimeMillis() + 1000L;
                int N = 0;
                while (System.currentTimeMillis() < T) {
                    Message m2 = new Message(3003000);
                    m2.append("(lossy test message)");
                    m2 = MessageUtils.bytesToMessage(this.lossy.transactLossy(this.transport, MessageUtils.messageToBytes(m2), 5000));
                    System.out.println("[LossyTestThread]" + m2);
                    ++N;
                }
                System.out.println("[LossyTestThread] able to perform " + N + " transactions per second");
            }
            System.out.println("[LossyTestThread] checking for random transaction lag");
            if (CHECK_LAG) {
                for (i = 0; i < 10; ++i) {
                    m = new Message(3003000);
                    m.append("(lossy test message)");
                    long lagT = System.currentTimeMillis();
                    m = MessageUtils.bytesToMessage(this.lossy.transactLossy(this.transport, MessageUtils.messageToBytes(m), 5000));
                    lagT = System.currentTimeMillis() - lagT;
                    System.out.println("[LossyTestThread] lag = " + lagT);
                    Thread.sleep((int)(4000.0 * Math.random()));
                }
            }
            if (CHECK_GUARANTEED) {
                System.out.println("[LossyTestThread] checking guaranteed delivery");
                this.lossy.SIMULATE_MESSAGE_LOSS = true;
                for (i = 0; i < 20; ++i) {
                    m = new Message(3006000);
                    m.append("(guaranteed test message)");
                    long lagT = System.currentTimeMillis();
                    m = MessageUtils.bytesToMessage(this.lossy.transactGuaranteed(this.transport, MessageUtils.messageToBytes(m)));
                    lagT = System.currentTimeMillis() - lagT;
                    System.out.println("[LossyTestThread] lag = " + lagT);
                    Thread.sleep(3000L);
                }
                this.lossy.SIMULATE_MESSAGE_LOSS = false;
            }
            System.out.println("[LossyTestThread] checking large message delivery");
            this.lossy.SIMULATE_MESSAGE_LOSS = true;
            Message m3 = new Message(3003000);
            for (int i2 = 0; i2 < 1000; ++i2) {
                m3.append(i2);
            }
            this.lossy.transactLossy(this.transport, MessageUtils.messageToBytes(m3), 30000);
            Thread.sleep(20000L);
            this.lossy.transactLossy(this.transport, MessageUtils.messageToBytes(m3), 30000);
            this.lossy.SIMULATE_MESSAGE_LOSS = false;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

