/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.licence;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class LicenseTermsAndConditions {
    public static final int LICENSE_TYPE_OWN_USE = 0;
    public static final int LICENSE_TYPE_SHARED_USE = 1;
    public static final int LICENSE_TYPE_HOSTED_RESALE = 2;
    public static final int LICENSE_TYPE_HOSTED_RESALE_SG_AUTOREPORTED = 3;

    public static void main(String[] args) throws UnsupportedEncodingException, IOException {
        if (args.length != 1) {
            System.err.println("ERROR: The license terms and conditions could not be generated. No destination file found.");
            System.exit(1);
        } else {
            System.out.println("[LicenseTermsAndConditions] Generating terms and conditions");
        }
        File targetFile = new File(args[0]);
        if (targetFile.exists()) {
            targetFile.delete();
        }
        String text = LicenseTermsAndConditions.getTextTerms(0);
        FileOutputStream fout = new FileOutputStream(targetFile);
        fout.write(text.getBytes("ISO-8859-1"));
        fout.close();
    }

    public static String getHtmlTerms(int licenseType) {
        int year = Calendar.getInstance().get(1);
        StringBuffer buffer = new StringBuffer();
        buffer.append("--- License terms and conditions:<br><br>");
        buffer.append("SimpleHelp Copyright (c) " + year + " by SimpleHelp<br>");
        buffer.append("<br>");
        buffer.append("SimpleHelp Ltd reserved all rights granted in this license agreement.<br>");
        buffer.append("<br>");
        buffer.append("<br>");
        buffer.append("--- Your Agreement to this License:<br>");
        buffer.append("<br>");
        buffer.append("By using, copying, transmitting, distributing or installing SimpleHelp, you agree to all of the terms of this agreement (\"License\").<br>");
        buffer.append("<br>");
        buffer.append("Please read the license terms below.  If you do not agree to all of the terms of this License, then do not use, copy, transmit, distribute, or install SimpleHelp.<br>");
        buffer.append("<br>");
        buffer.append("<br>");
        buffer.append("--- Scope of License:<br>");
        buffer.append("<br>");
        buffer.append("All rights of any kind in SimpleHelp which are not expressly granted in this License are entirely and exclusively reserved to and by SimpleHelp.  <br>");
        buffer.append("<br>");
        buffer.append("<br>");
        buffer.append("--- Warranty Disclaimers and Liability Limitations:<br>");
        buffer.append("<br>");
        buffer.append("SimpleHelp, and any and all accompanying software, files, data and materials, are distributed and provided \"AS IS\" and with no warranties of any kind, whether express or implied. You acknowledge that good data processing procedure dictates that any program, including SimpleHelp, must be  thoroughly tested with non-critical data before you rely on it, and you hereby assume the entire risk of using the program. This disclaimer of warranty constitutes an essential part of this License. <br>");
        buffer.append("<br>");
        buffer.append("In no event shall the authors, developers or distributors of this software be liable for damages, including any general, special, incidental, or consequential damages arising from the use or inability to use the software (including but not limited to the loss of data or being rendered inaccurate or losses sustained by you or third parties or failure of the software to operate with any other products), even if such holder or other party has been advised of the possibility of such damages.<br>");
        buffer.append("<br>");
        buffer.append("In addition, in no event are you authorised to use SimpleHelp in applications or systems where SimpleHelp's failure to perform can reasonably be expected to result in a significant physical injury, or in loss of life. Any such use by you is entirely at your own risk, and you agree to hold the authors, developers and distributors harmless from any and all claims or losses relating to such unauthorised use.<br>");
        buffer.append("<br>");
        buffer.append("<br>");
        buffer.append("--- Installation, Usage and Reselling:<br>");
        buffer.append("<br>");
        buffer.append("Purchasing a SimpleHelp license allows you to install the license on the specified number of SimpleHelp servers owned by the purchasing organisation or individual.<br>");
        buffer.append("<br>");
        buffer.append("You may not resell any purchased license.  You may not provide your license to any other organisations or individuals for their own use or for any other reason.  You may not install your purchased license on SimpleHelp servers owned or operated by other organisations or individuals.<br>");
        buffer.append("<br>");
        if (licenseType == 3) {
            buffer.append("The technician client component of your SimpleHelp server may be used by anyone.<br>");
            buffer.append("<br>");
            buffer.append("You may provide access to your SimpleHelp server, in order to run SimpleGateway sessions, as a paid service or as part of a paid service.<br>");
            buffer.append("<br>");
            buffer.append("If you allow others to use any other parts of your SimpleHelp server (such as presentations or SimpleHelp remote support sessions) you may not offer them as a paid service or as part of a paid service.<br>");
            buffer.append("<br>");
            buffer.append("You may only use this license on version 3.12 or later of SimpleHelp.<br>");
            buffer.append("<br>");
        } else if (licenseType == 2) {
            buffer.append("The technician client component of your SimpleHelp server may be used by anyone.<br>");
            buffer.append("<br>");
            buffer.append("You may provide access to your SimpleHelp server as a paid service or as part of a paid service.<br>");
            buffer.append("<br>");
        } else if (licenseType == 1) {
            buffer.append("The technician client component of your SimpleHelp server may be used by anyone.<br>");
            buffer.append("<br>");
            buffer.append("You may not resell use of the technician client to anyone.  You may not provide access to your SimpleHelp server as a paid service or as part of a paid service.<br>");
            buffer.append("<br>");
            buffer.append("In order to check its public availability, check updates and perform other functions not essential to the running of your server, your SimpleHelp server may query pages on the Simple-Help.com website.  In making these checks certain information may be transferred (e.g. your external IP address) but none of the information transferred will expose any details about individual machines or sessions.  You may block these non-essential functions using firewall rules or similar and it will not affect the running of your server.<br>");
            buffer.append("<br>");
        } else {
            buffer.append("The technician client component of your SimpleHelp server may be used only by parties employed by or performing work for you with one exception:<br>");
            buffer.append("<br>");
            buffer.append("If your license does not have unlimited sessions then you may provide access to your SimpleHelp server via the technician account exclusively for the purposes of remote access (not on demand remote support).<br>");
            buffer.append("<br>");
            buffer.append("Any technician accounts used by 3rd parties not employed by or performing work for you must be part of a technician group that is ");
            buffer.append("configured to allow only remote access (the group permissions must be set to disallow remote support, remote presentations or any other usage ");
            buffer.append("other than remote access).<br>");
            buffer.append("<br>");
            buffer.append("If your license does have unlimited sessions and you would like to offer 3rd party remote access please contact us.<br>");
            buffer.append("<br>");
            buffer.append("If you are offering 3rd party remote access and charging for (reselling) its usage directly or as part of a paid service then your license must be in a valid support period.<br>");
            buffer.append("<br>");
            buffer.append("In order to check its public availability, check updates and perform other functions not essential to the running of your server, your SimpleHelp server may query pages on the Simple-Help.com website.  In making these checks certain information may be transferred (e.g. your external IP address) but none of the information transferred will expose any details about individual machines or sessions.  You may block these non-essential functions using firewall rules or similar and it will not affect the running of your server.<br>");
            buffer.append("<br>");
        }
        buffer.append("<br>");
        if (licenseType == 3) {
            buffer.append("--- License billing:<br>");
            buffer.append("<br>");
            buffer.append("As this license is a Hosted Resale license you may continue to use the license only as long as you continue to pay the ongoing usage bills sent to you by SimpleHelp Ltd.<br>");
            buffer.append("<br>");
            buffer.append("The fees for your Hosted Resale license consist of an initial fee and ongoing usage fees.<br>");
            buffer.append("<br>");
            buffer.append("The initial fee is currently $500.  SimpleHelp Ltd may change this at any time but once you have paid your initial fee any changes will not be retroactively applied.<br>");
            buffer.append("<br>");
            buffer.append("The ongoing fees are currently $1 per month for each SimpleGateway Service connected to a SimpleHelp server running your hosted resale license.<br>");
            buffer.append("<br>");
            buffer.append("The minimum ongoing fee is $50 per month.  If you have fewer than 50 SimpleGateway Services connected to any SimpleHelp server actively running your license then we will bill you $50.<br>");
            buffer.append("<br>");
            buffer.append("We may change the ongoing fees or the minimum fee at any time.  If we change these fees we will provide you with 30 days notice of any change.  Any changes we make to these fees apply each month to all SimpleGateway Services, not just SimpleGateway Services newly added since the change.<br>");
            buffer.append("<br>");
            buffer.append("<br>");
            buffer.append("--- Automated usage reporting for billing:<br>");
            buffer.append("<br>");
            buffer.append("Usage of your license on any and all SimpleHelp servers will be automatically reported to us every day and we will bill you each month for the upper limit of the number of machines connected to them during the month billed for.<br>");
            buffer.append("<br>");
            buffer.append("You must ensure that your SimpleHelp server can access the SimpleHelp website (www.simple-help.com and simple-help.com) to report usage information to us.<br>");
            buffer.append("<br>");
            buffer.append("<br>");
            buffer.append("--- Discontinuation and Cancellation of Hosted Resale:<br>");
            buffer.append("<br>");
            buffer.append("We may discontinue the service and revoke your license with 30 days notice.<br>");
            buffer.append("<br>");
            buffer.append("You may discontinue your subscription to the service with 24 hours notice.  We will then revoke your license.<br>");
            buffer.append("<br>");
            buffer.append("If you fail to meet a payment then we may revoke your license without notice at that time or at any time thereafter until all bills have been settled, at which time we will then provide the standard 30 days notice.<br>");
            buffer.append("<br>");
            buffer.append("If your license has been revoked we will notify you by email, it is your responsibility for ensuring you have provided us with an up to date email address.<br>");
            buffer.append("<br>");
            buffer.append("If your license has been revoked you must delete any and all copies of your license and shut down and discontinue use any SimpleHelp servers immediately.<br>");
            buffer.append("<br>");
            buffer.append("<br>");
        } else if (licenseType == 2) {
            buffer.append("--- License expiry and renewal fees:<br>");
            buffer.append("<br>");
            buffer.append("As this license is a Hosted Resale license which requires a renewal fee, the license will expire 12 months from its purchase date. On the date of expiry the license will no longer be valid for use.<br>");
            buffer.append("<br>");
            buffer.append("It is your responsibility to ensure that a renewal license is purchased in advance of the expiry date if you wish to continue using the license.<br>");
            buffer.append("<br>");
            buffer.append("Annual renewal fees are currently $120 (USD) per session.  We may change these fees at any time.<br>");
            buffer.append("<br>");
            buffer.append("A renewal license will expire 12 months from the expiry date of your previous valid hosted resale license.<br>");
            buffer.append("<br>");
            buffer.append("<br>");
        }
        buffer.append("--- Delivery:<br>");
        buffer.append("<br>");
        buffer.append("We will deliver your license to the email address you provide within 48 hours.<br>");
        buffer.append("<br>");
        buffer.append("<br>");
        buffer.append("--- Refunds, Replacement and Cancellation:<br>");
        buffer.append("<br>");
        buffer.append("You may cancel your order at any point up until your license is sent out or payment is taken, whichever is sooner.<br>");
        buffer.append("<br>");
        if (licenseType == 3) {
            buffer.append("If you cancel your order before your license is sent out then we will refund your initial fee.<br>");
            buffer.append("<br>");
            buffer.append("Once we have sent your license out you are subscribed to the Hosted Resale service and discontinuation and cancellation terms apply as described above.<br>");
            buffer.append("<br>");
        }
        buffer.append("Un-sealed computer software is exempt from cancellation under the terms of the Consumer Protection (Distance Selling) Regulations 2000.  We are therefore unable to refund any purchase after a license has been sent out.  Please ensure that you have trialled the software fully and are comfortable it meets your needs before purchasing.<br>");
        buffer.append("<br>");
        buffer.append("If you lose your license you may contact us via our website to request that a new copy be sent out to your email address.  We cannot guarantee to keep licenses on file for more than 30 days from your purchase and we therefore cannot guarantee to send you a replacement copy beyond 30 days from your purchase.<br>");
        buffer.append("<br>");
        buffer.append("<br>");
        buffer.append("--- Support and Updates:<br>");
        buffer.append("<br>");
        if (licenseType == 3) {
            buffer.append("Support and updates to new versions are included as part of the initial fee and ongoing fees.<br>");
            buffer.append("<br>");
            buffer.append("We will not provide support directly to anyone who you are offering SimpleHelp as a paid service or as part of a paid service.  You must act as an intermediary offering them support and we will provide you with support.<br>");
            buffer.append("<br>");
        } else if (licenseType == 2) {
            buffer.append("Support and updates to new versions are included as part of the initial fee and ongoing renewal fee.<br>");
            buffer.append("<br>");
        } else {
            buffer.append("Support and updates are charged and managed as described on our website. Support is email based but we may escalate to telephone support if we believe it necessary.<br>");
            buffer.append("<br>");
            buffer.append("We may change terms and conditions and pricing for updates and support at any time without prior notice.<br>");
            buffer.append("<br>");
        }
        buffer.append("<br>");
        buffer.append("--- General:<br>");
        buffer.append("<br>");
        buffer.append("This License is the complete statement of the agreement between the parties on the subject matter, and merges and supersedes all other or prior understandings, purchase orders, agreements and arrangements.  This License shall be governed by the laws of Scotland (UK).  Exclusive jurisdiction and venue for all matters relating to this License shall be in courts and fora located in Scotland (UK), and you consent to such jurisdiction and venue.  There are no third party beneficiaries of any promises, obligations or representations made by SimpleHelp Ltd herein.  Any waiver by SimpleHelp Ltd of any violation of this License by you shall not constitute or contribute to a waiver of any other or future violation by you of the same provision, or any other provision, of this License. <br>");
        buffer.append("<br>");
        buffer.append("Copyright (c) " + new GregorianCalendar().get(1) + " by SimpleHelp Ltd.  All rights reserved.<br>");
        buffer.append("<br>");
        return buffer.toString();
    }

    public static String getTextTerms(int licenseType) {
        String terms = LicenseTermsAndConditions.getHtmlTerms(licenseType);
        return terms.replaceAll("<br>", "\r\n");
    }
}

