/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.licence;

import bcutil.BCUtil;
import com.aem.BuildDate;
import com.aem.shelp.licence.LicenseRevoker;
import com.aem.utils.StreamUtils;
import com.aem.utils.blowfish.Blowfish;
import com.aem.utils.crc.CRC32;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import utils.message.TypedMap;
import utils.progtools.date.DateUtil;
import utils.progtools.time.Times;
import utils.string.HexData;
import utils.string.Padder;
import utils.string.Sanitiser;
import utils.switches.Switches;

public class License {
    public static final int ALERT_LIMIT_BIZ = 5000;
    public static final int ALERT_LIMIT_ENT = Integer.MAX_VALUE;
    public static final int PLAN_1_ATTENDEES_FACTOR = 3;
    public static final int PLAN_2_ATTENDEES_FACTOR = 5;
    public static final int ALERTS_LICENSE_FACTOR = 50;
    public static final int SESSIONS_REQUIRED_FOR_CONDENSER = 20;
    public static final String TYPED_PROPERTIES_MAP = "typed_properties_map";
    public static final int LATEST_LICENSE_VER = 2;
    private static final String ISTRIAL = "istrial";
    private static final String V2STD = "licV2std";
    private static final String V2BIZ = "licV2biz";
    private static final String V2ENT = "licV2ent";
    private static final String DATEMS = "datems";
    private static final String EXPIRYMS = "expiryms";
    private static final String PURCHASEMS = "purchasems";
    private static final String YEARS_SUPPORT = "yrs";
    private static final String FILEVER = "filever";
    private static final String LICENSEPLANVER = "licenseplanver";
    private static final String RESELLERNAME = "resellername";
    private static final String ID_RESELLER = "id_reseller";
    private static final String ID_ACCOUNT = "id_account";
    private static final String ID_LICENSE = "id_license";
    private static final String EMAILLIST = "emaillist";
    private static final String ALERTLIMIT = "alertlimit";
    private static final String MACHINELIMIT = "machinelimit";
    private static final String MASSNOTIFY = "massnotify";
    private static final String MASSTOOLBOX = "masstoolbox";
    private static final String PROVIDER = "provider";
    private static final String ATTENDEES = "attendees";
    private static final String TUNNELS = "tunnels";
    private static final String RADIUS = "radius";
    private static final String NAME = "name";
    private static final String COMPANY = "company";
    private static final String DATE = "date";
    private static final String SESSIONS = "sessions";
    private static final String COMMERCIALUSE = "commercial";
    private static final String EMAIL = "email";
    private static final String EXPIRY = "expiry";
    private static final String NOTES = "notes";
    private static final String HIDDEN = "hidden";
    private static final String REBRANDING = "rebranding";
    private static final String REBRANDDIR = "rebranddir";
    private static final String PRODUCT = "product";
    private static final String TYPE = "type";
    private static final String REMOTEMACHINES = "remotemachines";
    private static final String DEMOATTENDEES = "demoattendees";
    private static final String REPORTSTATS = "reportstats";
    private static final String MONITORONLY = "monitoronly";
    private static final String SECURE_RANDOM = "secrandom";
    private static final String ALLOWSMANAGEMENT = "allowsmanagement";
    public static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
    private byte[] rawLicenseUnencData;
    private byte[] rawLicenseEncData;
    private byte[] recoveryHash;
    static int MAGIC = 18672734;
    static String KEY = "123bh j21b3jhk12j3 b19-(**()^b h123-98uj(PUnhj io2u1-)*(*(^(*&^%%6gv ig79%&^G (7g79 G&GB& g(& &( (&G &(T BUBGds96td67sg 7y2b97 342;4kjp 89*U(*";
    Properties oprops = new Properties();
    TypedMap tprops = new TypedMap();

    public void setLicenseRawEncData(byte[] raw) {
        this.rawLicenseEncData = (byte[])raw.clone();
    }

    public void setLicenseRawUnencData(byte[] raw) {
        this.rawLicenseUnencData = (byte[])raw.clone();
    }

    public byte[] getRecoveryHash() {
        if (this.recoveryHash != null) {
            return this.recoveryHash;
        }
        byte[] dat = new byte[this.rawLicenseUnencData.length + this.rawLicenseEncData.length];
        System.arraycopy(this.rawLicenseUnencData, 0, dat, 0, this.rawLicenseUnencData.length);
        System.arraycopy(this.rawLicenseEncData, 0, dat, this.rawLicenseUnencData.length, this.rawLicenseEncData.length);
        System.out.println("[LicenseConfig] Generating recovery hash");
        this.recoveryHash = BCUtil.getSha256Sha3HashOf(dat);
        return this.recoveryHash;
    }

    public static void main(String[] args) throws IOException {
        License l = License.read(new File("/Users/gchristelis/Desktop/shlicense-new.txt"));
        System.out.println(l.supportsServerBuild("20200101"));
    }

    private String strOrEmpty(String str) {
        if (str.trim().length() > 0) {
            return str;
        }
        return "(empty)";
    }

    public String getLicenseTypeString() {
        if (this.isVersion2Enterprise()) {
            return "Enterprise";
        }
        if (this.isVersion2Business()) {
            return "Business";
        }
        if (this.isVersion2Standard()) {
            return "Standard";
        }
        if (this.allowsV1Management()) {
            return "Remote Management";
        }
        return "Classic";
    }

    public String getLicenseDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("SimpleHelp ").append(this.getSessions());
        if (this.isVersion2Enterprise()) {
            sb.append(" (Enterprise)");
        } else if (this.isVersion2Business()) {
            sb.append(" (Business)");
        } else if (this.isVersion2Standard()) {
            sb.append(" (Standard)");
        } else if (this.allowsV1Management()) {
            sb.append(" (Remote Management)");
        } else {
            sb.append(" (Classic)");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Valid SH ");
        if (this.isVersion2Enterprise()) {
            sb.append("Plan 2 Enterprise");
        } else if (this.isVersion2Business()) {
            sb.append("Plan 2 Business");
        } else if (this.isVersion2Standard()) {
            sb.append("Plan 2 Standard");
        } else if (this.allowsV1Management()) {
            sb.append("Plan 1 Management");
        } else {
            sb.append("Plan 1 Standard");
        }
        sb.append(" License (V" + this.getFileVersion() + ")");
        sb.append("\n");
        sb.append(Padder.pad("\tName: ", 12) + this.strOrEmpty(this.getName()) + "\n");
        sb.append(Padder.pad("\tCompany: ", 12) + this.strOrEmpty(this.getCompany()) + "\n");
        sb.append(Padder.pad("\tEmail: ", 12) + this.strOrEmpty(this.getEmail()) + "\n");
        sb.append(Padder.pad("\tSessions: ", 12) + this.getSessions() + "\n");
        sb.append(Padder.pad("\tCreated: ", 12) + this.getSupportStartFormattedYMD() + "\n");
        if (this.getExpiryFormattedYMD().length() > 0) {
            sb.append(Padder.pad("\tExpires: ", 12) + this.getExpiryFormattedYMD() + "\n");
        }
        return sb.toString();
    }

    public String toFullString() {
        Object[] olds;
        StringBuilder sb = new StringBuilder();
        sb.append("License File Format: V" + this.getFileVersion());
        sb.append("\nLicense Plan Version: Plan " + this.getLicensePlanVersion());
        sb.append("\n");
        if (this.isVersion2Enterprise()) {
            sb.append("\nType: Plan 2 Enterprise");
        } else if (this.isVersion2Business()) {
            sb.append("\nType: Plan 2 Business");
        } else if (this.isVersion2Standard()) {
            sb.append("\nType: Plan 2 Standard");
        } else if (this.allowsV1Management()) {
            sb.append("\nType: Plan 1 Management");
        } else {
            sb.append("\nType: Plan 1 Standard");
        }
        sb.append("\n");
        if (this.allowsAlerts()) {
            sb.append("\nAllows Alerts: yes");
        } else {
            sb.append("\nAllows Alerts: no");
        }
        if (this.allowsMassToolbox()) {
            sb.append("\nAllows Mass Toolbox: yes");
        } else {
            sb.append("\nAllows Mass Toolbox: no");
        }
        if (this.allowsMassNotify()) {
            sb.append("\nAllows Mass Notify: yes");
        } else {
            sb.append("\nAllows Mass Notify: no");
        }
        if (this.allowsRebranding()) {
            sb.append("\nAllows Rebranding: yes");
        } else {
            sb.append("\nAllows Rebranding: no");
        }
        if (this.allowsRadius()) {
            sb.append("\nAllows RADIUS: yes");
        } else {
            sb.append("\nAllows RADIUS: no");
        }
        sb.append("\n");
        sb.append("\nCustomer ID: " + this.getV2CustomerAccountID());
        sb.append("\nReseller ID: " + this.getV2ResellerID());
        sb.append("\nLicense ID: " + this.getV2LicenseID());
        sb.append("\n");
        sb.append("\nName: " + this.strOrEmpty(this.getName()));
        sb.append("\nCompany: " + this.strOrEmpty(this.getCompany()));
        sb.append("\nPrimary Email: " + this.strOrEmpty(this.getEmail()));
        ArrayList<String> emails = this.getAssociatedEmails();
        sb.append("\nAssociated Emails (n=" + emails.size() + "):");
        for (String email : emails) {
            sb.append("\n-- Email: " + email);
        }
        sb.append("\n");
        if (this.isTrial()) {
            sb.append("\nTrial: yes");
        } else {
            sb.append("\nTrial: no");
        }
        sb.append("\nSessions: " + this.getSessions());
        sb.append("\nAlert Limit: " + this.getAlertLimit());
        sb.append("\nMachine Limit: " + this.getMachineLimit());
        sb.append("\nMass Notify: " + this.allowsMassNotify());
        sb.append("\nMass Toolbox: " + this.allowsMassToolbox());
        sb.append("\nCreated: " + this.getSupportStartFormattedYMD() + " (" + this.getSupportStartMS() + ")");
        if (this.getExpiryFormattedYMD().length() > 0) {
            sb.append("\nExpires: " + this.getExpiryFormattedYMD() + " (" + this.getExpiryMs() + ")");
        } else {
            sb.append("\nExpires: (never)");
        }
        sb.append("\nPresentation: x" + this.getDemoAttendees());
        sb.append("\n");
        sb.append("\nReseller ref: " + this.getOldReportStatsReference());
        sb.append("\nNotes: " + this.strOrEmpty(this.getNotes()));
        if (this.getSecRandom() != null) {
            sb.append("\nSecRandom: ").append(8 * (this.getSecRandom().length() / 2)).append(" bits");
        }
        sb.append("\n");
        sb.append("\nV2 Keys: " + this.map().getAllKeys().size());
        sb.append("\nV1 Keys: " + this.old().size());
        sb.append("\n");
        for (Object old : olds = this.old().keySet().toArray()) {
            Object val = this.old().get(old);
            sb.append("\n(V1 prop) " + old + ": " + val);
        }
        sb.append("\n");
        sb.append(this.map());
        sb.append("\n");
        return sb.toString();
    }

    private static int getSecondIndexOf(String main, String subString, boolean backwards) {
        if (!backwards) {
            int first = main.indexOf(subString);
            return main.indexOf(subString, first + 1);
        }
        int last = main.lastIndexOf(subString);
        return main.lastIndexOf(subString, last - 1);
    }

    public static byte[] getBytesFromHex(String s) throws IOException {
        char[] chars;
        s = s.toUpperCase();
        int begin = License.getSecondIndexOf(s, "::", false);
        int end = License.getSecondIndexOf(s, "::", true);
        if (begin == -1 || end == -1) {
            throw new IOException("Not a SimpleHelp license file");
        }
        s = s.substring(begin + "::".length(), end);
        StringBuilder sb = new StringBuilder();
        for (char aChar : chars = s.toCharArray()) {
            if ((aChar < '0' || aChar > '9') && (aChar < 'A' || aChar > 'F')) continue;
            sb.append(aChar);
        }
        return HexData.hexStringToByteArray(sb.toString());
    }

    public static String readInfoOnly(File f) throws IOException {
        FileInputStream fin = new FileInputStream(f);
        String hex = StreamUtils.readAllAsStringISO88951(fin);
        fin.close();
        byte[] orig = License.getBytesFromHex(hex);
        License tmp = License.read(orig, false);
        return tmp.toString();
    }

    public static License readLicenseWithoutFailure(File f) throws IOException {
        FileInputStream fin = new FileInputStream(f);
        String hex = StreamUtils.readAllAsStringISO88951(fin);
        fin.close();
        byte[] orig = License.getBytesFromHex(hex);
        License tmp = License.read(orig, false);
        return tmp;
    }

    public static License readLicenseWithoutFailure(byte[] fileData) throws IOException {
        String hex = new String(fileData, "ISO-8859-1");
        byte[] orig = License.getBytesFromHex(hex);
        License tmp = License.read(orig, false);
        return tmp;
    }

    public static License read(File f) throws IOException {
        FileInputStream fin = new FileInputStream(f);
        String hex = StreamUtils.readAllAsStringISO88951(fin);
        fin.close();
        byte[] orig = License.getBytesFromHex(hex);
        License tmp = License.read(orig);
        tmp.setLicenseRawEncData(orig);
        return tmp;
    }

    public static License readAny(File f) throws IOException {
        FileInputStream fin = new FileInputStream(f);
        String hex = StreamUtils.readAllAsStringISO88951(fin);
        fin.close();
        byte[] orig = License.getBytesFromHex(hex);
        return License.read(orig);
    }

    public static License read(String hex) throws IOException {
        byte[] orig = License.getBytesFromHex(hex);
        return License.read(orig);
    }

    public static License read(byte[] orig) throws IOException {
        return License.read(orig, true);
    }

    private static License read(byte[] orig, boolean throwErrors) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(orig);
        int magic = StreamUtils.readInt(in);
        if (magic != MAGIC) {
            throw new IOException("Not a SimpleHelp license file");
        }
        byte[] dat = StreamUtils.readAll(in);
        Blowfish bf = new Blowfish();
        try {
            bf.init(KEY);
            dat = bf.decryptSecure(dat, 0, true);
        }
        catch (Throwable t) {
            try {
                bf.init(KEY);
                dat = bf.decryptOld(dat, 0);
                CRC32 crc = new CRC32();
                crc.add(dat);
                int crc32 = crc.getVal32();
                boolean allowed = false;
                if (!allowed) {
                    throw new IOException("Not a SimpleHelp license file");
                }
            }
            catch (Throwable tt) {
                throw new IOException("Not a SimpleHelp license file");
            }
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(dat);
        magic = StreamUtils.readInt(bin);
        if (magic != MAGIC) {
            throw new IOException("Not a SimpleHelp license file");
        }
        try {
            License lic = new License();
            lic.setLicenseRawUnencData(dat);
            int len = StreamUtils.readInt(bin);
            Properties merged = new Properties();
            for (int i = 0; i < len; ++i) {
                String key = StreamUtils.readNStringISO88591(bin, 1000000);
                String val = StreamUtils.readNStringISO88591(bin, 1000000);
                merged.setProperty(key, val);
            }
            if (merged.getProperty(TYPED_PROPERTIES_MAP) != null) {
                lic.tprops = TypedMap.fromHex((String)merged.remove(TYPED_PROPERTIES_MAP));
            }
            lic.oprops = merged;
            boolean revoked = LicenseRevoker.isRevoked(lic);
            if (revoked && throwErrors) {
                throw new RevokedException("License is revoked.");
            }
            if (lic.isExpired() && throwErrors) {
                throw new ExpiredException("License expired on " + lic.getExpiryFormattedYMD() + ".");
            }
            return lic;
        }
        catch (ExpiredException e) {
            System.out.println(e.getMessage());
            throw new ExpiredException("Invalid license: " + e.getMessage());
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            throw new IOException("Invalid license: " + e.getMessage());
        }
    }

    public boolean supportsServerBuild() {
        if (Switches.SH_use50LicensingDate) {
            return this.supportsServerBuild("20170703");
        }
        return this.supportsServerBuild(BuildDate.YMD);
    }

    public boolean supportsServerBuild(String yyyyMMddBuildDate) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            Date buildDate = sdf.parse(yyyyMMddBuildDate);
            long buildDateMS = buildDate.getTime();
            return buildDateMS <= this.getSupportFinishMs();
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
            return false;
        }
    }

    public void setMandatory(boolean standard, boolean business, boolean enterprise, int licensePlanVersion, String id_reseller, String id_account) {
        long datems = System.currentTimeMillis();
        if (licensePlanVersion == 1) {
            System.out.println("[LicenseGeneration] License plan V1 specified, ignoring std/biz/ent");
        } else if (enterprise) {
            this.setLicenseV2Enterprise(true);
            System.out.println("[LicenseGeneration] V2 Enterprise");
        } else if (business) {
            this.setLicenseV2Business(true);
            System.out.println("[LicenseGeneration] V2 Business");
        } else if (standard) {
            this.setLicenseV2Standard(true);
            System.out.println("[LicenseGeneration] V2 Standard");
        } else {
            licensePlanVersion = 1;
            System.out.println("[LicenseGeneration] No V2 type specified, assuming license plan V1");
        }
        this.setFileVersion(2);
        this.setLicensePlanVersion(licensePlanVersion);
        byte[] dat = new byte[48];
        BCUtil.getSecureRandom().nextBytes(dat);
        this.setSecRandom(HexData.byteArrayToHexString(dat));
        this.setSupportStartMs(datems);
        this.setPurchaseDateMs(datems);
        this.setLicenseID(Math.abs(BCUtil.getSecureRandom().nextLong()));
        this.setCustomerAccountID(id_account);
        this.setResellerID(id_reseller);
        this.old().setProperty(PRODUCT, "SimpleSuite");
        this.old().setProperty(COMMERCIALUSE, "true");
        this.old().setProperty(REBRANDDIR, "");
        this.old().setProperty(HIDDEN, "");
        this.old().setProperty(REPORTSTATS, "");
        this.old().setProperty(REBRANDDIR, "");
        this.old().setProperty(NOTES, "");
    }

    public ArrayList<String> getAssociatedEmails() {
        String email;
        ArrayList<String> emails = this.map().getStringList(EMAILLIST);
        if (emails == null) {
            emails = new ArrayList();
        }
        if ((email = this.getEmail()).trim().length() > 0 && !emails.contains(email)) {
            emails.add(email);
        }
        for (int i = 0; i < emails.size(); ++i) {
            String email2 = emails.get(i);
            email2 = email2.trim();
            while (email2.endsWith(";") || email2.endsWith(",") || email2.endsWith(" ")) {
                email2 = email2.substring(0, email2.length() - 1);
            }
            while (email2.startsWith(";") || email2.startsWith(",") || email2.endsWith(" ")) {
                email2 = email2.substring(1);
            }
            emails.set(i, email2);
        }
        return emails;
    }

    public void addAssociatedEmailIfUnique(String email) {
        ArrayList<String> emails = this.map().getStringList(EMAILLIST);
        if (emails == null) {
            emails = new ArrayList();
        }
        if (!emails.contains(email)) {
            emails.add(email);
            this.map().setStringList(EMAILLIST, emails);
        }
    }

    public boolean isMassNotifyExceptionSet() {
        if (!this.map().has(MASSNOTIFY)) {
            return false;
        }
        return this.map().getBoolean(MASSNOTIFY);
    }

    public boolean isMassToolboxExceptionSet() {
        if (!this.map().has(MASSTOOLBOX)) {
            return false;
        }
        return this.map().getBoolean(MASSTOOLBOX);
    }

    public boolean isProviderExceptionSet() {
        if (!this.map().has(PROVIDER)) {
            return false;
        }
        return this.map().getBoolean(PROVIDER);
    }

    public boolean isRadiusExceptionSet() {
        if (!this.map().has(RADIUS)) {
            return false;
        }
        return this.map().getBoolean(RADIUS);
    }

    public void setMassNotifyException(boolean allowed) {
        this.map().setBoolean(MASSNOTIFY, allowed);
    }

    public void setMassToolboxException(boolean allowed) {
        this.map().setBoolean(MASSTOOLBOX, allowed);
    }

    public boolean allowsMassNotify() {
        if (this.isVersion2Business() || this.isVersion2Enterprise()) {
            return true;
        }
        return this.map().contains(MASSNOTIFY) && this.map().getBoolean(MASSNOTIFY);
    }

    public boolean allowsMassToolbox() {
        if (this.isVersion2Business() || this.isVersion2Enterprise()) {
            return true;
        }
        if (this.isVersion2Standard()) {
            return false;
        }
        if (this.map().contains(MASSNOTIFY) && this.map().getBoolean(MASSNOTIFY)) {
            return true;
        }
        return this.allowsV1Management();
    }

    public void setMachineLimitException(int machines) {
        this.map().setInt(MACHINELIMIT, machines);
    }

    public int getMachineLimit() {
        if (this.map().contains(MACHINELIMIT)) {
            return this.map().getInt(MACHINELIMIT);
        }
        if (this.isVersion2Standard()) {
            return 1000;
        }
        if (this.isVersion2Business()) {
            return 1000000000;
        }
        if (this.isVersion2Enterprise()) {
            return 1000000000;
        }
        return 1000000000;
    }

    public void setRadiusException(boolean allowRadius) {
        this.map().setBoolean(RADIUS, allowRadius);
    }

    public boolean allowsRadius() {
        if (this.map().contains(RADIUS)) {
            return this.map().getBoolean(RADIUS);
        }
        return this.isVersion2Enterprise() || this.isPlan1Management() || this.isPlan1Standard();
    }

    public void setTunnelsException(boolean allowTunnels) {
        this.map().setBoolean(TUNNELS, allowTunnels);
    }

    public boolean allowsTunnels() {
        if (this.map().contains(TUNNELS)) {
            return this.map().getBoolean(TUNNELS);
        }
        return this.isVersion2Business() || this.isVersion2Enterprise();
    }

    public void setAlertLimitException(int alerts) {
        this.map().setInt(ALERTLIMIT, alerts);
    }

    public boolean allowsAlerts() {
        return this.getAlertLimit() > 0;
    }

    public int getAlertLimit() {
        if (this.map().contains(ALERTLIMIT)) {
            return this.map().getInt(ALERTLIMIT);
        }
        if (this.isVersion2Standard()) {
            return 0;
        }
        if (this.isVersion2Business()) {
            return 5000;
        }
        if (this.isVersion2Enterprise()) {
            return 1000000000;
        }
        if (this.allowsV1Management()) {
            return this.getSessions() * 50;
        }
        return 0;
    }

    public void setProviderException(boolean b) {
        this.map().setBoolean(PROVIDER, b);
    }

    public boolean allowsProvider() {
        if (this.map().contains(PROVIDER)) {
            return this.map().getBoolean(PROVIDER);
        }
        return this.isVersion2Business() || this.isVersion2Enterprise();
    }

    public void setCustomerAccountID(String id) {
        this.map().setString(ID_ACCOUNT, id);
    }

    public void setResellerID(String id) {
        this.map().setString(ID_RESELLER, id);
    }

    public void setLicenseID(long id) {
        this.map().setLong(ID_LICENSE, id);
    }

    public long getV2LicenseID() {
        if (this.map().contains(ID_LICENSE)) {
            return this.map().getLong(ID_LICENSE);
        }
        return 0L;
    }

    public String getV2ResellerID() {
        if (this.map().contains(ID_RESELLER)) {
            try {
                return this.map().getString(ID_RESELLER);
            }
            catch (ClassCastException x) {
                return "0";
            }
        }
        return "0";
    }

    public String getV2CustomerAccountID() {
        if (this.map().contains(ID_ACCOUNT)) {
            try {
                return this.map().getString(ID_ACCOUNT);
            }
            catch (ClassCastException x) {
                return "0";
            }
        }
        return "0";
    }

    public void setTrial(boolean b, long expiryMs) {
        this.map().setBoolean(ISTRIAL, b);
        this.setExpiryMs(expiryMs);
    }

    public boolean isPlan1Standard() {
        return this.getLicensePlanVersion() == 1 && !this.allowsV1Management();
    }

    public boolean isPlan1Management() {
        return this.getLicensePlanVersion() == 1 && this.allowsV1Management();
    }

    public boolean isVersion2Standard() {
        try {
            return this.map().getBoolean(V2STD);
        }
        catch (Exception x) {
            return false;
        }
    }

    public boolean isVersion2Business() {
        try {
            return this.map().getBoolean(V2BIZ);
        }
        catch (Exception x) {
            return false;
        }
    }

    public boolean isVersion2Enterprise() {
        try {
            return this.map().getBoolean(V2ENT);
        }
        catch (Exception x) {
            return false;
        }
    }

    public void setLicenseV2Standard(boolean b) {
        if (b) {
            this.map().setBoolean(V2STD, true);
        }
    }

    public void setLicenseV2Business(boolean b) {
        if (b) {
            this.map().setBoolean(V2BIZ, true);
        }
    }

    public void setLicenseV2Enterprise(boolean b) {
        if (b) {
            this.map().setBoolean(V2ENT, true);
        }
    }

    public String getSupportStartFormattedYMD() {
        return sdf.format(new Date(this.getSupportStartMS()));
    }

    public long getSupportStartMS() {
        if (this.map().contains(DATEMS)) {
            return this.map().getLong(DATEMS);
        }
        try {
            return sdf.parse(this.getOldDateString().trim()).getTime();
        }
        catch (Exception x) {
            return 0L;
        }
    }

    public void setSupportStartMs(long ms) {
        this.map().setLong(DATEMS, ms);
        this.setOldDateString(sdf.format(new Date(ms)));
    }

    public String getPurchaseDateFormattedYMD() {
        return sdf.format(new Date(this.getPurchaseDateMS()));
    }

    public long getPurchaseDateMS() {
        if (this.map().contains(PURCHASEMS)) {
            return this.map().getLong(PURCHASEMS);
        }
        return this.getSupportStartMS();
    }

    public void setPurchaseDateMs(long ms) {
        this.map().setLong(PURCHASEMS, ms);
    }

    public void setYearsSupport(int years) {
        this.map().setInt(YEARS_SUPPORT, years);
    }

    public int getYearsSupport() {
        if (this.map().contains(YEARS_SUPPORT)) {
            return this.map().getInt(YEARS_SUPPORT);
        }
        return 1;
    }

    public String getSupportFinishFormattedYMD() {
        return sdf.format(new Date(this.getSupportFinishMs()));
    }

    public long getSupportFinishMs() {
        return this.getSupportStartMS() + (long)this.getYearsSupport() * Times.ONE_DAY * 366L;
    }

    public String getExpiryFormattedYMD() {
        if (this.getExpiryMs() == Long.MAX_VALUE) {
            return "";
        }
        return sdf.format(new Date(this.getExpiryMs()));
    }

    public long getExpiryMs() {
        if (this.map().contains(EXPIRYMS)) {
            return this.map().getLong(EXPIRYMS);
        }
        try {
            return sdf.parse(this.getOldExpiryString().trim()).getTime();
        }
        catch (Exception x) {
            return Long.MAX_VALUE;
        }
    }

    public void setExpiryMs(long ms) {
        this.map().setLong(EXPIRYMS, ms);
        this.setOldExpiryString(sdf.format(new Date(ms)));
    }

    public int getFileVersion() {
        if (this.map().contains(FILEVER)) {
            return this.map().getInt(FILEVER);
        }
        return 1;
    }

    public void setFileVersion(int ver) {
        this.map().setInt(FILEVER, ver);
    }

    public int getLicensePlanVersion() {
        if (this.map().contains(LICENSEPLANVER)) {
            return this.map().getInt(LICENSEPLANVER);
        }
        return 1;
    }

    public void setLicensePlanVersion(int ver) {
        this.map().setInt(LICENSEPLANVER, ver);
    }

    public void setDemoAttendeesException(int attendees) {
        this.map().setInt(ATTENDEES, attendees);
    }

    public int getDemoAttendees() {
        if (this.map().contains(ATTENDEES)) {
            return this.map().getInt(ATTENDEES);
        }
        if (this.getLicensePlanVersion() == 2) {
            if (this.isVersion2Enterprise()) {
                return Integer.MAX_VALUE;
            }
            if (this.isVersion2Business()) {
                return Integer.MAX_VALUE;
            }
            if (this.isVersion2Standard()) {
                return Integer.MAX_VALUE;
            }
            return 5;
        }
        try {
            String s = this.old().getProperty(DEMOATTENDEES);
            if (s == null || s.trim().length() == 0) {
                return this.getSessions() * 3;
            }
            return Integer.parseInt(s);
        }
        catch (Throwable throwable) {
            return this.getSessions() * 3;
        }
    }

    public long getBuildDate() {
        try {
            String build = BuildDate.YMD + "-" + BuildDate.HMS;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");
            return sdf.parse(build).getTime();
        }
        catch (Throwable throwable) {
            return Long.MAX_VALUE;
        }
    }

    public boolean isOutOfSupport() {
        if (this.isTrial()) {
            return System.currentTimeMillis() > this.getExpiryMs();
        }
        return System.currentTimeMillis() > this.getSupportFinishMs();
    }

    public boolean hasExpiry() {
        return this.getExpiryMs() < Long.MAX_VALUE;
    }

    public boolean isExpired() {
        long exp = this.getExpiryMs();
        if (this.getBuildDate() > exp) {
            return true;
        }
        return System.currentTimeMillis() > exp;
    }

    public boolean isTrial() {
        long creationMS;
        if (this.map().contains(ISTRIAL)) {
            return this.map().getBoolean(ISTRIAL);
        }
        if (!this.old().containsKey(EXPIRY)) {
            return false;
        }
        long expiryMS = this.getExpiryMs();
        return DateUtil.getDaysBetween(expiryMS, creationMS = this.getSupportStartMS()) < 186;
    }

    public String getName() {
        if (this.map().contains(NAME)) {
            return this.map().getString(NAME);
        }
        if (this.old().containsKey(NAME)) {
            return this.old().getProperty(NAME);
        }
        return "";
    }

    public void setName(String name) {
        this.map().setString(NAME, name);
        this.old().setProperty(NAME, Sanitiser.sanitiseAscii(name));
    }

    public String getNotes() {
        if (this.map().contains(NOTES)) {
            return this.map().getString(NOTES);
        }
        if (this.old().containsKey(NOTES)) {
            return this.old().getProperty(NOTES);
        }
        return "";
    }

    public void setNotes(String notes) {
        this.map().setString(NOTES, notes);
        this.old().setProperty(NOTES, Sanitiser.sanitiseAscii(notes));
    }

    public String getEmail() {
        if (this.map().contains(EMAIL)) {
            return this.map().getString(EMAIL);
        }
        if (this.old().containsKey(EMAIL)) {
            return this.old().getProperty(EMAIL);
        }
        return "";
    }

    public void setEmail(String name) {
        if (name == null) {
            name = "";
        }
        this.map().setString(EMAIL, name);
        this.old().setProperty(EMAIL, Sanitiser.sanitiseAscii(name));
    }

    public String getCompany() {
        if (this.map().contains(COMPANY)) {
            return this.map().getString(COMPANY);
        }
        if (this.old().containsKey(COMPANY)) {
            return this.old().getProperty(COMPANY);
        }
        return "";
    }

    public void setCompany(String comp) {
        if (comp == null) {
            comp = "";
        }
        this.map().setString(COMPANY, comp);
        this.old().setProperty(COMPANY, Sanitiser.sanitiseAscii(comp));
    }

    public void setResellerName(String reseller) {
        this.map().setString(RESELLERNAME, reseller);
        this.old().setProperty(REPORTSTATS, Sanitiser.sanitiseAscii(reseller));
    }

    public String getResellerName() {
        if (this.map().contains(RESELLERNAME)) {
            return this.map().getString(RESELLERNAME);
        }
        return this.getOldReportStatsReference();
    }

    public String getOldReportStatsReference() {
        return this.old().getProperty(REPORTSTATS);
    }

    public void setOldDateString(String date) {
        this.old().setProperty(DATE, date);
    }

    private String getOldDateString() {
        return this.old().getProperty(DATE);
    }

    public void setOldExpiryString(String date) {
        this.old().setProperty(EXPIRY, date);
    }

    private String getOldExpiryString() {
        return this.old().getProperty(EXPIRY);
    }

    public void setLicensePlanV1AllowsManagement(boolean b) {
        if (b) {
            this.old().setProperty(ALLOWSMANAGEMENT, "true");
        }
    }

    public boolean allowsV1Management() {
        if (this.isVersion2Business() || this.isVersion2Enterprise()) {
            return true;
        }
        try {
            if (this.old().get(ALLOWSMANAGEMENT) != null && this.old().get(ALLOWSMANAGEMENT).toString().length() > 0) {
                return Boolean.parseBoolean(this.old().get(ALLOWSMANAGEMENT).toString());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public boolean allowsRebranding() {
        try {
            return this.map().getBoolean(REBRANDING);
        }
        catch (Exception x) {
            try {
                String val;
                if (this.old().get(REBRANDING) != null && (val = this.old().get(REBRANDING).toString().trim()).length() > 0) {
                    return !val.trim().equalsIgnoreCase("false") && !val.trim().equalsIgnoreCase("no");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }
    }

    public void setAllowRebranding(boolean b) {
        this.map().setBoolean(REBRANDING, b);
        if (b) {
            this.old().setProperty(REBRANDING, "" + b);
        }
    }

    public int getSessions() {
        if (this.map().contains(SESSIONS)) {
            return this.map().getInt(SESSIONS);
        }
        return Integer.parseInt(this.old().getProperty(SESSIONS));
    }

    public void setSessions(int count) {
        this.map().setInt(SESSIONS, count);
        this.old().setProperty(SESSIONS, count + "");
    }

    public String getSecRandom() {
        if (this.map().contains(SECURE_RANDOM)) {
            return this.map().getString(SECURE_RANDOM);
        }
        return this.old().getProperty(SECURE_RANDOM);
    }

    public void setSecRandom(String secRandom) {
        this.map().setString(SECURE_RANDOM, secRandom);
        this.old().setProperty(SECURE_RANDOM, secRandom);
    }

    public boolean isTypeOwn() {
        try {
            if (this.old().get(TYPE) != null && this.old().get(TYPE).toString().length() > 0) {
                return this.old().get(TYPE).toString().trim().equalsIgnoreCase("own use");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public boolean isMonitoringOnly() {
        try {
            if (this.old().get(MONITORONLY) != null && this.old().get(MONITORONLY).toString().length() > 0) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static License fromBytes(byte[] dat) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(dat);
        Properties merged = new Properties();
        merged.load(bin);
        License lic = new License();
        if (merged.getProperty(TYPED_PROPERTIES_MAP) != null) {
            lic.tprops = TypedMap.fromHex((String)merged.remove(TYPED_PROPERTIES_MAP));
        }
        lic.oprops = merged;
        return lic;
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Properties props = (Properties)this.old().clone();
        props.setProperty(TYPED_PROPERTIES_MAP, this.map().toHex());
        props.store(bout, "");
        return bout.toByteArray();
    }

    private TypedMap map() {
        return this.tprops;
    }

    private Properties old() {
        return this.oprops;
    }

    private String getFromOldMap(String key) {
        return this.oprops.getProperty(key);
    }

    public Properties getMergedPropertiesForSave() {
        Properties props = (Properties)this.old().clone();
        props.setProperty(TYPED_PROPERTIES_MAP, this.map().toHex());
        return props;
    }

    public static class ExpiredException
    extends IOException {
        ExpiredException(String message) {
            super(message);
        }
    }

    private static class RevokedException
    extends IOException {
        RevokedException(String message) {
            super(message);
        }
    }
}

