/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.customer.details;

import com.aem.shelp.customer.details.DetailsListener;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import utils.swing.cui.layouts.CUIHorizontalPanel;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.ResultPair;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.types.fields.TextField;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.images.ImageLoader;

public class DetailsPanel
extends JPanel
implements ActionListener,
KeyListener {
    JButton bok;
    DetailsListener listener;
    JTextField focusField = null;
    ResourceBundle lang;
    CUIHorizontalPanel panel;
    TextField passwordField;
    AbstractField.ChangeListener changeListener = new AbstractField.ChangeListener(){

        @Override
        public void changed(AbstractField source) {
            if (DetailsPanel.this.panel.isValid()) {
                DetailsPanel.this.bok.setEnabled(true);
            } else {
                DetailsPanel.this.bok.setEnabled(false);
            }
        }
    };

    public DetailsPanel(ResourceBundle lang, DetailsListener listener, CUIField[] fields, boolean passwordRequired, ResultPair[] defaultValues, String defaultQueuePassword) {
        this.lang = lang;
        this.listener = listener;
        this.panel = new CUIHorizontalPanel(new Insets(3, 10, 3, 3), true);
        if (fields != null) {
            this.panel.addAll(fields);
        }
        if (passwordRequired) {
            this.passwordField = new TextField(lang.getString("DETAILS_PASSWORD_LABEL"), null);
            this.panel.add(this.passwordField);
            if (defaultQueuePassword != null) {
                this.passwordField.setDefaultValue(defaultQueuePassword);
            }
            this.passwordField.getComponent().addKeyListener(this);
        }
        this.panel.setChangeListener(this.changeListener);
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i] instanceof TextField) {
                    ((TextField)fields[i]).getComponent().addKeyListener(this);
                    String defaultValue = this.getDefaultValue(fields[i].getLabel(), defaultValues);
                    if (defaultValue != null) {
                        ((TextField)fields[i]).setDefaultValue(defaultValue);
                    }
                }
                if (!(fields[i] instanceof AbstractField)) continue;
                ((AbstractField)fields[i]).setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
            }
        }
        this.bok = new JButton(lang.getString("SUBMIT_SECURE"), ImageLoader.getImageIcon("images/svg/general/lock.svg,16"));
        SHButtonUI.makeButtonBlue(this.bok);
        this.setLayout(new BorderLayout());
        this.panel.getRootComponent().setBorder(SHBorderFactory.createCompoundBorder(SHBorderFactory.createEmptyBorder(10, 10, 10, 10), SHStyle.ROUNDRECTBORDER));
        JLabel disc = new JLabel(lang.getString("INPUT_DETAILS_PLEASE"), 0);
        disc.setBorder(SHBorderFactory.createEmptyBorder(20, 0, 0, 0));
        this.add("North", disc);
        JScrollPane sp = new JScrollPane(this.panel.getRootComponent());
        sp.setBorder(SHBorderFactory.createEmptyBorder());
        this.add("Center", sp);
        JPanel buttons = new JPanel();
        this.add("South", buttons);
        buttons.setLayout(new FlowLayout(1, 15, 15));
        buttons.add(this.bok);
        this.bok.addActionListener(this);
        this.bok.setEnabled(this.panel.isValid());
    }

    private String getDefaultValue(String labelKey, ResultPair[] defaultValues) {
        if (defaultValues == null) {
            return "";
        }
        for (int i = 0; i < defaultValues.length; ++i) {
            String key = defaultValues[i].getKey();
            String value = defaultValues[i].getValue();
            if (!key.equalsIgnoreCase(labelKey)) continue;
            return value;
        }
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        this.actionPerformed(o);
    }

    private void actionPerformed(Object o) {
        if (o == this.bok) {
            ResultPair[] filledOutResults = this.panel.getFilledOutResults(this.lang);
            String password = null;
            if (this.passwordField != null) {
                ResultPair[] newResults = new ResultPair[filledOutResults.length - 1];
                System.arraycopy(filledOutResults, 0, newResults, 0, newResults.length);
                password = filledOutResults[filledOutResults.length - 1].getValue();
            }
            this.listener.detailsAccepted(filledOutResults, password);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 && this.bok.isEnabled()) {
            this.actionPerformed(this.bok);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public JComponent getFocusComponent() {
        return this.focusField;
    }

    @Override
    public void grabFocus() {
    }
}

