/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common.toolbox.server;

import com.aem.shelp.common.GenericVariableUtil;
import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.common.toolbox.ToolBoxResource;
import com.aem.shelp.common.toolbox.ToolBoxResult;
import com.aem.shelp.common.toolbox.ToolBoxStatus;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import jwrapper.jwutils.JWWindowsOS;
import utils.files.FileUtil;
import utils.ostools.OS;
import utils.progtools.ProcessPrinter;
import utils.stream.CircularStreamReader;
import utils.stream.StreamUtils;
import utils.switches.Switches;

public class ToolBoxRunner {
    private static Object tmps_LOCK = new Object();
    private static HashMap<String, File> tmps = new HashMap();

    public static String[] translateCommandline(String toProcess) throws Exception {
        if (toProcess == null || toProcess.length() == 0) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        Vector<String> v = new Vector<String>();
        StringBuffer current = new StringBuffer();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
            } else if ("\"".equals(nextTok)) {
                state = 2;
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() != 0) {
                    v.addElement(current.toString());
                    current = new StringBuffer();
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            v.addElement(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new Exception("unbalanced quotes in " + toProcess);
        }
        Object[] args = new String[v.size()];
        v.copyInto(args);
        return args;
    }

    private static String resolveWithVariables(String command) throws IOException, InterruptedException {
        try {
            if (OS.isMacOS() || OS.isLinux()) {
                ProcessBuilder builder = new ProcessBuilder(new String[0]);
                builder.command("/bin/sh", "-c", "echo " + command);
                Process start = builder.start();
                ByteArrayOutputStream stdout = new ByteArrayOutputStream();
                ProcessPrinter pp = new ProcessPrinter(start, stdout, stdout);
                pp.waitForAllOutput();
                if (start.waitFor() == 0) {
                    return new String(stdout.toByteArray()).trim();
                }
                return command;
            }
            if (OS.isWindows()) {
                int closeVariable;
                JWWindowsOS windowsInstance = JWWindowsOS.getWindowsInstance();
                int openVariable = command.indexOf(37);
                while (openVariable > -1 && (closeVariable = command.indexOf(37, openVariable + 1)) > -1) {
                    String variable = command.substring(openVariable + 1, closeVariable);
                    String result = windowsInstance.getEnvironmentVariable(variable);
                    command = closeVariable + 1 != command.length() ? command.substring(0, openVariable) + result + command.substring(closeVariable + 1) : command.substring(0, openVariable) + result;
                    openVariable = command.indexOf(37);
                }
                return command;
            }
            return command;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return command;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getTmpFor(ToolBoxItem item) throws IOException {
        String id = item.getID();
        Object object = tmps_LOCK;
        synchronized (object) {
            File folder = tmps.get(id);
            if (folder != null) {
                return folder;
            }
            File workingFile = File.createTempFile("toolbox", "run");
            workingFile.delete();
            workingFile.mkdirs();
            tmps.put(id, workingFile);
            return workingFile;
        }
    }

    public static ToolBoxResult runToolBoxItem(ToolBoxItem item, String serverHostname, int serverPort, ToolBoxStatusListener statusListener) {
        ToolBoxRun run = ToolBoxRunner.launchToolBoxItem(item, serverHostname, serverPort, statusListener);
        return ToolBoxRunner.blockForToolBoxResult(run, statusListener);
    }

    public static ToolBoxRun launchToolBoxItem(ToolBoxItem item, String serverHostname, int serverPort, ToolBoxStatusListener statusListener) {
        if (statusListener != null) {
            statusListener.setStatus(new ToolBoxStatus(1));
        }
        ToolBoxRun result = new ToolBoxRun();
        try {
            if (OS.base_type != item.getTargetOperatingSystem()) {
                if (statusListener != null) {
                    statusListener.setStatus(new ToolBoxStatus("Cannot run tool box item " + item.getName() + " on this operating system."));
                }
                throw new Exception("Cannot run tool box item " + item.getName() + " on this operating system.");
            }
            System.out.println("[ToolBoxRunner] Running tool box item " + item.getName());
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            String workingDirectory = item.getWorkingDirectory();
            File workingFile = null;
            if (workingDirectory != null && workingDirectory.length() > 0) {
                workingDirectory = ToolBoxRunner.resolveWithVariables(workingDirectory);
                workingFile = new File(workingDirectory);
                try {
                    workingFile.mkdirs();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!workingFile.exists()) {
                    throw new IOException("Unable to access working directory '" + workingFile.getPath() + "'");
                }
                builder.directory(workingFile);
            } else {
                if (!Switches.SH_cacheToolboxRunTempFolders) {
                    workingFile = File.createTempFile("toolbox", "run");
                    workingFile.delete();
                    workingFile.mkdirs();
                } else {
                    workingFile = ToolBoxRunner.getTmpFor(item);
                }
                workingDirectory = workingFile.getAbsolutePath();
                builder.directory(workingFile);
            }
            System.out.println("[ToolBoxRunner] Using working directory: " + workingDirectory);
            if (statusListener != null) {
                statusListener.setStatus(new ToolBoxStatus(2));
            }
            ToolBoxRunner.fetchResources(item, serverHostname, serverPort, new SaveToFileResourceHandler(workingFile));
            if (item.getType() == 0) {
                File newTarget;
                File target;
                String[] translatedCommand = ToolBoxRunner.translateCommandline(item.getCommandLine());
                if (translatedCommand.length > 0 && !(target = new File(translatedCommand[0])).isAbsolute() && (newTarget = new File(new File(workingDirectory), translatedCommand[0])).exists()) {
                    translatedCommand[0] = newTarget.getAbsolutePath();
                }
                builder.command(translatedCommand);
            } else if (item.getType() == 1) {
                File scriptFile = ToolBoxRunner.getNewScriptFile(workingFile, item);
                System.out.println("[ToolBoxRunner] Writing temporary script file " + scriptFile.getPath());
                FileUtil.writeFileAsStringUTF8(scriptFile, item.getScript());
                String interpretter = item.getScriptInterpretterCommand();
                interpretter = GenericVariableUtil.substituteVariable(interpretter, "SCRIPT", scriptFile.getName());
                if (!interpretter.contains(scriptFile.getName())) {
                    interpretter = interpretter + " " + scriptFile.getName();
                }
                builder.command(ToolBoxRunner.translateCommandline(interpretter));
                result.scriptFile = scriptFile;
            }
            StringBuilder command = new StringBuilder();
            for (String c : builder.command()) {
                command.append("[").append(c).append("]");
            }
            System.out.println("[ToolBoxRunner] Running " + command);
            if (statusListener != null) {
                statusListener.setStatus(new ToolBoxStatus(3));
            }
            result.runningProcess = builder.start();
            result.waitForReturnCode = item.waitForProcessToFinish();
            if (statusListener != null) {
                statusListener.setStatus(new ToolBoxStatus(4));
            }
            result.stdoutReader = new CircularStreamReader(new BufferedInputStream(result.runningProcess.getInputStream()), 51200);
            result.stderrReader = new CircularStreamReader(new BufferedInputStream(result.runningProcess.getErrorStream()), 51200);
        }
        catch (Throwable t) {
            result.launchError = new ToolBoxResult();
            result.launchError.returnCode = -1;
            result.launchError.preLaunchError = t.getMessage();
            if (statusListener != null) {
                statusListener.setStatus(new ToolBoxStatus(result.launchError.preLaunchError));
            }
            t.printStackTrace();
        }
        return result;
    }

    public static void fetchResources(ToolBoxItem item, String serverHostname, int serverPort, ResourceHandler handler) throws IOException {
        ArrayList<ToolBoxResource> resources = item.getResources();
        for (ToolBoxResource resource : resources) {
            System.out.println("[ToolBoxRunner] Required resource: " + resource.getFilename() + " (id=" + resource.getID() + ")");
            if (resource.isDirectory()) {
                String parentURL = resource.getResourceURL(serverHostname, serverPort, item.getID());
                String catalogueURL = resource.getCatalogueURL(serverHostname, serverPort, item.getID());
                System.out.println("[ToolBoxRunner] Fetching Catalogue: " + catalogueURL);
                String files = ToolBoxRunner.downloadAsString(catalogueURL);
                if (files != null) {
                    String[] filesList;
                    for (String s : filesList = files.split("\n")) {
                        if (s.trim().length() == 0) continue;
                        String[] parts = s.split("\t");
                        String filename = parts[0];
                        long size = Long.parseLong(parts[1]);
                        String fileURL = parentURL + "/" + filename;
                        System.out.println("[ToolBoxRunner] Fetching Resource: " + fileURL);
                        handler.save(item.getID(), resource.getID(), fileURL, size, resource.getFilename(), filename);
                    }
                }
            } else {
                handler.save(item.getID(), resource.getID(), resource.getResourceURL(serverHostname, serverPort, item.getID()), resource.getSize(), resource.getFilename());
            }
            System.out.println("[ToolBoxRunner] Fetched resource " + resource.getFilename());
        }
    }

    private static File getNewScriptFile(File parent, ToolBoxItem item) {
        File result = null;
        while (result == null || result.exists()) {
            String filename = FileUtil.normaliseAsFilename(item.getName()) + "-" + System.currentTimeMillis();
            if (item.getBestGuessExtensionForScript() != null) {
                filename = filename + "." + item.getBestGuessExtensionForScript();
            }
            result = new File(parent, filename);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ToolBoxResult blockForToolBoxResult(ToolBoxRun run, ToolBoxStatusListener statusListener) {
        ToolBoxResult result;
        block12: {
            result = new ToolBoxResult();
            if (run == null) {
                System.out.println("[ToolBoxRunner] Warning: asked to wait for tool to finish, but no tool passed in.");
                return null;
            }
            try {
                if (run.runningProcess == null || run.launchError != null) {
                    return run.launchError;
                }
                if (run.waitForReturnCode) {
                    int returnCode;
                    System.out.println("[ToolBoxRunner] Waiting for tool " + run + " to finish (" + run.runningProcess + ", " + run.launchError + ")");
                    StatusUpdater updater = new StatusUpdater(run, statusListener);
                    try {
                        returnCode = run.runningProcess.waitFor();
                    }
                    finally {
                        updater.die = true;
                    }
                    if (statusListener != null) {
                        statusListener.setStatus(new ToolBoxStatus(5));
                    }
                    System.out.println("[ToolBoxRunner] Process returned " + returnCode);
                    run.stdoutReader.join();
                    run.stderrReader.join();
                    System.out.println("[ToolBoxRunner] Toolbox completed with return code " + returnCode);
                    if (run.scriptFile != null) {
                        System.out.println("[ToolBoxRunner] Removing script file.");
                        run.scriptFile.delete();
                    }
                    result.returnCode = returnCode;
                    result.stdout = new String(run.stdoutReader.popAll(), "UTF-8");
                    result.stderr = new String(run.stderrReader.popAll(), "UTF-8");
                    break block12;
                }
                System.out.println("[ToolBoxRunner] Tool should not wait for a result. Returning immediately.");
                if (statusListener != null) {
                    statusListener.setStatus(new ToolBoxStatus(5));
                }
                run.stderrReader.die();
                run.stderrReader.die();
                result.returnCode = 0;
            }
            catch (Throwable t) {
                result.returnCode = -1;
                result.preLaunchError = t.getMessage();
                t.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadToFile(String pathURL, File targetFile, long size) {
        if (targetFile.exists() && targetFile.length() == size) {
            System.out.println("[ToolBoxRunner] Skipping " + targetFile + " as resource already exists");
            return;
        }
        try {
            URL url = new URL(pathURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            try {
                InputStream inputStream = conn.getInputStream();
                try {
                    StreamUtils.readAllToFile(inputStream, targetFile);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                conn.disconnect();
            }
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static String downloadAsString(String pathURL) {
        try {
            URL url = new URL(pathURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            try {
                String string;
                InputStream inputStream = conn.getInputStream();
                try {
                    string = StreamUtils.readAllAsStringUTF8(inputStream);
                }
                catch (Throwable throwable) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return string;
            }
            finally {
                conn.disconnect();
            }
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static interface ToolBoxStatusListener {
        public void setStatus(ToolBoxStatus var1);
    }

    public static class ToolBoxRun {
        CircularStreamReader stdoutReader;
        CircularStreamReader stderrReader;
        Process runningProcess;
        ToolBoxResult launchError;
        boolean waitForReturnCode;
        public File scriptFile;

        public void cancelJob() {
            try {
                if (this.runningProcess != null) {
                    this.runningProcess.destroy();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private static class StatusUpdater
    extends Thread {
        private final ToolBoxRun run;
        private final ToolBoxStatusListener listener;
        private boolean die = false;

        public StatusUpdater(ToolBoxRun run, ToolBoxStatusListener listener) {
            System.out.println("[ToolBoxRunner] Initiated status updater");
            this.run = run;
            this.listener = listener;
            this.start();
        }

        public void die() {
            this.die = true;
        }

        @Override
        public void run() {
            while (!this.die) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                byte[] stdoutData = this.run.stdoutReader.popAll();
                byte[] stderrData = this.run.stderrReader.popAll();
                if (stdoutData.length <= 0 && stderrData.length <= 0) continue;
                try {
                    this.listener.setStatus(new ToolBoxStatus(new String(stdoutData, "UTF-8"), new String(stderrData, "UTF-8")));
                }
                catch (UnsupportedEncodingException t) {
                    t.printStackTrace();
                }
            }
            System.out.println("[ToolBoxRunner] Status updater done");
        }
    }

    private static class SaveToFileResourceHandler
    implements ResourceHandler {
        private final File workingDirectory;

        public SaveToFileResourceHandler(File workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        @Override
        public void save(String itemID, String resourceID, String fileURL, long size, String resourceFilename) {
            File targetFile = new File(this.workingDirectory, resourceFilename);
            ToolBoxRunner.downloadToFile(fileURL, targetFile, size);
        }

        @Override
        public void save(String itemID, String resourceID, String fileURL, long size, String parentDir, String resourceFilename) {
            File targetDir = new File(this.workingDirectory, parentDir);
            targetDir.mkdirs();
            File resourceSubFile = new File(targetDir, resourceFilename);
            ToolBoxRunner.downloadToFile(fileURL, resourceSubFile, size);
        }

        @Override
        public boolean cancel() {
            return false;
        }
    }

    public static interface ResourceHandler {
        public void save(String var1, String var2, String var3, long var4, String var6) throws IOException;

        public void save(String var1, String var2, String var3, long var4, String var6, String var7) throws IOException;

        public boolean cancel();
    }
}

