/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common.login;

import com.aem.sdesktop.ClientBranding;
import com.aem.utils.gui.GuiUtils;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import utils.swing.images.ImageLoader;

public class TechUiLoginDialog
extends JDialog
implements ActionListener,
KeyListener {
    JTextField server = new JTextField();
    JTextField port = new JTextField();
    JPasswordField pass = new JPasswordField();
    JLabel lserver;
    JLabel lport;
    JLabel lpass;
    JPanel main = new JPanel();
    JPanel panel = new JPanel();
    JPanel buttons = new JPanel();
    JButton bok;
    JButton bcancel;
    String sserver = null;
    String sport = null;
    String spass = null;

    public TechUiLoginDialog(Container frame, ResourceBundle lang) {
        this(frame, lang, null, null);
    }

    public TechUiLoginDialog(Container frame, ResourceBundle lang, String inithost, String initport) {
        this.setModal(true);
        this.lserver = new JLabel(lang.getString("SERVER_HOST_OR_IP"));
        this.lport = new JLabel(lang.getString("SERVER_PORT"));
        this.lpass = new JLabel(lang.getString("SERVER_PASSWORD"));
        this.bok = new JButton(lang.getString("LOGIN"), ImageLoader.getImageIcon("images/svg/arrows/right-moving.svg,16"));
        this.bcancel = new JButton(lang.getString("EXIT"), ImageLoader.getImageIcon("images/svg/general/cancel.svg,16"));
        GuiUtils.centreComponent(this, frame, 300, 300);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbl.setConstraints(this.lserver, new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        gbl.setConstraints(this.server, new GridBagConstraints(1, 0, 1, 1, 300.0, 100.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        gbl.setConstraints(this.lport, new GridBagConstraints(0, 1, 1, 1, 100.0, 100.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        gbl.setConstraints(this.port, new GridBagConstraints(1, 1, 1, 1, 300.0, 100.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        gbl.setConstraints(this.lpass, new GridBagConstraints(0, 2, 1, 1, 100.0, 100.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        gbl.setConstraints(this.pass, new GridBagConstraints(1, 2, 1, 1, 300.0, 100.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.panel.setLayout(gbl);
        this.panel.add(this.server);
        this.panel.add(this.port);
        this.panel.add(this.pass);
        this.panel.add(this.lserver);
        this.panel.add(this.lport);
        this.panel.add(this.lpass);
        this.getContentPane().add(this.main);
        this.main.setLayout(new BorderLayout());
        this.main.add("Center", this.panel);
        this.main.add("South", this.buttons);
        this.buttons.setLayout(new FlowLayout(1));
        this.buttons.add(this.bok);
        this.buttons.add(this.bcancel);
        this.bok.addActionListener(this);
        this.bcancel.addActionListener(this);
        this.server.addKeyListener(this);
        this.port.addKeyListener(this);
        this.pass.addKeyListener(this);
        this.setTitle(ClientBranding.get().getApplicationName(false) + " " + lang.getString("SERVER_LOGIN"));
        this.pack();
        Rectangle bounds = this.getBounds();
        if (bounds.width < 300) {
            bounds.width = 300;
        }
        GuiUtils.centreComponent(this, frame, bounds.width, bounds.height);
        if (inithost != null) {
            this.server.setText(inithost);
        }
        if (initport != null) {
            this.port.setText(initport);
        }
        if (inithost != null && initport != null) {
            this.pass.requestFocus();
            this.pass.grabFocus();
        }
        this.setVisible(true);
        if (inithost != null && initport != null) {
            this.pass.requestFocus();
            this.pass.grabFocus();
        }
    }

    public String getServer() {
        return this.sserver;
    }

    public String getPort() {
        return this.sport;
    }

    public String getPass() {
        return this.spass;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        this.actionPerformed(o);
    }

    public void actionPerformed(Object o) {
        if (o == this.bok) {
            this.sserver = this.server.getText();
            this.sport = this.port.getText();
            this.spass = this.pass.getText();
        } else if (o == this.bcancel) {
            this.sserver = null;
            this.sport = null;
            this.spass = null;
        }
        this.setVisible(false);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.actionPerformed(this.bok);
        } else if (e.getKeyCode() == 27) {
            this.actionPerformed(this.bcancel);
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }
}

