/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common;

import com.aem.nodelink.utils.ProxyUtil;
import com.aem.shelp.common.Language;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.TechHelpUIArguments;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import jwrapper.cmdline.JWCommandLineWrapper;
import jwrapper.updater.JWLaunchProperties;
import utils.files.FileUtil;
import utils.string.Base64;

public class TechLaunchAPI {
    public static final String ON = "on";
    public static final String OFF = "off";
    public static final String OPTIONAL = "optional";
    public static final String MODE_SCREEN = "screen";
    public static final String MODE_FILE_TRANSFER = "file";
    public static final String MODE_DIAGNOSTICS = "diagnostics";
    Properties lprops = new Properties();
    String lang;
    boolean requestAccess;
    long requestAccessTimeout;
    boolean viewOnly;

    public TechLaunchAPI() {
        this.lprops.setProperty("supported_langs", Language.getAllSupportedLanguages());
    }

    public TechLaunchAPI(Properties props, String url) {
        String s = props.getProperty("supported_langs");
        if (s != null && s.equals("alllangs")) {
            this.lprops.setProperty("supported_langs", Language.getAllSupportedLanguages());
        }
        JWLaunchProperties.addAllProperties(this.lprops, props);
        System.out.println("[TechLaunchAPI] Got URI config: '" + url + "'");
        if (url != null && url.length() > 0) {
            Map<String, String> splitQuery = TechLaunchAPI.splitQuery(url);
            for (String key : splitQuery.keySet()) {
                String value = splitQuery.get(key);
                if (key.toLowerCase().startsWith("jw_")) {
                    key = key.substring(3);
                }
                System.out.println("[TechLaunchAPI] [URIConfig] Setting " + key + " to " + value);
                this.lprops.setProperty(key, value);
            }
        }
    }

    public static Map<String, String> splitQuery(String url) {
        String[] pairs;
        LinkedHashMap<String, String> query_pairs = new LinkedHashMap<String, String>();
        if (url.indexOf(63) == -1) {
            return query_pairs;
        }
        String query = url.substring(url.indexOf(63) + 1);
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            try {
                query_pairs.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                ex.printStackTrace();
            }
        }
        return query_pairs;
    }

    public void setForceSingleLanguage(String langcode) {
        this.lprops.setProperty("supported_langs", langcode);
    }

    public void setSessionMode(String mode) {
        this.lprops.setProperty("mode", mode);
    }

    public void setDirectMachine(String machine) {
        this.lprops.setProperty("machine", machine);
    }

    public void setDirectMachine(String machine, String password) {
        this.lprops.setProperty("machine", machine);
        this.lprops.setProperty("machinepwd", password);
    }

    public void setDirectMachineByFilter(String machineFilter, String password) {
        this.lprops.setProperty("machine_filter", machineFilter);
        this.lprops.setProperty("machinepwd", password);
    }

    public void setDirectMachineByFilter(String machineFilter) {
        this.lprops.setProperty("machine_filter", machineFilter);
    }

    public void setDirectCustomerByFilter(String customerFilter) {
        this.lprops.setProperty("customer_filter", customerFilter);
    }

    public void setTechLogin(String username, String password) {
        this.lprops.setProperty("technician", username);
        this.lprops.setProperty("password", password);
    }

    public void setTechVisibleName(String tech) {
        this.lprops.setProperty("techname", tech);
    }

    public void launch(String serverHost, int serverPort) throws MalformedURLException {
        this.launch("http://" + serverHost + ":" + serverPort + "/");
    }

    public void launch(String serverHost, int serverPort, boolean https) throws MalformedURLException {
        if (https) {
            this.launch("https://" + serverHost + ":" + serverPort + "/");
        } else {
            this.launch("http://" + serverHost + ":" + serverPort + "/");
        }
    }

    public void setSplashImagePNG(File PNG) throws IOException {
        this.lprops.setProperty("splash_image", Base64.byteArrayToBase64(FileUtil.readFile(PNG.getAbsolutePath())));
    }

    public void setSplashImagePNG(byte[] PNG) {
        this.lprops.setProperty("splash_image", Base64.byteArrayToBase64(PNG));
    }

    public void setLanguage(String lang) {
        this.lang = lang;
    }

    public void setRequestAccess(boolean request, long timeout) {
        this.requestAccess = request;
        this.requestAccessTimeout = timeout;
    }

    public void setViewOnly(boolean viewOnly) {
        this.viewOnly = viewOnly;
    }

    TechHelpUIArguments buildTechHelpUIArguments(String url) throws MalformedURLException {
        if (url.length() > 0 && !url.endsWith("/")) {
            url = url + "/";
        }
        TechHelpUIArguments args = new TechHelpUIArguments();
        args.setLanguage(this.lang);
        args.setIsMachine(true);
        args.setHostAndPortFromURL(url);
        String pulledHost = args.getPopulatedProperties().getProperty("TechHelpUiHost");
        int pulledPort = Integer.parseInt(args.getPopulatedProperties().getProperty("TechHelpUiPort"));
        args.setUsername(this.lprops.getProperty("technician"));
        args.setPassword(this.lprops.getProperty("password"));
        args.setConnectCustomerOrMachineByID(this.lprops.getProperty("machine"));
        args.setConnectMachineFilter(this.lprops.getProperty("machine_filter"));
        args.setConnectCustomerFilter(this.lprops.getProperty("customer_filter"));
        args.setMachinePassword(this.lprops.getProperty("machinepwd"));
        if (JWLaunchProperties.isNonEmpty(this.lprops.getProperty("techname"))) {
            args.setTechName(this.lprops.getProperty("techname"));
        } else {
            args.setTechName(this.lprops.getProperty("technician"));
        }
        args.setSHRetry(true);
        if (JWLaunchProperties.isNonEmpty(this.lprops.getProperty("mode"))) {
            String mode = this.lprops.getProperty("mode");
            if (mode.equals(MODE_SCREEN)) {
                args.setInitialSessionScreen();
            } else if (mode.equals(MODE_FILE_TRANSFER)) {
                args.setInitialSessionFiles();
            } else if (mode.equals(MODE_DIAGNOSTICS)) {
                args.setInitialSessionDiagnostics();
            } else {
                args.setInitialSessionScreen();
            }
        } else {
            args.setInitialSessionScreen();
        }
        args.setRequestAccess(this.requestAccess);
        args.setRequestTimeout(this.requestAccessTimeout);
        args.setViewOnly(this.viewOnly);
        args.setTTSessionID(TechClient.NULL_SESSION_ID);
        String[] proxyInfo = null;
        try {
            proxyInfo = ProxyUtil.detectProxy(new URL("http://" + pulledHost + ":" + pulledPort + "/"));
            System.out.println("Proxy Host: " + proxyInfo[0]);
            System.out.println("Proxy Port: " + proxyInfo[1]);
        }
        catch (NullPointerException t) {
            System.out.println("No proxy detected");
        }
        catch (Throwable t) {
            System.out.println("Failed to detect proxy: " + t);
            t.printStackTrace();
        }
        if (proxyInfo != null) {
            args.setProxyHost((String)proxyInfo[0]);
            args.setProxyPort((String)proxyInfo[1]);
        }
        return args;
    }

    public void launch(String url) throws MalformedURLException {
        boolean isDirectSGSession;
        JWCommandLineWrapper jwc = new JWCommandLineWrapper();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        Properties mprops = new Properties();
        JWLaunchProperties.addAllProperties(mprops, this.lprops);
        boolean bl = isDirectSGSession = JWLaunchProperties.isNonEmpty(this.lprops.getProperty("machine")) || JWLaunchProperties.isNonEmpty(this.lprops.getProperty("machine_filter")) || JWLaunchProperties.isNonEmpty(this.lprops.getProperty("customer_filter"));
        if (isDirectSGSession) {
            System.out.println("[TechLaunchAPI] Direct connection");
            TechHelpUIArguments args = this.buildTechHelpUIArguments(url);
            JWLaunchProperties.addAllProperties(mprops, args.getPopulatedProperties());
            mprops.setProperty("gu_virt_app", "SessionUI");
        }
        boolean splashAllowed = false;
        try {
            URL burl = new URL(url + "branding/branding.properties");
            Properties branding = new Properties();
            InputStream in = burl.openStream();
            branding.load(in);
            try {
                splashAllowed = branding.getProperty("HOSTED_RESALE_BRANDING").equalsIgnoreCase("yes");
            }
            catch (Exception exception) {
                // empty catch block
            }
            in.close();
        }
        catch (Throwable t) {
            System.err.println("Unable to load branding.properties - " + t);
            t.printStackTrace();
        }
        if (!splashAllowed) {
            mprops.remove("splash_image");
        }
        jwc.overrideUpdateURL(url + "technician/");
        jwc.overrideApp(OemBranding.OEM_TECHNICIAN_APP_NAME, true, "perm_user");
        jwc.setLaunchProperties(mprops);
        jwc.updateAndLaunchAppNow();
    }
}

