/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common;

import com.aem.shelp.common.Language;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.types.Customer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Random;
import java.util.regex.Pattern;
import utils.message.Message;
import utils.xml.XML14Util;

public class Invitation {
    protected static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy/MM/dd");
    protected static final SimpleDateFormat EXPIRY_DATE_FORMATTER = new SimpleDateFormat("yyyy/MM/dd");
    protected static final SimpleDateFormat EXPIRY_TIME_FORMATTER = new SimpleDateFormat("HH:mm");
    protected static final SimpleDateFormat EXPIRY_FORMATTER = new SimpleDateFormat("yyyy/MM/dd  HH:mm");
    public String invitationID = "";
    public long creationTime = -1L;
    public long durationLimit = -1L;
    public int sessionLimit = -1;
    public ArrayList customerDetailLabels = new ArrayList();
    public ArrayList customerDetailValues = new ArrayList();
    public String technicianFilter = null;
    public String technicianGroupFilter = null;
    public String shareOption = null;
    public int createdByID = -1;
    public transient String createdByDisplayName = "";
    public static final String SHARE_OPTIONS_NONE = "None";
    public static final String SHARE_OPTIONS_ALL = "All";
    public static final String SHARE_OPTIONS_GROUP = "Group";
    private static final Pattern STRICT_EMAIL_PATTERN = Pattern.compile("^[\\w\\-]+(\\.[\\w\\-]+)*@([A-Za-z0-9-]+\\.)+[A-Za-z]{2,4}$");

    public String getFormattedCreationTime() {
        return DATE_FORMATTER.format(new Date(this.creationTime));
    }

    public String toString() {
        return this.getName();
    }

    public Iterator getDetailsLabelIterator() {
        return this.customerDetailLabels.iterator();
    }

    public boolean equals(Object i) {
        if (i == null || !(i instanceof Invitation)) {
            return false;
        }
        return ((Invitation)i).invitationID.equals(this.invitationID);
    }

    public static Invitation createRandom() {
        Invitation invitation = new Invitation();
        Random random = new Random();
        invitation.invitationID = "abcd1234" + random.nextInt(1000);
        invitation.addCustomerDetail("", "George_" + random.nextInt(100));
        invitation.addCustomerDetail("Email", "george.christelis@gmail.com");
        invitation.addCustomerDetail("Company", "SimpleHelp Ltd");
        invitation.setCreationTime(System.currentTimeMillis());
        invitation.createdByDisplayName = "Nelly" + random.nextInt(2);
        invitation.setDurationLimit(0x6DDD00L);
        return invitation;
    }

    public Message toMessage() {
        Message message = new Message();
        message.append(this.createdByID);
        message.append(this.createdByDisplayName);
        message.append(this.invitationID);
        message.append(this.creationTime);
        message.append(this.durationLimit);
        message.append(this.sessionLimit);
        if (this.technicianFilter != null) {
            message.append(true);
            message.append(this.technicianFilter);
        } else {
            message.append(false);
        }
        message.append(this.customerDetailLabels.size());
        for (int i = 0; i < this.customerDetailLabels.size(); ++i) {
            message.append(this.customerDetailLabels.get(i).toString());
            message.append(this.customerDetailValues.get(i).toString());
        }
        if (this.technicianGroupFilter != null) {
            message.append(true);
            message.append(this.technicianGroupFilter);
        } else {
            message.append(false);
        }
        if (this.shareOption != null) {
            message.append(true);
            message.append(this.shareOption);
        } else {
            message.append(false);
        }
        return message;
    }

    public static Invitation fromMessage(Message message) {
        boolean hasFilter;
        Invitation invitation = new Invitation();
        int id = 0;
        invitation.createdByID = message.getAsInt(id++);
        invitation.createdByDisplayName = message.getAsString(id++);
        invitation.invitationID = message.getAsString(id++);
        invitation.creationTime = message.getAsLong(id++);
        invitation.durationLimit = message.getAsLong(id++);
        invitation.sessionLimit = message.getAsInt(id++);
        if (hasFilter = message.getAsBoolean(id++)) {
            invitation.technicianFilter = message.getAsString(id++);
        }
        int count = message.getAsInt(id++);
        for (int i = 0; i < count; ++i) {
            invitation.addCustomerDetail(message.getAsString(id++), message.getAsString(id++));
        }
        try {
            boolean hasGroupFilter = message.getAsBoolean(id++);
            if (hasGroupFilter) {
                invitation.technicianGroupFilter = message.getAsString(id++);
            }
        }
        catch (Throwable ignore) {
            invitation.technicianGroupFilter = null;
        }
        try {
            if (message.getAsBoolean(id++)) {
                invitation.shareOption = message.getAsString(id++);
            }
        }
        catch (Throwable ignore) {
            invitation.shareOption = null;
        }
        return invitation;
    }

    public void addCustomerDetail(String label, String value) {
        String translatedName;
        if (label.equals("") && (translatedName = Language.get("NAME")) != null && !translatedName.equals("NAME")) {
            label = translatedName;
        }
        this.customerDetailLabels.add(label);
        this.customerDetailValues.add(value);
    }

    public String getInvitationID() {
        return this.invitationID;
    }

    public String getInvitationIDAsCode() {
        return this.invitationID.substring(0, 2) + "-" + this.invitationID.substring(2, 4) + "-" + this.invitationID.substring(4, 6);
    }

    public void setInvitationID(String invitationID) {
        this.invitationID = invitationID;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public long getDurationLimit() {
        return this.durationLimit;
    }

    public void setDurationLimit(long duration) {
        this.durationLimit = duration;
    }

    public int getSessionLimit() {
        return this.sessionLimit;
    }

    public void setSessionLimit(int sessionLimit) {
        this.sessionLimit = sessionLimit;
    }

    public boolean isExpired() {
        if (this.durationLimit != -1L && this.durationLimit != 0L && this.creationTime + this.durationLimit < System.currentTimeMillis()) {
            return true;
        }
        return this.sessionLimit == 0;
    }

    public String getFullDetails() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.customerDetailLabels.size(); ++i) {
            String label = (String)this.customerDetailLabels.get(i);
            String value = (String)this.customerDetailValues.get(i);
            if (i > 0) {
                buffer.append(" ");
            }
            buffer.append("(" + label + ":" + value + ")");
        }
        return buffer.toString();
    }

    public String getName() {
        for (int i = 0; i < this.customerDetailLabels.size(); ++i) {
            String label = (String)this.customerDetailLabels.get(i);
            if (!label.equals("") && !label.equalsIgnoreCase(Language.get("NAME"))) continue;
            return (String)this.customerDetailValues.get(i);
        }
        if (this.customerDetailLabels.size() > 0) {
            return (String)this.customerDetailValues.get(0);
        }
        return this.invitationID;
    }

    public void setTechnicianFilter(String filter) {
        this.technicianFilter = filter != null && filter.length() == 0 ? OemBranding.OEM_ADMIN_USERNAME : filter;
    }

    public String getTechnicianFilter() {
        return this.technicianFilter;
    }

    public boolean hasTechnicianFilter() {
        return this.technicianFilter != null;
    }

    public void setShareOption(String shareOption) {
        this.shareOption = shareOption;
    }

    public String getShareOption() {
        return this.shareOption;
    }

    public void setTechnicianGroupFilter(String filter) {
        this.technicianGroupFilter = filter;
    }

    public String getTechnicianGroupFilter() {
        return this.technicianGroupFilter;
    }

    public boolean hasTechnicianGroupFilter() {
        return this.technicianGroupFilter != null;
    }

    public int getCreatedByID() {
        return this.createdByID;
    }

    public void setCreatedByID(int createdByID) {
        this.createdByID = createdByID;
    }

    public String getDetailFor(String labelText) {
        for (int i = 0; i < this.customerDetailLabels.size(); ++i) {
            String label = (String)this.customerDetailLabels.get(i);
            if (!label.equals(labelText)) continue;
            return (String)this.customerDetailValues.get(i);
        }
        return "";
    }

    public String guessEmailAddress() {
        String value;
        int i;
        for (i = 0; i < this.customerDetailValues.size(); ++i) {
            value = (String)this.customerDetailValues.get(i);
            if (value != null) {
                value = value.trim();
            }
            if (!STRICT_EMAIL_PATTERN.matcher(value).find()) continue;
            return value;
        }
        for (i = 0; i < this.customerDetailValues.size(); ++i) {
            value = (String)this.customerDetailValues.get(i);
            if (value.indexOf(64) == -1 || value.indexOf(46) == -1) continue;
            return value;
        }
        return null;
    }

    public boolean hasLimit() {
        return this.sessionLimit != -1 || this.durationLimit != -1L;
    }

    public String getTextualExpiry() {
        if (this.sessionLimit != -1) {
            if (this.sessionLimit == 1) {
                return Language.get("EXPIRY_TEXT_CURRENT") + " [" + this.sessionLimit + " " + Language.get("SESSION") + "]";
            }
            return Language.get("EXPIRY_TEXT_CURRENT") + " [" + this.sessionLimit + " " + Language.get("SESSIONS") + "]";
        }
        if (this.durationLimit != -1L) {
            int endDay;
            long endTime = this.getDurationLimit() + this.getCreationTime();
            GregorianCalendar endCalendar = new GregorianCalendar();
            endCalendar.setTime(new Date(endTime));
            GregorianCalendar currentCalendar = new GregorianCalendar();
            currentCalendar.setTime(new Date(System.currentTimeMillis()));
            long hoursDiff = (endTime - System.currentTimeMillis()) / 3600000L;
            if (hoursDiff > 48L) {
                return Language.get("EXPIRY_TEXT_CURRENT") + " [" + EXPIRY_FORMATTER.format(new Date(endTime)) + "]";
            }
            int startDay = currentCalendar.get(6);
            if (startDay == (endDay = endCalendar.get(6))) {
                return Language.get("EXPIRY_TEXT_CURRENT") + " [" + Language.get("TODAY") + " " + EXPIRY_TIME_FORMATTER.format(new Date(endTime)) + "]";
            }
            if (startDay == endDay - 1) {
                return Language.get("EXPIRY_TEXT_CURRENT") + " [" + Language.get("TOMORROW") + " " + EXPIRY_TIME_FORMATTER.format(new Date(endTime)) + "]";
            }
            return Language.get("EXPIRY_TEXT_CURRENT") + " [" + EXPIRY_FORMATTER.format(new Date(endTime)) + "]";
        }
        return "";
    }

    public String getCreatedByDisplayName() {
        return this.createdByDisplayName;
    }

    public void setCreatedByDisplayName(String displayName) {
        this.createdByDisplayName = displayName;
    }

    public String toXML() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<Invitation>\n");
        buffer.append("\t<CreatedBy>").append(this.createdByID).append("</CreatedBy>\n");
        buffer.append("\t<InvitationID>").append(XML14Util.escape(this.invitationID)).append("</InvitationID>\n");
        buffer.append("\t<CreationTime>").append(XML14Util.escape(Long.toString(this.creationTime))).append("</CreationTime>\n");
        buffer.append("\t<DurationLimit>").append(XML14Util.escape(Long.toString(this.durationLimit))).append("</DurationLimit>\n");
        buffer.append("\t<SessionLimit>").append(XML14Util.escape(Integer.toString(this.sessionLimit))).append("</SessionLimit>\n");
        if (this.technicianFilter != null) {
            buffer.append("\t<TechnicianFilter>").append(XML14Util.escape(this.technicianFilter)).append("</TechnicianFilter>\n");
        }
        if (this.technicianGroupFilter != null) {
            buffer.append("\t<TechnicianGroupFilter>").append(XML14Util.escape(this.technicianGroupFilter)).append("</TechnicianGroupFilter>\n");
        }
        if (this.shareOption != null) {
            buffer.append("\t<ShareOption>" + this.shareOption + "</ShareOption>\n");
        }
        for (int i = 0; i < this.customerDetailLabels.size(); ++i) {
            buffer.append("\t<Detail>\n");
            String label = this.customerDetailLabels.get(i) + "";
            String value = this.customerDetailValues.get(i) + "";
            buffer.append("\t\t<Label>").append(XML14Util.escape(label)).append("</Label>\n");
            buffer.append("\t\t<Value>").append(XML14Util.escape(value)).append("</Value>\n");
            buffer.append("\t</Detail>\n");
        }
        buffer.append("</Invitation>");
        return buffer.toString();
    }

    public void applyDetailsTo(Customer customer) {
        String[] keys = new String[this.customerDetailLabels.size()];
        String[] values = new String[this.customerDetailValues.size()];
        for (int i = 0; i < this.customerDetailLabels.size(); ++i) {
            keys[i] = (String)this.customerDetailLabels.get(i);
            values[i] = (String)this.customerDetailValues.get(i);
        }
        customer.setDetailsKeys(keys);
        customer.setDetailsValues(values);
    }
}

