/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common;

import com.aem.CentralDebugging;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.sdesktop.ClientBranding;
import com.aem.sdesktop.server.SimpleDesktopServer;
import com.aem.sdesktop.server.controller.NativeGrab;
import com.aem.sdesktop.server.controller.SDesktopServerController;
import com.aem.sdesktop.server.gui.ConnectionSettings;
import com.aem.sdesktop.server.gui.ServerGUI;
import com.aem.sdesktop.util.MouseMover;
import com.aem.sdesktop.util.Version;
import com.aem.shelp.common.Language;
import com.aem.shelp.customer.ParameterHandler;
import com.aem.shelp.customer.details.DetailsListener;
import com.aem.shelp.customer.details.DetailsPanelGlassDialog;
import com.aem.shelp.customer.disclaimer.DisclaimerListener;
import com.aem.shelp.customer.disclaimer.DisclaimerPanelGlassDialog;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.util.ErrorDialogs;
import com.aem.shelp.util.ParamsParser;
import com.aem.shelp.util.TimerPanel;
import com.aem.tests.TestUtils;
import com.aem.tests.Testing;
import com.aem.utils.NativeLibraryLoader;
import com.aem.utils.NativeScreenUtil;
import com.aem.utils.NativeUtils;
import com.aem.utils.StreamUtils;
import com.jw.AuxConfig;
import com.jw.SHJWUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.im.InputContext;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import jwrapper.hidden.JWNativeAPI;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.test.JWTestControl;
import jwrapper.jwutils.test.JWTestable;
import jwrapper.jwutils.test.JWTesting;
import jwrapper.updater.JWLaunchProperties;
import utils.files.FileUtil;
import utils.files.PermissionsUtil;
import utils.message.Message;
import utils.ostools.OS;
import utils.swing.aa.AntiAliasingEnforcer;
import utils.swing.components.FitImagePanel;
import utils.swing.components.animated.arrow.ArrowAnimatedIcon;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.CUIFieldRepository;
import utils.swing.cui.types.ResultPair;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.dialog.glassdialog.GlassDialog;
import utils.swing.images.ImageLoader;
import utils.vm.VMFork;

public abstract class CommonHelpUtil
implements DisclaimerListener,
DetailsListener,
JWTestable {
    private CUIField[] detailFields;
    protected boolean started = false;
    public SDesktopServerController controller;
    private JLabel connectingLabel;
    boolean mmovefailedCompletely = false;
    boolean mmoveRestrictedLaunched = false;
    boolean sdemoConnection = false;
    JCheckBox ftpcheck;
    JCheckBox rdpcheck;
    private ServerGUI serverGUI;
    protected TimerPanel timer = new TimerPanel(false);
    RootPaneContainer rpc;
    ParameterHandler parameterHandler;
    HashMap autoparams = null;
    boolean autoconnect = false;
    boolean optionalautoconnect = false;
    boolean ftpoptional = false;
    boolean rdpoptional = false;
    boolean requirePassword = false;
    private String invitationID = null;
    private boolean managedToConnectOnce = false;
    JPanel main = new JPanel(){

        @Override
        public InputContext getInputContext() {
            return null;
        }
    };
    JPanel sui;
    ConnectionSettings settings = null;
    private FitImagePanel northBrand;
    private JPanel southBrand;
    ArrayList cleanup = new ArrayList();

    public abstract String getHost();

    public abstract int getPort();

    public abstract String getConnectURL();

    public abstract String getCodeBase();

    public abstract String getDemoName();

    public abstract Customer getDemoCustomerType();

    public CommonHelpUtil(RootPaneContainer rpc, boolean sdemoConnection) {
        this.rpc = rpc;
        this.sdemoConnection = sdemoConnection;
        if (sdemoConnection) {
            this.settings = new ConnectionSettings(this.getDemoCustomerType());
        } else {
            String reuseCustomerID = JWLaunchProperties.getProperty("reuse_cust_id");
            JWLaunchProperties.deleteProperty("reuse_cust_id");
            if (reuseCustomerID.length() > 0) {
                System.out.println("[CommonHelp] Reusing customer ID " + reuseCustomerID);
                this.settings = new ConnectionSettings(new Customer(0, reuseCustomerID));
            } else {
                this.settings = new ConnectionSettings(new Customer(0));
            }
        }
    }

    public ConnectionSettings getSettings() {
        return this.settings;
    }

    public void customerConnectedNotice(ConnectionSettings cSettings) {
    }

    private void retrieveParametersFromServer(String codebase) throws Exception {
        this.parameterHandler = new ParameterHandler(this.rpc, codebase);
        boolean connected = this.parameterHandler.retrieveParametersFromServer();
        if (!connected && !this.managedToConnectOnce) {
            ErrorDialogs.ErrorGlassDialog dialog = new ErrorDialogs.ErrorGlassDialog(this.rpc, Language.get("SERVER_DOWN_TITLE"));
            dialog.setText(Language.get("SERVER_DOWN_TITLE"), Language.get("SERVER_DOWN_MESSAGE", new Object[]{this.getCodeBase()}), null);
            dialog.showDialog();
            System.exit(1);
        } else {
            this.managedToConnectOnce = true;
        }
        try {
            System.out.println("[CommonHelpUtil] Processing parameters");
            this.processParameters();
            System.out.println("[CommonHelpUtil] Parameters all processed");
        }
        catch (Throwable t) {
            System.out.println("[CommonHelpUtil] Error while processing parameters: " + t);
            t.printStackTrace();
        }
    }

    public void setInfoText(String s) {
        try {
            this.connectingLabel.setIcon(null);
            this.connectingLabel.setText(s);
            this.connectingLabel.repaint();
            this.updateFrame();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setInfoIcon(Icon ii) {
        if (this.connectingLabel != null) {
            this.connectingLabel.setIcon(ii);
        }
    }

    public void inQueue() {
        if (this.sui == null) {
            return;
        }
        this.sui.setVisible(true);
    }

    public void processParameters() {
        String s;
        Boolean result;
        this.settings.host = this.getHost();
        this.settings.port = this.getPort();
        this.settings.url = this.getConnectURL();
        if (this.parameterHandler == null) {
            return;
        }
        String acon = this.parameterHandler.getParameter("AUTOCONNECT");
        if (acon != null) {
            if (acon.startsWith("on,")) {
                acon = acon.substring("on,".length());
            }
            this.autoparams = ParamsParser.parseParams(acon);
            this.autoconnect = true;
        }
        this.settings.invitationID = this.getStringParameterNullIfEmpty("invite");
        this.settings.requestElevation = this.getStringParameterNullIfEmpty("requestelevation");
        String cnow = this.parameterHandler.getParameter("connectnow");
        if (cnow != null) {
            System.out.println("[CommonHelpUtil] Found connect now parameter " + cnow);
            cnow = cnow.trim();
            if (cnow.length() > 0) {
                String commandString;
                int command = cnow.indexOf(44);
                if (command == -1) {
                    command = cnow.length();
                }
                if ((commandString = cnow.substring(0, command)) != null) {
                    if ((commandString = commandString.toLowerCase()).startsWith("no") || commandString.startsWith("false") || commandString.startsWith("off")) {
                        System.out.println("[CommonHelpUtil] Connectnow is off");
                        this.autoconnect = false;
                        this.optionalautoconnect = false;
                    } else if (commandString.startsWith("optional")) {
                        System.out.println("[CommonHelpUtil] Connectnow is optional");
                        this.autoconnect = true;
                        this.optionalautoconnect = true;
                    } else {
                        System.out.println("[CommonHelpUtil] Connectnow is on");
                        this.autoconnect = true;
                        this.optionalautoconnect = false;
                    }
                    if (command < cnow.length()) {
                        cnow = cnow.substring(command + 1);
                        this.autoparams = ParamsParser.parseParams(cnow);
                        this.settings.parseAutoConnectInformation(this.autoparams);
                    }
                }
            }
        }
        if (!this.sdemoConnection) {
            this.settings.technicianFilter = this.getStringParameterNullIfEmpty("technician");
            this.settings.technicianGroupFilter = this.getStringParameterNullIfEmpty("techniciangroup");
        }
        if ((result = this.getBooleanParameter("chat")) != null) {
            this.settings.chat = result;
        }
        if ((s = this.parameterHandler.getParameter("filetransfer")) != null) {
            if ((s = s.toLowerCase().trim()).equals("no") || s.equals("off") || s.equals("false")) {
                this.settings.ftp = false;
            } else if (s.equals("option") || s.equals("optional")) {
                this.ftpoptional = true;
                this.settings.ftp = true;
            } else {
                this.settings.ftp = true;
            }
        }
        if ((s = this.parameterHandler.getParameter("remotedesktop")) != null) {
            if ((s = s.toLowerCase().trim()).equals("no") || s.equals("off") || s.equals("false")) {
                this.settings.rdp = false;
            } else if (s.equals("option") || s.equals("optional")) {
                this.rdpoptional = true;
                this.settings.rdp = true;
            } else {
                this.settings.rdp = true;
            }
        }
        if ((result = this.getBooleanParameter("password_required")) != null) {
            this.requirePassword = result;
        }
    }

    public String getStringParameterNullIfEmpty(String key) {
        String s = this.parameterHandler.getParameter(key);
        if (s != null && s.trim().length() != 0) {
            return s.trim();
        }
        return null;
    }

    public Boolean getBooleanParameter(String key) {
        String s = this.parameterHandler.getParameter(key);
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        if ((s = s.toLowerCase().trim()).equals("no") || s.equals("off") || s.equals("false")) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public boolean getBooleanParameter(String key, boolean defaultResult) {
        String s = this.parameterHandler.getParameter(key);
        if (s == null || s.trim().length() == 0) {
            return defaultResult;
        }
        return !(s = s.toLowerCase().trim()).equals("no") && !s.equals("off") && !s.equals("false");
    }

    public void loadTranslations() throws Exception {
        String codebase = this.getCodeBase();
        if (!(codebase = codebase.substring(0, codebase.lastIndexOf(47) + 1)).endsWith("/")) {
            codebase = codebase + "/";
        }
        this.retrieveParametersFromServer(codebase);
        Language.loadTranslations();
        if (Language.DEFLANG_SRC == null) {
            System.out.println("[CommonHelpUtil] DEFLANG_SRC is null?");
            throw new Exception();
        }
        try {
            System.out.println("[CommonHelpUtil] About to call downloadSecondaryTranslations");
            Language.downloadSecondaryTranslations(codebase);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void setExecutable(File targetDir, String filename) {
        File targetFile = new File(targetDir, filename);
        PermissionsUtil.setExecutableForMe(targetFile);
    }

    public void loadNativeLibraries(boolean launchMouseMover) {
        block17: {
            try {
                File nativeLauncher;
                AuxConfig.blockUntilAuxDownloaded();
                NativeLibraryLoader.loadLibrary(JWSystem.getAppFolder());
                try {
                    NativeUtils.getInstance();
                }
                catch (Throwable t) {
                    System.out.println("[CommonHelp] \tLibrary Loader Failed (" + t.getMessage() + ")");
                }
                try {
                    NativeScreenUtil.getInstance();
                }
                catch (Throwable t) {
                    System.out.println("[CommonHelp] \tScreen Utility Failed (" + t.getMessage() + ")");
                }
                try {
                    NativeGrab.getInstance();
                }
                catch (Throwable t) {
                    if (t.getMessage() == null) {
                        System.out.println("[CommonHelp] \tFailed (" + t + ")");
                    }
                    System.out.println("[CommonHelp] \tFailed (" + t.getMessage() + ")");
                }
                this.setExecutable(JWSystem.getAppFolder(), "elev_mac");
                if (CentralDebugging.ENABLE_NATIVE_HOOKS) {
                    this.setupInputCapture();
                }
                if ((nativeLauncher = JWSystem.getNativeJavaLauncher()) != null) {
                    VMFork.overrideDefaultJavaExe(nativeLauncher.getAbsolutePath());
                }
                if (!launchMouseMover) break block17;
                try {
                    this.mmovefailedCompletely = false;
                    this.mmoveRestrictedLaunched = false;
                    String classPath = System.getProperty("java.class.path");
                    String pathSeparator = System.getProperty("path.separator");
                    String[] jarPaths = classPath.split(pathSeparator);
                    if (MouseMover.mouseMoverRequired()) {
                        System.out.println("[CommonHelp] Mouse utility required. ");
                        try {
                            if (!this.settings.shouldElevateMouseMover()) {
                                throw new Throwable("MouseMover elevation not requested");
                            }
                            MouseMover.getInstance(jarPaths, true, true);
                        }
                        catch (Throwable t) {
                            System.out.println("[CommonHelpUtil] Mouse mover startup failed. Requesting unelevated instance.");
                            t.printStackTrace();
                            MouseMover.getInstance(jarPaths, true, false);
                            this.mmoveRestrictedLaunched = true;
                        }
                        break block17;
                    }
                    MouseMover.setPathsForFutureUse(jarPaths);
                }
                catch (Throwable t) {
                    this.mmovefailedCompletely = true;
                    t.printStackTrace();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private void setupInputCapture() {
        System.out.println("[CommonHelpUtil] Setting up keyboard capture hook");
        if (OS.isWindows() && JWNativeAPI.getInstance() != null) {
            new Thread("KeyboardHook"){

                @Override
                public void run() {
                    System.out.println("[CommonHelpUtil] Loading keyboard hook.");
                    JWNativeAPI.getInstance().installKeyboardHookAndBlockThread(null);
                }
            }.start();
            new Thread("MouseHook"){

                @Override
                public void run() {
                    System.out.println("[CommonHelpUtil] Loading mouse hook.");
                    JWNativeAPI.getInstance().installMouseHook();
                }
            }.start();
        } else {
            System.out.println("[CommonHelpUtil] Cannot set up keyboard capture hook as NativeUtils was not initialised.");
        }
    }

    public static String getDomainName(String url) throws URISyntaxException {
        URI uri = new URI(url);
        String domain = uri.getHost();
        return domain;
    }

    public static void main(String[] args) throws URISyntaxException, IOException, InterruptedException {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        CommonHelpUtil test = new CommonHelpUtil(frame, false){

            @Override
            public String getHost() {
                return "localhost";
            }

            @Override
            public int getPort() {
                return 5401;
            }

            @Override
            public String getConnectURL() {
                return "http://localhost:5401";
            }

            @Override
            public String getCodeBase() {
                return "http://localhost:5401/";
            }

            @Override
            public String getDemoName() {
                return null;
            }

            @Override
            public Customer getDemoCustomerType() {
                return null;
            }
        };
        test.parameterHandler = new ParameterHandler(null, null){

            @Override
            public String getParameter(String key) {
                if (key.equals("connectnow")) {
                    return "off,George";
                }
                return null;
            }
        };
        test.processParameters();
        frame.getContentPane().add(test.main);
        frame.setVisible(true);
        ClientBranding.loadBrandingFromServer(test.getCodeBase());
        test.processParameters();
        test.startCustomer();
        Thread.sleep(3000L);
        test.serverGUI.setTechnicianConnectedStatus(true, "George", "lingo", System.currentTimeMillis());
        test.serverGUI.setConnected();
        test.serverGUI.setAvatar(FileUtil.readFile("/Users/gchristelis/Desktop/avatar.png"), "gchristelis", "George");
        Thread.sleep(2000L);
        test.serverGUI.setFinished();
    }

    public void startCustomer() {
        try {
            this.main.setOpaque(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("[CommonHelp] SimpleHelp customer console started");
        try {
            System.setSecurityManager(new SecurityManager(){

                @Override
                public void checkPermission(Permission perm) {
                }

                @Override
                public void checkPermission(Permission perm, Object context) {
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!this.sdemoConnection) {
            try {
                GlassDialog.clearAllGlassDialogs();
            }
            catch (Throwable tt) {
                tt.printStackTrace();
            }
        }
        this.ftpcheck = new JCheckBox(Language.get("ALLOW_REMOTE_FTP"), true);
        this.rdpcheck = new JCheckBox(Language.get("ALLOW_REMOTE_DESKTOP"), true);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(0, 0));
        this.northBrand = new FitImagePanel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                if (dim.height > 300) {
                    dim.height = 300;
                }
                return dim;
            }
        };
        BufferedImage splashImage = ClientBranding.get().getSplashImage(false);
        if (splashImage != null) {
            this.northBrand.setImage(splashImage);
        }
        this.southBrand = new JPanel();
        this.southBrand.setBorder(SHBorderFactory.createMatteBorder(1, 0, 0, 0, SHStyle.BORDER_COLOR));
        GridBagLayout gbl = new GridBagLayout();
        this.southBrand.setLayout(gbl);
        String version = Language.get("SIMPLEHELP_HELP_VERSION");
        if (version != null) {
            version = version.trim();
        }
        if (version == null) {
            version = "";
        }
        if (version.equals("SimpleHelp v")) {
            version = version + " " + Version.getExtendedUserFacing();
        }
        JLabel versionLabel = new JLabel(version, 4);
        final JLabel secureLabel = new JLabel();
        secureLabel.setIcon(ImageLoader.getImageIcon("images/svg/general/lock.svg,16"));
        secureLabel.setText(Language.get("SECURE_SHORT"));
        secureLabel.setToolTipText(Language.get("SECURE_LONG"));
        secureLabel.setHorizontalAlignment(0);
        this.timer.setFont(this.timer.getFont().deriveFont(0));
        gbl.setConstraints(this.timer, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        gbl.setConstraints(secureLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(0, 5, 0, 5), 0, 0));
        gbl.setConstraints(versionLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        final int minRequiredWidth = this.timer.getPreferredSize().width + secureLabel.getPreferredSize().width + versionLabel.getPreferredSize().width;
        this.southBrand.addComponentListener(new ComponentAdapter(){
            private boolean textVisible = true;

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = (Component)e.getSource();
                if (minRequiredWidth > c.getWidth() && this.textVisible) {
                    this.textVisible = false;
                    secureLabel.setVisible(false);
                } else if (minRequiredWidth <= c.getWidth() && !this.textVisible) {
                    this.textVisible = true;
                    secureLabel.setVisible(true);
                }
            }
        });
        this.southBrand.add(versionLabel);
        this.southBrand.add(this.timer);
        this.southBrand.add(secureLabel);
        mainPanel.add((Component)this.main, "Center");
        mainPanel.add((Component)this.southBrand, "South");
        mainPanel.add((Component)this.northBrand, "North");
        if (!this.sdemoConnection) {
            this.rpc.getContentPane().setLayout(new GridLayout(1, 1));
            this.rpc.getContentPane().add(mainPanel);
            String updateURL = JWSystem.getUpdateURL();
            if (updateURL != null) {
                this.settings.getCustomer().setRequestURL(updateURL);
                try {
                    String domainName = CommonHelpUtil.getDomainName(updateURL);
                    this.settings.getCustomer().setRequestDomain(domainName);
                }
                catch (Throwable t) {
                    System.out.println("[CommonHelpUtil] Warning. Unable to parse domain name " + updateURL + " (" + t.getMessage() + ")");
                }
            }
            this.settings.getCustomer().detectNetworkSettings();
        }
        if (this.autoconnect && !this.optionalautoconnect || this.sdemoConnection || this.settings.invitationID != null) {
            System.out.println("[CommonHelp] Automatic server connection initiated");
            new Connector(this.settings).start();
        } else if (Testing.amTesting()) {
            System.out.println("[RS Testing] Automatically entering in test customer details");
            this.settings.chat = true;
            this.settings.ftp = true;
            String deferTestControlHost = JWLaunchProperties.getPropertyPossiblyNull("INFO_CUST_DEFER");
            if (deferTestControlHost != null) {
                try {
                    JWTestControl.shareJWT(this, deferTestControlHost, TestUtils.TESTCONTROL_PORT);
                }
                catch (IOException x) {
                    x.printStackTrace();
                    System.exit(1);
                }
            }
            new Connector(this.settings).start();
        } else {
            String codebase = this.getCodeBase();
            if (!(codebase = codebase.substring(0, codebase.lastIndexOf(47) + 1)).endsWith("/")) {
                codebase = codebase + "/";
            }
            String disclaimerUrl = codebase + "simplehelpdisclaimer.txt?language=" + Language.DEFLANG_ID;
            System.out.println("[CommonHelp] Retrieving SimpleHelp disclaimer...");
            String disclaimer = null;
            try {
                URL url = new URL(disclaimerUrl);
                URLConnection urlc = url.openConnection();
                urlc.setUseCaches(false);
                InputStream in = urlc.getInputStream();
                disclaimer = StreamUtils.readAllAsStringUTF8(in);
                in.close();
            }
            catch (Throwable t) {
                System.out.println("[CommonHelp] Unable to fetch disclaimer (" + t.getMessage() + ")");
                t.printStackTrace();
            }
            System.out.println("[CommonHelp] Retrieving SimpleHelp details...");
            String detailsUrl = codebase + "simplehelpdetails.txt";
            try {
                URL detailsurl = new URL(detailsUrl);
                URLConnection detailsurlc = detailsurl.openConnection();
                detailsurlc.setUseCaches(false);
                InputStream din = detailsurlc.getInputStream();
                String detailXML = StreamUtils.readAllAsStringUTF8(din);
                this.detailFields = CUIFieldRepository.fieldsFromXML(detailXML);
                din.close();
                for (CUIField field : this.detailFields) {
                    field.setDisplayLabel(Language.get(field.getLabel()));
                    System.out.println("[CommonHelp] Setting displaylabel for " + field.getLabel() + " to " + field.getDisplayLabel());
                }
            }
            catch (Throwable e) {
                System.out.println("[CommonHelp] Unable to fetch details (" + e.getMessage() + ")");
            }
            this.main.removeAll();
            this.main.setLayout(new BorderLayout());
            JPanel options = new JPanel();
            int N = 0;
            if (this.ftpoptional) {
                ++N;
                options.add(this.ftpcheck);
            }
            if (this.rdpoptional) {
                ++N;
                options.add(this.rdpcheck);
            }
            options.setLayout(new GridLayout(N, 1));
            System.out.println("[CommonHelp] Showing disclaimer...");
            this.updateFrame();
            if (disclaimer == null || disclaimer.trim().length() == 0) {
                this.disclaimerAccepted();
            } else {
                new DisclaimerPanelGlassDialog(Language.DEFLANG, this.rpc, this, disclaimer, options);
            }
        }
    }

    @Override
    public void detailsRejected() {
        this.disclaimerRejected();
    }

    @Override
    public void disclaimerRejected() {
        this.main.removeAll();
        this.main.setLayout(new GridLayout(1, 1));
        this.main.add(new JLabel(Language.get("DISCLAIMER_REJECTED_MSG"), 0));
        this.updateFrame();
    }

    @Override
    public void disclaimerAccepted() {
        if (this.ftpoptional) {
            this.settings.ftp = this.ftpcheck.isSelected();
        }
        if (this.rdpoptional) {
            this.settings.rdp = this.rdpcheck.isSelected();
        }
        try {
            this.main.removeAll();
        }
        catch (Throwable t) {
            System.out.println("[CommonHelp] Caught firefox removeAll error (1).");
        }
        this.main.setLayout(new GridLayout(1, 1));
        System.out.println("[CommonHelp] Showing details dialog.");
        this.updateFrame();
        GlassDialog dp = null;
        if (this.detailFields != null) {
            System.out.println("[CommonHelp] Details fields are: " + Arrays.toString(this.detailFields));
        } else {
            System.out.println("[CommonHelp] Details fields are <<null>>");
        }
        if (this.detailFields != null && this.detailFields.length > 0 || this.requirePassword) {
            if (this.autoconnect && this.optionalautoconnect) {
                this.settings.parseAutoConnectInformation(this.autoparams);
                dp = new DetailsPanelGlassDialog(Language.DEFLANG, this.rpc, this, this.detailFields, this.requirePassword, this.settings);
            } else if (this.settings.getCustomer().hasDetails()) {
                new Connector(this.settings).start();
            } else {
                dp = new DetailsPanelGlassDialog(Language.DEFLANG, this.rpc, this, this.detailFields, this.requirePassword, this.settings);
            }
            if (dp != null) {
                dp.setFocus();
            }
        } else {
            this.detailsAccepted(new ResultPair[0], this.settings.queuePassword);
        }
    }

    @Override
    public void detailsAccepted(ResultPair[] results, String queuePassword) {
        for (int i = 0; i < results.length; ++i) {
            String value = results[i].getValue();
            if (value.length() > 500) {
                value = value.substring(0, 500);
            }
            results[i].setValue(value);
        }
        if (results.length == 0) {
            results = new ResultPair[]{new ResultPair("", System.getProperty("user.name"))};
        }
        if (results[0].getValue().length() == 0) {
            results[0].setValue(System.getProperty("user.name"));
        }
        this.settings.setCollectedDetails(results);
        this.settings.queuePassword = queuePassword;
        new Connector(this.settings).start();
    }

    protected NodeLinkStatusListener initStatusListener() {
        return this.timer;
    }

    public void updateFrame() {
        this.main.revalidate();
        this.main.repaint();
        this.rpc.getContentPane().invalidate();
        this.rpc.getContentPane().repaint();
    }

    public void registerForCleanup(Object o) {
        this.cleanup.add(o);
    }

    public void cleanup() {
        for (int i = 0; i < this.cleanup.size(); ++i) {
            try {
                Object o = this.cleanup.get(i);
                if (o instanceof SDesktopServerController) {
                    SDesktopServerController con = (SDesktopServerController)o;
                    con.stopBackwardsConnection();
                    continue;
                }
                if (o == null) continue;
                System.out.println("[CommonHelp] WARNING: unsure how to clean up " + o.getClass().getName());
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public String getTestableAppName() {
        return TestUtils.APP_RS_CUST;
    }

    @Override
    public void call(String str, Message m) throws IOException {
    }

    @Override
    public void testControlConnectionFailed() {
        System.out.println("[Testing] JWTestControl connection failed, exiting");
        try {
            JWTesting.reportFail("JWTestControl connection failed to CommonHelpUtil", "");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.exit(1);
    }

    static {
        SimpleHelpFrame.setLnf();
        AntiAliasingEnforcer.tryToSetAllFontsAntialiased();
    }

    public class Connector
    extends Thread {
        private ConnectionSettings settings;

        public Connector(ConnectionSettings settings) {
            this.settings = settings;
        }

        @Override
        public void run() {
            SDesktopServerController con;
            CommonHelpUtil.this.started = true;
            if (this.settings.url == null || this.settings.url.length() == 0) {
                this.settings.url = SHJWUtil.getUpdateURLProtocol() + "://" + this.settings.host + ":" + this.settings.port + "/technician";
            }
            System.out.println("[CommonHelp] Attempting to establish remote session to '" + this.settings.url + "'");
            SimpleDesktopServer.callback_only = true;
            SimpleDesktopServer.callback_via_proxy_server = true;
            try {
                CommonHelpUtil.this.main.removeAll();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            CommonHelpUtil.this.main.setLayout(new BorderLayout());
            CommonHelpUtil.this.connectingLabel = new JLabel(Language.get("CONNECTING"));
            CommonHelpUtil.this.connectingLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            CommonHelpUtil.this.connectingLabel.setHorizontalAlignment(0);
            CommonHelpUtil.this.connectingLabel.setIcon(new ArrowAnimatedIcon());
            CommonHelpUtil.this.main.add((Component)CommonHelpUtil.this.connectingLabel, "Center");
            CommonHelpUtil.this.timer.reset();
            if (!CommonHelpUtil.this.sdemoConnection) {
                try {
                    CommonHelpUtil.this.rpc.getContentPane().repaint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    CommonHelpUtil.this.updateFrame();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            CommonHelpUtil.this.sui = new JPanel();
            CommonHelpUtil.this.sui.setLayout(new BorderLayout());
            CommonHelpUtil.this.sui.setVisible(false);
            System.out.println("[CommonHelp] Creating customer GUI...");
            CommonHelpUtil.this.serverGUI = new ServerGUI(Language.DEFLANG, CommonHelpUtil.this.rpc, CommonHelpUtil.this.sui, CommonHelpUtil.this.sdemoConnection, false){

                @Override
                public void setFinished() {
                    super.setFinished();
                    CommonHelpUtil.this.timer.stop();
                    CommonHelpUtil.this.setInfoText(Language.get("NO_LONGER_CONNECTED"));
                }

                @Override
                public void setWaiting() {
                    super.setWaiting();
                    CommonHelpUtil.this.inQueue();
                    CommonHelpUtil.this.setInfoText(Language.get("IN_QUEUE_MSG"));
                    CommonHelpUtil.this.setInfoIcon(ImageLoader.getImageIcon("images/svg/users/queue.svg,24"));
                }

                @Override
                public void setConnected() {
                    super.setConnected();
                    CommonHelpUtil.this.main.removeAll();
                    CommonHelpUtil.this.sui.setVisible(true);
                    CommonHelpUtil.this.main.add((Component)CommonHelpUtil.this.sui, "Center");
                    CommonHelpUtil.this.sui.repaint();
                    CommonHelpUtil.this.main.repaint();
                }
            };
            CommonHelpUtil.this.sui.setVisible(false);
            CommonHelpUtil.this.sui.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int northBrandHeight = CommonHelpUtil.this.northBrand.getHeight();
                    boolean isVisible = CommonHelpUtil.this.northBrand.isVisible();
                    if (CommonHelpUtil.this.serverGUI.getChatPanelHeight() < 200 && isVisible) {
                        CommonHelpUtil.this.northBrand.setVisible(false);
                    }
                    if (CommonHelpUtil.this.serverGUI.getChatPanelHeight() - northBrandHeight > 200 && !isVisible) {
                        CommonHelpUtil.this.northBrand.setVisible(true);
                    }
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentShown(ComponentEvent e) {
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                }
            });
            System.out.println("[CommonHelp] Creating customer controller...");
            CommonHelpUtil.this.controller = con = new SDesktopServerController(Language.DEFLANG);
            CommonHelpUtil.this.registerForCleanup(con);
            System.out.println("[CommonHelp] Initialising customer console...");
            if (!this.settings.chat) {
                CommonHelpUtil.this.serverGUI.setNoChat();
            }
            CommonHelpUtil.this.serverGUI.init(con, this.settings.getCustomer().getUsefulHumanReadableName());
            CommonHelpUtil.this.serverGUI.setCustomer(this.settings.getCustomer());
            con.setGUI(CommonHelpUtil.this.serverGUI);
            con.setMouseMoverFailed(CommonHelpUtil.this.mmovefailedCompletely || CommonHelpUtil.this.mmoveRestrictedLaunched);
            con.setSimpleDemoConnection(CommonHelpUtil.this.sdemoConnection);
            CommonHelpUtil.this.serverGUI.setEnabled(false);
            this.notifyUserConnected(this.settings);
            if (JWTestControl.amDeferred()) {
                JWTesting.reportSuccess("Remote Support Customer Join Queue");
            }
            if (CommonHelpUtil.this.serverGUI.requestCallbackConnection(this.settings, CommonHelpUtil.this.initStatusListener())) {
                if (JWTestControl.amDeferred()) {
                    JWTesting.reportSuccess("Remote Support Customer In Session");
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CommonHelpUtil.this.sui.setVisible(true);
                        CommonHelpUtil.this.serverGUI.setConnected();
                    }
                });
            } else {
                CommonHelpUtil.this.serverGUI.setFinished();
            }
            CommonHelpUtil.this.timer.reset();
        }

        private void notifyUserConnected(ConnectionSettings cSettings) {
            CommonHelpUtil.this.customerConnectedNotice(cSettings);
        }
    }
}

