/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common;

import com.aem.SafeResourceBundle;
import com.aem.sdesktop.util.Version;
import com.aem.shelp.images.Icons;
import com.aem.shelp.licence.OemBranding;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import utils.files.FileUtil;
import utils.progtools.net.URLParser;
import utils.string.Normaliser;
import utils.swing.images.ImageHelper;
import utils.swing.images.ImageLoader;
import utils.swing.images.PNGChunkRemover;

public class AbstractBranding {
    public static final String HOSTED_RESALE_BRANDING = "HOSTED_RESALE_BRANDING";
    protected static AbstractBranding INSTANCE = new AbstractBranding();
    protected static BufferedImage splashImage = null;
    protected static BufferedImage scaledSplashImage = null;
    protected static byte[] splashImageBytes = null;
    protected static byte[] scaledSplashImageBytes = null;
    protected ImageIcon fullLogo = null;
    protected ImageIcon shLogo16 = null;
    protected ImageIcon shLogo32 = null;
    protected ImageIcon shLogo48 = null;
    protected ImageIcon shLogo256 = null;
    protected ImageIcon sgLogo16 = null;
    protected ImageIcon sgLogo32 = null;
    protected ImageIcon sgLogo48 = null;
    protected ImageIcon sgLogo256 = null;
    protected ImageIcon systemTrayBlue16 = null;
    protected ImageIcon systemTrayRed16 = null;
    protected ImageIcon systemTrayBlue36 = null;
    protected ImageIcon systemTrayRed36 = null;
    protected String technicianApplicationNameWithVersion = OemBranding.OEM_IS_SH ? OemBranding.OEM_APPLICATION_NAME + " " + Version.getExtendedUserFacing() : OemBranding.OEM_APPLICATION_NAME + " " + Version.getExtendedUserFacing();
    protected String technicianApplicationName = OemBranding.OEM_IS_SH ? OemBranding.OEM_APPLICATION_NAME : OemBranding.OEM_APPLICATION_NAME;
    protected String customerApplicationNameWithVersion = OemBranding.OEM_IS_SH ? OemBranding.OEM_APPLICATION_NAME + " " + Version.getExtendedUserFacing() : OemBranding.OEM_APPLICATION_NAME + " " + Version.getExtendedUserFacing();
    protected String customerApplicationName = OemBranding.OEM_IS_SH ? OemBranding.OEM_APPLICATION_NAME : OemBranding.OEM_APPLICATION_NAME;
    protected String supportExeName = null;
    protected boolean supportExeKeepOS = true;
    protected boolean supportExeKeepType = true;
    protected long lastModified = 0L;
    private byte[] lastReadImageData = null;

    public static AbstractBranding get() {
        return INSTANCE;
    }

    public BufferedImage createScaledVersionOf(BufferedImage image) {
        this.lastReadImageData = null;
        BufferedImage scaledSplash = ImageHelper.scaleDownToFitInside(image, 300, 200);
        if (scaledSplash == null) {
            return null;
        }
        this.lastReadImageData = AbstractBranding.getImageBytes(scaledSplash);
        if (this.lastReadImageData == null) {
            return null;
        }
        int w = 300;
        int h = 200;
        while (this.lastReadImageData.length > 100000 && w >= 50 && h >= 50) {
            scaledSplash = ImageHelper.scaleDownToFitInside(image, w /= 2, h /= 2);
            this.lastReadImageData = AbstractBranding.getImageBytes(scaledSplash);
        }
        return scaledSplash;
    }

    protected static byte[] getImageBytes(BufferedImage image) {
        if (image == null) {
            return null;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", bout);
            return bout.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public BufferedImage getSplashImage(boolean scaledDown) {
        if (scaledDown) {
            return scaledSplashImage;
        }
        return splashImage;
    }

    public byte[] getSplashImageBytes(boolean scaledDown) {
        if (scaledDown) {
            return scaledSplashImageBytes;
        }
        return splashImageBytes;
    }

    public String getRemoteSupportDownloadName() {
        return this.supportExeName;
    }

    public boolean shouldRemoteSupportDownloadKeepOS() {
        return this.supportExeKeepOS;
    }

    public boolean shouldRemoteSupportDownloadKeepType() {
        return this.supportExeKeepType;
    }

    public String getApplicationNameWithVersion(boolean customerFacing) {
        if (customerFacing) {
            if (this.customerApplicationNameWithVersion.contains("SimpleHelp")) {
                return this.customerApplicationNameWithVersion;
            }
            return this.customerApplicationName;
        }
        if (this.technicianApplicationNameWithVersion.contains("SimpleHelp")) {
            return this.technicianApplicationNameWithVersion;
        }
        return this.technicianApplicationName;
    }

    public String getApplicationName(boolean customerFacing) {
        if (customerFacing) {
            return this.customerApplicationName;
        }
        return this.technicianApplicationName;
    }

    public String getApplicationNameWithVersionSH(boolean customerFacing) {
        return this.getApplicationNameWithVersion(customerFacing);
    }

    public String getApplicationNameWithSH(boolean customerFacing) {
        return this.getApplicationName(customerFacing);
    }

    public Icon getFullLogo(boolean sh) {
        if (this.fullLogo != null) {
            return this.fullLogo;
        }
        return ImageLoader.getImageIcon(Icons.SH_LOGO_LARGE);
    }

    public ImageIcon getLogo32(boolean sh) {
        return AbstractBranding.returnWorkingImage(sh, this.shLogo32, "images/svg/logos/simplehelp-blue.svg,32", this.shLogo32, "images/svg/logos/simplehelp-blue.svg,32");
    }

    public ImageIcon getLogo16(boolean sh) {
        return AbstractBranding.returnWorkingImage(sh, this.shLogo16, "images/svg/logos/simplehelp-blue.svg,16", this.shLogo16, "images/svg/logos/simplehelp-blue.svg,16");
    }

    public ImageIcon getLogo48(boolean sh) {
        return AbstractBranding.returnWorkingImage(sh, this.shLogo48, "images/svg/logos/simplehelp-blue.svg,48", this.shLogo48, "images/svg/logos/simplehelp-blue.svg,48");
    }

    public ImageIcon getLogo256(boolean sh) {
        return AbstractBranding.returnWorkingImage(sh, this.shLogo256, "images/svg/logos/simplehelp-blue.svg,256", this.sgLogo256, "images/svg/logos/simplehelp-blue.svg,256");
    }

    private static ImageIcon returnWorkingImage(boolean first, ImageIcon firstCached, String firstKey, ImageIcon secondCached, String secondKey) {
        if (first) {
            if (firstCached != null) {
                return firstCached;
            }
            return new ImageIcon(ImageLoader.getAsImage(firstKey));
        }
        if (secondCached != null) {
            return secondCached;
        }
        return new ImageIcon(ImageLoader.getAsImage(secondKey));
    }

    public long getMostRecentLoadedImageLastModified() {
        return this.lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage loadImage(File imageFile, boolean stripStrangePNGBlocks, boolean trackLastModified) {
        try {
            if (!imageFile.exists()) {
                return null;
            }
            this.lastReadImageData = (byte[])(imageFile.length() > 0L ? FileUtil.readFile(imageFile) : null);
            if (stripStrangePNGBlocks) {
                File originalFileCopy = new File(imageFile.getParentFile(), imageFile.getName() + ".original");
                FileUtil.writeFile(originalFileCopy, this.lastReadImageData);
                File tmpFile = File.createTempFile(imageFile.getName(), "stripped");
                BufferedInputStream fin = new BufferedInputStream(new ByteArrayInputStream(this.lastReadImageData));
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmpFile));
                try {
                    System.out.println("[Branding] Stripping PNG chunks from " + imageFile.getName());
                    PNGChunkRemover.remove(fin, out);
                }
                finally {
                    try {
                        ((InputStream)fin).close();
                    }
                    catch (Exception exception) {}
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (Exception exception) {}
                }
                if (!tmpFile.renameTo(imageFile)) {
                    FileUtil.copy(tmpFile, imageFile);
                    tmpFile.delete();
                }
            }
            this.updateLastModified(imageFile.lastModified());
            if (imageFile.length() > 0L) {
                return ImageIO.read(new ByteArrayInputStream(this.lastReadImageData));
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private void updateLastModified(long lastModified) {
        this.lastModified = Math.max(lastModified, this.lastModified);
    }

    private BufferedImage loadImage(File parent, String path, boolean stripPngBlocks, boolean trackLastModified) {
        return this.loadImage(new File(parent, path), stripPngBlocks, trackLastModified);
    }

    private ImageIcon loadImageIcon(File imageFile, boolean stripPngBlocks, boolean trackLastModified) {
        try {
            BufferedImage image = this.loadImage(imageFile, stripPngBlocks, trackLastModified);
            if (image == null) {
                return null;
            }
            return new ImageIcon(image);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void loadBrandingFrom(File brandingFolder, boolean stripChunks) {
        this.loadBrandingFrom(brandingFolder, stripChunks, 0L);
    }

    public void loadBrandingFrom(File brandingFolder, boolean stripChunks, long otherLastModified) {
        block13: {
            this.lastModified = otherLastModified;
            boolean trackLastModified = otherLastModified != 0L;
            this.fullLogo = this.loadImageIcon(new File(brandingFolder, "logo_full.png"), stripChunks, trackLastModified);
            this.shLogo32 = this.loadImageIcon(new File(brandingFolder, "logo_blue_16.png"), stripChunks, trackLastModified);
            this.shLogo32 = this.loadImageIcon(new File(brandingFolder, "logo_blue_32.png"), stripChunks, trackLastModified);
            this.shLogo48 = this.loadImageIcon(new File(brandingFolder, "logo_blue_48.png"), stripChunks, trackLastModified);
            this.shLogo256 = this.loadImageIcon(new File(brandingFolder, "logo_blue_256.png"), stripChunks, trackLastModified);
            this.sgLogo16 = this.loadImageIcon(new File(brandingFolder, "logo_green_32.png"), stripChunks, trackLastModified);
            this.sgLogo32 = this.loadImageIcon(new File(brandingFolder, "logo_green_32.png"), stripChunks, trackLastModified);
            this.sgLogo48 = this.loadImageIcon(new File(brandingFolder, "logo_green_48.png"), stripChunks, trackLastModified);
            this.sgLogo256 = this.loadImageIcon(new File(brandingFolder, "logo_green_256.png"), stripChunks, trackLastModified);
            this.systemTrayBlue16 = this.loadImageIcon(new File(brandingFolder, "systemtray_blue_16.png"), stripChunks, trackLastModified);
            this.systemTrayRed16 = this.loadImageIcon(new File(brandingFolder, "systemtray_red_16.png"), stripChunks, trackLastModified);
            this.systemTrayBlue36 = this.loadImageIcon(new File(brandingFolder, "systemtray_blue_36.png"), stripChunks, trackLastModified);
            this.systemTrayRed36 = this.loadImageIcon(new File(brandingFolder, "systemtray_red_36.png"), stripChunks, trackLastModified);
            splashImage = this.loadImage(new File(brandingFolder, "applet_splash.png"), stripChunks, trackLastModified);
            splashImageBytes = this.lastReadImageData;
            if (splashImage != null && (scaledSplashImage = this.createScaledVersionOf(splashImage)) != null) {
                scaledSplashImageBytes = this.lastReadImageData;
            }
            try {
                File properties = new File(brandingFolder, "branding.properties");
                if (!properties.exists()) break block13;
                Properties newProperties = new Properties();
                newProperties.load(new FileInputStream(properties));
                this.customerApplicationName = this.customerApplicationNameWithVersion = (String)newProperties.get("APPLICATION_NAME");
                if (this.customerApplicationNameWithVersion == null) {
                    this.customerApplicationNameWithVersion = "SimpleHelp " + Version.getExtendedUserFacing();
                    this.customerApplicationName = "SimpleHelp";
                } else if (this.customerApplicationNameWithVersion.equals("SimpleHelp")) {
                    this.customerApplicationNameWithVersion = "SimpleHelp " + Version.getExtendedUserFacing();
                }
                if (newProperties.getProperty(HOSTED_RESALE_BRANDING) != null) {
                    this.technicianApplicationNameWithVersion = this.customerApplicationNameWithVersion;
                    this.technicianApplicationName = this.customerApplicationName;
                }
                this.supportExeName = (String)newProperties.get("SUPPORT_EXE_NAME");
                if (this.supportExeName != null) {
                    this.supportExeName = this.supportExeName.trim();
                    this.supportExeName = this.supportExeName.length() == 0 ? null : new String(this.convertToValidCDName(this.supportExeName.toCharArray()));
                }
                try {
                    this.supportExeKeepOS = ((String)newProperties.get("SUPPORT_EXE_NAME_KEEP_OS")).equalsIgnoreCase("true");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.supportExeKeepType = ((String)newProperties.get("SUPPORT_EXE_NAME_KEEP_TYPE")).equalsIgnoreCase("true");
                }
                catch (Exception exception) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.customerApplicationName != null && !this.customerApplicationName.equals("SimpleHelp")) {
            SafeResourceBundle.addReplaceString("SimpleHelp", this.customerApplicationName, new String[]{OemBranding.OEM_ADMIN_USERNAME});
        }
    }

    private char[] convertToValidCDName(char[] cs) {
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] == ' ' || cs[i] == '_' || cs[i] >= '0' && cs[i] <= '9' || cs[i] >= 'A' && cs[i] <= 'Z' || cs[i] >= 'a' && cs[i] <= 'z') continue;
            cs[i] = 95;
        }
        return cs;
    }

    protected static long getMostRecentlyModifiedResource(File brandingFolder) {
        brandingFolder.mkdirs();
        File[] file = brandingFolder.listFiles();
        long lastModified = 0L;
        if (file != null) {
            for (File aFile : file) {
                if (!aFile.getName().toLowerCase().endsWith("png") && !aFile.getName().toLowerCase().endsWith("ico") && !aFile.getName().toLowerCase().endsWith("branding.properties")) continue;
                lastModified = Math.max(lastModified, aFile.lastModified());
            }
        }
        if (lastModified == 0L) {
            return Long.MIN_VALUE;
        }
        return lastModified;
    }

    protected static File getBrandingFolderForServer(File branding, String codebase) {
        if (codebase == null || codebase.length() == 0) {
            return branding;
        }
        codebase = codebase.toLowerCase();
        URLParser parser = new URLParser(codebase);
        String hostAndPort = parser.getHostname();
        int port = parser.getPort(false);
        if (port > 0) {
            hostAndPort = hostAndPort + ":" + port;
        }
        File result = new File(branding, Normaliser.safeWithoutNormalising(hostAndPort));
        result.mkdirs();
        return result;
    }
}

