/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway.ui;

import com.aem.sgateway.SimpleGatewayServiceConfigure;
import com.aem.sgateway.config.Server;
import com.aem.sgateway.ui.SimpleMachineGroupList;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.login.TechCredentials;
import com.aem.shelp.common.login.TechLoginHandler;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.techclient.TechClientAdapter;
import com.aem.shelp.proxy.techclient.TechClientListener;
import com.aem.shelp.tech.TechHelpUIIPCHandler;
import com.aem.shelp.tech.authentication.TOTPCodeEntryGlassDialog;
import com.aem.shelp.tech.authentication.TwoTierCodeEntryGlassDialog;
import com.jw.SHJWUtil;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import utils.swing.SwingUtil;
import utils.swing.components.RoundBorderPanel;
import utils.swing.components.animated.arrow.ArrowedProgressBar;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class GroupSelectionPanel
implements ActionListener {
    private JPanel rootComponent = new JPanel();
    private SimpleGatewayServiceConfigure sgConfigureDialog;
    public String[][] groups = null;
    private JButton cancel;
    private JButton done;
    private GbPanel buttonsPanel;
    protected SimpleMachineGroupList groupTreePanel;
    private String[] selectedGroup;
    private TechClient tc = null;

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public GroupSelectionPanel(SimpleGatewayServiceConfigure sgConfigureDialog) {
        this.sgConfigureDialog = sgConfigureDialog;
        this.initUI();
    }

    private void initUI() {
        this.done = new JButton(Language.get("GROUP_CHOOSE_OK"));
        this.cancel = new JButton(Language.get("CANCEL"));
        this.buttonsPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        this.buttonsPanel.add(this.cancel, 0, 0, 1, 1, 1, 1, 13, 0);
        this.buttonsPanel.add(this.done, 1, 0, 1, 1, 1, 1, 17, 0);
        SHButtonUI.makeButtonBlue(this.done);
        this.cancel.addActionListener(this);
        this.done.addActionListener(this);
    }

    public void pickGroup() {
        this.showConnecting();
        new PickGroupThread().start();
    }

    private void showConnecting() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GroupSelectionPanel.this.rootComponent.removeAll();
                GroupSelectionPanel.this.rootComponent.setLayout(new BorderLayout());
                JLabel connectingLabel = new JLabel(Language.get("CONNECTING"));
                connectingLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
                ArrowedProgressBar apb = new ArrowedProgressBar();
                GbPanel progressPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
                progressPanel.add(apb.getRootComponent(), 0, 0, 1, 1, 0, 0, 13, 0);
                progressPanel.add(connectingLabel, 1, 0, 1, 1, 0, 0, 17, 0);
                GroupSelectionPanel.this.rootComponent.add("Center", progressPanel);
                apb.on();
                GroupSelectionPanel.this.rootComponent.revalidate();
                GroupSelectionPanel.this.rootComponent.repaint();
            }
        });
    }

    public void showGroupPicker(final String[][] groups) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GroupSelectionPanel.this.groupTreePanel = new SimpleMachineGroupList(groups);
                GroupSelectionPanel.this.rootComponent.removeAll();
                GroupSelectionPanel.this.rootComponent.setLayout(new BorderLayout());
                RoundBorderPanel border = new RoundBorderPanel(Language.get("GROUP_CHOOSE_DIALOG_TITLE"));
                border.setLayout(new GridLayout(1, 1));
                border.add(GroupSelectionPanel.this.groupTreePanel.getRootComponent());
                GroupSelectionPanel.this.rootComponent.add("Center", border);
                GroupSelectionPanel.this.rootComponent.add("South", GroupSelectionPanel.this.buttonsPanel);
                GroupSelectionPanel.this.rootComponent.revalidate();
                GroupSelectionPanel.this.rootComponent.repaint();
            }
        });
    }

    private String[][] getServersGroups(Server server) throws Exception {
        if (TechHelpUIIPCHandler.INSTANCE != null) {
            return TechHelpUIIPCHandler.INSTANCE.getGroupList();
        }
        TechCredentials creds = new TechCredentials();
        creds.setUsername(Language.get("DO_NOT_TRANSLATE_DEFAULT_USERNAME"));
        boolean isConnected = false;
        boolean first = true;
        final RootPaneContainer rpc = SwingUtil.getRootPaneContainer(this.sgConfigureDialog);
        TechClientAdapter techClientAdapter = new TechClientAdapter(){

            @Override
            public TechClientListener.TwoTierResponse requestTwoTierCode(boolean showIncorrectWarning, String techEmailAddress, boolean allowRemember) throws TwoTierCodeEntryGlassDialog.SwitchUserException {
                if (techEmailAddress != null) {
                    TwoTierCodeEntryGlassDialog dialog = new TwoTierCodeEntryGlassDialog(rpc, showIncorrectWarning, techEmailAddress, allowRemember);
                    return dialog.getCode();
                }
                TOTPCodeEntryGlassDialog dialog = new TOTPCodeEntryGlassDialog(rpc, showIncorrectWarning, allowRemember);
                return dialog.getCode();
            }
        };
        boolean previousPasswordIncorrect = false;
        while (this.tc == null && !isConnected) {
            if ((creds = TechLoginHandler.requestLoginCredentials(rpc, creds, SHJWUtil.getUpdateURLProtocol() + "://" + server.getHostname() + ":" + server.getPort(), first, previousPasswordIncorrect)) == null) {
                return null;
            }
            first = false;
            try {
                creds.setSessionToken(TechClient.NULL_SESSION_ID);
                this.tc = new TechClient(Language.DEFLANG_ID, (ResourceBundle)Language.DEFLANG, server.getHostname(), server.getPort(), creds, false, techClientAdapter);
            }
            catch (Throwable t) {
                System.out.println("[TechUI] Login failed - " + t);
                t.printStackTrace();
                previousPasswordIncorrect = t instanceof TechClient.WrongPasswordException;
                if (!previousPasswordIncorrect) {
                    SHGlassOptionPane.showErrorDialog(rpc, t.getMessage(), Language.get("ERROR_WHILE_CONNECTING"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48"), Language.get("CLOSE"));
                }
                creds.setPassword(null);
                isConnected = false;
                continue;
            }
            isConnected = true;
        }
        return this.tc.getEntireMachineGroupList();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.done) {
            this.selectedGroup = this.groupTreePanel.getSelectedGroup();
            this.sgConfigureDialog.setSelectedGroup(this.selectedGroup);
        } else {
            this.selectedGroup = null;
        }
        this.sgConfigureDialog.switchToConfigView();
    }

    public void setTechClient(TechClient tc) {
        this.tc = tc;
    }

    static /* synthetic */ String[] access$302(GroupSelectionPanel x0, String[] x1) {
        x0.selectedGroup = x1;
        return x1;
    }

    class PickGroupThread
    extends Thread {
        PickGroupThread() {
        }

        @Override
        public void run() {
            Server server = GroupSelectionPanel.this.sgConfigureDialog.getSelectedServerOrFirstOption();
            try {
                GroupSelectionPanel.this.groups = GroupSelectionPanel.this.getServersGroups(server);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (GroupSelectionPanel.this.groups == null) {
                GroupSelectionPanel.access$302(GroupSelectionPanel.this, null);
                GroupSelectionPanel.this.sgConfigureDialog.switchToConfigView();
                return;
            }
            GroupSelectionPanel.this.showGroupPicker(GroupSelectionPanel.this.groups);
        }
    }
}

