/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway.config.panels;

import com.aem.sgateway.SimpleGatewayConfig;
import com.aem.sgateway.config.panels.SGChangeListener;
import com.aem.shelp.common.Language;
import com.aem.shelp.tech.utils.StrippedContentPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapCheckBox;
import utils.swing.components.documents.IntegerRangeTextDocument;
import utils.swing.cui.types.fields.TextField;
import utils.swing.cui.validators.TextFieldIntegerRangeValidator;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.layout.GbPanel;

public class SGProxyPanel
implements ActionListener {
    private GbPanel rootComponent = new GbPanel();
    private StrippedContentPanel contentPanel = new StrippedContentPanel(this.rootComponent, false);
    private JWrapCheckBox proxy;
    private JTextField hostnameField;
    private JTextField portField;
    private JTextField usernameField;
    private JTextField passwordField;
    private JLabel hostnameLabel;
    private JLabel portLabel;
    private JLabel usernameLabel;
    private JLabel passwordLabel;
    private SGChangeListener dirtyListener;

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public SGProxyPanel(SGChangeListener dirtyListener, boolean useTabs) {
        this.dirtyListener = dirtyListener;
        this.contentPanel.setStartDark(!useTabs);
        this.initProxyTab(useTabs);
    }

    private void initProxyTab(boolean useTabs) {
        this.proxy = new JWrapCheckBox(Language.get("USE_HTTPS_IF_NECESSARY"));
        this.hostnameField = new JTextField();
        TextField tf = new TextField(null, null, 1);
        tf.addValidator(new TextFieldIntegerRangeValidator(1, 65535));
        IntegerRangeTextDocument textDoc = new IntegerRangeTextDocument(1, 65535);
        this.portField = (JTextField)tf.getComponent();
        this.portField.setDocument(textDoc);
        this.usernameField = TextField.getTextFieldForType(0, Language.get("OPTIONAL"));
        this.passwordField = TextField.getTextFieldForType(7, Language.get("OPTIONAL"));
        this.hostnameField.addKeyListener(this.dirtyListener);
        this.portField.addKeyListener(this.dirtyListener);
        this.usernameField.addKeyListener(this.dirtyListener);
        this.passwordField.addKeyListener(this.dirtyListener);
        this.hostnameLabel = new JLabel("   " + Language.get("PROXY") + " ");
        this.portLabel = new JLabel("   " + Language.get("PORT") + " ");
        this.usernameLabel = new JLabel("   " + Language.get("USERNAME") + " ");
        this.passwordLabel = new JLabel("   " + Language.get("PASSWORD") + " ");
        GbPanel proxyPanel = new GbPanel(new ScaledInsets(0, 0, 3, 0));
        int Y = 0;
        proxyPanel.add(this.proxy.getRootComponent(), 0, Y++, 2, 1, 0, 0, 17, 2);
        proxyPanel.add(this.hostnameLabel, 0, Y, 1, 1, 0, 0, 13, 0);
        proxyPanel.add(this.hostnameField, 1, Y, 1, 1, 30, 0, 10, 2);
        proxyPanel.add(this.portLabel, 2, Y, 1, 1, 0, 0, 13, 0);
        proxyPanel.add(this.portField, 3, Y++, 1, 1, 0, 0, 17, 0);
        SwingUtil.setWidth(this.portField, 70);
        proxyPanel.add(this.usernameLabel, 0, Y, 1, 1, 0, 0, 13, 0);
        proxyPanel.add(this.usernameField, 1, Y++, 1, 1, 30, 0, 10, 2);
        proxyPanel.add(this.passwordLabel, 0, Y, 1, 1, 0, 0, 13, 0);
        proxyPanel.add(this.passwordField, 1, Y++, 1, 1, 30, 0, 10, 2);
        this.contentPanel.addContent(proxyPanel, Language.get("PROXY"));
        if (useTabs) {
            this.contentPanel.addVerticalFiller();
        }
        this.contentPanel.setBackgroundColours(useTabs);
        this.proxy.getRootComponent().setBackground(proxyPanel.getBackground());
        this.proxy.addActionListener(this);
        this.updateEnabled();
    }

    public void saveTo(SimpleGatewayConfig config) {
        try {
            if (this.proxy.isSelected()) {
                config.setProxyHost(this.hostnameField.getText());
                config.setProxyUser(this.usernameField.getText());
                config.setProxyPass(this.passwordField.getText());
                if (this.portField.getText().length() > 0) {
                    config.setProxyPort(Integer.parseInt(this.portField.getText().trim()));
                } else {
                    config.setProxyPort(0);
                }
            } else {
                config.setProxyHost("");
                config.setProxyPort(0);
                config.setProxyUser("");
                config.setProxyPass("");
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public void loadFrom(SimpleGatewayConfig config) {
        if (config.getProxyHost() != null) {
            this.proxy.setSelected(true);
            this.hostnameField.setText(config.getProxyHost());
            this.portField.setText("" + config.getProxyPort());
            this.usernameField.setText(config.getProxyUser());
            this.passwordField.setText(config.getProxyPass());
        } else {
            this.proxy.setSelected(false);
            this.hostnameField.setText(null);
            this.portField.setText(null);
            this.usernameField.setText(null);
            this.passwordField.setText(null);
        }
        this.updateEnabled();
    }

    public void updateEnabled() {
        if (this.proxy != null) {
            boolean b = this.proxy.isSelected();
            this.hostnameField.setEnabled(b);
            this.hostnameLabel.setEnabled(b);
            this.portField.setEnabled(b);
            this.portLabel.setEnabled(b);
            this.usernameField.setEnabled(b);
            this.usernameLabel.setEnabled(b);
            this.passwordField.setEnabled(b);
            this.passwordLabel.setEnabled(b);
        }
    }

    public boolean canSave() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.proxy != null && e.getSource() == this.proxy.getCheckBoxComponent()) {
            this.dirtyListener.setDirty(true);
            this.updateEnabled();
        }
    }
}

