/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway;

import com.aem.sgateway.SGServiceInstallationManager;
import com.aem.sgateway.SimpleGatewayServiceStop;
import java.util.Properties;
import jwrapper.jwutils.JWLauncher;
import jwrapper.jwutils.JWLogging;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.JWUninstallApp;
import jwrapper.logging.LogPoller;
import jwrapper.logging.ProcessResult;

public class UninstallRemoteAccessService {
    public static final String ELEVATED_ALREADY_SO_DO_FULL_UNINSTALL = "ELEVATED_ALREADY_SO_DO_FULL_UNINSTALL";
    public static final String ELEVATED_ALREADY_SO_REMOVE_BITS = "ELEVATED_ALREADY_SO_REMOVE_BITS";
    public static int LAUNCHED_OK;
    public static boolean TESTING_NOUNINSTALL;

    public static ProcessResult elevateProcessToRequestUninstall(String elev_pass) throws Exception {
        Properties lprops = new Properties();
        lprops.setProperty(ELEVATED_ALREADY_SO_DO_FULL_UNINSTALL, "true");
        lprops.setProperty("show_no_ui", "true");
        if (elev_pass != null) {
            JWLauncher.setElevateToRootAutomatically(lprops, elev_pass);
        }
        JWLauncher.setCreateDebugLogsUntil(lprops, System.currentTimeMillis() + 300000L);
        System.out.println("[MiniController] Forking uninstall request (may auto-elevate)");
        long time = System.currentTimeMillis() - 1L;
        LogPoller lp = JWLogging.newLogPoller();
        lp.returnResultsAfter(time);
        JWSystem.forkVirtualApp("JWrapperPostUninstallApp", lprops, null, true, false);
        lp.addReturnOnLaunchedOkCase("JWrapperPostUninstallApp");
        ProcessResult result = lp.waitForResult(90000L);
        if (result == null) {
            throw new Exception("Timed out waiting for the elevated uninstallation process to launch");
        }
        return result;
    }

    public static void elevateProcessToRemoveBitsAndWait() throws Exception {
        Properties lprops = new Properties();
        lprops.setProperty(ELEVATED_ALREADY_SO_REMOVE_BITS, "true");
        lprops.setProperty("show_no_ui", "true");
        JWLauncher.setElevateToAdminOrRootViaDialog(lprops);
        JWLauncher.setCreateDebugLogsUntil(lprops, System.currentTimeMillis() + 300000L);
        System.out.println("[UninstallRemoteAccessService] Forking uninstall request (may request elevation via dialog)");
        long time = System.currentTimeMillis() - 1L;
        LogPoller lp = JWLogging.newLogPoller();
        System.out.println("[UninstallRemoteAccessService] Waiting for result after " + time);
        lp.returnResultsAfter(time);
        JWSystem.forkVirtualApp("JWrapperPostUninstallApp", lprops, null, true, false);
        lp.addReturnOnLaunchedOkCase("JWrapperPostUninstallApp");
        ProcessResult result = lp.waitForResult(90000L);
        if (result == null) {
            throw new Exception("Timed out waiting for the elevated uninstallation process to launch");
        }
        if (result.isLaunchedOK()) {
            lp = JWLogging.newLogPoller();
            lp.returnResultsAfter(time);
            lp.addReturnOnErrorCase("JWrapperPostUninstallApp");
            lp.addReturnOnSuccessCase("JWrapperPostUninstallApp");
            result = lp.waitForResult(300000L);
            if (result == null) {
                throw new Exception("Timed out waiting for a result from the elevated uninstallation process");
            }
            if (result.isError()) {
                throw new Exception("Elevated uninstallation process failed");
            }
        }
    }

    public static void main(String[] args) {
        if (JWSystem.getAppLaunchProperty(ELEVATED_ALREADY_SO_DO_FULL_UNINSTALL).length() > 0) {
            System.out.println("[MiniController] Elevated and asked to remove the entire bundle");
            try {
                JWLogging.writeProcessResult(4);
                Thread.sleep(LogPoller.POLL_FREQ * 3);
                UninstallRemoteAccessService.removeElevatedBits();
                JWUninstallApp.doUninstallOfEntireBundle(false);
                System.exit(0);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        } else if (JWSystem.getAppLaunchProperty(ELEVATED_ALREADY_SO_REMOVE_BITS).length() > 0) {
            System.out.println("[MiniController] Elevated and asked to remove just the non-standard parts of the bundle (uninstall service etc)");
            try {
                JWLogging.writeProcessResult(4);
                UninstallRemoteAccessService.removeElevatedBits();
                JWLogging.writeProcessResult(1);
                System.exit(0);
            }
            catch (Exception x) {
                x.printStackTrace();
                JWLogging.appendProcessTrace(x);
                JWLogging.writeProcessResult(2);
            }
        } else {
            System.out.println("[MiniController] GU requesting that we uninstall, will elevate to remove difficult bits");
            try {
                UninstallRemoteAccessService.elevateProcessToRemoveBitsAndWait();
                System.out.println("[MiniController] Difficult bits removed, will tell GU to continue with full bundle delete");
                if (TESTING_NOUNINSTALL) {
                    JWUninstallApp.exitJvm_CancelUninstall();
                } else {
                    JWUninstallApp.exitJvm_DoUninstall();
                }
            }
            catch (Exception x) {
                x.printStackTrace();
                System.out.println("[MiniController] Difficult bits were not removed, will tell GU to cancel the uninstall");
                JWUninstallApp.exitJvm_CancelUninstall();
            }
        }
    }

    private static void removeElevatedBits() throws Exception {
        System.out.println("[UninstallRemoteAccessService] Uninstalling the SG service");
        SGServiceInstallationManager.silentlyUninstallService();
        System.out.println("[UninstallRemoteAccessService] Removing the shortcuts / launchers");
        SGServiceInstallationManager.silentlyDeleteShortcuts();
        try {
            System.out.println("[UninstallRemoteAccessService] Stopping the SG service (if it is still running)");
            SimpleGatewayServiceStop.stopService(true, false);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    static {
        TESTING_NOUNINSTALL = false;
    }
}

