/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway;

import com.aem.SafeResourceBundle;
import com.aem.nodelink.utils.DataUtils;
import com.aem.sdesktop.client.controller.CommandResponseListener;
import com.aem.sdesktop.interfaces.ClientController;
import com.aem.sgateway.ServiceConfigureListener;
import com.aem.sgateway.SimpleGatewayConfig;
import com.aem.sgateway.SimpleGatewayServiceConfigure;
import com.aem.sgateway.common.SGServiceNameUtil;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.proxy.types.SupportSession;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JFrame;
import utils.message.Message;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.dialog.glassdialog.ScaledGlassDialog;
import utils.swing.images.ImageLoader;

public class ServiceConfigureGlassDialog
extends ScaledGlassDialog
implements WindowListener,
ServiceConfigureListener {
    public static String DEF_SERVER_URL = "";
    public static String DEF_PROXY_HOST = "";
    public static String DEF_PROXY_USERNAME = "";
    public static String DEF_PROXY_PASSWORD = "";
    public static int DEF_PROXY_PORT = 8080;
    SimpleGatewayServiceConfigure panel;
    ClientController controller;
    JFrame frame;
    Object SERVER_URL_LOCK = new Object();
    public boolean didInstallation = false;

    @Override
    public String getTitle() {
        try {
            return Language.get("INSTALL_SIMPLEGATEWAY_SESSION");
        }
        catch (Throwable t) {
            t.printStackTrace();
            return "";
        }
    }

    public ServiceConfigureGlassDialog(JFrame frame, ClientController controller, String nameTemplate, AbstractSession session) {
        super(frame, 450, 420, true, false, false);
        this.frame = frame;
        this.controller = controller;
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension screenSize = toolkit.getScreenSize();
            int x = (screenSize.width - this.getWidth()) / 2;
            int y = (screenSize.height - this.getHeight()) / 2;
            this.setLocation(x, y);
        }
        catch (Throwable toolkit) {
            // empty catch block
        }
        SimpleGatewayConfig conf = new SimpleGatewayConfig();
        if (session instanceof SupportSession) {
            Customer customer = ((SupportSession)session).getCustomer();
            if (nameTemplate == null) {
                conf.setName(Language.get("CUSTOMER") + "/" + customer.toString(false).replace('/', '\\').trim());
            } else {
                conf.setName(SGServiceNameUtil.subsituteCustomerDetails(nameTemplate, customer));
            }
        } else {
            conf.setName("AUTODETECT");
        }
        this.updateDefServerURLAndBlock();
        conf.setURLs(new String[]{DEF_SERVER_URL});
        if (DEF_PROXY_HOST != null && DEF_PROXY_HOST.length() > 0) {
            conf.setProxyHost(DEF_PROXY_HOST);
            conf.setProxyPort(DEF_PROXY_PORT);
            if (DEF_PROXY_USERNAME != null && DEF_PROXY_USERNAME.length() > 0) {
                conf.setProxyUser(DEF_PROXY_USERNAME);
                if (DEF_PROXY_PASSWORD != null && DEF_PROXY_PASSWORD.length() > 0) {
                    conf.setProxyPass(DEF_PROXY_PASSWORD);
                }
            }
        }
        this.panel = new SimpleGatewayServiceConfigure(frame, conf, this, true);
        this.getContentPane().add(this.panel);
        this.setFocusComponent(this.panel);
        this.init(false);
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDefServerURLAndBlock() {
        Object object = this.SERVER_URL_LOCK;
        synchronized (object) {
            Message m = new Message(-1061158794);
            this.controller.doAsyncRemoteCommand(new ServerURLResponseListener(), m);
            try {
                this.SERVER_URL_LOCK.wait(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        this.setVisible(false);
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    public boolean didInstallation() {
        return this.didInstallation;
    }

    @Override
    public void done() {
        this.didInstallation = true;
        this.setVisible(false);
        SHGlassOptionPane.showMessageDialog(this.frame, Language.get("SIMPLEGATEWAY_INSTALL_REQUESTED_1") + "\n\n" + Language.get("SIMPLEGATEWAY_INSTALL_REQUESTED_2"), Language.get("SIMPLEGATEWAY_INSTALL_REQUESTED_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/information.svg,48"));
        SimpleGatewayConfig config = this.panel.createConfigFromSettings();
        boolean installShortcuts = this.panel.installShortcuts();
        this.controller.requestSimpleGatewayInstallation(config, installShortcuts);
    }

    @Override
    public void cancelled() {
        this.didInstallation = false;
        this.setVisible(false);
    }

    public static void main(String[] args) throws IOException {
        SafeResourceBundle language;
        FileInputStream urlin = new FileInputStream("lib/translations/en.txt");
        byte[] tmp = DataUtils.readAll(urlin);
        ((InputStream)urlin).close();
        Language.DEFLANG = language = new SafeResourceBundle(new ByteArrayInputStream(tmp));
        SimpleHelpFrame frame = new SimpleHelpFrame();
        frame.setSize(700, 500);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        new ServiceConfigureGlassDialog(frame, null, "AUTODETECT", null);
    }

    class ServerURLResponseListener
    implements CommandResponseListener {
        ServerURLResponseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void response(Message m) {
            DEF_SERVER_URL = m.getNextString();
            System.out.println("[ServerURLResponseListener] Got response " + DEF_SERVER_URL);
            Object object = ServiceConfigureGlassDialog.this.SERVER_URL_LOCK;
            synchronized (object) {
                ServiceConfigureGlassDialog.this.SERVER_URL_LOCK.notifyAll();
            }
        }
    }
}

