/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway;

import build.BuildConstants;
import com.aem.sgateway.SimpleGatewayID;
import com.aem.sgateway.common.SGPortUtil;
import java.io.File;
import java.io.IOException;
import jwrapper.allplatformwrapper.AllPlatformWrapper;
import jwrapper.jwutils.JWMacOS;
import jwrapper.updater.LaunchFile;
import utils.files.FileUtil;
import utils.osstats.OsStats;
import utils.ostools.OS;

public class SGInstallationCheck {
    public static long getSgID() throws IOException {
        File master = SGInstallationCheck.getStandardSgMasterFolder();
        File config = new File(master, "JWAppsSharedConfig");
        File serviceid = new File(config, "serviceid.dat");
        return SimpleGatewayID.loadOnlyID(serviceid);
    }

    public static File getStandardSgMasterFolder() {
        File master = AllPlatformWrapper.getStandardMasterFolder(BuildConstants.BUNDLE_SG_SERVICE, true);
        return master;
    }

    public static boolean isSGServiceInstalledOnThisMachine() {
        System.out.println("[SGServiceRunningCheck] Checking for " + BuildConstants.BUNDLE_SG_SERVICE + " installation");
        return LaunchFile.getLatestVersionOf(BuildConstants.BUNDLE_SG_SERVICE, SGInstallationCheck.getStandardSgMasterFolder()) != null;
    }

    public static boolean isSGServiceRunningOnThisMachine() {
        File sgPortFile = SGPortUtil.getSGPortFile(SGInstallationCheck.getStandardSgMasterFolder());
        System.out.println("[SGServiceRunningCheck] " + sgPortFile);
        if (!sgPortFile.exists()) {
            return false;
        }
        System.out.println("[SGServiceRunningCheck] File exists...");
        return SGPortUtil.isSGPortFileLocked(sgPortFile);
    }

    public static void forceKillAllV4Services() {
        File master = SGInstallationCheck.getStandardSgMasterFolder();
        File[] portFiles = SGPortUtil.getSgPortFiles(master);
        System.out.println("[SGInstallCheck] Found " + portFiles.length + " port files inside " + master);
        for (File portFile : portFiles) {
            SGInstallationCheck.forceKillV4Service(portFile);
        }
    }

    public static void forceKillV4Service(File portFile) {
        try {
            int sport = SGPortUtil.getSgPortFromFile(portFile, true);
            System.out.println("[SGInstallCheck] Force terminating SG service listening on " + sport);
            OsStats.getOsStats().killProcessListeningOn(sport, true, true);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static void forceDeleteV4ServiceFolder() {
        if (OS.isMacOS() && !JWMacOS.haveSudoPermissions()) {
            System.out.println("[SGInstallCheck] WARNING Service folder cannot be deleted on MacOS without sudo permissions, not attempting to delete");
            return;
        }
        File master = SGInstallationCheck.getStandardSgMasterFolder();
        if (master.getName().contains("JWrapper")) {
            System.out.println("[SGInstallCheck] Deleting " + master);
            FileUtil.deleteDir(master);
        }
    }
}

