/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway;

import bcutil.BCUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.jwutils.JWSystem;
import utils.ostools.OS;
import utils.progtools.net.URLParser;

public class PKHashRepository
implements BCUtil.PublicKeyHashProvider {
    private File repositoryFolder = new File(JWSystem.getAllAppVersionsSharedFolder(), "hash.repository");
    private File hashesFolder;
    private File urlsFolder;

    public PKHashRepository() {
        if (!this.repositoryFolder.exists()) {
            this.repositoryFolder.mkdirs();
        } else if (this.repositoryFolder.isFile()) {
            this.repositoryFolder.delete();
            this.repositoryFolder.mkdirs();
        }
        this.hashesFolder = new File(this.repositoryFolder, "hashes");
        this.urlsFolder = new File(this.repositoryFolder, "urls");
        this.hashesFolder.mkdirs();
        this.urlsFolder.mkdirs();
        if (OS.isMacOS()) {
            System.out.println("[PKHashRepository] Setting permissions for hash repository");
            try {
                JWGenericOS.setWritableForAllUsers(this.repositoryFolder, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getKeyForURL(String url) {
        URLParser parser = new URLParser(url);
        return parser.getProtocol(true) + "__" + parser.getHostname() + "__" + parser.getPort(true);
    }

    private boolean containsFile(File parent, String filename) {
        if (!parent.exists()) {
            return false;
        }
        File[] files = parent.listFiles();
        if (files == null) {
            return false;
        }
        for (File f : files) {
            if (!f.getName().equals(filename)) continue;
            return true;
        }
        return false;
    }

    private boolean createFile(File parent, String filename) {
        if (!this.containsFile(parent, filename)) {
            File newFile = new File(parent, filename);
            try {
                newFile.createNewFile();
                if (OS.isMacOS()) {
                    System.out.println("[SimpleGatewayService] Setting permissions for hash/url file");
                    try {
                        JWGenericOS.setWritableForAllUsers(newFile, true);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public boolean containsURL(String url) {
        if (url == null) {
            return false;
        }
        String key = this.getKeyForURL(url);
        return this.containsFile(this.urlsFolder, key);
    }

    public void addURL(String url, String reason) {
        if (url == null) {
            return;
        }
        System.out.println("[PKHashRepo] Pinning URL " + url + " (" + reason + ")");
        String key = this.getKeyForURL(url);
        this.createFile(this.urlsFolder, key);
    }

    public void removeURL(String url) {
        if (url == null) {
            return;
        }
        String key = this.getKeyForURL(url);
        File file = new File(this.urlsFolder, key);
        if (file.exists()) {
            file.delete();
        }
    }

    public void addHash(String hash, String reason) {
        if (hash == null) {
            return;
        }
        System.out.println("[PKHashRepo] Adding PKHash " + hash + " (" + reason + ")");
        this.createFile(this.hashesFolder, hash);
    }

    public Iterator<String> urlKeyIterator() {
        ArrayList<String> allStrings = new ArrayList<String>();
        File[] files = this.urlsFolder.listFiles();
        if (files != null) {
            for (File f : files) {
                allStrings.add(f.getName());
            }
        }
        return allStrings.iterator();
    }

    @Override
    public Iterator<String> iterator() {
        ArrayList<String> allStrings = new ArrayList<String>();
        File[] files = this.hashesFolder.listFiles();
        if (files != null) {
            for (File f : files) {
                allStrings.add(f.getName());
            }
        }
        return allStrings.iterator();
    }

    public int getNumberOfHashes() {
        if (!this.hashesFolder.exists()) {
            return 0;
        }
        File[] files = this.hashesFolder.listFiles();
        if (files == null) {
            return 0;
        }
        return files.length;
    }

    public void trimURLsNotIncludedIn(String[] urlsToKeep) {
        File[] files = this.urlsFolder.listFiles();
        if (files != null) {
            for (File f : files) {
                boolean found = false;
                for (String url : urlsToKeep) {
                    String key = this.getKeyForURL(url);
                    if (!f.getName().equals(key)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                f.delete();
            }
        }
    }

    public static void main(String[] args) {
        PKHashRepository test = new PKHashRepository();
        test.addURL("udp://url1.com", "testing");
        test.addURL("udp://url2.com", "testing");
        test.addURL("udp://url3.com", "testing");
        test.addURL("udp://url4.com", "testing");
        Iterator<String> it = test.urlKeyIterator();
        while (it.hasNext()) {
            System.out.println((Object)it.next());
        }
        test.trimURLsNotIncludedIn(new String[]{"udp://url2.com", "udp://url4.com"});
        System.out.println();
        it = test.urlKeyIterator();
        while (it.hasNext()) {
            System.out.println((Object)it.next());
        }
    }
}

