/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.util.ui;

import com.aem.CentralDebugging;
import com.aem.sdesktop.util.DateFormatterUtil;
import com.aem.sdesktop.util.ui.ChatEntryPanel;
import com.aem.shelp.common.Language;
import com.aem.utils.Debugger;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import utils.ostools.OS;
import utils.swing.SwingUtil;
import utils.swing.browser.Browser;
import utils.swing.components.JWrapLabel;
import utils.swing.components.avatar.AvatarPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageHelper;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public abstract class ChatPanel
implements ChatEntryPanel.ChatEntryListener {
    private GbPanel rootComponent = new GbPanel();
    private static final int AVATAR_WIDTH = SimpleHelpLookAndFeel.scale(48);
    private static final int AVATAR_HEIGHT = SimpleHelpLookAndFeel.scale(48);
    private static final int AVATAR_BORDER_WIDTH = 1;
    private StyledDocument chat_doc = new DefaultStyledDocument();
    private boolean hasChatContent = false;
    ChatBubble lastBubble = null;
    protected JPanel chat_panel_top = new JPanel();
    protected JPanel chat_panel_bottom = new JPanel();
    protected JPanel chatWindowFiller = new JPanel();
    protected GbPanel chatWindow = new GbPanel();
    protected JScrollPane chat_scroll = new JScrollPane(this.chatWindow);
    private JLabel headerLabel;
    protected RootPaneContainer rpc;
    private boolean showAvatars = true;
    private HashMap<String, BufferedImage> displayNameToAvatarMap = new HashMap();
    private JLabel warningLabel;
    private JPanel warningPanel;
    protected String displayName;
    protected JPanel chatEntryCardPanel;
    protected CardLayout chatEntryCardLayout;
    protected ChatEntryPanel chatEntryPanel;
    protected int chatPanelWidth = 0;
    ScrollDownThread scroller;
    IsTypingBubble typingBubble = new IsTypingBubble();
    final Object typingBubbleLock = new Object();
    HideTypingBubbleThread typingBubbleThread = null;
    SimpleAttributeSet attr_plain = new SimpleAttributeSet();
    SimpleAttributeSet attr_date = new SimpleAttributeSet();
    SimpleAttributeSet attr_message_local = new SimpleAttributeSet();
    SimpleAttributeSet attr_message_remote = new SimpleAttributeSet();
    SimpleAttributeSet attr_uname_local = new SimpleAttributeSet();
    SimpleAttributeSet attr_uname_remote = new SimpleAttributeSet();
    SimpleAttributeSet attr_hname_local = new SimpleAttributeSet();
    SimpleAttributeSet attr_hname_remote = new SimpleAttributeSet();
    SimpleAttributeSet attr_tiny = new SimpleAttributeSet();
    SimpleAttributeSet attr_underline_local = new SimpleAttributeSet();
    SimpleAttributeSet attr_underline_remote = new SimpleAttributeSet();
    private static final LinkController LINKCONTROLLER = new LinkController();
    private static final String PATTERN_STRING = "(?xi)\\b((?:[a-z][\\w-]+:(?:/{1,3}|[a-z0-9%])|www\\d{0,3}[.]|[a-z0-9.\\-]+[.][a-z]{2,4}/)(?:[^\\s()<>]+|\\(([^\\s()<>]+|(\\([^\\s()<>]+\\)))*\\))+(?:\\(([^\\s()<>]+|(\\([^\\s()<>]+\\)))*\\)|[^\\s`!()\\[\\]{};:'\\\".,<>?]))";
    public static Pattern URLPATTERN = Pattern.compile("(?xi)\\b((?:[a-z][\\w-]+:(?:/{1,3}|[a-z0-9%])|www\\d{0,3}[.]|[a-z0-9.\\-]+[.][a-z]{2,4}/)(?:[^\\s()<>]+|\\(([^\\s()<>]+|(\\([^\\s()<>]+\\)))*\\))+(?:\\(([^\\s()<>]+|(\\([^\\s()<>]+\\)))*\\)|[^\\s`!()\\[\\]{};:'\\\".,<>?]))", 2);

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public void setAvatar(byte[] avatarBytes, String username, String displayName) {
        try {
            BufferedImage technicianAvatar = ImageIO.read(new ByteArrayInputStream(avatarBytes));
            technicianAvatar = this.getScaledAvatar(technicianAvatar);
            this.displayNameToAvatarMap.put(displayName, technicianAvatar);
            System.out.println("[ChatPanel] Set avatar for " + displayName);
        }
        catch (Throwable e) {
            this.displayNameToAvatarMap.put(displayName, null);
            e.printStackTrace();
        }
    }

    private BufferedImage getScaledAvatar(BufferedImage image) {
        int factor = 1;
        if (OS.isOSXRetina()) {
            factor = 2;
        }
        int iw = image.getWidth(null);
        int ih = image.getHeight(null);
        int widthBound = factor * (AVATAR_WIDTH - 2);
        int heightBound = factor * (AVATAR_HEIGHT - 2);
        widthBound = Math.max(0, widthBound);
        heightBound = Math.max(0, heightBound);
        if (widthBound == 0 || heightBound == 0) {
            return image;
        }
        if (widthBound < iw || heightBound < ih) {
            return ImageHelper.scaleDownToFitInside(image, widthBound, heightBound, false);
        }
        return image;
    }

    public String getChatText() {
        if (!this.hasChatContent) {
            System.out.println("[ChatPanel] No chat content, so returning the empty string");
            return "";
        }
        try {
            System.out.println("[ChatPanel] Returning " + this.chat_doc.getLength() + " of chat text");
            return this.chat_doc.getText(0, this.chat_doc.getLength());
        }
        catch (BadLocationException t) {
            t.printStackTrace();
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollToBottom() {
        if (this.scroller == null) {
            this.scroller = new ScrollDownThread();
            this.scroller.start();
        }
        Object object = this.scroller.lock;
        synchronized (object) {
            this.scroller.scrollDown = true;
            this.scroller.lock.notify();
        }
    }

    public BufferedImage getTechnicianAvatar(String displayName) {
        return this.displayNameToAvatarMap.get(displayName);
    }

    public ChatPanel(RootPaneContainer rpc, String displayName, boolean showAvatars) {
        this.rpc = rpc;
        this.displayName = displayName;
        this.showAvatars = showAvatars;
        this.initStyles();
        this.initGraphics();
        this.initEventHandling();
    }

    public void setFinishListener() {
    }

    protected boolean showNotifyButton() {
        return false;
    }

    public void highlightLastMessage() {
        if (this.lastBubble != null) {
            new MessageHighlightThread(this.lastBubble);
        }
    }

    protected void initGraphics() {
        this.rootComponent.setOpaque(false);
        JPanel topBottomPanel = new JPanel(new BorderLayout());
        topBottomPanel.add((Component)this.chat_panel_top, "Center");
        topBottomPanel.add((Component)this.chat_panel_bottom, "South");
        this.rootComponent.add(topBottomPanel, 0, 0, 1, 1, 1000, 1000, 11, 1, new Insets(0, 0, 0, 0));
        this.chatEntryCardLayout = new CardLayout();
        this.chatEntryCardPanel = new JPanel(this.chatEntryCardLayout);
        this.chatEntryPanel = new ChatEntryPanel(this.showNotifyButton(), this);
        this.chatEntryPanel.setBackground(this.getEntryPanelBackground());
        this.chatEntryCardPanel.add((Component)this.chatEntryPanel.getRootComponent(), "OK");
        this.headerLabel = new JLabel(Language.get("CHAT_TITLE"), 0);
        this.warningLabel = new JWrapLabel("<html>" + Language.get("CHAT_WARNING_BLANKED") + "</html>");
        this.warningLabel.setHorizontalAlignment(0);
        this.warningLabel.setForeground(Color.white);
        this.warningPanel = new JPanel(new GridLayout(1, 1));
        this.warningPanel.setBackground(new Color(169, 82, 82));
        this.warningPanel.add(this.warningLabel);
        this.warningPanel.setVisible(false);
        GbPanel headerPanel = new GbPanel(new ScaledInsets(0, 0, 0, 0));
        headerPanel.add(this.headerLabel, 0, 0, 1, 1, 1, 1, 10, 2);
        headerPanel.add(this.warningPanel, 0, 1, 1, 1, 1, 1, 10, 2);
        this.chat_panel_top.setLayout(new BorderLayout());
        this.chat_panel_top.add("North", headerPanel);
        this.chat_panel_top.add("Center", this.chat_scroll);
        this.chat_panel_top.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ChatPanel.this.chatPanelWidth = ChatPanel.this.chat_panel_top.getWidth();
                ChatPanel.this.typingBubble.setMaxWidth(ChatPanel.this.chatPanelWidth);
            }
        });
        this.chat_panel_bottom.setLayout(new BorderLayout());
        this.chat_panel_bottom.add("Center", this.chatEntryCardPanel);
        this.chat_scroll.setBorder(SHBorderFactory.createMatteBorder(1, 0, 1, 0, SHStyle.BORDER_COLOR));
        this.chatWindowFiller.setBackground(Color.white);
        this.chat_scroll.getVerticalScrollBar().setUnitIncrement(SHStyle.SCROLL_UNIT_INCREMENT);
        this.chat_scroll.getVerticalScrollBar().setBlockIncrement(SHStyle.SCROLL_BLOCK_INCREMENT);
        this.addInitialDateStampToChat();
    }

    protected void addComponentsToChatEntryPanel() {
    }

    public void setWarningLabelVisible(final boolean visible) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChatPanel.this.warningPanel.setVisible(visible);
                ChatPanel.this.chat_panel_top.validate();
                ChatPanel.this.chat_panel_top.repaint();
            }
        });
    }

    public void setTitle(String title) {
        if (title != null) {
            this.headerLabel.setVisible(true);
            this.headerLabel.setText(title);
        } else {
            this.headerLabel.setVisible(false);
        }
    }

    protected Color getEntryPanelBackground() {
        return SHStyle.PANEL_BACKGROUND_BLUE;
    }

    private void addInitialDateStampToChat() {
        this.addNotificationMessageToChat(DateFormatterUtil.formatChatDateFull(System.currentTimeMillis()) + "\n\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIsTyping(String message) {
        boolean end = this.isVerticalScrollerAtBottom();
        this.typingBubble.setMessage(message);
        if (end) {
            this.scrollToBottom();
        }
        Object object = this.typingBubbleLock;
        synchronized (object) {
            if (this.typingBubbleThread == null) {
                this.typingBubbleThread = new HideTypingBubbleThread();
                this.typingBubbleThread.start();
            } else {
                this.typingBubbleThread.touch();
            }
        }
    }

    protected void addNotificationMessageToChat(String message) {
        try {
            MessageBubble dateBubble = new MessageBubble(message);
            this.addBubbleToChatWindow(dateBubble);
            this.chat_doc.insertString(this.chat_doc.getLength(), message, this.attr_plain);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void addBubbleToChatWindow(JComponent bubble) {
        BubbleAdder adder = new BubbleAdder(bubble);
        if (SwingUtilities.isEventDispatchThread()) {
            adder.run();
        } else {
            SwingUtilities.invokeLater(adder);
        }
    }

    public StyledDocument getChatDocument() {
        return this.chat_doc;
    }

    public void clearMessages() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChatPanel.this.lastBubble = null;
                ChatPanel.this.chatWindow.removeAll();
                try {
                    ChatPanel.this.chat_doc.remove(0, ChatPanel.this.chat_doc.getLength());
                }
                catch (Exception e) {
                    Debugger.error("problem removing messages", e);
                }
                ChatPanel.this.addInitialDateStampToChat();
                ChatPanel.this.repaintChatWindow();
            }
        });
    }

    public void addMessage(final String user_name, final String host_name, final String message) {
        this.hasChatContent = true;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean atTheEnd = ChatPanel.this.isVerticalScrollerAtBottom();
                boolean isTechnician = ChatPanel.this.isTechnicianMessage(user_name, host_name);
                try {
                    Object object = ChatPanel.this.typingBubbleLock;
                    synchronized (object) {
                        ChatPanel.this.clearTypingBubble();
                        ChatPanel.this.typingBubbleThread = null;
                    }
                    boolean useLastBubble = ChatPanel.this.lastBubble != null && ChatPanel.this.lastBubble.username.equals(user_name);
                    boolean bl = useLastBubble = useLastBubble && System.currentTimeMillis() - ChatPanel.this.lastBubble.lastMessageTime < 60000L;
                    if (useLastBubble) {
                        ChatPanel.this.lastBubble.appendMessage(message);
                    } else {
                        BufferedImage technicianAvatar = ChatPanel.this.getTechnicianAvatar(user_name);
                        ChatBubble bubble = new ChatBubble(user_name, technicianAvatar, message, isTechnician);
                        ChatPanel.this.addBubbleToChatWindow(bubble);
                        ChatPanel.this.chat_doc.insertString(ChatPanel.this.chat_doc.getLength(), "\n" + DateFormatterUtil.formatChatTime(System.currentTimeMillis()), isTechnician ? ChatPanel.this.attr_hname_local : ChatPanel.this.attr_hname_remote);
                        ChatPanel.this.chat_doc.insertString(ChatPanel.this.chat_doc.getLength(), "     " + user_name, isTechnician ? ChatPanel.this.attr_uname_local : ChatPanel.this.attr_uname_remote);
                        ChatPanel.this.chat_doc.insertString(ChatPanel.this.chat_doc.getLength(), "\n", isTechnician ? ChatPanel.this.attr_hname_local : ChatPanel.this.attr_hname_remote);
                    }
                    if (atTheEnd) {
                        ChatPanel.this.scrollToBottom();
                    }
                    ChatPanel.this.chat_doc.insertString(ChatPanel.this.chat_doc.getLength(), "\t" + message + "\n", isTechnician ? ChatPanel.this.attr_message_local : ChatPanel.this.attr_message_remote);
                }
                catch (Throwable e) {
                    if (CentralDebugging.CHAT_VERBOSE) {
                        System.out.println("[Chat] Error adding message " + e.getMessage());
                    }
                    e.printStackTrace();
                    Debugger.error("problem adding message", e);
                }
            }
        });
    }

    private void clearTypingBubble() {
        this.typingBubble.timeLabel.setText(" ");
        this.typingBubble.timeLabel.repaint();
    }

    protected boolean isVerticalScrollerAtBottom() {
        JScrollBar vbar = this.chat_scroll.getVerticalScrollBar();
        boolean end = vbar.getMaximum() == vbar.getValue() + vbar.getVisibleAmount();
        return end;
    }

    protected abstract boolean isTechnicianMessage(String var1, String var2);

    @Override
    public void notifyKeyTyped() {
    }

    protected void initEventHandling() {
    }

    @Override
    public void invokeNotifyMessage() {
    }

    protected void initStyles() {
        StyleConstants.setFontSize(this.attr_plain, SimpleHelpLookAndFeel.scale(12));
        StyleConstants.setBold(this.attr_plain, false);
        StyleConstants.setItalic(this.attr_plain, false);
        StyleConstants.setForeground(this.attr_plain, Color.black);
        StyleConstants.setFontFamily(this.attr_plain, "SansSerif");
        this.attr_tiny = (SimpleAttributeSet)this.attr_plain.clone();
        StyleConstants.setFontSize(this.attr_tiny, SimpleHelpLookAndFeel.scale(6));
        this.attr_date = (SimpleAttributeSet)this.attr_plain.clone();
        StyleConstants.setForeground(this.attr_date, Color.DARK_GRAY);
        StyleConstants.setAlignment(this.attr_date, 1);
        this.attr_message_local = (SimpleAttributeSet)this.attr_plain.clone();
        StyleConstants.setForeground(this.attr_message_local, Color.blue.darker().darker());
        this.attr_uname_local = (SimpleAttributeSet)this.attr_plain.clone();
        StyleConstants.setForeground(this.attr_uname_local, SHStyle.EXAMPLE_TEXT_COLOR_LIGHT);
        StyleConstants.setFontSize(this.attr_uname_local, SHStyle.smallFont.getSize());
        this.attr_hname_local = (SimpleAttributeSet)this.attr_plain.clone();
        StyleConstants.setUnderline(this.attr_underline_local, true);
        StyleConstants.setForeground(this.attr_underline_local, SHStyle.EXAMPLE_TEXT_COLOR);
        this.attr_message_remote = (SimpleAttributeSet)this.attr_plain.clone();
        StyleConstants.setForeground(this.attr_message_remote, Color.DARK_GRAY.darker());
        this.attr_uname_remote = (SimpleAttributeSet)this.attr_plain.clone();
        StyleConstants.setForeground(this.attr_uname_remote, SHStyle.EXAMPLE_TEXT_COLOR_LIGHT);
        StyleConstants.setFontSize(this.attr_uname_remote, SHStyle.smallFont.getSize());
        this.attr_hname_remote = (SimpleAttributeSet)this.attr_plain.clone();
        this.attr_underline_remote = (SimpleAttributeSet)this.attr_underline_local.clone();
        StyleConstants.setForeground(this.attr_underline_remote, SHStyle.EXAMPLE_TEXT_COLOR);
    }

    @Override
    public void invokeSendMessage() {
        String message = this.chatEntryPanel.removeEnteredText();
        this.sendMessage(message);
    }

    protected abstract void sendMessage(String var1);

    public void setEnabled(boolean b) {
        this.chat_panel_top.setEnabled(b);
        this.chat_panel_bottom.setEnabled(b);
        this.chatEntryPanel.setEnabled(b);
    }

    private void repaintChatWindow() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChatPanel.this.chatWindow.repaint();
            }
        });
    }

    private static boolean isURL(String potentialURL) {
        try {
            new URL(potentialURL);
            return true;
        }
        catch (Throwable t) {
            return URLPATTERN.matcher(potentialURL).matches();
        }
    }

    public void setInputEnabled(boolean b) {
        this.chatEntryPanel.setInputEnabled(b);
    }

    private static class LinkController
    extends MouseAdapter
    implements MouseMotionListener {
        private LinkController() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            block14: {
                JTextPane editor = (JTextPane)event.getSource();
                if (!editor.isEditable()) {
                    Point pt = new Point(event.getX(), event.getY());
                    int pos = editor.viewToModel(pt);
                    String text = editor.getText();
                    if (pos >= 0 && pos < text.length()) {
                        int i;
                        int firstSpace = -1;
                        int lastSpace = -1;
                        for (i = pos; i >= 0; --i) {
                            if (!Character.isWhitespace(text.charAt(i))) continue;
                            firstSpace = i + 1;
                            break;
                        }
                        if (firstSpace == -1) {
                            firstSpace = 0;
                        }
                        for (i = pos; i < text.length(); ++i) {
                            if (!Character.isWhitespace(text.charAt(i))) continue;
                            lastSpace = i;
                            break;
                        }
                        if (lastSpace == -1) {
                            lastSpace = text.length();
                        }
                        if (firstSpace >= lastSpace) {
                            return;
                        }
                        try {
                            String url = text.substring(firstSpace, lastSpace);
                            if (!ChatPanel.isURL(url)) break block14;
                            try {
                                Browser.openURL(new URL(url));
                            }
                            catch (MalformedURLException ex) {
                                try {
                                    Browser.openURL(new URL("http://" + url));
                                }
                                catch (Exception exx) {
                                    exx.printStackTrace();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        catch (Throwable t) {
                            System.out.println("Text = " + text + " First=" + firstSpace + " Last=" + lastSpace);
                            t.printStackTrace();
                        }
                    }
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    class ChatBubble
    extends GbPanel {
        private StyledDocument chatBubbleDoc = new DefaultStyledDocument();
        private JTextPane chatBubbleTextPane = new JTextPane(this.chatBubbleDoc){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = SimpleHelpLookAndFeel.scale(50);
                return dim;
            }

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
            }
        };
        private AvatarPanel avatarPanel;
        private JLabel timeLabel;
        private boolean localUser;
        private String username;
        private boolean isTechnician;
        private JLabel nameLabel;
        private long lastMessageTime;

        @Override
        public void setBackground(Color c) {
            super.setBackground(c);
            if (this.avatarPanel != null) {
                this.avatarPanel.setBackground(c);
            }
            if (this.timeLabel != null) {
                this.timeLabel.setBackground(c);
            }
            if (this.chatBubbleTextPane != null) {
                this.chatBubbleTextPane.setBackground(c);
            }
        }

        public ChatBubble(String username, Image avatar, String message, boolean isTechnician) {
            this(username, avatar, message, isTechnician ? Color.white : SHStyle.CHAT_BACKGROUND_COLOR_BLUE, isTechnician);
        }

        private ChatBubble(String username, Image avatar, String message, Color bgColor, boolean isTechnician) {
            this.username = username;
            this.localUser = isTechnician;
            try {
                this.addMessage(message, isTechnician);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            if (avatar != null && ChatPanel.this.showAvatars) {
                if (isTechnician) {
                    this.avatarPanel = new AvatarPanel(AVATAR_WIDTH, AVATAR_HEIGHT, avatar, ImageLoader.getAsImage("images/svg/users/technician.svg,48"), null);
                } else {
                    this.avatarPanel = new AvatarPanel(AVATAR_WIDTH, AVATAR_HEIGHT, null, ImageLoader.getAsImage("images/svg/users/technician.svg,48"), null);
                    this.avatarPanel.setBackground(bgColor);
                }
            }
            this.setBackground(bgColor);
            this.chatBubbleTextPane.setFont(SHStyle.normalFont);
            this.chatBubbleTextPane.setEditable(false);
            this.chatBubbleTextPane.setBackground(bgColor);
            this.chatBubbleTextPane.addMouseListener(LINKCONTROLLER);
            this.timeLabel = new JLabel(DateFormatterUtil.formatChatTime(System.currentTimeMillis()));
            this.timeLabel.setFont(SHStyle.smallFont);
            this.isTechnician = isTechnician;
            this.nameLabel = new JWrapLabel("<html>" + username);
            this.nameLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_LIGHT);
            this.nameLabel.setFont(SHStyle.smallFont);
            this.nameLabel.setVisible(isTechnician);
            DefaultCaret caret = (DefaultCaret)this.chatBubbleTextPane.getCaret();
            caret.setUpdatePolicy(1);
            this.initUI();
        }

        private void addMessage(String message, boolean local) throws BadLocationException {
            this.lastMessageTime = System.currentTimeMillis();
            int originalStartIndex = this.chatBubbleDoc.getLength();
            this.chatBubbleDoc.insertString(this.chatBubbleDoc.getLength(), message, local ? ChatPanel.this.attr_message_local : ChatPanel.this.attr_message_remote);
            String[] words = message.split("\\s");
            for (int i = 0; i < words.length; ++i) {
                boolean isURL = ChatPanel.isURL(words[i]);
                if (!isURL) continue;
                int indexOf = message.indexOf(words[i]);
                this.chatBubbleDoc.setCharacterAttributes(originalStartIndex + indexOf, words[i].length(), local ? ChatPanel.this.attr_underline_local : ChatPanel.this.attr_underline_remote, false);
            }
        }

        public void appendMessage(String newMessage) {
            try {
                this.chatBubbleDoc.insertString(this.chatBubbleDoc.getLength(), "\n\n", ChatPanel.this.attr_tiny);
                this.addMessage(newMessage, this.localUser);
                this.repaintBubble();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        private void repaintBubble() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatBubble.this.repaint();
                }
            });
        }

        private void initUI() {
            SimpleAttributeSet aSet = new SimpleAttributeSet();
            StyleConstants.setLineSpacing(aSet, 0.3f);
            if (!this.isTechnician) {
                StyleConstants.setAlignment(aSet, 2);
            }
            this.chatBubbleTextPane.setParagraphAttributes(aSet, false);
            int topGap = SimpleHelpLookAndFeel.scale(5);
            int leftGap = SimpleHelpLookAndFeel.scale(10);
            int X = 0;
            if (this.avatarPanel != null) {
                this.avatarPanel.setBorder(SHBorderFactory.createLineBorder(SHStyle.BORDER_COLOR_LIGHT));
                this.add(this.avatarPanel, X++, 0, 1, 2, 0, 0, 18, 0, new Insets(topGap, leftGap, 0, SimpleHelpLookAndFeel.scale(10)));
                leftGap = 0;
            }
            if (this.isTechnician) {
                this.add(this.nameLabel, X, 0, 1, 1, 1, 0, 18, 1, new Insets(topGap, leftGap, 0, 0));
                this.add(this.timeLabel, X + 1, 0, 1, 1, 0, 0, 12, 0, new Insets(topGap, 0, 0, SimpleHelpLookAndFeel.scale(10)));
                this.add(this.chatBubbleTextPane, X, 1, 2, 1, 1, 1, 11, 2, new Insets(topGap - SimpleHelpLookAndFeel.scale(2), leftGap - SimpleHelpLookAndFeel.scale(3), topGap - SimpleHelpLookAndFeel.scale(2), SimpleHelpLookAndFeel.scale(10)));
            } else {
                this.add(this.chatBubbleTextPane, X, 1, 2, 1, 1, 1, 11, 2, new Insets(topGap, leftGap - SimpleHelpLookAndFeel.scale(3), topGap - SimpleHelpLookAndFeel.scale(3), SimpleHelpLookAndFeel.scale(10)));
            }
        }
    }

    class MessageBubble
    extends GbPanel {
        protected JLabel timeLabel;

        public MessageBubble(String message) {
            this.setBackground(Color.white);
            this.timeLabel = new JLabel(message);
            this.timeLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_LIGHT);
            this.timeLabel.setFont(SHStyle.smallFont);
            this.timeLabel.setHorizontalAlignment(0);
            this.add(this.timeLabel, 0, 0, 1, 1, 1, 1, 10, 2, new ScaledInsets(5, 5, 5, 5));
        }
    }

    class IsTypingBubble
    extends MessageBubble {
        public IsTypingBubble() {
            super(" ");
            this.timeLabel.setFont(SHStyle.smallerFont);
        }

        public void setMaxWidth(int chatPanelWidth) {
            SwingUtil.setWidth(this.timeLabel, chatPanelWidth - SimpleHelpLookAndFeel.scale(40));
        }

        public void setMessage(final String message) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.timeLabel.setText(message);
                this.timeLabel.repaint();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IsTypingBubble.this.timeLabel.setText(message);
                        IsTypingBubble.this.timeLabel.repaint();
                    }
                });
            }
        }
    }

    class BubbleAdder
    implements Runnable {
        private JComponent bubble;

        public BubbleAdder(JComponent bubble) {
            this.bubble = bubble;
        }

        @Override
        public void run() {
            if (this.bubble instanceof IsTypingBubble) {
                ChatPanel.this.chatWindow.remove(this.bubble);
            } else {
                ChatPanel.this.lastBubble = this.bubble instanceof ChatBubble ? (ChatBubble)this.bubble : null;
            }
            int currentComponentCount = ChatPanel.this.chatWindow.getComponentCount();
            if (currentComponentCount > 0) {
                ChatPanel.this.chatWindow.remove(ChatPanel.this.chatWindowFiller);
                --currentComponentCount;
                ChatPanel.this.chatWindow.remove(ChatPanel.this.typingBubble);
            }
            int n = --currentComponentCount;
            ChatPanel.this.chatWindow.add(this.bubble, 0, n, 1, 1, 1, 1, 11, 2);
            int n2 = ++currentComponentCount;
            ChatPanel.this.chatWindow.add(ChatPanel.this.typingBubble, 0, n2, 1, 1, 1, 0, 11, 1);
            int n3 = ++currentComponentCount;
            ++currentComponentCount;
            ChatPanel.this.chatWindow.add(ChatPanel.this.chatWindowFiller, 0, n3, 1, 1, 1, 1000, 11, 1);
            ChatPanel.this.chatWindow.revalidate();
            ChatPanel.this.chatWindow.repaint();
        }
    }

    public class HideTypingBubbleThread
    extends Thread {
        private long targetTime;

        public void touch() {
            this.targetTime = System.currentTimeMillis() + 2000L;
        }

        @Override
        public void run() {
            this.touch();
            try {
                while (System.currentTimeMillis() < this.targetTime) {
                    long timeToSleep = Math.max(this.targetTime - System.currentTimeMillis(), 0L);
                    Thread.sleep(timeToSleep);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = ChatPanel.this.typingBubbleLock;
                    synchronized (object) {
                        ChatPanel.this.clearTypingBubble();
                        ChatPanel.this.typingBubbleThread = null;
                    }
                }
            });
        }
    }

    class MessageHighlightThread
    extends Thread {
        private ChatBubble bubble;

        public MessageHighlightThread(ChatBubble bubble) {
            this.bubble = bubble;
            this.start();
        }

        @Override
        public void run() {
            int steps = 15;
            int rStart = 227;
            int gStart = 80;
            int bStart = 79;
            double rStep = (255.0 - (double)rStart) / (double)steps;
            double gStep = (255.0 - (double)gStart) / (double)steps;
            double bStep = (255.0 - (double)bStart) / (double)steps;
            for (int i = 1; i <= 15; ++i) {
                int r = (int)(rStep * (double)i + (double)rStart);
                int g = (int)(gStep * (double)i + (double)gStart);
                int b = (int)(bStep * (double)i + (double)bStart);
                if (i == 15) {
                    b = 255;
                    g = 255;
                    r = 255;
                }
                final Color c = new Color(r, g, b);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MessageHighlightThread.this.bubble.setBackground(c);
                        MessageHighlightThread.this.bubble.repaint();
                    }
                });
                try {
                    Thread.sleep(30L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class ScrollDownThread
    extends Thread {
        final Object lock = new Object();
        boolean scrollDown = true;

        ScrollDownThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this.scrollDown) continue;
                for (int i = 0; i < 50; ++i) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ChatPanel.this.chat_scroll.getVerticalScrollBar().setValue(ChatPanel.this.chat_scroll.getVerticalScrollBar().getMaximum());
                        }
                    });
                }
                this.scrollDown = false;
            }
        }
    }
}

