/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.util.ui;

import com.aem.shelp.common.Language;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import utils.swing.SwingUtil;
import utils.swing.components.messagefields.MessageTextPane;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class ChatEntryPanel
implements KeyListener,
ActionListener {
    private JPanel mainContentPanel;
    private GbPanel chatEntryPanel;
    protected MessageTextPane chat_ent;
    private int chat_ent_height = 0;
    private int maxHeight = 0;
    private JButton notifyButton;
    private JButton sendButton;
    private boolean showNotifyButton;
    private ChatEntryListener listener;
    private JScrollPane scrollPane;
    long lastKeyNotificationTimeSent = 0L;

    public void setChatEntHeight(int chatEntHeight) {
        if (this.chat_ent_height == chatEntHeight) {
            return;
        }
        this.chat_ent_height = chatEntHeight;
        SwingUtil.setHeight(this.sendButton, this.chat_ent_height);
        this.chatEntryPanel.revalidate();
        this.chatEntryPanel.repaint();
        this.scrollPane.revalidate();
        this.scrollPane.repaint();
    }

    public ChatEntryPanel(boolean showNotifyButton, ChatEntryListener listener) {
        this.listener = listener;
        this.showNotifyButton = showNotifyButton;
        this.initGraphics();
    }

    public void setBackground(Color background) {
        this.chatEntryPanel.setBackground(background);
    }

    public void initGraphics() {
        this.sendButton = new JButton(Language.get("INVITE_SEND"));
        this.sendButton.setEnabled(false);
        SHButtonUI.makeButtonSegmentedRight(this.sendButton);
        if (this.showNotifyButton) {
            this.notifyButton = new JButton(ImageLoader.getImageIcon("images/svg/general/bell.svg,16"));
            this.notifyButton.setToolTipText(Language.get("CHAT_VISUAL_ALERT_TOOLTIP"));
            this.notifyButton.setEnabled(false);
            Dimension dim = SimpleHelpLookAndFeel.scale(new Dimension(24, 24));
            this.notifyButton.setPreferredSize(dim);
            this.notifyButton.setMinimumSize(dim);
            this.notifyButton.setMaximumSize(dim);
            this.notifyButton.setEnabled(false);
        }
        this.maxHeight = SimpleHelpLookAndFeel.scale(72);
        this.chat_ent = new MessageTextPane(Language.get("TYPE_MESSAGE_2") + "...", null);
        this.chat_ent.setBackground(Color.white);
        if (this.showNotifyButton) {
            this.chat_ent.setBorder(SHBorderFactory.createEmptyBorder(4, 4, 4, 4));
        } else {
            this.chat_ent.setBorder(SHBorderFactory.createCompoundBorder(SHBorderFactory.createLineBorder(SHStyle.BORDER_COLOR), SHBorderFactory.createEmptyBorder(4, 4, 4, 4)));
        }
        SimpleAttributeSet set = new SimpleAttributeSet(this.chat_ent.getParagraphAttributes());
        StyleConstants.setSpaceAbove(set, 4.0f);
        StyleConstants.setSpaceBelow(set, 4.0f);
        StyleConstants.setLeftIndent(set, 2.0f);
        StyleConstants.setRightIndent(set, 2.0f);
        StyleConstants.setLineSpacing(set, 0.1f);
        this.chat_ent.setParagraphAttributes(set, true);
        this.chat_ent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ChatEntryPanel.this.setChatEntHeight(e.getComponent().getHeight());
            }
        });
        this.scrollPane = new JScrollPane(this.chat_ent){

            @Override
            public Dimension getPreferredSize() {
                return this.adjustHeight(super.getPreferredSize());
            }

            @Override
            public Dimension getMinimumSize() {
                return this.adjustHeight(super.getMinimumSize());
            }

            private Dimension adjustHeight(Dimension dim) {
                dim.height = Math.min(ChatEntryPanel.this.chat_ent_height, ChatEntryPanel.this.maxHeight);
                return dim;
            }
        };
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setBorder(SHBorderFactory.createEmptyBorder());
        this.chatEntryPanel = new GbPanel();
        if (this.showNotifyButton) {
            this.chatEntryPanel.add(this.scrollPane, 0, 0, 1, 1, 1000, 1000, 11, 1, new Insets(0, 0, 0, 0));
            this.chatEntryPanel.add(this.notifyButton, 1, 0, 1, 1, 0, 0, 11, 0, new Insets(4, 4, 4, 4));
        } else {
            this.chatEntryPanel.add(this.scrollPane, 0, 0, 1, 1, 1000, 1000, 11, 1, new Insets(5, 5, 5, 0));
            this.chatEntryPanel.add(this.sendButton, 1, 0, 1, 1, 0, 1, 11, 0, new Insets(5, 0, 5, 5));
        }
        this.chat_ent.addKeyListener(this);
        this.sendButton.addActionListener(this);
        if (this.showNotifyButton) {
            this.notifyButton.addActionListener(this);
        }
        this.setEnabled(false);
        this.mainContentPanel = new JPanel(new BorderLayout());
        this.mainContentPanel.add((Component)this.chatEntryPanel, "Center");
    }

    public JPanel getRootComponent() {
        return this.mainContentPanel;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keycode = e.getKeyCode();
        if (keycode == 10) {
            e.consume();
            if (this.chat_ent.getText().length() > 0) {
                this.listener.invokeSendMessage();
            }
        } else {
            if (this.chat_ent.getText().length() > 0) {
                this.sendButton.setEnabled(true);
            } else {
                this.sendButton.setEnabled(false);
            }
            if (System.currentTimeMillis() - this.lastKeyNotificationTimeSent > 1000L) {
                this.listener.notifyKeyTyped();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.setChatEntHeight(this.chat_ent.getPreferredSize().height);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.sendButton) {
            this.listener.invokeSendMessage();
        } else if (e.getSource() == this.notifyButton) {
            this.listener.invokeNotifyMessage();
        }
    }

    public void setEnabled(boolean b) {
        this.chat_ent.setEnabled(true);
        if (this.notifyButton != null) {
            this.notifyButton.setEnabled(b);
        }
    }

    public String removeEnteredText() {
        String message = this.chat_ent.getText();
        this.chat_ent.clear();
        this.setChatEntHeight(this.chat_ent.getPreferredSize().height);
        this.sendButton.setEnabled(false);
        this.chat_ent.requestFocusInWindow();
        return message;
    }

    public void setInputEnabled(boolean b) {
        this.chat_ent.setEnabled(b);
    }

    public static interface ChatEntryListener {
        public void invokeNotifyMessage();

        public void invokeSendMessage();

        public void notifyKeyTyped();
    }
}

