/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.util;

import com.aem.nodelink.InfiniteLoop;
import com.aem.nodelink.utils.BlockingObjectInputStream;
import com.aem.nodelink.utils.DataUtils;
import com.aem.sdesktop.interfaces.MSG;
import com.aem.shelp.tech.TechHelpUIIPCHandler;
import com.aem.utils.blowfish.Blowfish;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import utils.message.Message;
import utils.message.MessageReader;
import utils.message.MessageUtils;
import utils.message.MessageWriter;
import utils.stream.StreamPiper;

public class PortRedirector
extends Thread
implements MSG {
    private static boolean PAIRED_REDIRECTORS_NO_CLASH_USE_SMALL_UIDS = false;
    private static final int BUFSIZE = 4096;
    private static final int COMPRESSION = 1;
    private static final int ENCRYPTION = 2;
    private MessageReader mr;
    private MessageWriter mw;
    private Blowfish encrypt;
    private Blowfish decrypt;
    private boolean compress = false;
    private boolean secure = false;
    private boolean skipTunnel = false;
    private boolean socks = false;
    private int socksPort = 1080;
    private final Object UID_LOCK = new Object();
    private int UID_count = 0;
    private SocksThread socksThread;
    private final Object totalSent_LOCK = new Object();
    private double totalSentBefore = 0.0;
    private double totalSentAfter = 0.0;
    private final Object totalRecv_LOCK = new Object();
    private double totalRecvBefore = 0.0;
    private double totalRecvAfter = 0.0;
    private int next = 10000;
    private final Object next_LOCK = new Object();
    private boolean die = false;
    private final Object msgHandlers_LOCK = new Object();
    private HashMap<Long, InstanceMessageHandler> msgHandlers = new HashMap();
    private final Object LOCK = new Object();
    private Map<Long, RedirectListener> listeners = new HashMap<Long, RedirectListener>();
    private Map<Long, RedirectInstance> instances = new HashMap<Long, RedirectInstance>();
    private long counter = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getCompressionRatioReceived() {
        Object object = this.totalRecv_LOCK;
        synchronized (object) {
            return this.totalRecvBefore / this.totalRecvAfter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getCompressionRatioSent() {
        Object object = this.totalSent_LOCK;
        synchronized (object) {
            return this.totalSentAfter / this.totalSentBefore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getCompressionSpeedupReceived() {
        Object object = this.totalRecv_LOCK;
        synchronized (object) {
            return this.totalRecvAfter / this.totalRecvBefore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getCompressionSpeedupSent() {
        Object object = this.totalSent_LOCK;
        synchronized (object) {
            return this.totalSentBefore / this.totalSentAfter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getRedirectedTargets() {
        Object[] all;
        Object object = this.LOCK;
        synchronized (object) {
            all = this.instances.values().toArray();
        }
        String[] insts = new String[all.length];
        for (int i = 0; i < all.length; ++i) {
            try {
                insts[i] = ((RedirectInstance)all[i]).target;
                continue;
            }
            catch (Exception x) {
                insts[i] = "-";
            }
        }
        return insts;
    }

    public void setSocks(boolean on, int port) {
        this.socksPort = port;
        if (!this.socks && on) {
            if (this.socksThread == null) {
                System.out.println("[SOCKS] Starting SOCKS listener on " + port);
                this.socksThread = new SocksThread();
                this.socksThread.start();
            }
        } else if (this.socks && !on && this.socksThread != null) {
            System.out.println("[SOCKS] Shutting down SOCKS listening");
            try {
                this.socksThread.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.socks = on;
    }

    public void shutdown() {
        try {
            this.socksThread.shutdown();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.removeAllRedirection(true);
        Message m = new Message(589832);
        try {
            this.mw.write(m);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void setSkipTunnel(boolean b) {
        this.skipTunnel = b;
    }

    public void setCompressTransferredData(boolean b) {
        this.compress = b;
        Message m = new Message(589830);
        m.append(this.compress);
        try {
            this.mw.write(m);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void setEncryptTransferredData(boolean b) {
        this.secure = b;
        Message m = new Message(589831);
        m.append(b);
        try {
            this.mw.write(m);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public PortRedirector(MessageReader r, MessageWriter w) {
        this(r, w, null);
    }

    public PortRedirector(MessageReader r, MessageWriter w, Blowfish[] blowfishes) {
        this.mr = r;
        this.mw = w;
        if (blowfishes != null) {
            this.encrypt = blowfishes[0];
            this.decrypt = blowfishes[1];
        }
        this.start();
    }

    public void die() {
        this.die = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Message m = null;
        try {
            while (!this.die) {
                InstanceMessageHandler imh;
                Long instanceUID;
                m = this.mr.read();
                long T = System.currentTimeMillis();
                int type = m.getType();
                if (type == 589824) {
                    instanceUID = (Long)m.get(0);
                    imh = this.startInstanceMessageHandler(instanceUID);
                    imh.bob.add(m);
                } else if (type == 589825 || type == 589826) {
                    instanceUID = (Long)m.get(0);
                    Object object = this.msgHandlers_LOCK;
                    synchronized (object) {
                        imh = this.msgHandlers.get(instanceUID);
                    }
                    imh.bob.add(m);
                } else if (!this.handleMessage(m)) {
                    return;
                }
                if ((T = System.currentTimeMillis() - T) <= 2000L) continue;
                System.err.println("Slow transaction (" + T + "): " + m);
            }
        }
        catch (IOException e) {
            System.out.println("(Port Redirector Util) LAST MESSAGE:" + m);
            System.out.println("[PortRedirector] " + e);
        }
        catch (Throwable e) {
            System.out.println("(Port Redirector Util) LAST MESSAGE:" + m);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstanceMessageHandler startInstanceMessageHandler(Long instanceUID) {
        System.out.println("(Port Redirector Util) Starting instance message handler on " + instanceUID);
        InstanceMessageHandler imh = new InstanceMessageHandler(instanceUID);
        Object object = this.msgHandlers_LOCK;
        synchronized (object) {
            if (this.msgHandlers.containsKey(instanceUID)) {
                System.err.println("(Port Redirector Util) WARNING Asked to create instance with existing UID " + instanceUID);
            }
            this.msgHandlers.put(instanceUID, imh);
        }
        imh.start();
        return imh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInstanceHandler(Long uid) {
        InstanceMessageHandler imh;
        Object object = this.msgHandlers_LOCK;
        synchronized (object) {
            imh = this.msgHandlers.get(uid);
        }
        try {
            imh.bob.setClosed(new IOException("Instance handling for " + uid + " closed"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownRedirectInstance(Long UID) {
        RedirectInstance inst;
        Object object = this.LOCK;
        synchronized (object) {
            inst = this.instances.remove(UID);
        }
        try {
            if (inst != null) {
                inst.sock.close();
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        Message m = new Message(589826);
        m.append(UID);
        m.append("redirection on this port shut down");
        try {
            this.mw.write(m);
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redirectSocket(Socket sock, DataInputStream din, String host, int rport, List<Long> uids) throws IOException {
        RedirectInstance inst = new RedirectInstance("[C-PortRedirector] ", din);
        if (this.skipTunnel) {
            Socket localSock = new Socket(host, rport);
            Socket[] sockets = new Socket[]{sock, localSock};
            new LocalPiperInstance(din, localSock.getOutputStream(), sockets, sock);
            new LocalPiperInstance(localSock.getInputStream(), sock.getOutputStream(), sockets, localSock);
            return;
        }
        inst.target = host + ":" + rport;
        Object localSock = this.LOCK;
        synchronized (localSock) {
            inst.sock = sock;
            if (PAIRED_REDIRECTORS_NO_CLASH_USE_SMALL_UIDS) {
                Object object = this.UID_LOCK;
                synchronized (object) {
                    inst.UID = this.UID_count++;
                }
            } else {
                inst.UID = System.currentTimeMillis() * 100000L + (long)(Math.random() * 100000.0) + this.counter++;
            }
            this.instances.put(inst.UID, inst);
        }
        System.out.println("[C-PortRedirector] (" + inst.UID + ") creating corresponding socket to " + host + ":" + rport + " on remote side");
        this.startInstanceMessageHandler(inst.UID);
        Message m = new Message(589824);
        m.append(inst.UID);
        m.append(host);
        m.append(rport);
        uids.add(inst.UID);
        this.mw.write(m);
        System.out.println("[C-PortRedirector] (" + inst.UID + ") starting socket processing");
        inst.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRedirection(int lport, String host, int rport, long UID) {
        RedirectListener listener = new RedirectListener();
        listener.lport = lport;
        listener.rport = rport;
        listener.host = host;
        listener.UID = UID;
        System.out.println("[PortRedirector] asked to redirect " + lport + " to " + host + ":" + rport + " (" + UID + ")");
        Object object = this.LOCK;
        synchronized (object) {
            this.listeners.put(UID, listener);
        }
        listener.start();
    }

    public void addRemoteRedirection(int lport, String host, int rport, long UID) {
        Message m = new Message(589827);
        m.append(lport);
        m.append(host);
        m.append(rport);
        m.append(UID);
        System.out.println("[PortRedirector] asked to redirect remort port " + lport + " to " + host + ":" + rport + " (" + UID + ")");
        try {
            this.mw.write(m);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void removeRedirection(long UID) {
        this.removeRedirection(UID, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRedirection(long UID, boolean sendRemote) {
        RedirectListener list;
        Object object = this.LOCK;
        synchronized (object) {
            list = this.listeners.remove(UID);
        }
        if (list != null) {
            list.die = true;
            try {
                list.ssock.close();
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
        try {
            if (sendRemote) {
                Message m = new Message(589828);
                m.append(new Long(UID));
                this.mw.write(m);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void removeAllRedirection() {
        this.removeAllRedirection(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllRedirection(boolean sendRemote) {
        Object object = this.LOCK;
        synchronized (object) {
            Long[] keys;
            for (Long key : keys = this.listeners.keySet().toArray(new Long[0])) {
                RedirectListener list = this.listeners.remove(key);
                list.shutdown();
            }
        }
        try {
            if (sendRemote) {
                Message m = new Message(589829);
                this.mw.write(m);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleMessage(Message m) {
        int type = m.getType();
        if (type == 589825) {
            RedirectInstance inst;
            long instanceUID = (Long)m.get(0);
            int filters = (Integer)m.get(1);
            byte[] data = (byte[])m.get(2);
            if ((filters & 2) != 0) {
                data = this.decrypt.decryptSecure(data, 0, false);
            }
            Object object = this.totalRecv_LOCK;
            synchronized (object) {
                this.totalRecvBefore += (double)data.length;
            }
            if ((filters & 1) != 0) {
                try {
                    GZIPInputStream gz = new GZIPInputStream(new ByteArrayInputStream(data));
                    data = DataUtils.readAll(gz);
                }
                catch (IOException x) {
                    x.printStackTrace();
                    System.out.println("GZIP ERROR msg = " + m);
                    System.out.println("GZIP ERROR decrypt? = " + ((filters & 2) != 0));
                    System.out.println("GZIP ERROR data len = " + data.length);
                    System.out.println("GZIP ERROR filters = " + filters);
                    System.out.println("GZIP ERROR filters hex = " + Integer.toHexString(filters));
                }
            }
            Object x = this.totalRecv_LOCK;
            synchronized (x) {
                this.totalRecvAfter += (double)data.length;
            }
            Object object2 = this.LOCK;
            synchronized (object2) {
                inst = this.instances.get(instanceUID);
            }
            try {
                inst.write(data);
            }
            catch (Throwable x2) {
                try {
                    inst.sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Message mres = new Message(589826);
                mres.append(instanceUID);
                mres.append("" + x2);
                try {
                    this.mw.write(mres);
                }
                catch (IOException xx) {
                    xx.printStackTrace();
                }
            }
        } else if (type == 589827) {
            int lport = (Integer)m.get(0);
            String host = (String)m.get(1);
            int rport = (Integer)m.get(2);
            long instanceUID = (Long)m.get(3);
            this.addRedirection(lport, host, rport, instanceUID);
        } else {
            if (type == 589832) {
                return false;
            }
            if (type == 589828) {
                long listenerUID = (Long)m.get(0);
                this.removeRedirection(listenerUID, false);
            } else if (type == 589829) {
                this.removeAllRedirection(false);
            } else if (type == 589830) {
                this.compress = (Boolean)m.get(0);
                if (this.compress) {
                    System.out.println("[S-PortRedirector] asked to compress all outgoing data");
                } else {
                    System.out.println("[S-PortRedirector] asked to not compress all outgoing data");
                }
            } else if (type == 589831) {
                this.secure = (Boolean)m.get(0);
                if (this.secure) {
                    System.out.println("[S-PortRedirector] asked to encrypt all outgoing data");
                } else {
                    System.out.println("[S-PortRedirector] asked to not encrypt all outgoing data");
                }
            } else if (type == 589824) {
                long instanceUID = (Long)m.get(0);
                String host = (String)m.get(1);
                int port = (Integer)m.get(2);
                System.out.println("[S-PortRedirector] asked to create redirected remote socket to " + host + ":" + port);
                try {
                    if (host == null) {
                        host = "localhost";
                    }
                    Socket sock = new Socket(host, port);
                    RedirectInstance tsock = new RedirectInstance("[S-PortRedirector-" + instanceUID + "] ", new DataInputStream(new BufferedInputStream(sock.getInputStream())));
                    tsock.UID = instanceUID;
                    tsock.sock = sock;
                    Object mres = this.LOCK;
                    synchronized (mres) {
                        this.instances.put(instanceUID, tsock);
                    }
                    System.out.println("[S-PortRedirector] starting processing redirected socket (" + instanceUID + ")");
                    tsock.start();
                }
                catch (Exception x) {
                    x.printStackTrace();
                    Message mres = new Message(589826);
                    mres.append(instanceUID);
                    mres.append("" + x);
                    try {
                        this.mw.write(mres);
                    }
                    catch (IOException xx) {
                        xx.printStackTrace();
                    }
                }
            } else if (type == 589826) {
                RedirectInstance inst;
                long instanceUID = (Long)m.get(0);
                String err = (String)m.get(1);
                Object x = this.LOCK;
                synchronized (x) {
                    inst = this.instances.remove(instanceUID);
                }
                if (inst == null) {
                    System.out.println("[PortRedirector] (" + instanceUID + ") Unable to close missing instance " + instanceUID);
                } else {
                    System.out.println("[PortRedirector] (" + inst.UID + ") Told to close redirected socket because alternate died: " + err);
                    System.out.println("[PortRedirector] (" + inst.UID + ") Closing redirected socket in 3...");
                    try {
                        if (inst.sock != null) {
                            inst.sock.close();
                        }
                    }
                    catch (Exception x3) {
                        System.out.println("[PortRedirector] closed, " + x3);
                    }
                }
                this.closeInstanceHandler(instanceUID);
            }
        }
        return true;
    }

    class RedirectInstance
    extends Thread {
        DataInputStream din;
        ByteArrayOutputStream zout = new ByteArrayOutputStream();
        Socket sock;
        long UID;
        String prefix;
        String target;
        boolean debug = false;

        public RedirectInstance(String prefix, DataInputStream din) {
            this.prefix = prefix;
            this.din = din;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                System.out.println(this.prefix + "Processing socket data (" + this.UID + ")");
                byte[] buf = new byte[4096];
                int n = 0;
                InfiniteLoop il = new InfiniteLoop();
                while (n != -1) {
                    il.LOOP();
                    n = this.din.read(buf);
                    Object object = PortRedirector.this.totalSent_LOCK;
                    synchronized (object) {
                        PortRedirector.this.totalSentBefore = PortRedirector.this.totalSentBefore + (double)n;
                    }
                    if (n <= 0) continue;
                    Message m = new Message(589825);
                    m.append(this.UID);
                    if (!PortRedirector.this.compress && !PortRedirector.this.secure) {
                        m.append(0);
                        m.appendRef_WARNING_NO_GETS(buf, 0, n);
                    } else {
                        int filters = 0;
                        byte[] tmp = null;
                        if (PortRedirector.this.compress) {
                            this.zout.reset();
                            GZIPOutputStream gz = new GZIPOutputStream(this.zout);
                            gz.write(buf, 0, n);
                            gz.finish();
                            gz.close();
                            if (this.zout.size() < n) {
                                filters |= 1;
                                tmp = this.zout.toByteArray();
                            }
                        }
                        if (PortRedirector.this.secure) {
                            filters |= 2;
                            tmp = tmp == null ? PortRedirector.this.encrypt.encryptSecure(buf, 0, n, false) : PortRedirector.this.encrypt.encryptSecure(tmp, 0, tmp.length, false);
                        }
                        if (tmp == null) {
                            m.append(0);
                            m.appendRef_WARNING_NO_GETS(buf, 0, n);
                        } else {
                            m.append(filters);
                            m.append(tmp);
                        }
                    }
                    byte[] dat = MessageUtils.messageToBytes(m);
                    Object object2 = PortRedirector.this.totalSent_LOCK;
                    synchronized (object2) {
                        PortRedirector.this.totalSentAfter = PortRedirector.this.totalSentAfter + (double)dat.length;
                    }
                    PortRedirector.this.mw.write(dat);
                }
            }
            catch (Throwable x) {
                System.out.println(this.prefix + "closed, " + x);
            }
            try {
                this.sock.close();
            }
            catch (Exception x) {
                // empty catch block
            }
            try {
                Message m = new Message(589826);
                m.append(this.UID);
                m.append("socket shut down");
                PortRedirector.this.mw.write(m);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Object object = PortRedirector.this.LOCK;
            synchronized (object) {
                try {
                    PortRedirector.this.instances.remove(this.UID);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            System.out.println(this.prefix + "Socket data processing complete (" + this.UID + ")");
        }

        public void write(byte[] dat) throws IOException {
            OutputStream out = this.sock.getOutputStream();
            out.write(dat, 0, dat.length);
            out.flush();
        }
    }

    class LocalPiperInstance
    extends Thread {
        InputStream in;
        OutputStream out;
        Socket[] sockets;
        Socket inSocket;

        public LocalPiperInstance(InputStream in, OutputStream out, Socket[] sockets, Socket readSocket) {
            this.in = new BufferedInputStream(in);
            this.out = new BufferedOutputStream(out);
            this.sockets = sockets;
            this.inSocket = readSocket;
            this.start();
        }

        @Override
        public void run() {
            try {
                this.inSocket.setSoTimeout(50);
                StreamPiper.pipe(this.in, this.out, 50000, null, true, false, true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.sockets[0].close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.sockets[1].close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class RedirectListener
    extends Thread {
        int lport;
        int rport;
        String host;
        long UID;
        ServerSocket ssock;
        boolean die = false;
        ArrayList<Long> uids = new ArrayList();

        RedirectListener() {
        }

        public void startup() throws IOException {
            this.ssock = new ServerSocket(this.lport, 250);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.die = true;
            try {
                this.ssock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (Long uid : this.uids) {
                PortRedirector.this.shutdownRedirectInstance(uid);
            }
            try {
                Object object = PortRedirector.this.LOCK;
                synchronized (object) {
                    PortRedirector.this.listeners.remove(this.UID);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            try {
                this.startup();
                System.out.println("[C-PortRedirector] bound to " + this.ssock.getLocalPort() + " OK, waiting for sockets");
                try {
                    System.out.println("[C-PortRedirector] Calling sendPortForward");
                    TechHelpUIIPCHandler.INSTANCE.sendPortForwardPort(this.ssock.getLocalPort());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                System.out.println("[C-PortRedirector] Entering socket loop (die:" + this.die + ")");
                InfiniteLoop il = new InfiniteLoop();
                while (!this.die) {
                    il.LOOP();
                    Socket sock = this.ssock.accept();
                    System.out.println("[C-PortRedirector] socket came in on " + this.ssock.getLocalPort());
                    PortRedirector.this.redirectSocket(sock, new DataInputStream(new BufferedInputStream(sock.getInputStream())), this.host, this.rport, this.uids);
                }
                System.out.println("[C-PortRedirector] Socket loop complete");
            }
            catch (IOException x) {
                System.out.println("[C-PortRedirector] failed: " + x);
                x.printStackTrace();
                this.shutdown();
            }
        }
    }

    class InstanceMessageHandler
    extends Thread {
        Long instanceUID;
        BlockingObjectInputStream bob = new BlockingObjectInputStream();

        public InstanceMessageHandler(Long uid) {
            this.instanceUID = uid;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Message m = (Message)this.bob.next();
                    PortRedirector.this.handleMessage(m);
                }
            }
            catch (Exception x) {
                System.out.println("(Port Redirector Util) Instance message handler closed " + this.instanceUID + " - " + x);
                return;
            }
        }
    }

    class SocksThread
    extends Thread {
        boolean shutdown = false;
        ServerSocket ssock;
        List<Long> uids = Collections.synchronizedList(new ArrayList());

        SocksThread() {
        }

        public void shutdown() {
            PortRedirector.this.socksThread = null;
            this.shutdown = true;
            try {
                this.ssock.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (Long uid : this.uids) {
                try {
                    PortRedirector.this.shutdownRedirectInstance(uid);
                }
                catch (Throwable throwable) {}
            }
        }

        @Override
        public void run() {
            InfiniteLoop il = new InfiniteLoop();
            while (!this.shutdown) {
                il.LOOP();
                try {
                    System.out.println("[SOCKS] Listening for incoming SOCKS connections on " + PortRedirector.this.socksPort);
                    this.ssock = new ServerSocket(PortRedirector.this.socksPort, 250);
                    InfiniteLoop il2 = new InfiniteLoop();
                    while (true) {
                        il2.LOOP();
                        Socket sock = this.ssock.accept();
                        System.out.println("[SOCKS] socket came in on " + PortRedirector.this.socksPort);
                        SocksHandlerThread handler = new SocksHandlerThread(sock);
                        handler.start();
                    }
                }
                catch (BindException x) {
                    System.out.println("[SOCKS] Unable to listen on socks port");
                    try {
                        Thread.sleep(25000L);
                    }
                    catch (Exception exception) {}
                }
                catch (IOException x) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {}
                }
                catch (Exception x) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    System.out.println("[SOCKS] Unknown error listening");
                    x.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeV5Binding(Socket sock, DataOutputStream out, int addressType) throws IOException {
            int mine;
            out.write(0);
            out.write(1);
            out.write(192);
            out.write(168);
            out.write(1);
            out.write(222);
            Object object = PortRedirector.this.next_LOCK;
            synchronized (object) {
                mine = PortRedirector.this.next++;
                if (PortRedirector.this.next == 65000) {
                    PortRedirector.this.next = 10000;
                }
            }
            System.out.println("Responded with accept on 192.168.1.222:" + mine);
            out.writeShort(mine);
            out.flush();
        }

        class SocksHandlerThread
        extends Thread {
            Socket sock;
            byte[] empty = new byte[6];

            public SocksHandlerThread(Socket sock) {
                this.sock = sock;
            }

            @Override
            public void run() {
                block35: {
                    try {
                        DataInputStream in = new DataInputStream(new BufferedInputStream(this.sock.getInputStream()));
                        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
                        int cver = in.read();
                        System.out.println("[SOCKS] Reading SOCKS request");
                        if (cver == 4) {
                            System.out.println("[SOCKS] v4 request");
                            out.write(0);
                            out.flush();
                            try {
                                String ip;
                                short port;
                                DataInputStream din;
                                if (in.read() == 1) {
                                    System.out.println("[SOCKS] TCP connection request");
                                    din = new DataInputStream(in);
                                    port = din.readShort();
                                    ip = "";
                                    ip = ip + (0xFF & din.readByte());
                                    ip = ip + '.';
                                    ip = ip + (0xFF & din.readByte());
                                    ip = ip + '.';
                                    ip = ip + (0xFF & din.readByte());
                                    ip = ip + '.';
                                    ip = ip + (0xFF & din.readByte());
                                    int B = 1;
                                    InfiniteLoop il3 = new InfiniteLoop();
                                    while (B != 0) {
                                        il3.LOOP();
                                        B = in.read();
                                        if (B != -1) continue;
                                        throw new IOException("End of stream during SOCKS handshake");
                                    }
                                } else {
                                    throw new IOException("[SOCKS] Bind requests not supported, only TCP connection requests are supported");
                                }
                                System.out.println("[SOCKS] Asked to connect to " + ip + ":" + port + ", passing to C-PortRedirector");
                                out.write(90);
                                out.write(this.empty);
                                out.flush();
                                PortRedirector.this.redirectSocket(this.sock, din, ip, port, SocksThread.this.uids);
                            }
                            catch (IOException x) {
                                System.out.println("[SOCKS] Refused: " + x);
                                x.printStackTrace();
                                try {
                                    out.write(91);
                                    out.write(this.empty);
                                    out.flush();
                                }
                                catch (IOException port) {
                                    // empty catch block
                                }
                                try {
                                    Thread.sleep(3000L);
                                }
                                catch (Exception port) {
                                    // empty catch block
                                }
                                try {
                                    this.sock.close();
                                    break block35;
                                }
                                catch (Exception port) {}
                            }
                            break block35;
                        }
                        if (cver != 5) break block35;
                        System.out.println("[SOCKS] v5 request");
                        out.write(5);
                        out.flush();
                        boolean noAuthSupported = false;
                        boolean userPassSupported = false;
                        int auths = in.read();
                        for (int i = 0; i < auths; ++i) {
                            int auth = in.read();
                            if (auth == 0) {
                                noAuthSupported = true;
                                continue;
                            }
                            if (auth != 2) continue;
                            userPassSupported = true;
                        }
                        if (noAuthSupported) {
                            out.write(0);
                            out.flush();
                        } else if (userPassSupported) {
                            out.write(2);
                            out.flush();
                            int version = in.read();
                            if (version != 1) {
                                out.write(version);
                                out.write(1);
                                out.flush();
                                throw new IOException("Unsupported username/password login version");
                            }
                            int ulen = in.read();
                            for (int i = 0; i < ulen; ++i) {
                                in.read();
                            }
                            int plen = in.read();
                            for (int i = 0; i < plen; ++i) {
                                in.read();
                            }
                            out.write(version);
                            out.write(0);
                            out.flush();
                        } else {
                            out.write(255);
                            out.flush();
                            throw new IOException("No supported authentication methods for client");
                        }
                        if (in.read() != 5) {
                            throw new IOException("Malformed client request - SOCKS version 0x05 not provided before connection request");
                        }
                        int command = in.read();
                        in.read();
                        int addressType = in.read();
                        DataInputStream din = new DataInputStream(in);
                        StringBuilder ip = new StringBuilder();
                        if (addressType == 1) {
                            ip.append(0xFF & din.readByte());
                            ip.append('.');
                            ip.append(0xFF & din.readByte());
                            ip.append('.');
                            ip.append(0xFF & din.readByte());
                            ip.append('.');
                            ip.append(0xFF & din.readByte());
                        } else if (addressType == 3) {
                            int len = in.read();
                            for (int i = 0; i < len; ++i) {
                                ip.append((char)in.read());
                            }
                        } else if (addressType == 4) {
                            ip.append(0xFF & din.readByte());
                            ip.append(0xFF & din.readByte());
                            ip.append(':');
                            ip.append(0xFF & din.readByte());
                            ip.append(0xFF & din.readByte());
                            ip.append(':');
                            ip.append(0xFF & din.readByte());
                            ip.append(0xFF & din.readByte());
                            ip.append(':');
                            ip.append(0xFF & din.readByte());
                            ip.append(0xFF & din.readByte());
                            ip.append(':');
                            ip.append(0xFF & din.readByte());
                            ip.append(0xFF & din.readByte());
                            ip.append(':');
                            ip.append(0xFF & din.readByte());
                            ip.append(0xFF & din.readByte());
                            ip.append(':');
                            ip.append(0xFF & din.readByte());
                            ip.append(0xFF & din.readByte());
                            ip.append(':');
                            ip.append(0xFF & din.readByte());
                            ip.append(0xFF & din.readByte());
                        }
                        String shost = ip.toString();
                        short port = din.readShort();
                        if (command == 1) {
                            System.out.println("[SOCKS] v5 TCP connection request");
                            System.out.println("[SOCKS] Asked to connect to " + shost + ":" + port);
                            out.write(5);
                            out.write(0);
                            SocksThread.this.writeV5Binding(this.sock, out, addressType);
                            out.flush();
                            System.out.println("[SOCKS] Sent accept to client for " + shost + ":" + port + ", passing to C-PortRedirector");
                            PortRedirector.this.redirectSocket(this.sock, din, shost, port, SocksThread.this.uids);
                            System.out.println("[SOCKS] Successfully redirected " + shost + ":" + port + ", " + addressType);
                            break block35;
                        }
                        out.write(5);
                        out.write(7);
                        SocksThread.this.writeV5Binding(this.sock, out, addressType);
                        out.flush();
                        throw new IOException("[SOCKS] unsupported command " + command);
                    }
                    catch (IOException x) {
                        System.out.println("[SOCKS] Error: " + x);
                        x.printStackTrace();
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            this.sock.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }
}

