/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.util;

import com.aem.CentralDebugging;
import com.aem.ClientManagement;
import com.aem.nodelink.attempt.ConcurrentAttempt;
import com.aem.nodelink.attempt.socket.ClientSocketConnectAttempt;
import com.aem.nodelink.attempt.socket.ServerSocketConnectAttempt;
import com.aem.nodelink.attempt.socket.SocketConnectAttempt;
import com.aem.nodelink.utils.DataUtils;
import com.aem.sdesktop.server.controller.NativeGrab;
import com.aem.sdesktop.server.controller.settings.WallpaperDisabler;
import com.aem.sdesktop.util.CancelledException;
import com.aem.sdesktop.util.CleanupWithProperties;
import com.aem.sdesktop.util.DoubleClickSimulator;
import com.aem.sdesktop.util.RestrictedMouseMover;
import com.aem.shelp.common.Language;
import com.aem.shelp.util.CacheDirUtil;
import com.aem.shelp.util.CadPolicyAllower;
import com.aem.shelp.util.RebootUtil;
import com.aem.shelp.util.SafeModeUtil;
import com.aem.shelp.util.Secure;
import com.aem.shelp.util.SimpleGatewayInstaller;
import com.aem.shelp.util.SimpleGatewayUninstaller;
import com.aem.shelp.util.SimpleServiceUtil;
import com.aem.shelp.util.UacPromptModifier;
import com.aem.utils.CommandRunner;
import com.aem.utils.FileCopyUtil;
import com.aem.utils.NativeLibraryLoader;
import com.aem.utils.NativeMacUtils;
import com.aem.utils.NativeScreenUtil;
import com.aem.utils.NativeUtils;
import com.aem.utils.NonNativeLogicalArray;
import com.aem.utils.ScreenUtil;
import com.aem.utils.StreamUtils;
import java.awt.Robot;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import jwrapper.hidden.JWNativeAPI;
import jwrapper.jwutils.JWLinuxOS;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.JWWindowsOS;
import jwrapper.logging.ProcessOutputUtil;
import jwrapper.logging.ProcessResult;
import utils.files.FileUtil;
import utils.files.PermissionsUtil;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.osstats.winutils.WmicUtil;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.progtools.ProcessPrinter;
import utils.string.HexData;
import utils.vm.VMFork;

public class MouseMover
implements RestrictedMouseMover,
ScreenUtil {
    static final boolean FAKE_VISTA = false;
    static final boolean WAIT_FOR_CAD_COMPLETION = false;
    static final boolean BACKUP_MMOVE_FROM_MMOVE = true;
    static final boolean NO_BACKUP_FOR_SG = false;
    static final boolean NO_MMOVE_FOR_SG = false;
    private static final int CONNECT_FIRST = 313182719;
    private String elevateshMac = null;
    static ArrayList allprocs = new ArrayList();
    static Object allprocs_LOCK = new Object();
    String[] myJarPaths;
    final Object cmds_LOCK = new Object();
    Socket socket;
    Process p;
    PrintStream cmds;
    InputStream backchannel;
    boolean killed = false;
    boolean isElevated = false;
    static MouseMover mmove;
    static MouseMover backup_mmove;
    static String[] recentJarPaths;
    static Properties mmoveProperties;
    static RandomAccessFile cachedFile;
    static String cachedFileName;
    static long nextMouseClickAllowed;
    static DoubleClickSimulator dclick;
    static long doubleClickTime;
    static Object thread_LOCK;
    static Thread thread;
    Properties localProperties = new Properties();

    public static File getAppFolder() {
        File appFolder = JWSystem.getAppFolder();
        if (appFolder.exists()) {
            return appFolder;
        }
        appFolder = new File("lib");
        if (!appFolder.exists()) {
            System.out.println("[MouseMover] ERROR: Cannot find app folder! Neither JWSystem nor lib folders present.");
        }
        return appFolder;
    }

    public static boolean mouseMoverRequired() throws Exception {
        if (OS.isWindowsVistaOrAbove() || OS.isWindows2003()) {
            block8: {
                String java = System.getProperty("java.version");
                System.out.println("[MMove] OS is Vista or above: JVM version " + java);
                if (java.startsWith("1.5")) {
                    System.out.println("[MMove] 1.5 JVM");
                    if (java.startsWith("1.5.0")) {
                        System.out.println("[MMove] 1.5.0 JVM, checking update");
                        try {
                            int update = Integer.parseInt(java.substring(java.indexOf(95) + 1));
                            if (update < 11) {
                                throw new Exception("Must upgrade Java to 1.6 (or 1.5u11 or later) to support mmove with High DPI (1.5.0 but pre u11)");
                            }
                            break block8;
                        }
                        catch (Throwable t) {
                            throw new Exception("Must upgrade Java to 1.6 (or 1.5u11 or later) to support mmove with High DPI (" + java + ")");
                        }
                    }
                    System.out.println("[MMove] >1.5.0 JVM, OK");
                } else if (java.startsWith("1.1") || java.startsWith("1.2") || java.startsWith("1.4")) {
                    throw new Exception("Must upgrade Java to 1.6 (or 1.5u11 or later) to support mmove with High DPI (pre 1.5)");
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killAllMouseMoversWith5SecondPossibleWait() {
        try {
            MouseMover.shutdown();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        long timeout = System.currentTimeMillis() + 5000L;
        int aliveProcessCount = 0;
        Object object = allprocs_LOCK;
        synchronized (object) {
            aliveProcessCount = allprocs.size();
        }
        while (System.currentTimeMillis() < timeout && aliveProcessCount > 0) {
            try {
                object = allprocs_LOCK;
                synchronized (object) {
                    ArrayList<Process> doneProcesses = new ArrayList<Process>();
                    for (int i = 0; i < allprocs.size(); ++i) {
                        try {
                            Process p = (Process)allprocs.get(i);
                            try {
                                p.exitValue();
                                doneProcesses.add(p);
                            }
                            catch (IllegalThreadStateException illegalThreadStateException) {}
                            continue;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    allprocs.removeAll(doneProcesses);
                    if (allprocs.size() == 0) {
                        break;
                    }
                    aliveProcessCount = allprocs.size();
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        try {
            object = allprocs_LOCK;
            synchronized (object) {
                if (allprocs.size() > 0) {
                    for (int i = 0; i < allprocs.size(); ++i) {
                        try {
                            Process p = (Process)allprocs.get(i);
                            p.destroy();
                            continue;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    allprocs.clear();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addMmoveProcess(Process p) {
        Object object = allprocs_LOCK;
        synchronized (object) {
            allprocs.add(p);
        }
    }

    public static void setPathsForFutureUse(String[] jarPaths) {
        recentJarPaths = jarPaths;
        System.out.println("[MouseMover] Paths set for future use [" + Arrays.toString(jarPaths) + "]");
    }

    public static MouseMover forceNewElevatedInstanceWithCredentials(String username, String password) throws IOException {
        MouseMover tmp;
        MouseMover oldbackup;
        MouseMover oldmmove;
        block21: {
            System.out.println("[MouseMover] Asked to force new instance with credentials for user " + username);
            oldmmove = mmove;
            oldbackup = backup_mmove;
            String altusername = null;
            try {
                int altpoint = username.indexOf(92);
                if (altpoint != -1) {
                    String domain = username.substring(0, altpoint);
                    String user = username.substring(altpoint + 1);
                    altusername = user + "@" + domain;
                } else {
                    altpoint = username.indexOf(64);
                    if (altpoint != -1) {
                        String user = username.substring(0, altpoint);
                        String domain = username.substring(altpoint + 1);
                        altusername = domain + "\\" + user;
                    }
                }
            }
            catch (Exception altpoint) {
                // empty catch block
            }
            tmp = null;
            try {
                tmp = new MouseMover(recentJarPaths, username, password, true, false);
            }
            catch (Throwable errOne) {
                if (altusername != null) {
                    System.out.println("[MouseMover] trying alternate style user " + altusername);
                    try {
                        tmp = new MouseMover(recentJarPaths, altusername, password, true, false);
                    }
                    catch (Throwable domain) {
                        // empty catch block
                    }
                }
                if (tmp != null) break block21;
                if (errOne instanceof IOException) {
                    throw (IOException)errOne;
                }
                IOException io = new IOException("Elevation failed (" + errOne.getMessage() + ")");
                io.initCause(errOne);
                throw io;
            }
        }
        mmove = tmp;
        if (backup_mmove == null) {
            backup_mmove = new MouseMover(mmove, true);
        }
        if (oldmmove != null) {
            try {
                MouseMover.sendPropertiesTo(oldmmove.localProperties, mmove);
                MouseMover.sendPropertiesTo(oldmmove.localProperties, backup_mmove);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            if (oldmmove != null) {
                oldmmove.exit(false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (oldbackup != null) {
                oldbackup.exit(false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mmove;
    }

    private static void sendPropertiesTo(Properties properties, MouseMover targetMMove) {
        if (properties == null) {
            return;
        }
        if (targetMMove == null) {
            return;
        }
        for (String string : properties.keySet()) {
            String value = (String)properties.get(string);
            targetMMove.setCleanupState(string, value);
        }
    }

    public static MouseMover forceNewElevatedInstanceWithoutCredentials() throws IOException {
        System.out.println("[MouseMover] Requested a new MouseMover without credentials");
        return MouseMover.getInstance(recentJarPaths, true, true);
    }

    public static MouseMover getInstance(String[] jarpaths, boolean force, boolean elevate) throws IOException {
        for (int i = 0; i < jarpaths.length; ++i) {
            System.out.println("[MouseMover] JAR path: " + i + "/" + jarpaths.length + " - " + jarpaths[i]);
        }
        MouseMover.setPathsForFutureUse(jarpaths);
        Properties properties = null;
        if (mmove != null && !force) {
            if (MouseMover.mmove.isElevated || !elevate) {
                return mmove;
            }
            properties = MouseMover.mmove.localProperties;
        }
        boolean firstEverMMove = mmove == null;
        mmove = new MouseMover(jarpaths, elevate, false);
        if (firstEverMMove) {
            mmove.preloadSessionStartupStuff();
        }
        if (backup_mmove == null || MouseMover.backup_mmove.isElevated != elevate) {
            backup_mmove = new MouseMover(mmove, true);
        }
        MouseMover.sendPropertiesTo(properties, mmove);
        MouseMover.sendPropertiesTo(properties, backup_mmove);
        return mmove;
    }

    public static MouseMover getStaticMouseMover() {
        if (mmove != null) {
            mmove.checkConnection();
            if (!MouseMover.mmove.isElevated) {
                return null;
            }
        }
        return mmove;
    }

    public static RestrictedMouseMover getPossiblyRestrictedMouseMover() {
        if (mmove != null) {
            mmove.checkConnection();
        }
        return mmove;
    }

    private MouseMover(MouseMover pmove, boolean isBackup) throws IOException {
        Socket sock;
        System.out.println("[MouseMover] Creating forked instance.");
        this.myJarPaths = pmove.myJarPaths;
        MMoveConnection conn = this.getConnectionToMMove();
        String id = MouseMover.getMMoveID(pmove.isElevated, isBackup);
        pmove.forkNewMmove(conn.backwardHost, conn.backwardPort, conn.forwardHost, conn.forwardPort, "" + id);
        int errors = 0;
        System.out.println("[MouseMover] Waiting for forked mmove...");
        int WAIT = 1000;
        int EXIT_AFTER = 900000;
        int MAX_ERRORS = EXIT_AFTER / WAIT;
        conn.startConnectingInBackground();
        while (true) {
            try {
                sock = conn.getValidConnection(WAIT);
                System.out.println("[MouseMover] MouseMover connected OK (forked - " + conn + ")");
            }
            catch (IOException e) {
                if (++errors <= MAX_ERRORS) continue;
                System.out.println("[MouseMover] Timed out waiting for forked MouseMover");
                throw new IOException("Timed out waiting for MouseMover");
            }
            break;
        }
        this.socket = MouseMover.applyNoDelay(sock);
        this.cmds = new PrintStream((OutputStream)new BufferedOutputStream(sock.getOutputStream()), false, "UTF-8");
        this.backchannel = new BufferedInputStream(sock.getInputStream());
    }

    private static Socket applyNoDelay(Socket tmp) {
        try {
            tmp.setTcpNoDelay(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return tmp;
    }

    private static Socket getConnectionForMMove(String hostListen, int portListen, String host, int port) {
        ConcurrentAttempt ca = new ConcurrentAttempt();
        try {
            ca.appendAttemptToCurrentLayer(new ServerSocketConnectAttempt(new ServerSocket(portListen, 1, InetAddress.getByName(hostListen)), true, 0L));
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        ca.appendAttemptToCurrentLayer(new ClientSocketConnectAttempt(host, port, 30, 4000L, 0L));
        SocketConnectAttempt success = (SocketConnectAttempt)ca.attemptNow();
        return MouseMover.applyNoDelay(success.getSocket());
    }

    private MMoveConnection getConnectionToMMove() throws IOException {
        String localhost;
        try {
            localhost = InetAddress.getByName(null).getHostAddress();
        }
        catch (Exception x) {
            localhost = "localhost";
        }
        System.out.println("[MouseMover] Binding to loopback IP: " + localhost);
        MMoveConnection conn = new MMoveConnection();
        conn.ssockBack = new ServerSocket(0, 1, InetAddress.getByName(localhost));
        conn.backwardHost = localhost;
        conn.backwardPort = conn.ssockBack.getLocalPort();
        ServerSocket ssockTest = new ServerSocket(0, 1, InetAddress.getByName(localhost));
        conn.forwardHost = localhost;
        conn.forwardPort = ssockTest.getLocalPort();
        ssockTest.close();
        conn.ca = new ConcurrentAttempt();
        ServerSocketConnectAttempt sc = new ServerSocketConnectAttempt(conn.ssockBack, true, 0L);
        sc.setExpectedFirstData(313182719);
        conn.ca.appendAttemptToCurrentLayer(sc);
        ClientSocketConnectAttempt cc = new ClientSocketConnectAttempt(conn.forwardHost, conn.forwardPort, 30, 4000L, 0L);
        cc.setExpectedFirstData(313182719);
        conn.ca.appendAttemptToCurrentLayer(cc);
        return conn;
    }

    private MouseMover(String[] jarpaths, boolean elevate, boolean isBackup) throws IOException {
        this(jarpaths, null, null, elevate, isBackup);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MouseMover(String[] jarpaths, String user, String pass, boolean elevate, boolean isBackup) throws IOException {
        Socket sock;
        OutputStream outputStream;
        String serviceInstaller;
        File nativeUtilsFile;
        String nativeUtilsPath;
        this.isElevated = elevate;
        if (user == null) {
            System.out.println("[MouseMover] Creating with no credentials (Elevation=" + elevate + ")");
        } else {
            System.out.println("[MouseMover] Creating for user " + user + " with password");
        }
        this.myJarPaths = jarpaths;
        MMoveConnection conn = this.getConnectionToMMove();
        String id = MouseMover.getMMoveID(elevate, isBackup);
        VMFork fork = new VMFork(MouseMover.class.getName(), new String[]{conn.backwardHost, "" + conn.backwardPort, conn.forwardHost, "" + conn.forwardPort, id});
        File launcherExe = JWSystem.getNativeJavaLauncher();
        if (launcherExe != null && launcherExe.exists()) {
            fork.setJavaExe(launcherExe.getAbsolutePath());
        }
        if ((nativeUtilsPath = (nativeUtilsFile = MouseMover.getAppFolder()).getAbsolutePath()).endsWith("\\") || nativeUtilsPath.endsWith("/")) {
            nativeUtilsPath = nativeUtilsPath.substring(0, nativeUtilsPath.length() - 1);
        }
        if (OS.isLinux()) {
            if (nativeUtilsPath != null) {
                fork.setVMSpecificArgs(new String[]{"-Xmx128m", "-Xms5m", "-Dsun.java2d.dpiaware=true", "-Djava.library.path=" + nativeUtilsPath, "-Djava.awt.headless=true"});
            } else {
                fork.setVMSpecificArgs(new String[]{"-Xmx128m", "-Xms5m", "-Dsun.java2d.dpiaware=true", "-Djava.awt.headless=true"});
            }
        } else if (nativeUtilsPath != null) {
            fork.setVMSpecificArgs(new String[]{"-Xmx128m", "-Xms5m", "-Dsun.java2d.dpiaware=true", "-Djava.library.path=" + nativeUtilsPath});
        } else {
            fork.setVMSpecificArgs(new String[]{"-Xmx128m", "-Xms5m", "-Dsun.java2d.dpiaware=true"});
        }
        if (jarpaths != null) {
            fork.setBaseClasspath(jarpaths);
        }
        System.out.println("[MouseMover] Starting MouseMover " + fork);
        nativeUtilsPath = nativeUtilsPath + File.separatorChar;
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        Process p = null;
        boolean launchedAsService = false;
        boolean graphicalSudo = false;
        if (ClientManagement.isSimpleHelp()) {
            if (elevate) {
                if (OS.isWindows()) {
                    File canonicalFile = new File(".").getCanonicalFile();
                    System.out.println("[MouseMover] MMove dir will be " + canonicalFile.getAbsolutePath());
                    SimpleServiceUtil sservice = new SimpleServiceUtil(canonicalFile, user, pass);
                    p = sservice.launchVmForkViaService(nativeUtilsPath, fork);
                    launchedAsService = true;
                } else if (OS.isMacOS()) {
                    if (user == null) {
                        System.out.println("[MouseMover] Mac graphical sudo");
                        graphicalSudo = true;
                        serviceInstaller = this.getMacServiceInstallerPath(nativeUtilsPath);
                        System.out.println("[MouseMover] Mac service install path is " + serviceInstaller);
                        p = fork.fork(new String[]{serviceInstaller});
                        MouseMover.addMmoveProcess(p);
                    } else {
                        System.out.println("[MouseMover] Mac non-graphical sudo");
                        p = fork.fork(new String[]{"sudo", "-u", user, "-S", "sudo"});
                        outputStream = p.getOutputStream();
                        outputStream.write((pass + "\n").getBytes());
                        outputStream.flush();
                        MouseMover.addMmoveProcess(p);
                    }
                } else if (OS.isLinux()) {
                    if (user == null) {
                        System.out.println("[MouseMover] Linux graphical sudo");
                        graphicalSudo = true;
                        if (JWLinuxOS.isGkSudoAvailable()) {
                            fork.setEscapeSpacesAfterPreExec(true);
                            fork.setMergeAllCommandsAfterPreExec(true);
                            p = fork.fork(new String[]{"gksudo", "-D 'Remote Access Service'"});
                        } else if (JWLinuxOS.isKdeSudoAvailable()) {
                            fork.setEscapeSpacesAfterPreExec(true);
                            fork.setMergeAllCommandsAfterPreExec(true);
                            p = fork.fork(new String[]{"kdesudo"});
                        } else if (JWLinuxOS.isBeeSuAvailable()) {
                            fork.setEscapeSpacesAfterPreExec(true);
                            fork.setMergeAllCommandsAfterPreExec(true);
                            p = fork.fork(new String[]{"beesu"});
                        } else if (JWLinuxOS.isGnomeSuAvailable()) {
                            fork.setEscapeSpacesAfterPreExec(true);
                            fork.setMergeAllCommandsAfterPreExec(true);
                            p = fork.fork(new String[]{"gnomesu"});
                        } else if (JWLinuxOS.isPkExecAvailable()) {
                            p = fork.fork(new String[]{"pkexec"});
                        } else {
                            System.out.println("WARNING: Unable to find elevation utility.");
                            p = fork.fork(new String[]{"pkexec"});
                        }
                        MouseMover.addMmoveProcess(p);
                    } else {
                        System.out.println("[MouseMover] Linux non-graphical sudo");
                        p = fork.fork(new String[]{"sudo", "-u", user, "-S", "sudo"});
                        outputStream = p.getOutputStream();
                        outputStream.write((pass + "\n").getBytes());
                        outputStream.flush();
                        MouseMover.addMmoveProcess(p);
                    }
                }
            } else {
                p = fork.fork();
                MouseMover.addMmoveProcess(p);
            }
        } else {
            if (OS.isWindows()) {
                p = user == null ? fork.fork(new String[]{nativeUtilsPath + "elev_win.exe", nativeUtilsPath + "elev_win.exe"}) : fork.fork(new String[]{nativeUtilsPath + "elev_win.exe", "--runas", user, pass, nativeUtilsPath + "elev_win.exe"});
            } else if (OS.isMacOS()) {
                if (user == null) {
                    System.out.println("[MouseMover] Mac graphical sudo");
                    serviceInstaller = this.getMacServiceInstallerPath(nativeUtilsPath);
                    System.out.println("[MouseMover] Mac service install path is " + serviceInstaller);
                    p = fork.fork(new String[]{serviceInstaller});
                } else {
                    System.out.println("[MouseMover] Mac non-graphical sudo");
                    p = fork.fork(new String[]{"sudo", "-u", user, "-S", "sudo", "-S"});
                    outputStream = p.getOutputStream();
                    outputStream.write((pass + "\n").getBytes());
                    outputStream.flush();
                }
            } else if (OS.isLinux()) {
                if (user == null) {
                    System.out.println("[MouseMover] Linux graphical sudo");
                    if (JWLinuxOS.isGkSudoAvailable()) {
                        fork.setEscapeSpacesAfterPreExec(true);
                        fork.setMergeAllCommandsAfterPreExec(true);
                        p = fork.fork(new String[]{"gksudo", "-D 'Remote Access Service'"});
                    } else if (JWLinuxOS.isKdeSudoAvailable()) {
                        fork.setEscapeSpacesAfterPreExec(true);
                        fork.setMergeAllCommandsAfterPreExec(true);
                        p = fork.fork(new String[]{"kdesudo"});
                    } else if (JWLinuxOS.isBeeSuAvailable()) {
                        fork.setEscapeSpacesAfterPreExec(true);
                        fork.setMergeAllCommandsAfterPreExec(true);
                        p = fork.fork(new String[]{"beesu"});
                    } else if (JWLinuxOS.isGnomeSuAvailable()) {
                        fork.setEscapeSpacesAfterPreExec(true);
                        fork.setMergeAllCommandsAfterPreExec(true);
                        p = fork.fork(new String[]{"gnomesu"});
                    } else if (JWLinuxOS.isPkExecAvailable()) {
                        p = fork.fork(new String[]{"pkexec"});
                    } else {
                        System.out.println("WARNING: Unable to find elevation utility.");
                        p = fork.fork(new String[]{"pkexec"});
                    }
                } else {
                    System.out.println("[MouseMover] Linux non-graphical sudo");
                    p = fork.fork(new String[]{"sudo", "-u", user, "-S", "sudo", "-S"});
                    outputStream = p.getOutputStream();
                    outputStream.write((pass + "\n").getBytes());
                    outputStream.flush();
                }
            }
            MouseMover.addMmoveProcess(p);
        }
        ProcessPrinter pp = new ProcessPrinter(p, stdout, stderr);
        ProcessWaiter pwait = new ProcessWaiter(p);
        int errors = 0;
        System.out.println("[MouseMover] Waiting for executed MouseMover...");
        int WAIT = 1000;
        int EXIT_AFTER = 120000;
        int MAX_ERRORS = EXIT_AFTER / WAIT;
        conn.startConnectingInBackground();
        while (true) {
            try {
                sock = conn.getValidConnection(WAIT);
                System.out.println("[MouseMover] MouseMover connected OK (initial - " + conn + ").");
            }
            catch (IOException e) {
                boolean isAlive = false;
                try {
                    p.exitValue();
                }
                catch (IllegalThreadStateException ex) {
                    isAlive = true;
                }
                ++errors;
                if (!isAlive) {
                    if (OS.isMacOS() && elevate && graphicalSudo) {
                        try {
                            if (p.exitValue() == 1) {
                                throw new CancelledException();
                            }
                        }
                        catch (IllegalThreadStateException ex) {
                            // empty catch block
                        }
                    }
                    if (OS.isLinux() && elevate && graphicalSudo) {
                        try {
                            if (JWLinuxOS.isGkSudoAvailable()) {
                                if (p.exitValue() == 1) {
                                    throw new ElevationException();
                                }
                                if (p.exitValue() == 255) {
                                    throw new CancelledException();
                                }
                            } else if (JWLinuxOS.isKdeSudoAvailable()) {
                                if (p.exitValue() == 1) {
                                    throw new ElevationException();
                                }
                            } else if (JWLinuxOS.isBeeSuAvailable()) {
                                if (p.exitValue() == 1) {
                                    throw new ElevationException();
                                }
                            } else if (JWLinuxOS.isGnomeSuAvailable()) {
                                if (p.exitValue() != 0) {
                                    throw new ElevationException();
                                }
                            } else if (JWLinuxOS.isPkExecAvailable()) {
                                if (p.exitValue() == 127) {
                                    throw new ElevationException();
                                }
                                if (p.exitValue() == 126) {
                                    throw new CancelledException();
                                }
                            } else if (p.exitValue() != 0) {
                                throw new ElevationException();
                            }
                        }
                        catch (IllegalThreadStateException ex) {
                            // empty catch block
                        }
                    }
                }
                if (errors > MAX_ERRORS) {
                    System.out.println("[MouseMover] Timed out waiting for MouseMover");
                    throw new IOException("Timed out waiting for MouseMover");
                }
                if (pwait.processAlive() || stdout == null) continue;
                try {
                    pp.waitForAllOutput();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                String out = new String(stdout.toByteArray());
                stdout = null;
                String err = new String(stderr.toByteArray());
                stderr = null;
                System.out.println("[MouseMover] Launched process exited with [" + out + "] [" + err + "]");
                if (launchedAsService) {
                    int ex = p.exitValue();
                    System.out.println("[MouseMover] Launched process exited with return code [" + ex + "]");
                    if (ex == 53) {
                        throw new IOException("Elevated process died with error (ret code " + ex + ")");
                    }
                }
                if (out.toUpperCase().indexOf("ERROR") != -1) {
                    throw new IOException("Elevated process died with error " + out);
                }
                if (err.toUpperCase().indexOf("ERROR") != -1) throw new IOException("Elevated process died with error " + err);
                continue;
            }
            break;
        }
        this.socket = MouseMover.applyNoDelay(sock);
        this.cmds = new PrintStream((OutputStream)new BufferedOutputStream(sock.getOutputStream()), false, "UTF-8");
        this.backchannel = new BufferedInputStream(sock.getInputStream());
        try {
            this.setCentralDebuggingFolder(new File(".").getAbsoluteFile().getCanonicalPath());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.setNativeLibsFolder(MouseMover.getAppFolder().getAbsolutePath());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.setJWNativeAPIFolder(MouseMover.getAppFolder().getAbsolutePath());
            return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String getMacServiceInstallerPath(String nativeUtilsPath) throws IOException {
        if (this.elevateshMac != null) {
            return this.elevateshMac;
        }
        File newInstaller = new File(nativeUtilsPath + "ServiceInstaller");
        File oldInstaller = new File(nativeUtilsPath + "elev_mac");
        if (!oldInstaller.exists()) {
            oldInstaller = new File(nativeUtilsPath + "elevatesh_mac");
        }
        FileCopyUtil.copyFile(oldInstaller, newInstaller);
        PermissionsUtil.setExecutableForMe(newInstaller);
        this.elevateshMac = nativeUtilsPath + "ServiceInstaller";
        return this.elevateshMac;
    }

    private static String getMMoveID(boolean elevate, boolean isBackup) {
        String id = "restricted";
        if (elevate) {
            id = "elevated";
        }
        if (isBackup) {
            id = id + "_backup";
        }
        return id;
    }

    public static void shutdown() {
        if (mmove != null) {
            mmove.exit(true);
            mmove = null;
        }
        if (backup_mmove != null) {
            backup_mmove.exit(true);
            backup_mmove = null;
        }
    }

    private void exit(boolean doCleanup) {
        new ExitThread(doCleanup).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConnection() {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            if (this.cmds.checkError()) {
                new Exception("An I/O Error has occurred in the connection to MouseMover").printStackTrace();
                if (backup_mmove != null) {
                    System.out.println("[MMove] No backup MMove found");
                    mmove = backup_mmove;
                } else {
                    System.out.println("[MMove] Backup MMove found");
                }
                String[] jpaths = MouseMover.mmove.myJarPaths;
                boolean doElevatedRelaunch = MouseMover.mmove.isElevated;
                if (this.cmds.checkError()) {
                    System.out.println("[MMove] All MouseMovers have died");
                    if (ClientManagement.isSimpleHelp()) {
                        doElevatedRelaunch = false;
                        System.out.println("[MMove] Starting a restricted MouseMover from scratch (SH)");
                    } else {
                        System.out.println("[MMove] Starting a new MouseMover from scratch (SG)");
                    }
                    try {
                        mmove = new MouseMover(jpaths, doElevatedRelaunch, false);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        mmove = null;
                        return;
                    }
                    MouseMover.sendPropertiesTo(this.localProperties, mmove);
                }
                try {
                    System.out.println("[MMove] Attempting to start new (backup) MouseMover");
                    backup_mmove = new MouseMover(mmove, true);
                    MouseMover.sendPropertiesTo(this.localProperties, backup_mmove);
                    System.out.println("[MMove] Started new (backup) MouseMover OK");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forkNewMmove(String backHost, int backPort, String fwdHost, int fwdPort, String isBackup) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("forkmmove, " + backHost + ", " + backPort + ", " + fwdHost + ", " + fwdPort + ", " + isBackup);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCommandAndIgnore(String command, String dir) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("runcommand, " + dir + "$ " + command);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCommandAndWait(String command, String dir) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("runcommandandwait, " + dir + "$ " + command);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reboot(boolean safeMode, boolean force) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("reboot, " + safeMode + "," + force);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killProcess(String procId) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("killprocess, " + procId);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wmicCommand(String cmdline) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("wmiccommand, " + cmdline);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFile(String path) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("closefile, " + path);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readFile(String path) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("readfile, " + path);
            this.cmds.flush();
            try {
                return StreamUtils.readNBytes(this.backchannel, 5000000);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateGrabArea(int grab_x, int grab_y, int grab_w, int grab_h) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("grab_update, " + grab_x + "," + grab_y + "," + grab_w + "," + grab_h);
            this.cmds.flush();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NonNativeLogicalArray fetchArray(int grab_x, int grab_y, int grab_w, int grab_h) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("grab_fetch, " + grab_x + "," + grab_y + "," + grab_w + "," + grab_h);
            this.cmds.flush();
            try {
                NonNativeLogicalArray result = NonNativeLogicalArray.fromStream(this.backchannel);
                return result;
            }
            catch (IOException ex) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFilePart(String path, long start, byte[] dat) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("writefile, " + start + ", " + path);
            try {
                StreamUtils.writeBytes(this.cmds, dat);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileLastMod(String path, long lastmod) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("filelastmod, " + lastmod + ", " + path);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileLength(String path, long length) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("filelength, " + length + ", " + path);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFile(String path) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("deletefile, " + path);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preloadSessionStartupStuff() {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("preloadsessionstartup");
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCentralDebuggingFolder(String path) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("centraldebugging, " + path);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNativeLibsFolder(String path) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("nativelibsfolder, " + path);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJWNativeAPIFolder(String path) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("jwnativeapifolder, " + path);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newFolder(String path) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("newfolder, " + path);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameFile(String oldname, String newname) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("renamefile, " + oldname.length() + " " + oldname + ", " + newname.length() + " " + newname);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMouse(int x, int y) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println(x + "," + y);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMouseNormalized(int x, int y) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("mn, " + x + ", " + y);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDown(int a, int b) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("down, " + a + ", " + b);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseUp(int a, int b) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("up, " + a + ", " + b);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDoubleClickTime(long dclickTime) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("doubleclicktime, " + dclickTime);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDownSimulate(int a, int b, boolean isDoubleClick) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("downsim, " + a + ", " + b + ", " + isDoubleClick);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseUpSimulate(int a, int b) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("upsim, " + a + ", " + b);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyDown(int a, boolean isMapped) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("keydown, " + a + ", " + isMapped);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyUp(int a, boolean isMapped) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("keyup, " + a + ", " + isMapped);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backgroundImageOffInternal(boolean mustWait) {
        System.out.println("[MouseMover] Disabling background image");
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            if (mustWait) {
                this.cmds.println("backgroundimageandwait, off");
            } else {
                this.cmds.println("backgroundimage, off");
            }
            this.cmds.flush();
            try {
                String s = StreamUtils.readNStringISO88591(this.backchannel, 5000000);
                System.out.println(s);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNumLockOn() {
        System.out.println("[MouseMover] Setting num lock on");
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("numlock, on");
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNumLockOff() {
        System.out.println("[MouseMover] Setting num lock off");
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("numlock, off");
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backgroundImageOn() {
        System.out.println("[MouseMover] Enabling background image");
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("backgroundimage, on");
            this.cmds.flush();
            try {
                String s = StreamUtils.readNStringISO88591(this.backchannel, 5000000);
                System.out.println(s);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aeroOff() {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("aeroeffects, off");
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aeroOn() {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("aeroeffects, on");
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gdriverOff() {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("gdriver, off");
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gdriverOn() {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("gdriver, on");
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uacOff() {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("vistauac, off");
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uacOn() {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("vistauac, on");
            this.cmds.flush();
            this.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ctrlAltDel() {
        if (OS.isWindows()) {
            if (!JWNativeAPI.getInstance().isConsoleSession() || CentralDebugging.CAD_ALWAYS_USE_EXE) {
                Object target;
                Object object = this.cmds_LOCK;
                synchronized (object) {
                    this.checkConnection();
                    this.cmds.println("init_cad");
                    this.cmds.flush();
                    this.checkConnection();
                }
                try {
                    target = new File(StreamUtils.readNStringUTF8(this.backchannel, 10000));
                    String[] array = new String[]{"cmd.exe", "/c", "\"" + ((File)target).getCanonicalPath() + "\""};
                    RunCommandGetOutput.CommandResponse commandResponse = RunCommandGetOutput.runCommand(array, ((File)target).getParentFile(), true, false);
                    System.out.println("[MouseMover] Issued CAD and got:");
                    System.out.println("[MouseMover] Stdout: " + commandResponse.stdout);
                    System.out.println("[MouseMover] Stderr: " + commandResponse.stderr);
                    System.out.println("[MouseMover] ReturnCode: " + commandResponse.returnCode);
                    System.out.println("[MouseMover] Error: " + commandResponse.error);
                }
                catch (Throwable t) {
                    System.out.println("[MouseMover] Unable to issue CAD");
                    t.printStackTrace();
                }
                finally {
                    target = this.cmds_LOCK;
                    synchronized (target) {
                        this.checkConnection();
                        this.cmds.println("remove_cad");
                        this.cmds.flush();
                        this.checkConnection();
                    }
                }
            } else {
                Object object = this.cmds_LOCK;
                synchronized (object) {
                    this.checkConnection();
                    this.cmds.println("ctrlaltdel");
                    this.cmds.flush();
                    this.checkConnection();
                }
            }
        }
    }

    public ProcessResult installSGService(byte[] configbytes, String proxyHost, int proxyPort, String proxyUser, String proxyPass, boolean installShortcuts) {
        String updateURL = SimpleGatewayInstaller.getSGUpdateURL();
        return this.installSGService(updateURL, configbytes, proxyHost, proxyPort, proxyUser, proxyPass, installShortcuts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessResult installSGService(String updateURL, byte[] configbytes, String proxyHost, int proxyPort, String proxyUser, String proxyPass, boolean installShortcuts) {
        System.out.println("[MouseMover] Asked to install SimpleGateway. Update URL is " + updateURL);
        String logFileLocation = null;
        try {
            logFileLocation = MouseMover.createUniqueFile("simpleinstaller").getAbsolutePath();
            System.out.println("[MouseMove] SG Install Logging to " + logFileLocation);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        String chosenLanguage = Language.DEFLANG_ID;
        Message installMessage = SimpleGatewayInstaller.getInstallMessageFor(updateURL, chosenLanguage, configbytes, logFileLocation, proxyHost, proxyPort, proxyUser, proxyPass, installShortcuts);
        String hexMessage = HexData.byteArrayToHexString(MessageUtils.messageToBytes(installMessage));
        System.out.println("[MouseMove] Install SG Service. Message created to send to MouseMover.");
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("installsgservice, " + hexMessage);
            this.cmds.flush();
            try {
                String s = StreamUtils.readNStringISO88591(this.backchannel, 5000000);
                System.out.println(s);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.checkConnection();
        }
        System.out.println("[MouseMove] Mouse Mover Returned - now waiting for output from installer");
        try {
            return MouseMover.waitForProcessOutput(new File(logFileLocation));
        }
        catch (IOException e) {
            e.printStackTrace();
            ProcessResult result = new ProcessResult();
            result.code = 2;
            result.stacktrace = MouseMover.getStacktrace(e);
            result.logMessages.append(e.getMessage());
            result.logErrors.append(e.getMessage());
            return result;
        }
    }

    public static ProcessResult installSGServiceWithoutMouseMover(byte[] configbytes, boolean waitForResult, String proxyHost, int proxyPort, String proxyUser, String proxyPass, boolean installShortcuts) {
        String updateURL = SimpleGatewayInstaller.getSGUpdateURL();
        return MouseMover.installSGServiceWithoutMouseMover(updateURL, configbytes, waitForResult, proxyHost, proxyPort, proxyUser, proxyPass, installShortcuts);
    }

    public static ProcessResult installSGServiceWithoutMouseMover(String updateURL, byte[] configbytes, boolean waitForResult, String proxyHost, int proxyPort, String proxyUser, String proxyPass, boolean installShortcuts) {
        System.out.println("[MouseMover] Asked to install SimpleGateway. Update URL is " + updateURL);
        String logFileLocation = null;
        try {
            logFileLocation = MouseMover.createUniqueFile("simpleinstaller").getAbsolutePath();
            System.out.println("[MouseMove] SG Install Logging to " + logFileLocation);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        String chosenLanguage = Language.DEFLANG_ID;
        Message installMessage = SimpleGatewayInstaller.getInstallMessageFor(updateURL, chosenLanguage, configbytes, logFileLocation, proxyHost, proxyPort, proxyUser, proxyPass, installShortcuts);
        System.out.println("[MouseMove] Install SG Service. Bypassing mouse mover process.");
        try {
            SimpleGatewayInstaller installer = new SimpleGatewayInstaller(installMessage);
            installer.installSimpleGatewayAndThrowErrors(waitForResult);
            return MouseMover.waitForProcessOutput(new File(logFileLocation));
        }
        catch (Throwable e) {
            System.out.println("[MouseMover] Install SG Service failed.");
            e.printStackTrace();
            ProcessResult result = new ProcessResult();
            result.code = 2;
            result.stacktrace = MouseMover.getStacktrace(e);
            result.logMessages.append(e.getMessage());
            result.logErrors.append(e.getMessage());
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCleanupProperty(String key, String value) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("property, " + key + "=" + value);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    public ProcessResult uninstallSGService() {
        String updateURL = SimpleGatewayInstaller.getSGUpdateURL();
        return this.uninstallSGService(updateURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessResult uninstallSGService(String updateURL) {
        System.out.println("[MouseMover] Asked to remove SimpleGateway. Update URL is " + updateURL);
        String logFileLocation = null;
        try {
            logFileLocation = MouseMover.createUniqueFile("simpleuninstaller").getAbsolutePath();
            System.out.println("[MouseMove] SG Uninstall Logging to " + logFileLocation);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        String chosenLanguage = Language.DEFLANG_ID;
        Message installMessage = SimpleGatewayUninstaller.getUninstallMessageFor(updateURL, chosenLanguage, logFileLocation);
        String hexMessage = HexData.byteArrayToHexString(MessageUtils.messageToBytes(installMessage));
        System.out.println("[MouseMove] Uninstall SG Service. Message created to send to MouseMover.");
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("uninstallsgservice, " + hexMessage);
            this.cmds.flush();
            try {
                String s = StreamUtils.readNStringISO88591(this.backchannel, 5000000);
                System.out.println(s);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.checkConnection();
        }
        System.out.println("[MouseMove] Mouse Mover Returned - now waiting for output from uninstaller");
        try {
            return MouseMover.waitForProcessOutput(new File(logFileLocation));
        }
        catch (IOException e) {
            e.printStackTrace();
            ProcessResult result = new ProcessResult();
            result.code = 2;
            result.stacktrace = MouseMover.getStacktrace(e);
            result.logMessages.append(e.getMessage());
            result.logErrors.append(e.getMessage());
            return result;
        }
    }

    public static ProcessResult uninstallSGServiceWithoutMouseMover(boolean waitForResult) {
        String updateURL = SimpleGatewayInstaller.getSGUpdateURL();
        return MouseMover.uninstallSGServiceWithoutMouseMover(updateURL, waitForResult);
    }

    public static ProcessResult uninstallSGServiceWithoutMouseMover(String updateURL, boolean waitForResult) {
        System.out.println("[MouseMover] Asked to uninstall SimpleGateway. Update URL is " + updateURL);
        String logFileLocation = null;
        try {
            logFileLocation = MouseMover.createUniqueFile("simpleuninstaller").getAbsolutePath();
            System.out.println("[MouseMove] SG Uninstall Logging to " + logFileLocation);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        String chosenLanguage = Language.DEFLANG_ID;
        Message installMessage = SimpleGatewayUninstaller.getUninstallMessageFor(updateURL, chosenLanguage, logFileLocation);
        System.out.println("[MouseMove] Uninstall SG Service. Bypassing mouse mover process.");
        try {
            SimpleGatewayUninstaller installer = new SimpleGatewayUninstaller(installMessage);
            installer.uninstallSimpleGateway(waitForResult);
            return MouseMover.waitForProcessOutput(new File(logFileLocation));
        }
        catch (Throwable e) {
            e.printStackTrace();
            ProcessResult result = new ProcessResult();
            result.code = 2;
            result.stacktrace = MouseMover.getStacktrace(e);
            result.logMessages.append(e.getMessage());
            result.logErrors.append(e.getMessage());
            return result;
        }
    }

    public static void main(String[] args) {
        boolean doCleanup;
        block255: {
            System.setProperty("apple.awt.UIElement", "true");
            boolean nativeForOSX = DoubleClickSimulator.useNativeMouseEventsForOSX();
            doCleanup = true;
            String id = "";
            try {
                if (args.length > 4) {
                    id = args[4];
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                CentralDebugging.loadDebugSettings("MMoveSession_" + id, false);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                System.setProperty("apple.awt.UIElement", "true");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                String hostBack = args[0];
                int portBack = Integer.parseInt(args[1]);
                String hostFwd = args[2];
                int portFwd = Integer.parseInt(args[3]);
                System.out.println("[MouseMover] Connecting to " + hostBack + ":" + portBack);
                System.out.println("[MouseMover] Binding to " + hostFwd + ":" + portFwd);
                Socket sock = MouseMover.getConnectionForMMove(hostFwd, portFwd, hostBack, portBack);
                String prop = System.getProperty("sun.java2d.dpiaware");
                System.out.println("[MouseMover] DPI aware = " + prop);
                prop = System.getProperty("java.library.path");
                System.out.println("[MouseMover] Native utils path = " + prop);
                InputStream in = sock.getInputStream();
                BufferedOutputStream out = new BufferedOutputStream(sock.getOutputStream());
                DataUtils.writeInt(out, 313182719);
                ((OutputStream)out).flush();
                NativeUtils nutils = null;
                try {
                    System.out.println("[MouseMover] Loading from current folder");
                    NativeLibraryLoader.loadLibrary(new File("."));
                    System.out.println("[MouseMover] MMove Loaded native libraries OK");
                }
                catch (Throwable t) {
                    System.out.println("[MouseMover] MMove Failed to load native libraries from current folder (" + t + ")");
                }
                try {
                    nutils = NativeUtils.getInstance();
                    System.out.println("[MouseMover] MMove Loaded NativeUtils");
                }
                catch (Throwable t) {
                    System.out.println("[MouseMover] MMove Failed to load NativeUtils (" + t + ")");
                }
                try {
                    if (OS.isWindows()) {
                        System.out.println("[MouseMover] Natively increasing process priority.");
                        NativeUtils.getInstance().setProcessPriorityHigh(-1);
                    }
                }
                catch (Throwable t) {
                    System.out.println("[MouseMover] Unable to change process priority.");
                    t.printStackTrace();
                }
                Robot robot = null;
                try {
                    robot = new Robot();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
                String s = StreamUtils.readLine(in, "UTF-8");
                while (s != null) {
                    block256: {
                        if (CentralDebugging.MMOVE_PRINT_ALL_COMMANDS) {
                            System.out.println(sdf.format(new Date()) + ": " + s);
                        }
                        if (s.startsWith("dontcleanup")) {
                            doCleanup = false;
                        } else if (!s.startsWith("preloadsessionstartup")) {
                            if (s.startsWith("exitruntime")) break block255;
                            if (s.startsWith("doubleclicktime")) {
                                doubleClickTime = Long.parseLong(s.substring(s.indexOf(44) + 1).trim());
                            } else if (s.startsWith("runcommandandwait")) {
                                int one = s.indexOf(44) + 1;
                                int two = s.indexOf(36, one) + 1;
                                String dir = s.substring(one, two - 1).trim();
                                String command = s.substring(two).trim();
                                try {
                                    Process p = Runtime.getRuntime().exec(command, null, new File(dir));
                                    new ProcessPrinter(p, System.out, System.out);
                                    p.waitFor();
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            } else if (s.startsWith("grab_update")) {
                                String[] arguments = s.split(",");
                                int grab_x = Integer.parseInt(arguments[1].trim());
                                int grab_y = Integer.parseInt(arguments[2].trim());
                                int grab_w = Integer.parseInt(arguments[3].trim());
                                int grab_h = Integer.parseInt(arguments[4].trim());
                                NativeScreenUtil.getInstance().updateGrabArea(grab_x, grab_y, grab_w, grab_h);
                            } else if (s.startsWith("grab_fetch")) {
                                String[] arguments = s.split(",");
                                int chunk_x = Integer.parseInt(arguments[1].trim());
                                int chunk_y = Integer.parseInt(arguments[2].trim());
                                int chunk_w = Integer.parseInt(arguments[3].trim());
                                int chunk_h = Integer.parseInt(arguments[4].trim());
                                NonNativeLogicalArray result = NativeScreenUtil.getInstance().fetchArray(chunk_x, chunk_y, chunk_w, chunk_h);
                                result.toStream(out);
                                ((OutputStream)out).flush();
                            } else if (s.startsWith("runcommand")) {
                                String[] options = s.split(",");
                                String dir = options[1].trim();
                                String command = options[2].trim();
                                try {
                                    MouseMover.runCommand(dir, command);
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            } else if (s.startsWith("reboot")) {
                                String[] options = s.split(",");
                                boolean safeMode = options[1].trim().equalsIgnoreCase("true");
                                boolean force = options[2].trim().equalsIgnoreCase("true");
                                try {
                                    SafeModeUtil util;
                                    if (safeMode) {
                                        util = new SafeModeUtil();
                                        util.setBootIntoSafeMode();
                                    } else {
                                        util = new SafeModeUtil();
                                        util.setBootIntoNormalMode();
                                    }
                                    RebootUtil.reboot(force);
                                }
                                catch (Throwable x) {
                                    x.printStackTrace();
                                }
                            } else if (s.startsWith("forkmmove")) {
                                int one = s.indexOf(44) + 1;
                                System.out.println("Asked to fork (i=" + one + "): " + s);
                                try {
                                    File binDir;
                                    File launcher;
                                    String[] margs = s.substring(one).split(",");
                                    for (int i = 0; i < margs.length; ++i) {
                                        margs[i] = margs[i].trim();
                                    }
                                    VMFork fork = new VMFork(MouseMover.class.getName(), margs);
                                    fork.setProcessName("Session Elevation Helper");
                                    File javaExe = new File(VMFork.getJavaExe());
                                    if (OS.isWindows() && javaExe != null && javaExe.exists() && (launcher = new File(binDir = javaExe.getParentFile(), "windowslauncher.exe")).exists()) {
                                        VMFork.overrideDefaultJavaExe(launcher.getCanonicalPath());
                                    }
                                    String libpath = System.getProperty("java.library.path");
                                    if (prop != null) {
                                        fork.setVMSpecificArgs(new String[]{"-Xmx128m", "-Xms5m", "-Dsun.java2d.dpiaware=true", "-Djava.library.path=" + libpath});
                                    } else {
                                        fork.setVMSpecificArgs(new String[]{"-Xmx128m", "-Xms5m", "-Dsun.java2d.dpiaware=true"});
                                    }
                                    Process p = fork.fork();
                                    new ProcessPrinter(p, System.out, System.err);
                                }
                                catch (Exception x) {
                                    System.out.println("Failed to fork: " + x);
                                }
                            } else if (s.startsWith("killprocess")) {
                                int one = s.indexOf(44) + 1;
                                String pid = s.substring(one).trim();
                                try {
                                    Process p = WmicUtil.launchWmicCommand("/interactive:off process where ProcessId=\"" + pid + "\" call terminate");
                                    OutputStream pout = p.getOutputStream();
                                    pout.write("yyyyyyyy\r\nyyyyyy\r\n".getBytes());
                                    pout.flush();
                                    p.getInputStream().close();
                                    p.getErrorStream().close();
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            } else if (s.startsWith("wmiccommand")) {
                                int one = s.indexOf(44) + 1;
                                String pid = s.substring(one).trim();
                                try {
                                    Process p = WmicUtil.launchWmicCommand(pid);
                                    OutputStream pout = p.getOutputStream();
                                    pout.write("yyyyyyyy\r\nyyyyyy\r\n".getBytes());
                                    pout.flush();
                                    p.getInputStream().close();
                                    p.getErrorStream().close();
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            } else if (s.startsWith("closefile")) {
                                String file = s.substring(s.indexOf(44) + 1).trim();
                                try {
                                    if (!cachedFileName.equals(file)) break block256;
                                    try {
                                        cachedFile.close();
                                        cachedFile = null;
                                        cachedFileName = "";
                                    }
                                    catch (Throwable pid) {
                                    }
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            } else if (s.startsWith("readfile")) {
                                String file = s.substring(s.indexOf(44) + 1).trim();
                                try {
                                    FileInputStream fin = new FileInputStream(file);
                                    byte[] dat = StreamUtils.readAll(fin);
                                    fin.close();
                                    StreamUtils.writeBytes(out, dat);
                                    ((OutputStream)out).flush();
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            } else if (s.startsWith("property")) {
                                String keyValue = s.substring(s.indexOf(44) + 1).trim();
                                try {
                                    int index = keyValue.indexOf(61);
                                    if (index != -1) {
                                        String key = keyValue.substring(0, index);
                                        String value = keyValue.substring(index + 1);
                                        System.out.println("Got property " + key + "=" + value + "|\n");
                                        mmoveProperties.put(key, value);
                                    }
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            } else if (s.startsWith("deletefile")) {
                                String file = s.substring(s.indexOf(44) + 1).trim();
                                try {
                                    MouseMover.deleteFiles(new File(file));
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            } else if (s.startsWith("nativelibsfolder")) {
                                String file = s.substring(s.indexOf(44) + 1).trim();
                                try {
                                    if (file.length() == 0) {
                                        ClientManagement.SIMPLEHELP = false;
                                        ClientManagement.SIMPLEGATEWAY = true;
                                        break block256;
                                    }
                                    ClientManagement.SIMPLEHELP = true;
                                    ClientManagement.SIMPLEGATEWAY = false;
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            } else if (s.startsWith("jwnativeapifolder")) {
                                String file = s.substring(s.indexOf(44) + 1).trim();
                                try {
                                    JWNativeAPI.loadLibraryFrom(new File(file));
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            } else if (s.startsWith("centraldebugging")) {
                                String file = s.substring(s.indexOf(44) + 1).trim();
                                try {
                                    CentralDebugging.setOptionalDebugDir(new File(file));
                                    CentralDebugging.loadDebugSettings("MMove", false);
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            } else if (s.startsWith("newfolder")) {
                                String file = s.substring(s.indexOf(44) + 1).trim();
                                try {
                                    new File(file).mkdirs();
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            } else if (s.startsWith("runcommand")) {
                                int one = s.indexOf(44) + 1;
                                int two = s.indexOf(44, one) + 1;
                                String cmd = s.substring(one, two - 1).trim();
                                String dir = s.substring(two).trim();
                                MouseMover.runCommand(cmd, dir);
                            } else if (s.startsWith("renamefile")) {
                                String files = s.substring(s.indexOf(44) + 1).trim();
                                files = files.trim();
                                int index = files.indexOf(" ");
                                int len = Integer.parseInt(files.substring(0, index).trim());
                                String file1 = files.substring(index + 1, index + 1 + len);
                                files = files.substring(index + 1 + len + 1).trim();
                                index = files.indexOf(" ");
                                len = Integer.parseInt(files.substring(0, index).trim());
                                String file2 = files.substring(index + 1, index + 1 + len);
                                try {
                                    new File(file1).renameTo(new File(file2));
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            } else if (s.startsWith("filelastmod")) {
                                int one = s.indexOf(44) + 1;
                                int two = s.indexOf(44, one) + 1;
                                long lastmod = Long.parseLong(s.substring(one, two - 1).trim());
                                String file = s.substring(two).trim();
                                try {
                                    new File(file).setLastModified(lastmod);
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            } else if (s.startsWith("filelength")) {
                                int one = s.indexOf(44) + 1;
                                int two = s.indexOf(44, one) + 1;
                                long length = Long.parseLong(s.substring(one, two - 1).trim());
                                String file = s.substring(two).trim();
                                try {
                                    new File(file).getParentFile().mkdirs();
                                    if (!cachedFileName.equals(file)) {
                                        try {
                                            cachedFile.close();
                                            cachedFile = null;
                                            cachedFileName = "";
                                        }
                                        catch (Throwable t) {
                                            // empty catch block
                                        }
                                        cachedFile = new RandomAccessFile(file, "rw");
                                        cachedFileName = file;
                                    }
                                    cachedFile.setLength(length);
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            } else if (s.startsWith("writefile")) {
                                int one = s.indexOf(44) + 1;
                                int two = s.indexOf(44, one) + 1;
                                long start = Long.parseLong(s.substring(one, two - 1).trim());
                                String file = s.substring(two).trim();
                                try {
                                    byte[] dat = StreamUtils.readNBytes(in, 50000000);
                                    new File(file).getParentFile().mkdirs();
                                    if (!cachedFileName.equals(file)) {
                                        try {
                                            cachedFile.close();
                                            cachedFile = null;
                                            cachedFileName = "";
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                        cachedFile = new RandomAccessFile(file, "rw");
                                    }
                                    try {
                                        cachedFile.seek(start);
                                        cachedFile.write(dat);
                                    }
                                    catch (Throwable t) {
                                        t.printStackTrace();
                                    }
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            } else if (s.trim().startsWith("init_cad")) {
                                try {
                                    String path = MouseMover.initCADEnvironment();
                                    if (path != null) {
                                        StreamUtils.writeStringUTF8(out, path);
                                        break block256;
                                    }
                                    StreamUtils.writeStringUTF8(out, "");
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                    StreamUtils.writeStringUTF8(out, "");
                                }
                            } else if (s.trim().startsWith("remove_cad")) {
                                MouseMover.removeCADEnvironment();
                            } else if (s.trim().startsWith("ctrlaltdel")) {
                                if (OS.isWindows()) {
                                    if (!JWNativeAPI.getInstance().isConsoleSession()) {
                                        try {
                                            MouseMover.runUserCad();
                                        }
                                        catch (Throwable t) {}
                                    } else {
                                        CadPolicyAllower.tryForceAllowSAS();
                                        if (OS.isWindowsVistaOrAbove() || OS.isWindows2003()) {
                                            boolean isConsole = JWNativeAPI.getInstance().isConsoleSession();
                                            if (isConsole) {
                                                File canonicalFile = new File(".").getCanonicalFile();
                                                SimpleServiceUtil sutil = new SimpleServiceUtil(canonicalFile);
                                                sutil.doCadViaService();
                                            } else {
                                                try {
                                                    MouseMover.runUserCad();
                                                }
                                                catch (Throwable t) {
                                                    t.printStackTrace();
                                                }
                                            }
                                        } else {
                                            nutils.doCtrlAltDel();
                                        }
                                    }
                                }
                            } else if (s.trim().startsWith("downsim")) {
                                int one = s.indexOf(44);
                                int two = s.indexOf(44, one + 1);
                                int three = s.indexOf(44, two + 1);
                                int buttons = Integer.parseInt(s.substring(one + 1, two).trim());
                                int nativebuttons = Integer.parseInt(s.substring(two + 1, three).trim());
                                boolean isDoubleClick = new Boolean(s.substring(three + 1).trim());
                                dclick.mouseDown(nutils, robot, doubleClickTime, buttons, nativebuttons, isDoubleClick);
                            } else if (s.trim().startsWith("upsim")) {
                                int buttons = Integer.parseInt(s.substring(s.indexOf(44) + 1, s.lastIndexOf(44)).trim());
                                int nativebuttons = Integer.parseInt(s.substring(s.lastIndexOf(44) + 1).trim());
                                dclick.mouseUp(nutils, robot, doubleClickTime, buttons, nativebuttons);
                            } else if (s.trim().startsWith("mn")) {
                                int xr = Integer.parseInt(s.substring(s.indexOf(44) + 1, s.lastIndexOf(44)).trim());
                                int yr = Integer.parseInt(s.substring(s.lastIndexOf(44) + 1).trim());
                                try {
                                    if (nutils != null) {
                                        nutils.setPointerBySendInputNormalizedCoords(xr, yr);
                                    }
                                }
                                catch (Exception three) {}
                            } else if (s.trim().startsWith("down")) {
                                int buttons = Integer.parseInt(s.substring(s.indexOf(44) + 1, s.lastIndexOf(44)).trim());
                                int nativebuttons = Integer.parseInt(s.substring(s.lastIndexOf(44) + 1).trim());
                                try {
                                    if (nutils != null && nativebuttons != -1 && !CentralDebugging.FORCE_MMOVE_USE_ROBOT) {
                                        nutils.mouseDown(nativebuttons);
                                    } else if (nativeForOSX) {
                                        NativeScreenUtil.getInstance().mousePressed(nativebuttons);
                                    } else if (robot != null) {
                                        robot.mousePress(buttons);
                                    }
                                }
                                catch (Exception three) {}
                            } else if (s.trim().startsWith("up")) {
                                int buttons = Integer.parseInt(s.substring(s.indexOf(44) + 1, s.lastIndexOf(44)).trim());
                                int nativebuttons = Integer.parseInt(s.substring(s.lastIndexOf(44) + 1).trim());
                                try {
                                    if (nutils != null && nativebuttons != -1 && !CentralDebugging.FORCE_MMOVE_USE_ROBOT) {
                                        nutils.mouseUp(nativebuttons);
                                    } else if (nativeForOSX) {
                                        NativeScreenUtil.getInstance().mouseRelease(nativebuttons);
                                    } else if (robot != null) {
                                        robot.mouseRelease(buttons);
                                    }
                                }
                                catch (Exception three) {}
                            } else if (s.trim().startsWith("keyup")) {
                                int buttons = Integer.parseInt(s.substring(s.indexOf(44) + 1, s.lastIndexOf(44)).trim());
                                boolean isMapped = s.substring(s.lastIndexOf(44) + 1).trim().equals("true");
                                if (isMapped) {
                                    try {
                                        if (OS.isWindows()) {
                                            nutils.simulateKeyUp(buttons);
                                        } else if (OS.isMacOS()) {
                                            NativeMacUtils.getInstance().keyUp(buttons);
                                        } else if (OS.isLinux()) {
                                            NativeGrab.getInstance().keyUp(buttons);
                                        }
                                    }
                                    catch (Exception e) {
                                        try {
                                            if (robot != null) {
                                                robot.keyRelease(buttons);
                                            }
                                        }
                                        catch (Exception exception) {}
                                    }
                                } else {
                                    try {
                                        if (robot != null) {
                                            robot.keyRelease(buttons);
                                        }
                                    }
                                    catch (Exception e) {}
                                }
                            } else if (s.trim().startsWith("keydown")) {
                                int buttons = Integer.parseInt(s.substring(s.indexOf(44) + 1, s.lastIndexOf(44)).trim());
                                boolean isMapped = s.substring(s.lastIndexOf(44) + 1).trim().equals("true");
                                if (isMapped) {
                                    try {
                                        if (OS.isWindows()) {
                                            nutils.simulateKeyDown(buttons);
                                        } else if (OS.isMacOS()) {
                                            NativeMacUtils.getInstance().keyDown(buttons);
                                        } else if (OS.isLinux()) {
                                            NativeGrab.getInstance().keyDown(buttons);
                                        }
                                    }
                                    catch (Throwable e) {
                                        try {
                                            if (robot != null) {
                                                robot.keyPress(buttons);
                                            }
                                        }
                                        catch (Throwable throwable) {}
                                    }
                                } else {
                                    try {
                                        if (robot != null) {
                                            robot.keyPress(buttons);
                                        }
                                    }
                                    catch (Throwable e) {}
                                }
                            } else if (s.trim().startsWith("vistauac")) {
                                boolean on = s.substring(s.indexOf(44) + 1, s.length()).trim().equalsIgnoreCase("on");
                                if (on) {
                                    UacPromptModifier.enableUACAndWait();
                                } else {
                                    UacPromptModifier.disableUACAndWait();
                                }
                            } else if (s.trim().startsWith("aeroeffects")) {
                                boolean on = s.substring(s.indexOf(44) + 1, s.length()).trim().equalsIgnoreCase("on");
                                if (nutils != null) {
                                    if (on) {
                                        try {
                                            Process p = Runtime.getRuntime().exec("net.exe start UxSms", null, null);
                                            new ProcessPrinter(p, System.out, System.out);
                                        }
                                        catch (Throwable t) {
                                            t.printStackTrace();
                                        }
                                    } else {
                                        try {
                                            Process p = Runtime.getRuntime().exec("net.exe stop UxSms", null, null);
                                            new ProcessPrinter(p, System.out, System.out);
                                        }
                                        catch (Throwable t) {
                                            t.printStackTrace();
                                        }
                                    }
                                }
                            } else if (s.trim().startsWith("gdriver")) {
                                boolean on = s.substring(s.indexOf(44) + 1, s.length()).trim().equalsIgnoreCase("on");
                                if (nutils != null) {
                                    if (on) {
                                        nutils.restoreHardwareAcceleration();
                                    } else {
                                        nutils.disableHardwareAcceleration();
                                    }
                                }
                            } else if (s.trim().startsWith("installsgservice")) {
                                try {
                                    String hexData = s.substring(s.indexOf(44) + 1, s.length()).trim();
                                    Message message = MessageUtils.bytesToMessage(HexData.hexStringToByteArray(hexData));
                                    SimpleGatewayInstaller installer = new SimpleGatewayInstaller(message);
                                    installer.installSimpleGateway(false);
                                    StreamUtils.writeStringISO88591(out, "[MouseMover] Install Done");
                                    ((OutputStream)out).flush();
                                }
                                catch (Throwable t) {
                                    StreamUtils.writeStringISO88591(out, "[MouseMover Error]: " + t.getClass() + ": " + t.getMessage());
                                    ((OutputStream)out).flush();
                                }
                            } else if (s.trim().startsWith("uninstallsgservice")) {
                                try {
                                    String hexData = s.substring(s.indexOf(44) + 1, s.length()).trim();
                                    Message message = MessageUtils.bytesToMessage(HexData.hexStringToByteArray(hexData));
                                    SimpleGatewayUninstaller uninstaller = new SimpleGatewayUninstaller(message);
                                    uninstaller.uninstallSimpleGateway(false);
                                    StreamUtils.writeStringISO88591(out, "[MouseMover] Uninstall Done");
                                    ((OutputStream)out).flush();
                                }
                                catch (Throwable t) {
                                    StreamUtils.writeStringISO88591(out, "[MouseMover Error]: " + t.getClass() + ": " + t.getMessage());
                                    ((OutputStream)out).flush();
                                }
                            } else if (s.trim().startsWith("numlock")) {
                                try {
                                    boolean on = s.substring(s.indexOf(44) + 1, s.length()).trim().equalsIgnoreCase("on");
                                    if (nutils != null) {
                                        nutils.setNumLock(on);
                                    }
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            } else {
                                String X = s.substring(0, s.indexOf(44)).trim();
                                String Y = s.substring(s.indexOf(44) + 1).trim();
                                try {
                                    if (nutils != null) {
                                        nutils.setPointerBySetCursorPos(Integer.parseInt(X), Integer.parseInt(Y));
                                    } else if (nativeForOSX) {
                                        NativeScreenUtil.getInstance().mouseMoved(Integer.parseInt(X), Integer.parseInt(Y));
                                    } else if (robot != null) {
                                        robot.mouseMove(Integer.parseInt(X), Integer.parseInt(Y));
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    s = StreamUtils.readLine(in, "UTF-8");
                }
            }
            catch (Throwable t) {
                try {
                    t.printStackTrace();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (doCleanup) {
            try {
                MouseMover.cleanup();
            }
            catch (Throwable t) {
                try {
                    t.printStackTrace();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        try {
            System.exit(0);
        }
        catch (Throwable t) {
            try {
                t.printStackTrace();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            Runtime.getRuntime().exit(0);
        }
        catch (Throwable t) {
            try {
                t.printStackTrace();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static String initCADEnvironment() throws IOException {
        CadPolicyAllower.tryForceAllowSAS();
        File cadAsUser = new File(new File(".").getCanonicalFile(), "cadasuser.exe");
        String programFiles = NativeUtils.getInstance().getWindowsEnv("PROGRAMFILES");
        File pfFile = new File(programFiles);
        File sh = new File(pfFile, "SimpleHelpUtilities");
        if (!sh.exists()) {
            sh.mkdirs();
        }
        File target2 = new File(sh, "SimpleHelpCAD.exe");
        FileUtil.copy(cadAsUser, target2);
        System.out.println("[MouseMover] Target2 exists: " + target2.exists());
        System.out.println("[MouseMover] Target2 length: " + target2.length());
        JWWindowsOS.setReadableForAllUsers(target2, false);
        return target2.getAbsolutePath();
    }

    private static void removeCADEnvironment() {
        String programFiles = NativeUtils.getInstance().getWindowsEnv("PROGRAMFILES");
        File pfFile = new File(programFiles);
        File sh = new File(pfFile, "SimpleHelpUtilities");
        if (sh.exists()) {
            FileUtil.deleteDir(sh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void runUserCad() throws IOException {
        File cadAsUser = new File(new File(".").getCanonicalFile(), "cadasuser.exe");
        String programFiles = NativeUtils.getInstance().getWindowsEnv("PROGRAMFILES");
        File pfFile = new File(programFiles);
        File sh = new File(pfFile, "SimpleHelpUtilities");
        if (!sh.exists()) {
            sh.mkdirs();
        }
        File target2 = new File(sh, "SimpleHelpCAD.exe");
        try {
            FileUtil.copy(cadAsUser, target2);
            System.out.println("[MouseMover] Target2 exists: " + target2.exists());
            System.out.println("[MouseMover] Target2 length: " + target2.length());
            try {
                String[] array = new String[]{"cmd.exe", "/c", "\"" + target2.getCanonicalPath() + "\""};
                System.out.println("[MouseMover] Running ");
                RunCommandGetOutput.CommandResponse commandResponse = RunCommandGetOutput.runCommand(array, sh, true, false);
                System.out.println("[MouseMover] Issued CAD and got:");
                System.out.println("[MouseMover] Stdout: " + commandResponse.stdout);
                System.out.println("[MouseMover] Stderr: " + commandResponse.stderr);
                System.out.println("[MouseMover] ReturnCode: " + commandResponse.returnCode);
                System.out.println("[MouseMover] Error: " + commandResponse.error);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            try {
                target2.delete();
            }
            catch (Throwable t) {}
            try {
                FileUtil.deleteDir(sh);
            }
            catch (Throwable t) {}
        }
    }

    private static String getStacktrace(Throwable t) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        t.printStackTrace(ps);
        return os.toString();
    }

    public static boolean deleteFiles(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                MouseMover.deleteFiles(files[i]);
            }
        }
        return f.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void threadWaitForPreviousThread(Thread thisThread) {
        Object object = thread_LOCK;
        synchronized (object) {
            if (thread != null) {
                try {
                    thread.join();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                thread = thisThread;
            }
        }
    }

    private static File createUniqueFile(String prefix) throws IOException {
        File logFile = new File(CacheDirUtil.getAllAccessibleTempDir(), prefix + ".log");
        if (logFile.exists()) {
            logFile.delete();
        }
        int count = 0;
        while (logFile.exists()) {
            logFile = new File(CacheDirUtil.getAllAccessibleTempDir(), prefix + "_" + count + ".log");
            ++count;
            if (!logFile.exists()) continue;
            logFile.delete();
        }
        logFile.createNewFile();
        return logFile;
    }

    private static ProcessResult waitForProcessOutput(File outputLogFile) throws IOException {
        System.out.println("[MouseMover] Process launched, will wait for process output");
        try {
            String output;
            long timeout = System.currentTimeMillis() + 30000L;
            while (System.currentTimeMillis() < timeout) {
                try {
                    Thread.sleep(500L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                System.out.println("[MouseMover] Waiting for process output...");
                if (!outputLogFile.exists() || !(output = DataUtils.readAllAsString(new FileInputStream(outputLogFile))).contains("<<<<END>>>>")) continue;
                break;
            }
            System.out.println("[MouseMover] Processing output...");
            output = DataUtils.readAllAsString(new FileInputStream(outputLogFile));
            System.out.println(output);
            ProcessResult result = ProcessOutputUtil.parseOutputForLatestReturnCode(output, "[MouseMover] ");
            System.out.println("[MouseMover] Finished processing, returning result");
            ProcessResult processResult = result;
            return processResult;
        }
        catch (Throwable t) {
            IOException ex = new IOException(t.getMessage());
            ex.initCause(t);
            throw ex;
        }
        finally {
            if (!outputLogFile.delete()) {
                System.out.println("[MouseMover] Could not delete temporary log file!");
            }
        }
    }

    public static void cleanup() {
        try {
            System.out.println("[MouseMover] Cleaning up wallpaper changes.");
            WallpaperDisabler.INSTANCE.setEnabled(false);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        CleanupWithProperties.cleanup(mmoveProperties);
    }

    @Override
    public void setCleanupState(String key, String value) {
        System.out.println("[MouseMover] Setting cleanup state: " + key + "=" + value);
        this.localProperties.put(key, value);
        this.sendCleanupProperty(key, value);
    }

    private static void runCommand(String cmd, String dir) {
        String test = cmd.trim().toLowerCase();
        if ((test.equals("cmd") || test.equals("cmd.exe")) && OS.isWindows()) {
            cmd = "cmd.exe /c start cmd.exe";
        }
        try {
            VMFork fork = Secure.isSecureJar() ? new VMFork("SecureRunner1", new String[]{CommandRunner.class.getName(), cmd}) : new VMFork(CommandRunner.class.getName(), new String[]{cmd});
            fork.setWorkingDir(new File(dir));
            if (ClientManagement.isSimpleHelp()) {
                String classPath = System.getProperty("java.class.path");
                String pathSeparator = System.getProperty("path.separator");
                String[] jarPaths = classPath.split(pathSeparator);
                fork.setBaseClasspath(jarPaths);
            }
            System.out.println(fork);
            Process p = fork.fork();
            new ProcessPrinter(p, System.out, System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void runCommand(String cmd, String dir, boolean elevate, boolean useMMove) {
        if (!useMMove) {
            MouseMover.runCommand(cmd, dir);
        } else {
            MouseMover.getStaticMouseMover().runCommandWithMMove(cmd, dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCommandWithMMove(String cmd, String dir) {
        Object object = this.cmds_LOCK;
        synchronized (object) {
            this.checkConnection();
            this.cmds.println("runcommand, " + cmd + ", " + dir);
            this.cmds.flush();
            this.checkConnection();
        }
    }

    static {
        mmoveProperties = new Properties();
        cachedFileName = "";
        nextMouseClickAllowed = 0L;
        dclick = new DoubleClickSimulator();
        doubleClickTime = 500L;
        thread_LOCK = new Object();
        thread = null;
    }

    class ExitThread
    extends Thread {
        private boolean doCleanup;

        public ExitThread(boolean doCleanup) {
            this.doCleanup = doCleanup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = MouseMover.this.cmds_LOCK;
            synchronized (object) {
                System.out.println("[MMove] Telling MMove to shutdown (doCleanup=" + this.doCleanup + ")");
                if (!this.doCleanup) {
                    System.out.println("[MMove] Telling MMove to not cleanup (controlled shutdown)");
                    MouseMover.this.cmds.println("dontcleanup");
                    MouseMover.this.cmds.flush();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                MouseMover.this.cmds.println("exitruntime");
                MouseMover.this.cmds.flush();
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    System.out.println("[MMove] Closing MMove comms");
                    MouseMover.this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    class ProcessWaiter
    extends Thread {
        Process p;
        boolean alive = true;

        public ProcessWaiter(Process p) {
            this.p = p;
            this.start();
        }

        public boolean processAlive() {
            return this.alive;
        }

        @Override
        public void run() {
            try {
                this.p.waitFor();
                this.alive = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class MMoveConnection {
        ServerSocket ssockBack = null;
        String backwardHost;
        int backwardPort;
        String forwardHost;
        int forwardPort;
        private ConcurrentAttempt ca;

        MMoveConnection() {
        }

        public void startConnectingInBackground() {
            this.ca.attemptNowNonBlocking();
        }

        public Socket getValidConnection(long TIMEOUT) throws IOException {
            long t = System.currentTimeMillis() + TIMEOUT;
            while (System.currentTimeMillis() < t) {
                if (this.ca.attemptsFinished()) {
                    return ((SocketConnectAttempt)this.ca.getSuccessfulAttempt()).getSocket();
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            throw new IOException("Not finished yet...");
        }

        public String toString() {
            return this.ca.getSuccessfulAttempt() + "";
        }
    }

    public class ElevationException
    extends IOException {
    }
}

