/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.util;

import com.aem.utils.multiplex.MultiplexerByteInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class DualPrinter {
    private PrintStream p1;
    private PrintStream p2;
    private PrintStream p3;
    private SimpleDateFormat sdf = new SimpleDateFormat("dd/MM HH:mm:ss.SSS: ");
    private final Object LOCK = new Object();
    private final ArrayList<RePrinter> threads = new ArrayList();

    public DualPrinter(PrintStream p1, PrintStream p2) {
        this.p1 = p1;
        this.p2 = p2;
    }

    public DualPrinter(PrintStream p1) {
        this.p1 = p1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream createNewOutputStream() {
        MultiplexerByteInputStream bin = new MultiplexerByteInputStream();
        ByteArrayInPrinter printer = new ByteArrayInPrinter(bin);
        RePrinter reprinter = new RePrinter(new BufferedReader(new InputStreamReader(bin)));
        reprinter.start();
        ArrayList<RePrinter> arrayList = this.threads;
        synchronized (arrayList) {
            this.threads.add(reprinter);
        }
        return printer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void die() {
        ArrayList<RePrinter> arrayList = this.threads;
        synchronized (arrayList) {
            for (RePrinter printer : this.threads) {
                printer.die();
            }
            this.threads.clear();
        }
    }

    class ByteArrayInPrinter
    extends OutputStream {
        MultiplexerByteInputStream bin;

        public ByteArrayInPrinter(MultiplexerByteInputStream bin) {
            this.bin = bin;
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(byte[] b) {
            this.bin.addData(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            byte[] dat = new byte[len];
            System.arraycopy(b, off, dat, 0, len);
            this.bin.addData(dat);
        }

        @Override
        public void write(int b) {
            this.bin.addData(new byte[]{(byte)b});
        }
    }

    public class RePrinter
    extends Thread {
        private BufferedReader bread;
        private boolean die;

        public RePrinter(BufferedReader bread) {
            super("RePrinter");
            this.die = false;
            this.bread = bread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.die) {
                    String s = this.bread.readLine();
                    Date date = new Date(System.currentTimeMillis());
                    if (s == null) {
                        return;
                    }
                    Object object = DualPrinter.this.LOCK;
                    synchronized (object) {
                        if (DualPrinter.this.p1 != null) {
                            DualPrinter.this.p1.println(s);
                        }
                        if (DualPrinter.this.p2 != null) {
                            DualPrinter.this.p2.print(DualPrinter.this.sdf.format(date) + s + "\r\n");
                        }
                        if (DualPrinter.this.p3 != null) {
                            DualPrinter.this.p3.println(s);
                        }
                        if (DualPrinter.this.p1 != null) {
                            DualPrinter.this.p1.flush();
                        }
                        if (DualPrinter.this.p2 != null) {
                            DualPrinter.this.p2.flush();
                        }
                        if (DualPrinter.this.p3 != null) {
                            DualPrinter.this.p3.flush();
                        }
                    }
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void die() {
            this.die = true;
        }
    }
}

