/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.gui;

import com.aem.CentralDebugging;
import com.aem.ClientManagement;
import com.aem.TestResourceBundle;
import com.aem.sdesktop.interfaces.ServerController;
import com.aem.sdesktop.server.SimpleDesktopServer;
import com.aem.sdesktop.server.controller.SDesktopServerController;
import com.aem.sdesktop.server.gui.ServerChatPanel;
import com.aem.sdesktop.server.gui.ServerNoGUI;
import com.aem.sdesktop.server.sounds.SHSounds;
import com.aem.shelp.common.Language;
import com.aem.shelp.util.OSNotificationUtil;
import com.aem.shelp.util.ScreenDimension;
import com.aem.shelp.util.TechPresenceVisibilityDialog;
import com.aem.utils.NativeScreenUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Random;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.RootPaneContainer;
import utils.progtools.URIUtil;
import utils.progtools.net.URLParser;
import utils.stream.StreamUtils;
import utils.swing.SwingUtil;
import utils.swing.browser.Browser;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;

public class ServerGUI
extends ServerNoGUI {
    private int systrayImage = -1;
    private RootPaneContainer rpc;
    private JComponent mainComponent;
    private JPanel mainpanel = new JPanel();
    protected TechPresenceVisibilityDialog.TechnicianInfoPanel technicianInfoPanel;
    private JTabbedPane tab_panel = new JTabbedPane();
    private ServerChatPanel chat_panel;
    private TechPresenceVisibilityDialog techPresenceDialog;
    ActionListener chatListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ServerGUI.this.rpc != null) {
                ServerGUI.this.techPresenceDialog.setVisible(false);
                if (ServerGUI.this.rpc instanceof Frame) {
                    ((Frame)((Object)ServerGUI.this.rpc)).setExtendedState(0);
                    ((Frame)((Object)ServerGUI.this.rpc)).setVisible(true);
                }
            }
        }
    };
    ActionListener terminateListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ServerGUI.this.rpc != null && ServerGUI.this.rpc instanceof Frame) {
                ((Frame)((Object)ServerGUI.this.rpc)).setVisible(false);
            }
            ServerGUI.this.controller.disconnect(true);
        }
    };
    boolean nochat = false;

    public ServerGUI(ResourceBundle lang, RootPaneContainer rpc, JComponent comp, boolean sdemoConnection, boolean remoteAccessConnection) {
        super(sdemoConnection, remoteAccessConnection);
        this.rpc = rpc;
        this.mainComponent = comp;
        if (this.mainComponent != null) {
            this.initGraphics();
            this.mainComponent.setVisible(true);
        }
    }

    @Override
    public boolean isHeadless() {
        return false;
    }

    protected void handleError(Exception e, String message, String title, ImageIcon icon) {
        if (this.rpc != null) {
            SHGlassOptionPane.showMessageDialog(this.rpc, message, title, icon);
        }
    }

    @Override
    public void setTechnicianConnectedStatus(boolean connected, String name, String hostname, long startTime) {
        super.setTechnicianConnectedStatus(connected, name, hostname, startTime);
        BufferedImage avatar = null;
        if (connected) {
            avatar = this.chat_panel.getTechnicianAvatar(name);
        }
        TechPresenceVisibilityDialog.TechnicianInfoPanel newInfoPanel = new TechPresenceVisibilityDialog.TechnicianInfoPanel(name, startTime, avatar, hostname, this.remoteAccessConnection);
        if (this.technicianInfoPanel == null) {
            this.technicianInfoPanel = newInfoPanel;
            this.mainpanel.add((Component)this.technicianInfoPanel, "North");
        }
        if (connected) {
            if (this.techPresenceDialog != null) {
                this.techPresenceDialog.addTechnicianInfo(name, startTime, avatar, hostname);
            }
        } else if (this.techPresenceDialog != null) {
            this.techPresenceDialog.removeTechnicianInfo(name, startTime, hostname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFinished() {
        super.setFinished();
        ServerGUI serverGUI = this;
        synchronized (serverGUI) {
            if (this.technicianInfoPanel != null) {
                this.technicianInfoPanel.setFinished();
            }
            this.chat_panel.connectionTerminated();
            if (this.serverOptions != null) {
                if (!this.sdemoConnection && !this.expectReboot && this.serverOptions.openBrowserAtEndOfSession(!this.remoteAccessConnection)) {
                    this.processedEndOfSessionActions = true;
                    try {
                        String url = this.serverOptions.endOfSessionURL;
                        URLParser parser = new URLParser(url);
                        String query = parser.getQuery();
                        if (query != null) {
                            ArrayList<String> keys = new ArrayList<String>();
                            ArrayList<String> values = new ArrayList<String>();
                            if (this.customer != null) {
                                for (String key : this.customer.getDetailsKeys()) {
                                    keys.add(key);
                                }
                                for (String value : this.customer.getDetailsValues()) {
                                    values.add(value);
                                }
                            }
                            keys.add("Technician");
                            values.add(this.technicianInfoPanel.getTechnicianName());
                            System.out.println("[QueryKeys] " + keys);
                            System.out.println("[QueryValues] " + values);
                            query = ServerGUI.substituteQueryValues(query, keys.toArray(new String[0]), values.toArray(new String[0]));
                        }
                        parser.setQuery(query);
                        URL newUrl = parser.getBestGuessURL();
                        System.out.println("[ServerGUI] Attempting to open URL: " + newUrl + " constructed from " + url);
                        Browser.openURL(newUrl);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            } else {
                System.out.println("[ServerGUI] No post session actions requested.");
            }
        }
    }

    public static String substituteQueryValues(String query, String[] keys, String[] values) {
        if (query == null) {
            return query;
        }
        if (query.startsWith("?")) {
            query = query.substring(1);
        }
        String[] parameters = query.split("&");
        ArrayList<String> keysList = new ArrayList<String>();
        ArrayList<String> valuesList = new ArrayList<String>();
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < parameters.length; ++i) {
            String parameter;
            int equals;
            if (result.length() > 0) {
                result.append("&");
            }
            if ((equals = (parameter = parameters[i]).indexOf(61)) == -1) {
                keysList.add(parameters[i]);
                continue;
            }
            String key = parameter.substring(0, equals);
            String value = parameter.substring(equals + 1);
            for (int j = 0; j < keys.length; ++j) {
                value = value.replace("${" + keys[j] + "}", values[j]);
            }
            if (value.contains("${")) continue;
            keysList.add(key);
            valuesList.add(value);
        }
        return URIUtil.createQueryString(keysList.toArray(new String[0]), valuesList.toArray(new String[0]));
    }

    @Override
    public JComponent getParentFrame() {
        return this.getFrame();
    }

    @Override
    public JComponent getParentComponent() {
        return this.getFrame();
    }

    @Override
    public JComponent getFrame() {
        return this.mainComponent;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.chat_panel.setInputEnabled(b);
    }

    public static void main(String[] args) throws InterruptedException, FileNotFoundException, IOException {
        SimpleHelpFrame frame = new SimpleHelpFrame();
        frame.setTitle("Technician Chat");
        ((Window)frame).setSize(200, 300);
        JPanel panel = new JPanel(new GridLayout(1, 1));
        ServerGUI gui = new ServerGUI(new TestResourceBundle(), frame, panel, false, false);
        gui.init(null, null);
        frame.getContentPane().add(panel);
        frame.setVisible(true);
        try {
            gui.setTechnicianConnectedStatus(true, "George", "shimmy", System.currentTimeMillis());
            byte[] data = StreamUtils.readAllAndClose(new FileInputStream("avatar.png"));
            gui.setAvatar(data, "123", "localhost");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        Random r = new Random();
        for (int i = 0; i < 100; ++i) {
            if (i % 2 == 0) {
                gui.receiveMessage("This is a message " + System.currentTimeMillis(), "localhost", "localhost");
            } else {
                gui.receiveMessage("This is a message " + System.currentTimeMillis(), "server", "server");
            }
            Thread.sleep(500L);
        }
    }

    @Override
    public void init(ServerController controller, String displayName) {
        if (displayName == null) {
            System.out.println("Remote user display name is null, will init to a basic value");
            displayName = Language.get("REMOTE_USER");
        }
        super.init(controller, displayName);
        this.initGraphics2(displayName);
        boolean start_minimized = false;
        if (!SimpleDesktopServer.callback_only && start_minimized && this.systrayImage != -1) {
            this.mainComponent.setVisible(false);
        }
    }

    private void initGraphics() {
        this.mainComponent.add(this.mainpanel);
        this.mainpanel.setLayout(new BorderLayout());
        if (this.rpc != null) {
            this.initPresenceDialog();
            if (this.rpc instanceof Frame) {
                final Frame frame = (Frame)((Object)this.rpc);
                frame.addWindowListener(new WindowListener(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                    }

                    @Override
                    public void windowClosing(WindowEvent e) {
                        if (ServerGUI.this.serverOptions != null && ServerGUI.this.serverOptions.showTechPresenceDialog) {
                            frame.setVisible(false);
                            if (ServerGUI.this.techPresenceDialog != null) {
                                ServerGUI.this.techPresenceDialog.setVisible(true);
                            }
                        } else if (ClientManagement.isSimpleGateway()) {
                            frame.setExtendedState(1);
                        }
                    }

                    @Override
                    public void windowClosed(WindowEvent e) {
                    }

                    @Override
                    public void windowIconified(WindowEvent e) {
                    }

                    @Override
                    public void windowDeiconified(WindowEvent e) {
                    }

                    @Override
                    public void windowActivated(WindowEvent e) {
                    }

                    @Override
                    public void windowDeactivated(WindowEvent e) {
                    }
                });
            }
        }
    }

    private void initPresenceDialog() {
        this.techPresenceDialog = new TechPresenceVisibilityDialog(Language.get("REMOTE_TECHNICIAN_CONNECTED_TITLE"), this.remoteAccessConnection);
        this.techPresenceDialog.addActionListeners(this.terminateListener, this.chatListener);
    }

    @Override
    public void setNoChat() {
        this.nochat = true;
    }

    public void initGraphics2(String displayName) {
        this.mainpanel.removeAll();
        this.mainpanel.setLayout(new BorderLayout());
        this.chat_panel = new ServerChatPanel(Language.DEFLANG, this, this.rpc, this.controller, displayName, this.nochat, this.remoteAccessConnection);
        this.chat_panel.setTitle(null);
        this.mainpanel.add("Center", this.chat_panel.getRootComponent());
        try {
            if (!GraphicsEnvironment.isHeadless()) {
                System.out.println("************* Screen Info ***************");
                if (NativeScreenUtil.getInstance() != null) {
                    System.out.println("Physical Screen Size      : " + ScreenDimension.getPhysicalScreenSize());
                }
                System.out.println("Toolkit                   : " + Toolkit.getDefaultToolkit().getScreenSize());
                System.out.println("Toolkit Res               : " + Toolkit.getDefaultToolkit().getScreenResolution());
                System.out.println("Grapics Environment Bounds: " + GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds());
                DisplayMode displayMode = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
                if (displayMode != null) {
                    System.out.println("Display mode: " + displayMode.getWidth() + " x " + displayMode.getHeight());
                } else {
                    System.out.println("Display mode: NULL");
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void receiveMessage(String msg, String username, String hostname) {
        if (CentralDebugging.CHAT_VERBOSE) {
            System.out.println("[Chat] Adding message to chat panel");
        }
        this.chat_panel.addMessage(username, hostname, msg);
        if (CentralDebugging.CHAT_VERBOSE) {
            System.out.println("[Chat] Bringing frame to front (if required)");
        }
        this.bringFrameToFront();
    }

    private void bringFrameToFront() {
        try {
            JFrame frame;
            if (this.rpc instanceof JFrame && (frame = (JFrame)this.rpc).isActive()) {
                return;
            }
            SwingUtil.frameToFront(this.rpc);
        }
        catch (Exception e) {
            System.out.println("[ServerGUI] Unable to bring frame front.");
        }
    }

    public void setDirty(Component component, boolean dirty) {
        int n = this.tab_panel.indexOfComponent(component);
        if (n == -1) {
            return;
        }
        String name = "ERROR?";
        if (dirty) {
            name = name + " **";
        }
        this.tab_panel.setTitleAt(n, name);
    }

    @Override
    public void setAvatar(byte[] bytes, String username, String displayName) {
        try {
            this.chat_panel.setAvatar(bytes, username, displayName);
            BufferedImage technicianAvatar = ImageIO.read(new ByteArrayInputStream(bytes));
            System.out.println("[ServerGUI] Set avatar in map for " + username);
            if (this.techPresenceDialog != null) {
                this.techPresenceDialog.updateTechnicianAvatar(displayName, technicianAvatar);
            }
            if (this.technicianInfoPanel != null && this.technicianInfoPanel.getTechnicianName().equals(displayName)) {
                System.out.println("[ServerGUI] Setting avatar in technician info panel");
                this.technicianInfoPanel.setAvatar(technicianAvatar);
            }
        }
        catch (Throwable t) {
            System.out.println("[ServerGUI] Unable to set avatar for technician.");
            t.printStackTrace();
        }
    }

    @Override
    public void setServerOptions(SDesktopServerController.ServerOptions serverOptions) {
        super.setServerOptions(serverOptions);
        if (serverOptions.showTechPresenceDialog && this.techPresenceDialog != null && !this.techPresenceDialog.isVisible()) {
            if (this.rpc != null && this.rpc instanceof Frame && ((Frame)((Object)this.rpc)).isVisible()) {
                return;
            }
            this.techPresenceDialog.setVisible(true);
        }
    }

    @Override
    public int getChatPanelHeight() {
        return this.chat_panel.getRootComponent().getHeight();
    }

    @Override
    public void alertUser() {
        this.bringFrameToFront();
        this.chat_panel.scrollToBottom();
        this.chat_panel.highlightLastMessage();
        if (this.rpc != null && this.rpc instanceof Frame) {
            Frame frame = (Frame)((Object)this.rpc);
            String frameTitle = frame.getTitle();
            OSNotificationUtil.notifyUser(frameTitle, 3);
        }
        if (SHSounds.beep != null) {
            SHSounds.play(SHSounds.beep);
        }
    }

    @Override
    public void setTechnicianIsTyping(String displayName) {
        if (displayName.length() > 40) {
            displayName = displayName.substring(0, 40);
        }
        this.chat_panel.updateIsTyping(displayName + " " + Language.get("IS_TYPING") + "...");
    }
}

