/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.controller;

import com.aem.CentralDebugging;
import com.aem.nodelink.NodeLink;
import com.aem.sdesktop.interfaces.GC;
import com.aem.sdesktop.interfaces.MSG;
import com.aem.sdesktop.interfaces.ServerPart;
import com.aem.sdesktop.server.controller.SDesktopServerController;
import com.aem.sdesktop.server.controller.SDesktopServerInstance;
import com.aem.utils.Debugger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import utils.message.Message;
import utils.message.MessageReader;
import utils.message.MessageWriter;

public class WhiteboardServer
extends Thread
implements MSG,
GC,
ServerPart {
    MessageReader min;
    MessageWriter mout;
    SDesktopServerController controller;
    SDesktopServerInstance instance;
    String username;
    boolean die = false;

    @Override
    public void die() {
        this.die = true;
    }

    public void log(String s) {
        System.out.println(s);
    }

    public WhiteboardServer(SDesktopServerInstance instance, SDesktopServerController controller, InputStream input, OutputStream output, String username) {
        super("WhiteboardServerThread");
        this.controller = controller;
        this.instance = instance;
        this.username = username;
        this.min = new MessageReader(input);
        this.mout = new MessageWriter(output);
    }

    public void broadcastWhiteboard(Message m) throws IOException {
        this.mout.write(m);
    }

    @Override
    public void run() {
        Message m = null;
        try {
            while (!this.die) {
                m = this.min.read();
                this.handleMessage(m);
            }
        }
        catch (IOException e) {
            if (!NodeLink.isGracefulStop(e)) {
                if (CentralDebugging.PRINT_STACK_ON_CONNECTION_FAIL) {
                    System.out.println("(Whiteboard Server) LAST MESSAGE:" + m);
                    e.printStackTrace();
                } else {
                    System.out.println("[WhiteboardServer] " + e);
                }
            }
            this.log("[WhiteboardServer] Connection terminated");
        }
        catch (Throwable e) {
            this.log("An unclassified error occurred in WhiteboardServer: " + Debugger.getStackTrace(e));
            System.out.println("(Whiteboard Server) LAST MESSAGE:" + m);
            e.printStackTrace();
        }
        this.instance.died();
    }

    public void handleMessage(Message m) throws IOException {
        int type = m.getType();
    }
}

