/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.controller;

import java.io.IOException;
import utils.vnc.VNC;
import utils.vnc.encoders.datatarget.IntArrayTarget;
import utils.vnc.exceptions.FailedSecurityException;
import utils.vnc.exceptions.UnsupportedSecurityException;

public class VNCScreenUtil {
    private VNC vnc;
    private IntArrayTarget image;
    private VNCRequestThread requestThread;

    public VNCScreenUtil(VNC vnc) throws IOException, FailedSecurityException, UnsupportedSecurityException {
        System.out.println("[VNCScreenUtil] Initialising...");
        this.image = new IntArrayTarget(vnc.getCurrentPixelFormat().getScreenWidth(), vnc.getCurrentPixelFormat().getScreenHeight());
        this.vnc = vnc;
        vnc.setDataInterface(null, this.image);
        this.requestThread = new VNCRequestThread();
        this.requestThread.start();
    }

    public void setGrabRectangle(int grab_x, int grab_y, int grab_w, int grab_h) {
        this.requestThread.setGrabRect(grab_x, grab_y, grab_w, grab_h);
    }

    public int[] getImageInts() {
        if (this.image != null) {
            return this.image.getPixels();
        }
        return new int[0];
    }

    public int getSourceWidth() {
        return this.image.getWidth();
    }

    public int getSourceHeight() {
        return this.image.getHeight();
    }

    class VNCRequestThread
    extends Thread {
        private int requestIndex;
        private int grab_h;
        private int grab_w;
        private int grab_y;
        private int grab_x;

        public VNCRequestThread() {
            super("VNCRequestThread");
            this.requestIndex = 0;
        }

        public void setGrabRect(int grab_x, int grab_y, int grab_w, int grab_h) {
            this.grab_x = grab_x;
            this.grab_y = grab_y;
            this.grab_w = grab_w;
            this.grab_h = grab_h;
        }

        @Override
        public void run() {
            System.out.println("[VNCRequestThread] Starting request thread...");
            try {
                VNCScreenUtil.this.vnc.sendFramebufferUpdateRequest(this.requestIndex++, 0, 0, VNCScreenUtil.this.getSourceWidth(), VNCScreenUtil.this.getSourceHeight());
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    VNCScreenUtil.this.vnc.sendFramebufferUpdateRequest(this.requestIndex++, this.grab_x, this.grab_y, this.grab_w, this.grab_h);
                }
                catch (IOException e1) {
                    System.out.println("[VNCRequestThread] IO problem detected.");
                    e1.printStackTrace();
                    return;
                }
            }
        }
    }
}

