/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.controller;

import com.aem.CentralDebugging;
import com.aem.sdesktop.common.OpusConfig;
import com.aem.sdesktop.interfaces.MSG;
import com.aem.sdesktop.interfaces.ProxiedSoundListener;
import com.aem.sdesktop.interfaces.ServerUserInterface;
import com.aem.sdesktop.server.controller.SDesktopServerController;
import com.aem.sdesktop.server.controller.SDesktopServerInstance;
import com.aem.utils.Debugger;
import com.aem.utils.NativeAudioHandler;
import com.aem.utils.NativeAudioUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import org.concentus.OpusApplication;
import org.concentus.OpusEncoder;
import org.concentus.OpusException;
import org.concentus.OpusMode;
import org.concentus.OpusSignal;
import utils.message.Message;
import utils.message.MessageReader;
import utils.message.MessageWriter;
import utils.message.MessageWriterInterface;
import utils.ostools.OS;
import utils.progtools.buffers.CircularByteBuffer;
import utils.sound.encoders.opus.OpusTest;
import utils.sound.util.SoundMessageBuffer;
import utils.switches.Switches;

public class SoundServer
extends Thread
implements MSG {
    public static SoundServer INSTANCE;
    private static final Object INSTANCE_LOCK;
    private MessageReader min;
    private MessageWriter mout;
    private SDesktopServerInstance instance;
    private SDesktopServerController controller;
    private ServerUserInterface sui;
    private CircularByteBuffer circularByteBuffer = new CircularByteBuffer(204800);
    private EncodingThread encodingThread;
    private SoundBuffer soundBuffer;
    private boolean die = false;
    private boolean captureAudio = false;
    private Message lastFormatMessage;
    private boolean ableToReceiveAudioFromRemoteSide = false;
    private boolean technicianRequestedAudio = false;
    private long timeOfLastAudioCapture = -1L;
    private final Object listeners_LOCK = new Object();
    private ArrayList<ProxiedSoundListener> listeners = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SoundServer getInstanceOrWait() {
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            System.out.println("[SoundServer] Waiting for initialisation to complete...");
            while (INSTANCE == null) {
                try {
                    INSTANCE_LOCK.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            System.out.println("[SoundServer] Initialisation complete.");
            return INSTANCE;
        }
    }

    public void setAudioCaptureAllowed() {
        if (this.ableToReceiveAudioFromRemoteSide) {
            return;
        }
        this.ableToReceiveAudioFromRemoteSide = true;
        if (OS.isWindows() && OS.isWindowsVistaOrAbove() && CentralDebugging.ENABLE_SYSTEM_AUDIO_CAPTURE) {
            this.soundBuffer = new SoundBuffer(2000L, this.mout);
            NativeAudioUtil.getInstance().initialise(new SoundCaptureHandler());
            this.decideWhetherToCaptureAudio();
        }
    }

    public void setCaptureAudio(boolean technicianRequestedAudio) {
        this.technicianRequestedAudio = technicianRequestedAudio;
        this.decideWhetherToCaptureAudio();
    }

    private void decideWhetherToCaptureAudio() {
        if (this.ableToReceiveAudioFromRemoteSide && this.technicianRequestedAudio) {
            try {
                this.sendFormatMessage();
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.captureAudio = false;
                return;
            }
        }
        this.captureAudio = this.ableToReceiveAudioFromRemoteSide && this.technicianRequestedAudio;
    }

    private void sendFormatMessage() {
        if (this.lastFormatMessage != null) {
            System.out.println("[SoundServer] Format message is " + this.lastFormatMessage);
            this.soundBuffer.addFormatToBuffer(this.lastFormatMessage);
            this.encodingThread.setChannelCount();
        }
    }

    public void die() {
        this.die = true;
    }

    public void cleanup(boolean lastConnectionAlive) {
        this.die = true;
    }

    public void log(String s) {
        System.out.println(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoundServer(SDesktopServerInstance instance, ServerUserInterface sui, SDesktopServerController controller, InputStream input, OutputStream output) {
        super("SoundServer");
        System.out.println("[SoundServer] Initialising sound server...");
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            INSTANCE = this;
            INSTANCE_LOCK.notifyAll();
        }
        this.controller = controller;
        this.instance = instance;
        this.sui = sui;
        this.min = new MessageReader(input);
        this.mout = new MessageWriter(output);
        try {
            this.encodingThread = new EncodingThread();
        }
        catch (Throwable t) {
            System.out.println("[SoundServer] [ERROR] Unable to initialise SoundServer");
            t.printStackTrace();
        }
    }

    @Override
    public void run() {
        Message m = null;
        System.out.println("[SoundServer] Starting...");
        try {
            while (!this.die) {
                m = this.min.read();
                this.handleMessage(m);
            }
        }
        catch (IOException e) {
            if (CentralDebugging.PRINT_STACK_ON_CONNECTION_FAIL) {
                System.out.println("(Sound Server) LAST MESSAGE:" + m);
                e.printStackTrace();
            } else {
                System.out.println("[SoundServer] " + e);
            }
            this.log("[SoundServer] Connection terminated");
        }
        catch (Throwable e) {
            this.log("An unclassified error occurred in SoundServer: " + Debugger.getStackTrace(e));
            System.out.println("(Sound Server) LAST MESSAGE:" + m);
            e.printStackTrace();
        }
        this.instance.died();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message m) {
        Object object = this.listeners_LOCK;
        synchronized (object) {
            try {
                int type = m.getType();
                if (type == 655367) {
                    this.setAudioCaptureAllowed();
                } else if (type == 655361) {
                    byte[] dat = (byte[])m.get(0);
                    if (CentralDebugging.ENABLE_AUDIO_TECH_TO_CUST) {
                        if (CentralDebugging.PRINT_AUDIO_DEBUG) {
                            System.out.println("[SoundServer] Received " + dat.length + " bytes...");
                        }
                        for (ProxiedSoundListener listener : this.listeners) {
                            listener.soundBytes(dat);
                        }
                    }
                } else {
                    System.out.println("unrecognised sound server message " + m);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSoundListener(ProxiedSoundListener listener) {
        Object object = this.listeners_LOCK;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFormat(int sampleRate, int sampleSizeBits, int channels) {
        SoundServer soundServer = this;
        synchronized (soundServer) {
            this.lastFormatMessage = new Message(655365);
            this.lastFormatMessage.append(sampleRate);
            this.lastFormatMessage.append(sampleSizeBits);
            this.lastFormatMessage.append(channels);
        }
        if (!CentralDebugging.ENABLE_SYSTEM_AUDIO_CAPTURE || !this.captureAudio) {
            return;
        }
        if (CentralDebugging.PRINT_AUDIO_DEBUG) {
            System.out.println("[SoundServer] Sending format sampleRate:" + sampleRate + " sampleSizeBits:" + sampleSizeBits + " channels:" + channels);
        }
        this.sendFormatMessage();
    }

    static {
        INSTANCE_LOCK = new Object();
    }

    public class SoundBuffer
    extends SoundMessageBuffer {
        Message batchMessage;

        public SoundBuffer(long sizeInMS, MessageWriterInterface messageWriter) {
            super(sizeInMS, messageWriter);
        }

        @Override
        protected boolean isDataMessage(Message m) {
            return m.getType() == 655366 || m.getType() == 655361 || m.getType() == 655368;
        }

        @Override
        protected AudioFormat getAudioFormat(Message m) {
            return new AudioFormat(m.getAsInt(0), m.getAsInt(1), m.getAsInt(2), true, false);
        }

        @Override
        protected void startBatch() {
            this.batchMessage = new Message(655368);
        }

        @Override
        protected void batch(Message message) {
            this.batchMessage.append(message);
        }

        @Override
        protected Message endBatch() {
            return this.batchMessage;
        }
    }

    public class EncodingThread
    extends Thread {
        private OpusEncoder encoder;

        public EncodingThread() {
            super("OpusEncoding");
            this.start();
        }

        public void setChannelCount() {
            try {
                System.out.println("[SoundServer] Initialising encoder (" + OpusConfig.bitRate + ")");
                this.encoder = new OpusEncoder(48000, 2, OpusApplication.OPUS_APPLICATION_AUDIO);
                this.encoder.setBitrate(OpusConfig.bitRate);
                this.encoder.setForceMode(OpusMode.MODE_CELT_ONLY);
                this.encoder.setForceChannels(1);
                this.encoder.setSignalType(OpusSignal.OPUS_SIGNAL_AUTO);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        @Override
        public void run() {
            int read = 0;
            byte[] sample = new byte[3840];
            short[] pcmData = new short[sample.length / 2];
            try {
                long timestamp = System.currentTimeMillis() - System.currentTimeMillis() % 1000L;
                long totalSourceBytes = 0L;
                long totalTargetBytes = 0L;
                while (read != -1) {
                    read = SoundServer.this.circularByteBuffer.popFillBuffer(sample, 0, sample.length);
                    OpusTest.BytesToShorts(sample, 0, sample.length, pcmData);
                    byte[] data_packet = new byte[1275];
                    Message m = new Message(655366);
                    try {
                        int bytesEncoded = this.encoder.encode(pcmData, 0, 960, data_packet, 0, 1275);
                        if (System.currentTimeMillis() > timestamp + 1000L) {
                            System.out.println("[SoundServer] Encoded totalSource:" + totalSourceBytes + " -> totalTarget:" + totalTargetBytes);
                            timestamp = System.currentTimeMillis() - System.currentTimeMillis() % 1000L;
                            totalSourceBytes = 0L;
                            totalTargetBytes = 0L;
                        }
                        totalSourceBytes += (long)read;
                        totalTargetBytes += (long)bytesEncoded;
                        if (CentralDebugging.PRINT_AUDIO_DEBUG) {
                            System.out.println("[SoundServer] Encoded " + sample.length + " bytes to " + bytesEncoded);
                        }
                        m.append(data_packet, 0, bytesEncoded);
                        SoundServer.this.soundBuffer.addDataToBuffer(m, OpusConfig.getOpusEncodedSampleLength(bytesEncoded));
                    }
                    catch (OpusException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public class SoundCaptureHandler
    implements NativeAudioHandler {
        @Override
        public void SetFormat(int sampleRate, int sampleSizeBits, int channels) {
            if (CentralDebugging.PRINT_AUDIO_DEBUG) {
                System.out.println("[SoundServer] Format details are sampleRate:" + sampleRate + " sampleSizeInBits:" + sampleSizeBits + " channels:" + channels);
            }
            SoundServer.this.sendFormat(sampleRate, sampleSizeBits, channels);
        }

        @Override
        public void SetData(byte[] byteArray, int length) {
            if (!SoundServer.this.captureAudio) {
                return;
            }
            if (Switches.SH_skipSilentPackets) {
                boolean allOnesAndZeros = true;
                for (byte b : byteArray) {
                    if (b == 1 || b == -1 || b == 0) continue;
                    allOnesAndZeros = false;
                    break;
                }
                if (allOnesAndZeros) {
                    System.out.println("[SoundServer] Silence detected... ");
                    return;
                }
            }
            try {
                if (CentralDebugging.PRINT_AUDIO_DEBUG) {
                    System.out.println("[SoundServer] Capture has collected " + length + " bytes...");
                }
                SoundServer.this.timeOfLastAudioCapture = System.currentTimeMillis();
                SoundServer.this.circularByteBuffer.push(byteArray, 0, length);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

